/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.slo;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.SsoConfig;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.internal.utils.ForwardRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.ws.security.saml.sso20.metadata.AcsDOMMetadataProvider;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.util.List;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.joda.time.DateTime;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutResponse;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.LogoutRequestMarshaller;
import org.opensaml.saml.saml2.core.impl.LogoutResponseBuilder;
import org.opensaml.saml.saml2.core.impl.StatusBuilder;
import org.opensaml.saml.saml2.core.impl.StatusCodeBuilder;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.Signer;
import org.opensaml.xmlsec.signature.support.SignerProvider;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IdPInitiatedSLO {
    public static final TraceComponent tc = Tr.register(IdPInitiatedSLO.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    SsoSamlService ssoService = null;
    BasicMessageContext<?, ?> basicMsgCtx;
    String idpRelayState = null;
    static final String SINDEX = "sessionIndex";
    static final long serialVersionUID = 1524137271191391371L;

    public IdPInitiatedSLO(SsoSamlService service, BasicMessageContext<?, ?> msgCtx) {
        this.ssoService = service;
        this.basicMsgCtx = msgCtx;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("IdPInitiatedSLO(" + service.getProviderId() + ")"), (Object[])new Object[0]);
        }
    }

    public IdPInitiatedSLO(SsoSamlService service, BasicMessageContext<?, ?> msgCtx, String externalRelayState) {
        this.ssoService = service;
        this.basicMsgCtx = msgCtx;
        this.idpRelayState = externalRelayState;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("IdPInitiatedSLO(" + service.getProviderId() + ")"), (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={SamlException.class})
    public void sendSLOResponseToIdp(HttpServletRequest req, HttpServletResponse resp) {
        try {
            req.setAttribute("SLOInProgress", (Object)true);
            req.logout();
        }
        catch (ServletException servletException) {
            FFDCFilter.processException((Throwable)servletException, (String)"com.ibm.ws.security.saml.sso20.slo.IdPInitiatedSLO", (String)"123", (Object)this, (Object[])new Object[]{req, resp});
            this.basicMsgCtx.getSLOResponseStatus().getStatusCode().setValue("urn:oasis:names:tc:SAML:2.0:status:Responder");
        }
        String idpUrl = null;
        try {
            idpUrl = this.handleIdpMetadataAndLogoutUrl(this.basicMsgCtx);
            LogoutResponse logoutResponse = this.buildLogoutResponse(this.basicMsgCtx.getInResponseTo(), req, this.basicMsgCtx);
            String sloResponseStr = "";
            if (this.basicMsgCtx.getSsoConfig().isAuthnRequestsSigned()) {
                this.signLogoutResponse((SAMLObject)logoutResponse, RequestUtil.getSigningCredential(this.ssoService));
            }
            sloResponseStr = this.getSignedLogoutResponseString(logoutResponse);
            String shortRelayState = SamlUtil.generateRandom();
            String relayState = "sp_initial_" + shortRelayState;
            this.postIdp(req, resp, sloResponseStr, relayState, idpUrl);
        }
        catch (SamlException e1) {
            this.handleLogoutError(req, resp);
        }
    }

    private void handleLogoutError(HttpServletRequest req, HttpServletResponse resp) {
    }

    /*
     * WARNING - void declaration
     */
    String handleIdpMetadataAndLogoutUrl(BasicMessageContext<?, ?> basicMsgCtx) throws SamlException {
        String idpUrl;
        block11: {
            idpUrl = null;
            AcsDOMMetadataProvider metadataProvider = basicMsgCtx.getMetadataProvider();
            if (metadataProvider == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("idp metadata file :" + basicMsgCtx.getSsoConfig().getIdpMetadata()), (Object[])new Object[0]);
                }
                SsoConfig ssoConfig = this.ssoService.getConfig();
                String idpMetadataFile = ssoConfig.getIdpMetadata();
                String providerId = this.ssoService.getProviderId();
                if (idpMetadataFile == null || idpMetadataFile.isEmpty()) {
                    throw new SamlException("SAML20_NO_IDP_URL_OR_METADATA", null, new Object[]{providerId});
                }
                throw new SamlException("SAML20_NO_IDP_URL_ERROR", null, new Object[]{idpMetadataFile, providerId});
            }
            EntityDescriptor metadata2 = null;
            String entityID = metadataProvider.getEntityId();
            try {
                CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)});
                metadata2 = metadataProvider.resolveSingle(criteriaSet);
                if (metadata2 != null) {
                    EntityDescriptor entityDescriptor = metadata2;
                    String idpEntityId = entityDescriptor.getEntityID();
                    IDPSSODescriptor ssoDescriptor = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
                    if (ssoDescriptor != null) {
                        List list = ssoDescriptor.getSingleLogoutServices();
                        for (SingleLogoutService sloService : list) {
                            if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(sloService.getBinding())) continue;
                            basicMsgCtx.setPeerEntityEndpoint((Endpoint)sloService);
                            idpUrl = sloService.getLocation();
                            break;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("idpLogout url:" + idpUrl + "(" + "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST" + ")"), (Object[])new Object[0]);
                        }
                        break block11;
                    }
                    SsoConfig ssoConfig = this.ssoService.getConfig();
                    String idpMetadataFile = ssoConfig.getIdpMetadata();
                    String providerId = this.ssoService.getProviderId();
                    throw new SamlException("SAML20_IDP_METADATA_PARSE_ERROR", null, new Object[]{idpMetadataFile, providerId, "No IDPSSODescriptor"});
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ERROR: metadata is not an EntityDescriptor", (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("idp metadata file :" + basicMsgCtx.getSsoConfig().getIdpMetadata()), (Object[])new Object[0]);
                }
                SsoConfig ssoConfig = this.ssoService.getConfig();
                String idpMetadaFile = ssoConfig.getIdpMetadata();
                String providerId = this.ssoService.getProviderId();
                throw new SamlException("SAML20_NO_IDP_URL_ERROR", null, new Object[]{idpMetadaFile, providerId});
            }
            catch (ResolverException ssoConfig) {
                void e;
                FFDCFilter.processException((Throwable)ssoConfig, (String)"com.ibm.ws.security.saml.sso20.slo.IdPInitiatedSLO", (String)"241", (Object)this, (Object[])new Object[]{basicMsgCtx});
                throw new SamlException((Exception)e);
            }
        }
        return idpUrl;
    }

    LogoutResponse buildLogoutResponse(String inResponseToId, HttpServletRequest req, BasicMessageContext<?, ?> basicMsgCtx) throws SamlException {
        LogoutResponseBuilder lorBuilder = new LogoutResponseBuilder();
        LogoutResponse response = lorBuilder.buildObject();
        response.setInResponseTo(inResponseToId);
        response.setConsent("urn:oasis:names:tc:SAML:2.0:consent:unspecified");
        if (basicMsgCtx == null || basicMsgCtx.getPeerEntityEndpoint() == null || basicMsgCtx.getPeerEntityEndpoint().getLocation() == null) {
            throw new SamlException("SAML20_SLOENDPOINT_NOT_IN_METADATA", null, new Object[]{this.ssoService.getProviderId()});
        }
        response.setDestination(basicMsgCtx.getPeerEntityEndpoint().getLocation());
        response.setIssueInstant(new DateTime());
        response.setVersion(SAMLVersion.VERSION_20);
        String id = SamlUtil.generateRandomID();
        response.setID(id);
        String entityUrl = RequestUtil.getEntityUrl(req, "/ibm/saml20/", this.ssoService.getProviderId(), this.ssoService.getConfig());
        response.setIssuer(this.getIssuer(entityUrl));
        StatusBuilder statusBuilder = new StatusBuilder();
        Status status = statusBuilder.buildObject();
        StatusCodeBuilder statusCodeBuilder = new StatusCodeBuilder();
        StatusCode statusCode = statusCodeBuilder.buildObject();
        String value = this.getStatus(basicMsgCtx);
        statusCode.setValue(value);
        status.setStatusCode(statusCode);
        response.setStatus(status);
        return response;
    }

    private String getStatus(BasicMessageContext<?, ?> basicMsgCtx) {
        return basicMsgCtx.getSLOResponseStatus().getStatusCode().getValue();
    }

    Issuer getIssuer(String acsEndpointUrl) {
        IssuerBuilder issuerBuilder = new IssuerBuilder();
        Issuer issuer = issuerBuilder.buildObject();
        issuer.setValue(acsEndpointUrl);
        return issuer;
    }

    /*
     * WARNING - void declaration
     */
    void postIdp(HttpServletRequest req, HttpServletResponse resp, String logoutResponse, String relayState, String idpUrl) throws SamlException {
        byte[] logoutResBytes = null;
        try {
            logoutResBytes = logoutResponse.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            void e1;
            FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.saml.sso20.slo.IdPInitiatedSLO", (String)"337", (Object)this, (Object[])new Object[]{req, resp, logoutResponse, relayState, idpUrl});
            SamlException samlException = new SamlException((Exception)e1);
            throw samlException;
        }
        String samlResponse = Base64Support.encode((byte[])logoutResBytes, (boolean)false);
        if (relayState == null || samlResponse == null || idpUrl == null) {
            throw new SamlException("RelayState, Single-Sign-On URL, and Saml Logout Response must be provided");
        }
        resp.setStatus(200);
        ForwardRequestInfo requestInfo = new ForwardRequestInfo(idpUrl);
        if (this.idpRelayState != null) {
            requestInfo.setParameter("RelayState", new String[]{this.idpRelayState});
        }
        requestInfo.setParameter("SAMLResponse", new String[]{samlResponse});
        requestInfo.redirectPostRequest(req, resp, null, null);
    }

    /*
     * WARNING - void declaration
     */
    void signLogoutResponse(SAMLObject logoutResponse, Credential signingCredential) throws SamlException {
        SsoConfig samlConfig = this.ssoService.getConfig();
        if (logoutResponse instanceof SignableSAMLObject && signingCredential != null) {
            SignableSAMLObject signableMessage = (SignableSAMLObject)logoutResponse;
            XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
            XMLObjectBuilder signatureBuilder = builderFactory.getBuilder(Signature.DEFAULT_ELEMENT_NAME);
            Signature signature = (Signature)signatureBuilder.buildObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSignatureAlgorithm(samlConfig.getSignatureMethodAlgorithm());
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            signature.setSigningCredential(signingCredential);
            signableMessage.setSignature(signature);
            ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Marshaller marshaller = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)signableMessage);
                if (marshaller == null) {
                    throw new SamlException("SAML20_AUTHENTICATION_FAIL", null, new Object[0]);
                }
                marshaller.marshall((XMLObject)signableMessage);
                Thread.currentThread().setContextClassLoader(SignerProvider.class.getClassLoader());
                Signer.signObject((Signature)signature);
            }
            catch (Exception marshaller) {
                void e;
                FFDCFilter.processException((Throwable)marshaller, (String)"com.ibm.ws.security.saml.sso20.slo.IdPInitiatedSLO", (String)"408", (Object)this, (Object[])new Object[]{logoutResponse, signingCredential});
                throw new SamlException((Exception)e, true);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalClassLoader);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    String getSignedLogoutResponseString(LogoutResponse logoutResponse) throws SamlException {
        String result = null;
        if (logoutResponse != null) {
            try {
                LogoutRequestMarshaller marshaller = new LogoutRequestMarshaller();
                Element element = marshaller.marshall((XMLObject)logoutResponse);
                result = SerializeSupport.nodeToString((Node)element);
            }
            catch (MarshallingException marshaller) {
                void e;
                FFDCFilter.processException((Throwable)marshaller, (String)"com.ibm.ws.security.saml.sso20.slo.IdPInitiatedSLO", (String)"424", (Object)this, (Object[])new Object[]{logoutResponse});
                throw new SamlException((Exception)e, true);
            }
        }
        return result;
    }
}

