/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.web;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.json.java.JSONObject;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20BadParameterFormatException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import com.ibm.oauth.core.util.WebUtils;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.oauth20.AuthnContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.claims.UserClaims;
import com.ibm.ws.security.oauth20.ProvidersService;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.internal.AuthnContextImpl;
import com.ibm.ws.security.oauth20.plugins.BaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.plugins.jose4j.OidcUserClaims;
import com.ibm.ws.security.oauth20.util.ConfigUtils;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.EndpointUtils;
import com.ibm.ws.security.oauth20.web.OAuth20EndpointServices;
import com.ibm.ws.security.oauth20.web.OAuth20Request;
import com.ibm.ws.security.openidconnect.server.internal.HashUtils;
import com.ibm.ws.security.openidconnect.token.IDTokenValidationFailedException;
import com.ibm.ws.security.openidconnect.token.JWT;
import com.ibm.ws.security.openidconnect.token.JWTPayload;
import com.ibm.ws.security.openidconnect.token.JsonTokenUtil;
import com.ibm.ws.security.openidconnect.web.BrowserState;
import com.ibm.ws.security.openidconnect.web.Discovery;
import com.ibm.ws.security.openidconnect.web.OidcOptionalParams;
import com.ibm.ws.security.openidconnect.web.OidcRequest;
import com.ibm.ws.security.openidconnect.web.OidcRpInitiatedLogout;
import com.ibm.ws.webcontainer.security.jwk.JSONWebKey;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.openidconnect.IDTokenMediator;
import com.ibm.wsspi.security.openidconnect.UserinfoProvider;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import io.openliberty.security.common.jwt.jws.JwsSignatureVerifier;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Key;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={OidcEndpointServices.class}, name="com.ibm.ws.security.openidconnect.web.OidcEndpointServices", immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class OidcEndpointServices
extends OAuth20EndpointServices {
    private static TraceComponent tc = Tr.register(OidcEndpointServices.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    public static final String KEY_OAUTH20_ENDPOINT_SERVICES = "oauth20EndpointServices";
    public static final String KEY_ID = "id";
    public static final String KEY_SERVICE_PID = "service.pid";
    public static final String KEY_OIDC_SERVER_CONFIG = "oidcServerConfig";
    private final ConcurrentServiceReferenceMap<String, OidcServerConfig> oidcServerConfigRef = new ConcurrentServiceReferenceMap("oidcServerConfig");
    private boolean bOidcUpdated = false;
    private HashMap<String, OidcServerConfig> oidcMap = new HashMap();
    public static final String KEY_USER_INFO_PROVIDER = "userinfoProvider";
    private final ConcurrentServiceReferenceMap<String, UserinfoProvider> userinfoProviderConfigRef = new ConcurrentServiceReferenceMap("userinfoProvider");
    public static final String KEY_IDTOKEN_MEDIATOR = "idTokenMediator";
    private final ConcurrentServiceReferenceMap<String, IDTokenMediator> idTokenMediatorRef = new ConcurrentServiceReferenceMap("idTokenMediator");
    protected final AtomicServiceReference<OAuth20EndpointServices> oauth20EndpointServicesRef = new AtomicServiceReference("oauth20EndpointServices");
    private volatile BrowserState browserState = null;
    private volatile Discovery discovery = null;
    private volatile OidcOptionalParams optionalParameters = null;
    private static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    ConfigUtils configUtils = new ConfigUtils();
    static final long serialVersionUID = 2720069572232101399L;

    @Reference(service=OAuth20EndpointServices.class, name="oauth20EndpointServices", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setOAuth20EndpointServices(ServiceReference<OAuth20EndpointServices> reference) {
        this.oauth20EndpointServicesRef.setReference(reference);
    }

    protected void unsetOAuth20EndpointServices(ServiceReference<OAuth20EndpointServices> reference) {
        this.oauth20EndpointServicesRef.unsetReference(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=UserinfoProvider.class, name="userinfoProvider", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setUserinfoProvider(ServiceReference<UserinfoProvider> ref) {
        ConcurrentServiceReferenceMap<String, UserinfoProvider> concurrentServiceReferenceMap = this.userinfoProviderConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            this.userinfoProviderConfigRef.putReference((Object)((String)ref.getProperty(KEY_SERVICE_PID)), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetUserinfoProvider(ServiceReference<UserinfoProvider> ref) {
        ConcurrentServiceReferenceMap<String, UserinfoProvider> concurrentServiceReferenceMap = this.userinfoProviderConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            this.userinfoProviderConfigRef.removeReference((Object)((String)ref.getProperty(KEY_SERVICE_PID)), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=IDTokenMediator.class, name="idTokenMediator", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setIdTokenMediator(ServiceReference<IDTokenMediator> ref) {
        ConcurrentServiceReferenceMap<String, IDTokenMediator> concurrentServiceReferenceMap = this.idTokenMediatorRef;
        synchronized (concurrentServiceReferenceMap) {
            this.idTokenMediatorRef.putReference((Object)((String)ref.getProperty(KEY_SERVICE_PID)), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetIdTokenMediator(ServiceReference<IDTokenMediator> ref) {
        ConcurrentServiceReferenceMap<String, IDTokenMediator> concurrentServiceReferenceMap = this.idTokenMediatorRef;
        synchronized (concurrentServiceReferenceMap) {
            this.idTokenMediatorRef.removeReference((Object)((String)ref.getProperty(KEY_SERVICE_PID)), ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=OidcServerConfig.class, name="oidcServerConfig", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE, policyOption=ReferencePolicyOption.GREEDY)
    protected void setOidcServerConfig(ServiceReference<OidcServerConfig> ref) {
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = this.oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            this.oidcServerConfigRef.putReference((Object)((String)ref.getProperty(KEY_ID)), ref);
            this.bOidcUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetOidcServerConfig(ServiceReference<OidcServerConfig> ref) {
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = this.oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            this.oidcServerConfigRef.removeReference((Object)((String)ref.getProperty(KEY_ID)), ref);
            this.bOidcUpdated = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext cc) {
        this.securityServiceRef.activate(cc);
        this.oauth20EndpointServicesRef.activate(cc);
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = this.oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            this.oidcServerConfigRef.activate(cc);
            this.bOidcUpdated = true;
        }
        this.userinfoProviderConfigRef.activate(cc);
        this.idTokenMediatorRef.activate(cc);
        ConfigUtils.setIdTokenMediatorService(this.idTokenMediatorRef);
        this.browserState = new BrowserState();
        this.discovery = new Discovery();
        this.optionalParameters = new OidcOptionalParams();
        Tr.info((TraceComponent)tc, (String)"OIDC_ENDPOINT_SERVICE_ACTIVATED", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext cc) {
        this.securityServiceRef.deactivate(cc);
        this.oauth20EndpointServicesRef.deactivate(cc);
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = this.oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            this.oidcServerConfigRef.deactivate(cc);
            this.bOidcUpdated = true;
        }
        this.userinfoProviderConfigRef.deactivate(cc);
        this.idTokenMediatorRef.deactivate(cc);
    }

    @Trivial
    protected void logExitMsgFinished() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OIDC _SSO OP PROCESS HAS ENDED.", (Object[])new Object[0]);
        }
    }

    @Trivial
    protected void logExitMsgNo() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OIDC _SSO OP WILL NOT PROCESS THE REQUEST", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void handleOidcRequest(HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ServletException, IOException {
        OidcRequest oidcRequest;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Checking if OIDC Provider should process the request.", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Inbound request " + com.ibm.ws.security.common.web.WebUtils.getRequestStringForTrace((HttpServletRequest)request, (String)"client_secret")), (Object[])new Object[0]);
        }
        if ((oidcRequest = this.getOidcRequest(request, response)) == null) {
            this.logExitMsgNo();
            return;
        }
        String oidcProviderName = oidcRequest.getProviderName();
        OidcServerConfig oidcServerConfig = this.getOidcServerConfig(response, oidcProviderName);
        if (oidcServerConfig == null) {
            this.logExitMsgNo();
            return;
        }
        OAuth20Provider oauth20provider = this.getOAuthProvider(response, oidcServerConfig);
        if (oauth20provider == null) {
            this.logExitMsgNo();
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OIDC _SSO OP PROCESS IS STARTING.", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("OIDC _SSO OP inbound URL " + com.ibm.ws.security.common.web.WebUtils.getRequestStringForTrace((HttpServletRequest)request, (String)"client_secret")), (Object[])new Object[0]);
        }
        OAuth20Request.EndpointType endpointType = oidcRequest.getType();
        AttributeList optionalParams = null;
        try {
            optionalParams = this.optionalParameters.getParameters(request);
        }
        catch (OAuth20BadParameterFormatException oAuth20BadParameterFormatException) {
            void e;
            FFDCFilter.processException((Throwable)oAuth20BadParameterFormatException, (String)"com.ibm.ws.security.openidconnect.web.OidcEndpointServices", (String)"252", (Object)((Object)this), (Object[])new Object[]{request, response, servletContext});
            response.sendError(400, e.getMessage());
            return;
        }
        if (endpointType == OAuth20Request.EndpointType.authorize) {
            String externalClaimNames = oidcServerConfig.getExternalClaimNames();
            if (externalClaimNames != null && externalClaimNames.length() > 0) {
                optionalParams.setAttribute("externalClaimNames", "externalClaimNames", new String[]{externalClaimNames});
            }
            this.handleIdTokenHint(oauth20provider, oidcServerConfig, optionalParams);
            if (oidcServerConfig.isSessionManaged()) {
                this.browserState.processSession(request, response);
                this.browserState.generateState(request, optionalParams);
            }
        }
        this.handleEndpointRequest(request, response, servletContext, oauth20provider, endpointType, optionalParams);
        if (response.isCommitted()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Response has already been committed, will not continue processing the request", (Object[])new Object[0]);
            }
            this.logExitMsgFinished();
            return;
        }
        switch (endpointType) {
            case discovery: {
                this.discovery.processRequest(oidcServerConfig, request, response);
                this.logExitMsgFinished();
                return;
            }
            case userinfo: {
                this.userinfo(oauth20provider, oidcServerConfig, request, response);
                this.logExitMsgFinished();
                return;
            }
            case end_session: {
                this.processEndSession(oauth20provider, oidcServerConfig, request, response);
                this.logExitMsgFinished();
                return;
            }
            case check_session_iframe: {
                this.processCheckSessionRequest(response, oidcServerConfig);
                this.logExitMsgFinished();
                return;
            }
            case jwk: {
                this.processJWKRequest(response, oidcServerConfig);
                this.logExitMsgFinished();
                return;
            }
        }
        this.logExitMsgFinished();
    }

    private OidcRequest getOidcRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        OidcRequest oidcRequest = (OidcRequest)((Object)request.getAttribute("OidcRequest"));
        if (oidcRequest == null) {
            String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_REQUEST_ATTRIBUTE_MISSING", (Object[])new Object[]{request.getRequestURI(), "OidcRequest"}, (String)"CWWKS1634E: The request endpoint {0} does not have attribute {1}.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            response.sendError(404, errorMsg);
        }
        return oidcRequest;
    }

    private OAuth20Provider getOAuthProvider(HttpServletResponse response, OidcServerConfig oidcServerConfig) throws IOException {
        String oidcProviderName = oidcServerConfig.getProviderId();
        String oauthProviderName = oidcServerConfig.getOauthProviderName();
        if (oauthProviderName == null) {
            String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_OAUTH_PROVIDER_NAME_NOT_FOUND", (Object[])new Object[]{oidcProviderName}, (String)"CWWKS1632E: The OAuth provider name referenced by the OpenID Connect provider {0} was not found.");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            response.sendError(404, errorMsg);
            return null;
        }
        OAuth20Provider oauth20provider = ProvidersService.getOAuth20Provider((String)oauthProviderName);
        if (oauth20provider == null) {
            String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_OAUTH_PROVIDER_OBJECT_NULL", (Object[])new Object[]{oidcProviderName}, (String)"CWWKS1630E: OAuth20Provider object is null for the OpenID Connect provider {0}");
            Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
            response.sendError(404, errorMsg);
        }
        return oauth20provider;
    }

    public OidcServerConfig getOidcServerConfig(HttpServletResponse response, String oidcProviderName) throws IOException {
        return this.getOidcServerConfig(response, oidcProviderName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OidcServerConfig getOidcServerConfig(HttpServletResponse response, String oidcProviderName, boolean sendErrorIfProviderNotFound) throws IOException {
        ConcurrentServiceReferenceMap<String, OidcServerConfig> concurrentServiceReferenceMap = this.oidcServerConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            if (this.bOidcUpdated) {
                this.oidcMap = this.configUtils.checkDuplicateOAuthProvider(this.oidcServerConfigRef);
                this.bOidcUpdated = false;
            }
        }
        OidcServerConfig oidcServerConfig = this.oidcMap.get(oidcProviderName);
        if (oidcServerConfig == null && sendErrorIfProviderNotFound) {
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_CONFIG_SERVICE_NOT_AVAILABLE", (Object[])new Object[]{oidcProviderName});
            response.sendError(404, "OpenID Connect configuration service is not avaliable for OpenID Connect provider name " + oidcProviderName);
        }
        return oidcServerConfig;
    }

    protected void processEndSession(OAuth20Provider oauth20provider, OidcServerConfig oidcServerConfig, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        OidcRpInitiatedLogout rpInitiatedLogout = new OidcRpInitiatedLogout(this, oauth20provider, oidcServerConfig, request, response);
        rpInitiatedLogout.processEndSession();
    }

    @ManualTrace
    private void processCheckSessionRequest(HttpServletResponse response, OidcServerConfig oidcServerConfig) throws IOException {
        String methodName = "processCheckSessionRequest";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        String iframeUrl = oidcServerConfig.getCheckSessionIframeEndpointUrl();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OIDC _SSO OP redirecting to [" + iframeUrl + "]"), (Object[])new Object[0]);
        }
        response.sendRedirect(iframeUrl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    JWT createJwt(String tokenString, OAuth20Provider oauth20provider, OidcServerConfig oidcServerConfig) throws Exception {
        String aud = null;
        String issuer = null;
        JWTPayload payload = JsonTokenUtil.getPayload((String)tokenString);
        if (payload != null) {
            aud = JsonTokenUtil.getAud((JWTPayload)payload);
            issuer = JsonTokenUtil.getIss((JWTPayload)payload);
        }
        Object key = this.getJwtVerificationKey(tokenString, oauth20provider, oidcServerConfig);
        String signatureAlgorithm = oidcServerConfig.getSignatureAlgorithm();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clientId : " + aud + " key : " + (key == null ? "null" : "<removed>") + " issuer : " + issuer + " signatureAlgorithm : " + signatureAlgorithm), (Object[])new Object[0]);
        }
        return new JWT(tokenString, key, aud, issuer, signatureAlgorithm);
    }

    @Sensitive
    Object getJwtVerificationKey(String tokenString, OAuth20Provider oauth20provider, OidcServerConfig oidcServerConfig) throws Exception {
        Object key = null;
        JwtContext jwtContext = JwtParsingUtils.parseJwtWithoutValidation((String)tokenString);
        String signingAlgorithm = JwsSignatureVerifier.verifyJwsAlgHeaderOnly((JwtContext)jwtContext, Arrays.asList(oidcServerConfig.getIdTokenSigningAlgValuesSupported()));
        if (signingAlgorithm.equals("none")) {
            key = null;
        } else if (signingAlgorithm.startsWith("HS")) {
            key = this.getSharedKey(jwtContext, oauth20provider);
        } else if (ProductInfo.getBetaEdition()) {
            JsonWebStructure jsonStruct = JwtParsingUtils.getJsonWebStructureFromJwtContext((JwtContext)jwtContext);
            key = this.getPublicKeyFromJsonWebStructure(jsonStruct, oidcServerConfig);
        }
        return key;
    }

    @Sensitive
    Object getSharedKey(JwtContext jwtContext, OAuth20Provider oauth20provider) throws OidcServerException, MalformedClaimException {
        JwtClaims jwtClaims = jwtContext.getJwtClaims();
        List audiences = jwtClaims.getAudience();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Audiences from JWT: " + audiences), (Object[])new Object[0]);
        }
        if (audiences == null || audiences.isEmpty() || audiences.size() > 1) {
            return null;
        }
        String clientId = (String)audiences.get(0);
        return this.getSharedKey(oauth20provider, clientId);
    }

    @Sensitive
    Object getSharedKey(OAuth20Provider oauth20provider, String clientId) throws OidcServerException {
        String sharedKey = null;
        OidcOAuth20ClientProvider clientProvider = oauth20provider.getClientProvider();
        OidcBaseClient oauth20Client = clientProvider.get(clientId);
        if (oauth20Client instanceof BaseClient) {
            BaseClient baseClient = (BaseClient)oauth20Client;
            sharedKey = baseClient.getClientSecret();
        }
        return sharedKey;
    }

    Key getPublicKeyFromJsonWebStructure(JsonWebStructure jsonStruct, OidcServerConfig oidcServerConfig) {
        String alg = jsonStruct.getAlgorithmHeaderValue();
        String kid = jsonStruct.getKeyIdHeaderValue();
        String x5t = jsonStruct.getX509CertSha1ThumbprintHeaderValue();
        PublicKey publicKey = null;
        JSONWebKey jwk = oidcServerConfig.getJSONWebKey();
        if (jwk != null && alg.equals(jwk.getAlgorithm())) {
            if (kid != null && kid.equals(jwk.getKeyID())) {
                publicKey = jwk.getPublicKey();
            } else if (x5t != null && x5t.equals(jwk.getKeyX5t())) {
                publicKey = jwk.getPublicKey();
            } else if (kid == null && x5t == null) {
                publicKey = jwk.getPublicKey();
            }
        }
        return publicKey;
    }

    void userinfo(OAuth20Provider oauth20provider, OidcServerConfig oidcServerConfig, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String accessTokenString;
        Enumeration params = request.getParameterNames();
        if (params != null) {
            while (params.hasMoreElements()) {
                String param = (String)params.nextElement();
                if (param.equals("access_token")) continue;
                String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_SERVER_USERINFO_UNSUPPORTED_PARAMETER", (Object[])new Object[]{param, request.getRequestURI()}, (String)"CWWKS1633E: A userinfo request was made with unsupported parameter {0}. The request URI was {1}.");
                this.setWWWAuthenticateHeaderResponse(response, 400, "invalid_request", errorMsg, null);
                Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_USERINFO_UNSUPPORTED_PARAMETER", (Object[])new Object[]{param, request.getRequestURI()});
                return;
            }
        }
        String reqParamAccessTokenString = accessTokenString = request.getParameter("access_token");
        String authzHeader = request.getHeader("Authorization");
        if (authzHeader != null) {
            String hdrAccessTokenString = WebUtils.getBearerTokenFromAuthzHeader((String)authzHeader);
            if (accessTokenString != null && hdrAccessTokenString != null) {
                String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_SERVER_USERINFO_MULTIPLE_ACCESS_TOKENS", (Object[])new Object[]{request.getRequestURI()}, (String)"CWWKS1621E: A userinfo request was made with an access token in the access_token request parameter and also the authorization header. Only one access token is allowed. The request URI was {0}.");
                this.setWWWAuthenticateHeaderResponse(response, 400, "invalid_request", errorMsg, null);
                Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_USERINFO_MULTIPLE_ACCESS_TOKENS", (Object[])new Object[]{request.getRequestURI()});
                return;
            }
            if (accessTokenString == null) {
                accessTokenString = hdrAccessTokenString;
            }
        }
        if (accessTokenString == null) {
            String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_SERVER_USERINFO_NO_ACCESS_TOKEN", (Object[])new Object[]{request.getRequestURI()}, (String)"CWWKS1616E: A userinfo request was made with no access token. The request URI was {0}.");
            this.setWWWAuthenticateHeaderResponse(response, 400, "invalid_request", errorMsg, null);
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_USERINFO_NO_ACCESS_TOKEN", (Object[])new Object[]{request.getRequestURI()});
            return;
        }
        String tokenLookupStr = accessTokenString;
        boolean isAppPasswordOrToken = false;
        if (OidcOAuth20Util.isJwtToken((String)accessTokenString)) {
            tokenLookupStr = HashUtils.digest(accessTokenString);
        } else if (tokenLookupStr.length() == oauth20provider.getAccessTokenLength() + 2) {
            String encode = oauth20provider.getAccessTokenEncoding();
            tokenLookupStr = "plain".equals(encode) ? EndpointUtils.computeTokenHash((String)accessTokenString) : EndpointUtils.computeTokenHash((String)accessTokenString, (String)encode);
            isAppPasswordOrToken = true;
        }
        OAuth20Token accessToken = null;
        accessToken = isAppPasswordOrToken ? oauth20provider.getTokenCache().getByHash(tokenLookupStr) : oauth20provider.getTokenCache().get(tokenLookupStr);
        boolean isAppPassword = false;
        if (accessToken != null) {
            boolean bl = isAppPassword = accessToken.getGrantType() != null && accessToken.getGrantType().equals("app_password");
        }
        if (accessToken == null || !oauth20provider.isLocalStoreUsed() && isAppPassword) {
            String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_SERVER_USERINFO_BAD_ACCESS_TOKEN", (Object[])new Object[]{request.getRequestURI()}, (String)"CWWKS1617E: A userinfo request was made with an access token that was not recognized. The request URI was {0}.");
            this.setWWWAuthenticateHeaderResponse(response, 401, "invalid_token", errorMsg, null);
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_USERINFO_BAD_ACCESS_TOKEN", (Object[])new Object[]{request.getRequestURI()});
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("token type: " + accessToken.getType() + " grant type: " + accessToken.getGrantType()), (Object[])new Object[0]);
        }
        boolean isAccessToken = accessToken.getType().equals("access_token");
        if (isAppPassword || !isAccessToken) {
            String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_SERVER_USERINFO_BAD_TOKEN_TYPE", (Object[])new Object[]{request.getRequestURI()}, (String)"CWWKS1622E: A userinfo request was made with a token that was not an access token. The request URI was {0}.");
            this.setWWWAuthenticateHeaderResponse(response, 401, "invalid_token", errorMsg, null);
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_USERINFO_BAD_TOKEN_TYPE", (Object[])new Object[]{request.getRequestURI()});
            return;
        }
        if (OAuth20TokenHelper.isTokenExpired((OAuth20Token)accessToken)) {
            String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_SERVER_USERINFO_EXPIRED_ACCESS_TOKEN", (Object[])new Object[]{request.getRequestURI()}, (String)"CWWKS1623E: A userinfo request was made with an expired access token. The request URI was {0}.");
            this.setWWWAuthenticateHeaderResponse(response, 401, "invalid_token", errorMsg, null);
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_USERINFO_EXPIRED_ACCESS_TOKEN", (Object[])new Object[]{request.getRequestURI()});
            return;
        }
        if (oidcServerConfig == null) {
            String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_SERVER_USERINFO_INVALID_REQUEST", (Object[])new Object[]{request.getRequestURI()}, (String)"CWWKS1618E: A userinfo request URI was not valid. The request URI was {0}.");
            this.setWWWAuthenticateHeaderResponse(response, 400, "invalid_request", errorMsg, null);
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_USERINFO_INVALID_REQUEST", (Object[])new Object[]{request.getRequestURI()});
            return;
        }
        boolean requireOpenidScope = oidcServerConfig.isOpenidScopeRequiredForUserInfo();
        String[] tokenScopes = accessToken.getScope();
        Properties scopeToClaims = oidcServerConfig.getScopeToClaimMap();
        HashSet<String> claims = new HashSet<String>();
        boolean hasOpenidScope = false;
        for (String scope : tokenScopes) {
            if (scope.equals("openid")) {
                hasOpenidScope = true;
            }
            Object[] scopeClaims = (String[])scopeToClaims.get(scope);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("scope: " + scope + "  has claims: " + Arrays.toString(scopeClaims)), (Object[])new Object[0]);
            }
            if (scopeClaims == null || scopeClaims.length <= 0) continue;
            claims.addAll(Arrays.asList(scopeClaims));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("claims: " + claims), (Object[])new Object[0]);
        }
        if (!hasOpenidScope && requireOpenidScope) {
            String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_SERVER_USERINFO_NOT_OIDC_ACCESS_TOKEN", (Object[])new Object[]{request.getRequestURI()}, (String)"CWWKS1619E: A userinfo request was made with an access token that did not have the required 'openid' scope. The request URI was {0}.");
            this.setWWWAuthenticateHeaderResponse(response, 400, "invalid_request", errorMsg, "openid");
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_USERINFO_NOT_OIDC_ACCESS_TOKEN", (Object[])new Object[]{request.getRequestURI()});
            return;
        }
        if (reqParamAccessTokenString != null) {
            response.setHeader("Cache-Control", "private");
        }
        if (!this.userinfoProviderConfigRef.isEmpty()) {
            UserinfoProvider userinfoProvider = null;
            Iterator it = this.userinfoProviderConfigRef.getServices();
            JSONObject customJSON = null;
            int providersInstalled = this.userinfoProviderConfigRef.size();
            while (it.hasNext()) {
                userinfoProvider = (UserinfoProvider)it.next();
                try {
                    customJSON = this.getUserinfoFromCustomProvider(accessToken, userinfoProvider, request, response);
                }
                catch (IOException scopeClaims) {
                    FFDCFilter.processException((Throwable)scopeClaims, (String)"com.ibm.ws.security.openidconnect.web.OidcEndpointServices", (String)"724", (Object)((Object)this), (Object[])new Object[]{oauth20provider, oidcServerConfig, request, response});
                    String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_SERVER_USERINFO_INVALID_JSONOBJECT", (Object[])new Object[]{accessToken.getUsername(), userinfoProvider.getClass().getName()}, (String)"CWWKS1639E: The userinfo for {0} returned by Liberty user feature {1} is invalid.");
                    response.sendError(500, errorMsg);
                    Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_USERINFO_INVALID_JSONOBJECT", (Object[])new Object[]{accessToken.getUsername(), userinfoProvider.getClass().getName()});
                    return;
                }
                if (customJSON == null) continue;
                if (providersInstalled <= 1) break;
                Tr.info((TraceComponent)tc, (String)"OIDC_SERVER_MULTIPLE_USERINFO_PROVIDER_CONFIGURED", (Object[])new Object[0]);
                break;
            }
            if (customJSON == null) {
                String errorMsg = TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages", (String)"OIDC_SERVER_USERINFO_PROVIDER_INTERNAL_ERROR", (Object[])new Object[]{accessToken.getUsername(), userinfoProvider.getClass().getName()}, (String)"CWWKS1637E: The userinfo for {0} returned by Liberty user feature {1} is null.");
                response.sendError(500, errorMsg);
                Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_USERINFO_PROVIDER_INTERNAL_ERROR", (Object[])new Object[]{accessToken.getUsername(), userinfoProvider.getClass().getName()});
                return;
            }
            com.ibm.ws.security.oauth20.web.WebUtils.setJSONResponse((HttpServletResponse)response, (int)200, (String)customJSON.toString());
        } else {
            JSONObject responseJSON = this.getUserinfoFromRegistry(oauth20provider, oidcServerConfig, request, response, accessToken, claims);
            com.ibm.ws.security.oauth20.web.WebUtils.setJSONResponse((HttpServletResponse)response, (int)200, (JSONObject)responseJSON);
        }
    }

    private JSONObject getUserinfoFromCustomProvider(OAuth20Token accessToken, UserinfoProvider userinfoProvider, HttpServletRequest request, HttpServletResponse response) throws IOException {
        AuthnContextImpl authnContext = new AuthnContextImpl(request, response, accessToken.getTokenString(), accessToken.getScope(), accessToken.getCreatedAt(), (long)accessToken.getLifetimeSeconds(), accessToken.getUsername(), accessToken.getExtensionProperties());
        String strJsonObject = userinfoProvider.getUserInfo((AuthnContext)authnContext);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getUserInfo:'" + strJsonObject + "'"), (Object[])new Object[0]);
        }
        if (strJsonObject != null) {
            return JSONObject.parse((String)strJsonObject);
        }
        return null;
    }

    private String getCalculatedIssuerId(HttpServletRequest request) {
        String hostname = request.getServerName();
        String scheme = request.getScheme();
        int port = request.getLocalPort();
        String path = request.getRequestURI();
        int lastSlashIndex = path.lastIndexOf("/");
        String issuerIdentifier = scheme + "://" + hostname + ":" + port + path.substring(0, lastSlashIndex);
        return issuerIdentifier;
    }

    protected JSONObject getUserinfoFromRegistry(OAuth20Provider oauth20provider, OidcServerConfig oidcServerConfig, HttpServletRequest request, HttpServletResponse response, OAuth20Token accessToken, HashSet<String> claims) throws IOException {
        JSONObject responseJSON = new JSONObject();
        String userName = accessToken.getUsername();
        responseJSON.put((Object)"sub", (Object)userName);
        String issuer = oidcServerConfig.getIssuerIdentifier();
        if (issuer == null) {
            issuer = this.getCalculatedIssuerId(request);
        }
        responseJSON.put((Object)"iss", (Object)issuer);
        UserClaims oauthClaims = this.getUserClaimsObj(oauth20provider, accessToken);
        Map userClaimsMap = this.getUserClaimsMap(oauthClaims, true);
        if (userClaimsMap != null) {
            responseJSON.putAll(userClaimsMap);
        }
        if (oauthClaims != null && oauthClaims.isEnabled()) {
            OidcUserClaims oidcClaims = new OidcUserClaims(oauthClaims);
            responseJSON = oidcClaims.getUserinfoFromRegistry(oidcServerConfig, responseJSON, request, response, claims);
        }
        return responseJSON;
    }

    private void setWWWAuthenticateHeaderResponse(HttpServletResponse response, int status, String error, String errorDescription, String scope) {
        String header = "Bearer error=" + error + ",";
        header = header + " error_description=" + errorDescription;
        if (scope != null) {
            header = header + ", scope=" + scope;
        }
        response.setHeader(WWW_AUTHENTICATE_HEADER, header);
        response.setStatus(status);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={IDTokenValidationFailedException.class, IllegalStateException.class})
    protected void handleIdTokenHint(OAuth20Provider oauth20provider, OidcServerConfig oidcServerConfig, AttributeList attrs) {
        String idTokenHint = attrs.getAttributeValueByName("id_token_hint");
        if (idTokenHint != null) {
            OAuth20Token cachedIdToken = null;
            OAuth20EnhancedTokenCache tokenCache = null;
            tokenCache = oauth20provider.getTokenCache();
            if (tokenCache != null) {
                String hash = HashUtils.digest(idTokenHint);
                if (hash != null) {
                    cachedIdToken = tokenCache.get(hash);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("idToken : " + cachedIdToken), (Object[])new Object[0]);
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{"IDTokenValidatonFailedException"});
                    attrs.setAttribute("id_token_hint_status", "urn:ibm:names:oauth:request", new String[]{"fail_invalid_id_token"});
                    return;
                }
            }
            String tokenUsername = null;
            String clientId = null;
            if (cachedIdToken != null) {
                tokenUsername = cachedIdToken.getUsername();
                clientId = cachedIdToken.getClientId();
            } else {
                JWT jwt = null;
                try {
                    jwt = this.createJwt(idTokenHint, oauth20provider, oidcServerConfig);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("JWT : " + jwt), (Object[])new Object[0]);
                    }
                    if (!jwt.verifySignatureOnly()) {
                        Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{"IDTokenValidatonFailedException"});
                        attrs.setAttribute("id_token_hint_status", "urn:ibm:names:oauth:request", new String[]{"fail_invalid_id_token"});
                        return;
                    }
                    tokenUsername = JsonTokenUtil.getSub((JWTPayload)jwt.getPayload());
                    clientId = JsonTokenUtil.getAud((JWTPayload)jwt.getPayload());
                }
                catch (IDTokenValidationFailedException ivfe) {
                    Throwable cause = ivfe.getCause();
                    if (cause != null && cause instanceof IllegalStateException) {
                        try {
                            JWTPayload payload = JsonTokenUtil.getPayload((String)idTokenHint);
                            if (payload != null) {
                                tokenUsername = JsonTokenUtil.getSub((JWTPayload)payload);
                                clientId = JsonTokenUtil.getAud((JWTPayload)payload);
                            }
                        }
                        catch (Exception payload) {
                            void e;
                            FFDCFilter.processException((Throwable)payload, (String)"com.ibm.ws.security.openidconnect.web.OidcEndpointServices", (String)"925", (Object)((Object)this), (Object[])new Object[]{oauth20provider, oidcServerConfig, attrs});
                            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{e});
                            attrs.setAttribute("id_token_hint_status", "urn:ibm:names:oauth:request", new String[]{"fail_invalid_id_token"});
                            return;
                        }
                    }
                    Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{ivfe});
                    attrs.setAttribute("id_token_hint_status", "urn:ibm:names:oauth:request", new String[]{"fail_invalid_id_token"});
                    return;
                }
                catch (IllegalStateException ise) {
                    try {
                        JWTPayload payload = JsonTokenUtil.getPayload((String)idTokenHint);
                        if (payload != null) {
                            tokenUsername = JsonTokenUtil.getSub((JWTPayload)payload);
                            clientId = JsonTokenUtil.getAud((JWTPayload)payload);
                        }
                    }
                    catch (IllegalStateException e) {
                        Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{e});
                        attrs.setAttribute("id_token_hint_status", "urn:ibm:names:oauth:request", new String[]{"fail_invalid_id_token"});
                        return;
                    }
                }
                catch (Throwable ise) {
                    void e;
                    FFDCFilter.processException((Throwable)ise, (String)"com.ibm.ws.security.openidconnect.web.OidcEndpointServices", (String)"950", (Object)((Object)this), (Object[])new Object[]{oauth20provider, oidcServerConfig, attrs});
                    Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{e});
                    attrs.setAttribute("id_token_hint_status", "urn:ibm:names:oauth:request", new String[]{"fail_invalid_id_token"});
                    return;
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("id_token_hint username : " + tokenUsername + " client id: " + clientId), (Object[])new Object[0]);
            }
            if (tokenUsername != null || clientId != null) {
                attrs.setAttribute("id_token_hint_status", "urn:ibm:names:oauth:request", new String[]{"success"});
                attrs.setAttribute("id_token_hint_username", "urn:ibm:names:oauth:request", new String[]{tokenUsername});
                attrs.setAttribute("id_token_hint_clientid", "urn:ibm:names:oauth:request", new String[]{clientId});
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    private void processJWKRequest(HttpServletResponse response, OidcServerConfig oidcServerConfig) throws IOException {
        block7: {
            String methodName = "processJWKRequest";
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
            }
            String jwkString = oidcServerConfig.getJwkJsonString();
            try {
                String cacheControlValue = response.getHeader("Cache-Control");
                cacheControlValue = cacheControlValue != null && !cacheControlValue.isEmpty() ? cacheControlValue + ", " + "no-store" : "no-store";
                response.setHeader("Cache-Control", cacheControlValue);
                response.setHeader("Pragma", "no-cache");
                response.setStatus(200);
                if (jwkString != null) {
                    response.setHeader("Content-Type", "application/json;charset=UTF-8");
                    PrintWriter pw = response.getWriter();
                    pw.write(jwkString);
                    pw.flush();
                }
            }
            catch (IOException cacheControlValue) {
                FFDCFilter.processException((Throwable)cacheControlValue, (String)"com.ibm.ws.security.openidconnect.web.OidcEndpointServices", (String)"998", (Object)((Object)this), (Object[])new Object[]{response, oidcServerConfig});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"Internal error processing JWK request", (Object[])new Object[]{e});
                }
                try {
                    response.sendError(500);
                }
                catch (IOException pw) {
                    void ioe;
                    FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.openidconnect.web.OidcEndpointServices", (String)"1003", (Object)((Object)this), (Object[])new Object[]{response, oidcServerConfig});
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)"Internal error process JWK request error", (Object[])new Object[]{ioe});
                }
            }
        }
    }
}

