/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.web;

import com.google.gson.JsonArray;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.api.oauth20.token.OAuth20TokenCache;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.CacheUtil;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.OAuthClientTracker;
import com.ibm.ws.security.openidconnect.web.OidcEndpointServices;
import com.ibm.ws.security.openidconnect.web.OidcRpInitiatedLogoutTokenAndRequestData;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import io.openliberty.security.openidconnect.backchannellogout.BackchannelLogoutRequestHelper;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcRpInitiatedLogout {
    private static TraceComponent tc = Tr.register(OidcRpInitiatedLogout.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    private final OidcEndpointServices endpointServices;
    private final OAuth20Provider oauth20Provider;
    private final OidcServerConfig oidcServerConfig;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    static final long serialVersionUID = 704400541885381844L;

    public OidcRpInitiatedLogout(OidcEndpointServices endpointServices, OAuth20Provider oauth20Provider, OidcServerConfig oidcServerConfig, HttpServletRequest request, HttpServletResponse response) {
        this.endpointServices = endpointServices;
        this.oauth20Provider = oauth20Provider;
        this.oidcServerConfig = oidcServerConfig;
        this.request = request;
        this.response = response;
    }

    protected void processEndSession() throws ServletException, IOException {
        OidcRpInitiatedLogoutTokenAndRequestData tokenAndRequestData = new OidcRpInitiatedLogoutTokenAndRequestData(this.request, this.endpointServices, this.oauth20Provider, this.oidcServerConfig);
        tokenAndRequestData.populate();
        boolean isDataValidForLogout = tokenAndRequestData.isDataValidForLogout();
        if (isDataValidForLogout) {
            this.removeRefreshTokenFromCache(tokenAndRequestData.getCachedIdToken());
        }
        String redirectUri = this.getPostLogoutRedirectUri(isDataValidForLogout, tokenAndRequestData.getPostLogoutRedirectUriParameter(), tokenAndRequestData.getClientId());
        this.request.setAttribute("OIDC_END_SESSION_REDIRECT", (Object)redirectUri);
        if (isDataValidForLogout) {
            this.logOutUser(tokenAndRequestData.getUserPrincipal(), redirectUri, tokenAndRequestData.getUserPrincipalName(), tokenAndRequestData.getIdTokenHintParameter());
        }
        if (this.request.getAttribute("OIDC_END_SESSION_REDIRECT") != null) {
            this.sendPostEndSessionRedirect(redirectUri);
        }
    }

    void removeRefreshTokenFromCache(OAuth20Token cachedIdToken) {
        if (cachedIdToken == null) {
            return;
        }
        OAuth20EnhancedTokenCache tokenCache = this.oauth20Provider.getTokenCache();
        if (tokenCache != null) {
            CacheUtil cu = new CacheUtil((OAuth20TokenCache)tokenCache);
            OAuth20Token refreshToken = cu.getRefreshToken(cachedIdToken);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("refreshToken : " + refreshToken), (Object[])new Object[0]);
            }
            if (refreshToken != null) {
                tokenCache.remove(refreshToken.getTokenString());
            }
        }
    }

    String getPostLogoutRedirectUri(boolean isDataValidForLogout, String redirectUriReqParameter, String clientId) {
        String redirectUri = redirectUriReqParameter;
        redirectUri = !isDataValidForLogout ? this.request.getContextPath() + "/end_session_error.html" : (redirectUri == null ? this.request.getContextPath() + "/end_session_logout.html" : this.verifyPostLogoutRedirectUriMatchesConfiguration(clientId, redirectUri));
        if (this.oauth20Provider.isTrackOAuthClients()) {
            redirectUri = this.updateRedirectUriWithTrackedOAuthClients(redirectUri);
        }
        return redirectUri;
    }

    /*
     * WARNING - void declaration
     */
    String verifyPostLogoutRedirectUriMatchesConfiguration(String clientId, String redirectUri) {
        try {
            Object[] uris = this.getPostLogoutRedirectUris(clientId);
            if (!this.containUri(redirectUri, (String[])uris)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && clientId == null) {
                    Tr.debug((TraceComponent)tc, (String)"postLogoutRedirectUri value cannot be identified because client id is not set. Most likely this is because the id_token_hint parameter is not set or invalid.", (Object[])new Object[0]);
                }
                Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_LOGOUT_REDIRECT_URI_MISMATCH", (Object[])new Object[]{redirectUri, Arrays.toString(uris), clientId});
                redirectUri = this.request.getContextPath() + "/end_session_logout.html";
            }
        }
        catch (OidcServerException uris) {
            void ose;
            FFDCFilter.processException((Throwable)uris, (String)"com.ibm.ws.security.openidconnect.web.OidcRpInitiatedLogout", (String)"144", (Object)this, (Object[])new Object[]{clientId, redirectUri});
            Tr.error((TraceComponent)tc, (String)"OIDC_SERVER_IDTOKEN_VERIFY_ERR", (Object[])new Object[]{ose});
            redirectUri = this.request.getContextPath() + "/end_session_error.html";
        }
        return redirectUri;
    }

    String[] getPostLogoutRedirectUris(String clientId) throws OidcServerException {
        OidcOAuth20ClientProvider clientProvider;
        OidcBaseClient oauth20Client;
        String[] uris = null;
        if (clientId != null && (oauth20Client = (clientProvider = this.oauth20Provider.getClientProvider()).get(clientId)) instanceof OidcBaseClient) {
            OidcBaseClient baseClient = oauth20Client;
            uris = OidcOAuth20Util.getStringArray((JsonArray)baseClient.getPostLogoutRedirectUris());
        }
        return uris;
    }

    boolean containUri(String uri, String[] uris) {
        boolean contain = false;
        if (uris != null && uris.length > 0 && uri != null) {
            for (int i = 0; i < uris.length; ++i) {
                if (!uri.equals(uris[i])) continue;
                contain = true;
                break;
            }
        }
        return contain;
    }

    String updateRedirectUriWithTrackedOAuthClients(String redirectUri) {
        OAuthClientTracker clientTracker = new OAuthClientTracker(this.request, this.response, this.oauth20Provider);
        return clientTracker.updateLogoutUrlAndDeleteCookie(redirectUri);
    }

    void logOutUser(Principal user, String redirectUri, String userName, String idTokenString) throws ServletException {
        if (user != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("save  OIDC_END_SESSION_REDIRECT uri in op end_session : " + redirectUri), (Object[])new Object[0]);
            }
            this.request.logout();
        } else {
            this.sendBackchannelLogoutRequests(userName, idTokenString);
        }
    }

    void sendBackchannelLogoutRequests(String userName, String idTokenString) {
        BackchannelLogoutRequestHelper bclRequestCreator = new BackchannelLogoutRequestHelper(this.oidcServerConfig);
        bclRequestCreator.sendBackchannelLogoutRequests(userName, idTokenString);
    }

    void sendPostEndSessionRedirect(String redirectUri) throws IOException {
        this.request.removeAttribute("OIDC_END_SESSION_REDIRECT");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OIDC _SSO OP redirecting to [" + redirectUri + "]"), (Object[])new Object[0]);
        }
        this.response.sendRedirect(redirectUri);
    }
}

