/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.SingleTableCache;
import com.ibm.ws.security.openidconnect.client.internal.AccessTokenCacheKey;
import com.ibm.ws.security.openidconnect.client.internal.AccessTokenCacheValue;
import com.ibm.ws.security.openidconnect.client.jose4j.OidcTokenImpl;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AccessTokenCacheHelper {
    private static final TraceComponent tc = Tr.register(AccessTokenCacheHelper.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
    static final long serialVersionUID = -4100774136915217252L;

    public AccessTokenCacheKey getCacheKey(@Sensitive String accessToken, String configId) {
        return new AccessTokenCacheKey(accessToken, configId);
    }

    public ProviderAuthenticationResult getCachedTokenAuthenticationResult(OidcClientConfig clientConfig, String token) {
        AccessTokenCacheKey cacheKey;
        if (!clientConfig.getAccessTokenCacheEnabled()) {
            return null;
        }
        SingleTableCache cache = clientConfig.getCache();
        AccessTokenCacheValue cacheEntry = (AccessTokenCacheValue)cache.get((Object)(cacheKey = this.getCacheKey(token, clientConfig.getId())));
        if (cacheEntry == null) {
            return null;
        }
        ProviderAuthenticationResult result = cacheEntry.getResult();
        if (this.isTokenInCachedResultExpired(result, clientConfig)) {
            return null;
        }
        String uniqueID = cacheEntry.getUniqueID();
        Hashtable customProperties = result.getCustomProperties();
        if (customProperties.get("com.ibm.wsspi.security.cred.uniqueId") == null && uniqueID != null) {
            customProperties.put("com.ibm.wsspi.security.cred.uniqueId", uniqueID);
        }
        Subject newSubject = this.recreateSubject(result.getSubject());
        return new ProviderAuthenticationResult(result.getStatus(), result.getHttpStatusCode(), result.getUserName(), newSubject, customProperties, result.getRedirectUrl());
    }

    public void cacheTokenAuthenticationResult(OidcClientConfig clientConfig, String token, ProviderAuthenticationResult result) {
        if (clientConfig.getAccessTokenCacheEnabled()) {
            SingleTableCache cache = clientConfig.getCache();
            Hashtable customProperties = result.getCustomProperties();
            String uniqueID = null;
            if (customProperties != null) {
                uniqueID = (String)customProperties.get("com.ibm.wsspi.security.cred.uniqueId");
            }
            AccessTokenCacheKey cacheKey = this.getCacheKey(token, clientConfig.getId());
            cache.put((Object)cacheKey, (Object)new AccessTokenCacheValue(uniqueID, result), clientConfig.getClockSkew());
        }
    }

    boolean isTokenInCachedResultExpired(ProviderAuthenticationResult cachedResult, OidcClientConfig clientConfig) {
        Hashtable customProperties = cachedResult.getCustomProperties();
        if (customProperties == null || customProperties.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Custom properties were null or empty", (Object[])new Object[0]);
            }
            return true;
        }
        if (!this.doesPropertyExistInAccessTokenInfo("exp", customProperties)) {
            return false;
        }
        long tokenExp = this.getTokenExpirationFromCustomProperties(customProperties);
        long clockSkew = clientConfig.getClockSkewInSeconds();
        long now = System.currentTimeMillis() / 1000L;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Current system time: " + now + ", token expiration time: " + tokenExp + ", clockSkew: " + clockSkew), (Object[])new Object[0]);
        }
        return now > tokenExp + clockSkew;
    }

    @FFDCIgnore(value={Exception.class})
    boolean doesPropertyExistInAccessTokenInfo(String propertyName, Hashtable<String, Object> customProperties) {
        if (customProperties == null || customProperties.isEmpty()) {
            return false;
        }
        if (!customProperties.containsKey("access_token_info")) {
            return false;
        }
        try {
            Map tokenInfoMap = (Map)customProperties.get("access_token_info");
            if (tokenInfoMap == null) {
                return false;
            }
            if (!tokenInfoMap.containsKey(propertyName)) {
                return false;
            }
            return tokenInfoMap.get(propertyName) != null;
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to check " + propertyName + " from customer properties: " + e), (Object[])new Object[0]);
            }
            return false;
        }
    }

    @FFDCIgnore(value={Exception.class})
    long getTokenExpirationFromCustomProperties(Hashtable<String, Object> customProperties) {
        try {
            Map tokenInfoMap = (Map)customProperties.get("access_token_info");
            return (Long)tokenInfoMap.get("exp");
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Failed to obtain expiration time from customer properties: " + e), (Object[])new Object[0]);
            }
            return 0L;
        }
    }

    Subject recreateSubject(Subject cachedSubject) {
        Subject newSubject = new Subject();
        if (cachedSubject == null) {
            return newSubject;
        }
        Set<Object> newPRCreds = newSubject.getPrivateCredentials();
        Set<Object> cachedPRCreds = cachedSubject.getPrivateCredentials();
        for (Object cachedPRCred : cachedPRCreds) {
            if (!(cachedPRCred instanceof OidcTokenImpl) && !(cachedPRCred instanceof Hashtable)) continue;
            newPRCreds.add(cachedPRCred);
        }
        return newSubject;
    }
}

