/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transport.iiop.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AcidReference<T> {
    private final AtomicReference<Ref<T>> atomicReference = new AtomicReference<Ref>(() -> initial);
    static final long serialVersionUID = 5598114621309293442L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public AcidReference(T initial) {
    }

    public AcidReference() {
        this(null);
    }

    private Ref<T> getWithWait() {
        Ref<T> ref;
        while (!(ref = this.atomicReference.get()).isReady()) {
        }
        return ref;
    }

    public T get() {
        return this.getWithWait().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(Function<T, Supplier<T>> updaterSupplier) {
        Ref<T> ref = this.getWithWait();
        Supplier<T> neededUpdate = updaterSupplier.apply(ref.get());
        if (null == neededUpdate) {
            return false;
        }
        TransitionalRef tranRef = new TransitionalRef();
        while (!this.atomicReference.compareAndSet(ref, tranRef)) {
            ref = this.getWithWait();
            neededUpdate = updaterSupplier.apply(ref.get());
            if (null != neededUpdate) continue;
            return false;
        }
        try {
            Object newValue = neededUpdate.get();
            ref = () -> newValue;
            boolean bl = true;
            return bl;
        }
        finally {
            this.atomicReference.set(ref);
            tranRef.markAsReady();
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.internal.AcidReference", AcidReference.class, (String)"IIOP", (String)"com.ibm.ws.transport.iiop.resources.IiopMessages");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class TransitionalRef<T>
    implements Ref<T> {
        private final CountDownLatch latch = new CountDownLatch(1);
        private final Thread updaterThread = Thread.currentThread();
        static final long serialVersionUID = -5146069864389720931L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private TransitionalRef() {
        }

        @Override
        public boolean isReady() {
            if (Thread.currentThread() == this.updaterThread) {
                throw new IllegalStateException("Attempt to retrieve value during update process");
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.transport.iiop.internal.AcidReference$TransitionalRef", (String)"45", (Object)this, (Object[])new Object[0]);
            }
            return false;
        }

        void markAsReady() {
            this.latch.countDown();
        }

        @Override
        public T get() {
            throw new UnsupportedOperationException();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.transport.iiop.internal.AcidReference$TransitionalRef", TransitionalRef.class, (String)"IIOP", (String)"com.ibm.ws.transport.iiop.resources.IiopMessages");
        }
    }

    @FunctionalInterface
    private static interface Ref<T>
    extends Supplier<T> {
        default public boolean isReady() {
            return true;
        }
    }
}

