/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer.types;

import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.bind.JsonbException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.Function;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.yasson.internal.BuiltInTypes;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.serializer.ModelSerializer;
import org.eclipse.yasson.internal.serializer.SerializationModelCreator;
import org.eclipse.yasson.internal.serializer.types.BigDecimalSerializer;
import org.eclipse.yasson.internal.serializer.types.BigIntegerSerializer;
import org.eclipse.yasson.internal.serializer.types.BooleanSerializer;
import org.eclipse.yasson.internal.serializer.types.ByteSerializer;
import org.eclipse.yasson.internal.serializer.types.CalendarSerializer;
import org.eclipse.yasson.internal.serializer.types.CharSerializer;
import org.eclipse.yasson.internal.serializer.types.DateSerializer;
import org.eclipse.yasson.internal.serializer.types.DoubleSerializer;
import org.eclipse.yasson.internal.serializer.types.DurationSerializer;
import org.eclipse.yasson.internal.serializer.types.EnumSerializer;
import org.eclipse.yasson.internal.serializer.types.FloatSerializer;
import org.eclipse.yasson.internal.serializer.types.InstantSerializer;
import org.eclipse.yasson.internal.serializer.types.IntegerSerializer;
import org.eclipse.yasson.internal.serializer.types.JsonValueSerializer;
import org.eclipse.yasson.internal.serializer.types.LocalDateSerializer;
import org.eclipse.yasson.internal.serializer.types.LocalDateTimeSerializer;
import org.eclipse.yasson.internal.serializer.types.LocalTimeSerializer;
import org.eclipse.yasson.internal.serializer.types.LongSerializer;
import org.eclipse.yasson.internal.serializer.types.MonthDayTypeSerializer;
import org.eclipse.yasson.internal.serializer.types.NumberSerializer;
import org.eclipse.yasson.internal.serializer.types.ObjectTypeSerializer;
import org.eclipse.yasson.internal.serializer.types.OffsetDateTimeSerializer;
import org.eclipse.yasson.internal.serializer.types.OffsetTimeSerializer;
import org.eclipse.yasson.internal.serializer.types.OptionalDoubleSerializer;
import org.eclipse.yasson.internal.serializer.types.OptionalIntSerializer;
import org.eclipse.yasson.internal.serializer.types.OptionalLongSerializer;
import org.eclipse.yasson.internal.serializer.types.PathSerializer;
import org.eclipse.yasson.internal.serializer.types.PeriodSerializer;
import org.eclipse.yasson.internal.serializer.types.ShortSerializer;
import org.eclipse.yasson.internal.serializer.types.SqlDateSerializer;
import org.eclipse.yasson.internal.serializer.types.SqlTimestampSerializer;
import org.eclipse.yasson.internal.serializer.types.StringSerializer;
import org.eclipse.yasson.internal.serializer.types.TimeZoneSerializer;
import org.eclipse.yasson.internal.serializer.types.TypeSerializerBuilder;
import org.eclipse.yasson.internal.serializer.types.UriSerializer;
import org.eclipse.yasson.internal.serializer.types.UrlSerializer;
import org.eclipse.yasson.internal.serializer.types.UuidSerializer;
import org.eclipse.yasson.internal.serializer.types.XmlGregorianCalendarSerializer;
import org.eclipse.yasson.internal.serializer.types.YearMonthTypeSerializer;
import org.eclipse.yasson.internal.serializer.types.ZoneIdSerializer;
import org.eclipse.yasson.internal.serializer.types.ZoneOffsetSerializer;
import org.eclipse.yasson.internal.serializer.types.ZonedDateTimeSerializer;

public class TypeSerializers {
    private static final Map<Class<?>, Function<TypeSerializerBuilder, ModelSerializer>> SERIALIZERS;
    private static final Set<Class<?>> SUPPORTED_MAP_KEYS;
    private static final Map<Class<?>, Class<?>> OPTIONALS;

    private TypeSerializers() {
        throw new IllegalStateException("Util class cannot be instantiated");
    }

    public static boolean isSupportedMapKey(Class<?> clazz) {
        return Enum.class.isAssignableFrom(clazz) || SUPPORTED_MAP_KEYS.contains(clazz);
    }

    public static ModelSerializer getTypeSerializer(Class<?> clazz, Customization customization, JsonbContext jsonbContext) {
        return TypeSerializers.getTypeSerializer(Collections.emptyList(), clazz, customization, jsonbContext, false);
    }

    public static ModelSerializer getTypeSerializer(List<Type> chain, Class<?> clazz, Customization customization, JsonbContext jsonbContext, boolean key) {
        Class<?> current = clazz;
        LinkedList<Type> chainClone = new LinkedList<Type>(chain);
        TypeSerializerBuilder builder = new TypeSerializerBuilder(chainClone, clazz, customization, jsonbContext, key);
        ModelSerializer typeSerializer = null;
        if (Object.class.equals(current)) {
            return SERIALIZERS.get(current).apply(builder);
        }
        if (OPTIONALS.containsKey(current)) {
            Class<?> optionalInner = OPTIONALS.get(current);
            ModelSerializer serializer = TypeSerializers.getTypeSerializer(chainClone, optionalInner, customization, jsonbContext, key);
            if (OptionalInt.class.equals(current)) {
                return new OptionalIntSerializer(serializer);
            }
            if (OptionalLong.class.equals(current)) {
                return new OptionalLongSerializer(serializer);
            }
            if (OptionalDouble.class.equals(current)) {
                return new OptionalDoubleSerializer(serializer);
            }
            throw new JsonbException("Unsupported Optional type for serialization: " + clazz);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            typeSerializer = new EnumSerializer(builder);
        } else if (JsonValue.class.isAssignableFrom(clazz)) {
            typeSerializer = new JsonValueSerializer(builder);
        }
        if (typeSerializer == null) {
            do {
                if (!SERIALIZERS.containsKey(current)) continue;
                typeSerializer = SERIALIZERS.get(current).apply(builder);
                break;
            } while (!Object.class.equals(current = current.getSuperclass()) && current != null);
        }
        if (key) {
            return typeSerializer;
        }
        return typeSerializer == null ? null : SerializationModelCreator.wrapInCommonSet(typeSerializer, customization, jsonbContext);
    }

    static {
        HashMap<Class<Object>, Function<TypeSerializerBuilder, ModelSerializer>> cache = new HashMap<Class<Object>, Function<TypeSerializerBuilder, ModelSerializer>>();
        cache.put(Byte.class, ByteSerializer::new);
        cache.put(Byte.TYPE, ByteSerializer::new);
        cache.put(BigDecimal.class, BigDecimalSerializer::new);
        cache.put(BigInteger.class, BigIntegerSerializer::new);
        cache.put(Boolean.class, BooleanSerializer::new);
        cache.put(Boolean.TYPE, BooleanSerializer::new);
        cache.put(Calendar.class, CalendarSerializer::new);
        cache.put(Character.class, CharSerializer::new);
        cache.put(Character.TYPE, CharSerializer::new);
        cache.put(Date.class, DateSerializer::new);
        cache.put(Double.class, DoubleSerializer::new);
        cache.put(Double.TYPE, DoubleSerializer::new);
        cache.put(Duration.class, DurationSerializer::new);
        cache.put(Float.class, FloatSerializer::new);
        cache.put(Float.TYPE, FloatSerializer::new);
        cache.put(Integer.class, IntegerSerializer::new);
        cache.put(Integer.TYPE, IntegerSerializer::new);
        cache.put(Instant.class, InstantSerializer::new);
        cache.put(LocalDateTime.class, LocalDateTimeSerializer::new);
        cache.put(LocalDate.class, LocalDateSerializer::new);
        cache.put(LocalTime.class, LocalTimeSerializer::new);
        cache.put(Long.class, LongSerializer::new);
        cache.put(Long.TYPE, LongSerializer::new);
        cache.put(MonthDay.class, MonthDayTypeSerializer::new);
        cache.put(Number.class, NumberSerializer::new);
        cache.put(Object.class, ObjectTypeSerializer::new);
        cache.put(OffsetDateTime.class, OffsetDateTimeSerializer::new);
        cache.put(OffsetTime.class, OffsetTimeSerializer::new);
        cache.put(Path.class, PathSerializer::new);
        cache.put(Period.class, PeriodSerializer::new);
        cache.put(Short.class, ShortSerializer::new);
        cache.put(Short.TYPE, ShortSerializer::new);
        cache.put(String.class, StringSerializer::new);
        cache.put(TimeZone.class, TimeZoneSerializer::new);
        cache.put(URI.class, UriSerializer::new);
        cache.put(URL.class, UrlSerializer::new);
        cache.put(UUID.class, UuidSerializer::new);
        if (BuiltInTypes.isClassAvailable("javax.xml.datatype.XMLGregorianCalendar")) {
            cache.put(XMLGregorianCalendar.class, XmlGregorianCalendarSerializer::new);
        }
        cache.put(YearMonth.class, YearMonthTypeSerializer::new);
        cache.put(ZonedDateTime.class, ZonedDateTimeSerializer::new);
        cache.put(ZoneId.class, ZoneIdSerializer::new);
        cache.put(ZoneOffset.class, ZoneOffsetSerializer::new);
        if (BuiltInTypes.isClassAvailable("java.sql.Date")) {
            cache.put(Date.class, SqlDateSerializer::new);
            cache.put(java.sql.Date.class, SqlDateSerializer::new);
            cache.put(Timestamp.class, SqlTimestampSerializer::new);
        }
        SERIALIZERS = Map.copyOf(cache);
        HashMap<Class<OptionalLong>, Class<Long>> optionals = new HashMap<Class<OptionalLong>, Class<Long>>();
        optionals.put(OptionalDouble.class, Double.class);
        optionals.put(OptionalInt.class, Integer.class);
        optionals.put(OptionalLong.class, Long.class);
        OPTIONALS = Map.copyOf(optionals);
        HashSet mapKeys = new HashSet(SERIALIZERS.keySet());
        mapKeys.addAll(optionals.keySet());
        mapKeys.add(JsonNumber.class);
        mapKeys.add(JsonString.class);
        mapKeys.remove(Object.class);
        SUPPORTED_MAP_KEYS = Set.copyOf(mapKeys);
    }
}

