/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util.stub;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MethodRef {
    String name;
    Class<?> declaringClass;
    Class<?>[] parameterTypes;
    Class<?> returnType;
    Class<?>[] exceptionTypes;
    int modifiers;
    Method method;
    String signature;
    private static final Map<Class<?>, String> KNOWN_TYPE_MAP = Collections.unmodifiableMap(new HashMap<Class<?>, String>(){
        {
            this.put(Integer.TYPE, "I");
            this.put(Boolean.TYPE, "Z");
            this.put(Byte.TYPE, "B");
            this.put(Short.TYPE, "S");
            this.put(Long.TYPE, "J");
            this.put(Double.TYPE, "D");
            this.put(Float.TYPE, "F");
            this.put(Void.TYPE, "V");
            this.put(Character.TYPE, "C");
        }
    });

    public MethodRef(Method method) {
        this.method = method;
        this.name = method.getName();
        this.setDeclaringClass(method.getDeclaringClass());
        this.setParameterTypes(method.getParameterTypes());
        this.setReturnType(method.getReturnType());
        this.setExceptionTypes(method.getExceptionTypes());
        this.setModifiers(method.getModifiers());
    }

    static String getKey(Method m) {
        return m.getName() + MethodRef.getSignature(m.getReturnType(), m.getParameterTypes());
    }

    String getKey() {
        return this.getName() + this.getSignature();
    }

    public Method getMethod() {
        return this.method;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDeclaringClass(Class<?> declaringClass) {
        this.declaringClass = declaringClass;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setExceptionTypes(Class<?>[] exceptionTypes) {
        this.exceptionTypes = exceptionTypes;
    }

    public Class<?>[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getSignature() {
        if (null == this.signature) {
            this.signature = MethodRef.getSignature(this.returnType, this.parameterTypes);
        }
        return this.signature;
    }

    private static String getSignature(Class<?> rType, Class<?> ... pTypes) {
        return Stream.of(pTypes).map(MethodRef::getSignature).collect(Collectors.joining("", "(", ")" + MethodRef.getSignature(rType)));
    }

    static String getSignature(Class<?> clz) {
        if (clz.isPrimitive()) {
            return Optional.ofNullable(KNOWN_TYPE_MAP.get(clz)).orElseThrow(() -> new InternalError("cannot handle " + clz));
        }
        return clz.isArray() ? "[" + MethodRef.getSignature(clz.getComponentType()) : "L" + clz.getName().replace('.', '/') + ";";
    }
}

