/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.internal.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.internal.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.internal.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.internal.validation.ValidatorUtils;
import org.eclipse.microprofile.openapi.models.info.Contact;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ContactValidator
extends TypeValidator<Contact> {
    private static final TraceComponent tc = Tr.register(ContactValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final ContactValidator INSTANCE = new ContactValidator();
    static final long serialVersionUID = 7723445059620295660L;

    public static ContactValidator getInstance() {
        return INSTANCE;
    }

    private ContactValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, Contact t) {
        if (t != null) {
            String email;
            String url = t.getUrl();
            if (url != null && !ValidatorUtils.isValidURI(url)) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"contactInvalidURL", (Object[])new Object[]{url});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("url"), message));
            }
            if ((email = t.getEmail()) != null && !ValidatorUtils.isValidEmailAddress(email)) {
                String message = Tr.formatMessage((TraceComponent)tc, (String)"contactInvalidEmail", (Object[])new Object[]{email});
                helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.ERROR, context.getLocation("email"), message));
            }
        }
    }
}

