/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.openidconnect.token.IdToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcUtil;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class OidcClientCache {
    private static final TraceComponent tc = Tr.register(OidcClientCache.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
    static final String UTF8 = "UTF-8";
    AuthCacheService authCache = null;
    OidcClientConfig clientCfg = null;
    OidcClientRequest oidcClientRequest = null;
    String preKeyValue = null;
    @Sensitive
    String customCacheKey = null;
    static final long serialVersionUID = -340765262546822283L;

    OidcClientCache(AuthCacheService authCacheService, OidcClientConfig oidcClientConfig, OidcClientRequest oidcClientRequest) {
        this.authCache = authCacheService;
        this.clientCfg = oidcClientConfig;
        this.oidcClientRequest = oidcClientRequest;
    }

    public Subject getBackValidSubject(HttpServletRequest req, OidcClientConfig clientConfig) {
        String preKeyValue = this.getPreKeyValue(req);
        if (preKeyValue == null || preKeyValue.isEmpty()) {
            return null;
        }
        Subject subject = this.getBackCachedSubject(req, preKeyValue);
        if (subject != null && !this.isValid(subject, clientConfig.getReAuthnCushion(), clientConfig.isReAuthnOnAccessTokenExpire())) {
            this.removeSubject(req);
            subject = null;
        }
        return subject;
    }

    public Subject getBackCachedSubject(HttpServletRequest req, String preKeyValue) {
        Subject subject = null;
        this.customCacheKey = this.oidcClientRequest.getCustomCookieValue(preKeyValue);
        if (this.customCacheKey != null && !this.customCacheKey.isEmpty()) {
            subject = this.authCache.getSubject((Object)this.customCacheKey);
        }
        return subject;
    }

    public void removeSubject(HttpServletRequest req) {
        if (this.customCacheKey == null) {
            String preKeyValue = this.getPreKeyValue(req);
            this.customCacheKey = this.oidcClientRequest.getCustomCookieValue(preKeyValue);
        }
        if (this.customCacheKey != null && !this.customCacheKey.isEmpty()) {
            this.authCache.remove((Object)this.customCacheKey);
        }
        OidcUtil.removeCookie((OidcClientRequest)this.oidcClientRequest);
    }

    boolean isValid(Subject subject, long cushionMilliseconds, boolean checkAccessToken) {
        boolean valid = true;
        IdToken idToken = this.getIdToken(subject);
        if (idToken != null) {
            valid = this.isIdTokenValid(idToken, cushionMilliseconds);
        }
        if (valid && checkAccessToken) {
            valid = this.isAccessTokenValid(subject, cushionMilliseconds);
        }
        return valid;
    }

    boolean isIdTokenValid(IdToken idToken, long cushionMilliseconds) {
        long expSeconds = idToken.getExpirationTimeSeconds();
        Date date = new Date();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("date(" + date.getTime() + ") expSec(" + expSeconds + ") cushionMillisec(" + cushionMilliseconds + ")"), (Object[])new Object[0]);
        }
        return expSeconds * 1000L - cushionMilliseconds > date.getTime();
    }

    /*
     * WARNING - void declaration
     */
    boolean isAccessTokenValid(Subject subject, long cushionMilliseconds) {
        long lExpiresIn;
        block4: {
            String strExpiresIn = (String)this.getOAuthAttribute(subject, "expires_in");
            if (strExpiresIn == null || strExpiresIn.isEmpty()) {
                return false;
            }
            lExpiresIn = 0L;
            try {
                lExpiresIn = Long.parseLong(strExpiresIn) * 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                void e;
                FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.security.openidconnect.client.internal.OidcClientCache", (String)"136", (Object)this, (Object[])new Object[]{subject, cushionMilliseconds});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)"hit unexpected exception", (Object[])new Object[]{e});
            }
        }
        Long storeTimeMilliseconds = (Long)this.getOAuthAttribute(subject, "com.ibm.wssi.security.oidc.client.credential.storing.utc.time.milliseconds");
        Date date = new Date();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("date(" + date.getTime() + ") storeMilli(" + storeTimeMilliseconds + ") cushion(" + cushionMilliseconds + ")"), (Object[])new Object[0]);
        }
        return storeTimeMilliseconds + lExpiresIn - cushionMilliseconds > date.getTime();
    }

    protected IdToken getIdToken(Subject subject) {
        IdToken idToken;
        block4: {
            Set<IdToken> privateIdTokens;
            Iterator<IdToken> iterator;
            idToken = null;
            if (subject == null) break block4;
            Set<IdToken> idTokens = subject.getPublicCredentials(IdToken.class);
            Iterator<IdToken> iterator2 = idTokens.iterator();
            if (iterator2.hasNext()) {
                IdToken idTokenTmp;
                idToken = idTokenTmp = iterator2.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("public IdToken:" + idToken), (Object[])new Object[0]);
                }
            }
            if (idToken == null && (iterator = (privateIdTokens = subject.getPrivateCredentials(IdToken.class)).iterator()).hasNext()) {
                IdToken idTokenTmp;
                idToken = idTokenTmp = iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("private IdToken:" + idToken), (Object[])new Object[0]);
                }
            }
        }
        return idToken;
    }

    protected Object getOAuthAttribute(Subject subject, String attribKey) {
        Set<Object> publicCredentials = subject.getPublicCredentials();
        int iCnt = 0;
        for (Object credentialObj : publicCredentials) {
            Object obj;
            ++iCnt;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("publicCredential(" + iCnt + ") class:" + credentialObj.getClass().getName()), (Object[])new Object[0]);
            }
            if (!(credentialObj instanceof Map) || (obj = ((Map)credentialObj).get(attribKey)) == null) continue;
            return obj;
        }
        Set<Object> privCredentials = subject.getPrivateCredentials();
        for (Object credentialObj : privCredentials) {
            Object obj;
            ++iCnt;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("privateCredential(" + iCnt + ") class:" + credentialObj.getClass().getName()), (Object[])new Object[0]);
            }
            if (!(credentialObj instanceof Map) || (obj = ((Map)credentialObj).get(attribKey)) == null) continue;
            return obj;
        }
        return null;
    }

    public String getPreKeyValue(HttpServletRequest req) {
        if (this.preKeyValue == null) {
            try {
                String oidcClientCookieName = this.oidcClientRequest.getOidcClientCookieName();
                byte[] cookieValueBytes = ((IExtendedRequest)req).getCookieValueAsBytes(oidcClientCookieName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cookieValueBytes is null:" + (cookieValueBytes == null)), (Object[])new Object[0]);
                }
                if (cookieValueBytes != null && cookieValueBytes.length > 0) {
                    this.preKeyValue = new String(cookieValueBytes, UTF8);
                }
            }
            catch (Exception oidcClientCookieName) {
                FFDCFilter.processException((Throwable)oidcClientCookieName, (String)"com.ibm.ws.security.openidconnect.client.internal.OidcClientCache", (String)"222", (Object)this, (Object[])new Object[]{req});
                return null;
            }
        }
        return this.preKeyValue;
    }

    @Trivial
    public String getCustomCacheKey() {
        return this.customCacheKey;
    }
}

