/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.AuthenticationData;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.authentication.WSAuthenticationData;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.common.structures.BoundedHashMap;
import com.ibm.ws.security.common.web.WebUtils;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.oauth20.util.OAuth20ProviderUtils;
import com.ibm.ws.security.openidconnect.client.internal.AccessTokenAuthenticator;
import com.ibm.ws.security.openidconnect.client.internal.AttributeToSubjectExt;
import com.ibm.ws.security.openidconnect.client.internal.OidcClientAuthenticator;
import com.ibm.ws.security.openidconnect.client.internal.OidcClientCache;
import com.ibm.ws.security.openidconnect.client.internal.OidcClientConfigImpl;
import com.ibm.ws.security.openidconnect.client.web.OidcRedirectServlet;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionInfo;
import com.ibm.ws.security.openidconnect.clients.common.OidcSessionUtils;
import com.ibm.ws.security.openidconnect.clients.common.OidcUtil;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.PostParameterHelper;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.UnprotectedResourceService;
import com.ibm.ws.webcontainer.security.openidconnect.OidcClient;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.oauth20.UserCredentialResolver;
import com.ibm.wsspi.ssl.SSLSupport;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OidcClientImpl
implements OidcClient,
UnprotectedResourceService {
    private static final TraceComponent tc = Tr.register(OidcClientImpl.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
    static final String KEY_SECURITY_SERVICE = "securityService";
    public static final String CFG_KEY_OPENID_CONNECT_CLIENT_CONFIG = "oidcClientConfig";
    public static final String KEY_FILTER = "authFilter";
    protected static final String KEY_SERVICE_PID = "service.pid";
    public static final String CFG_KEY_ID = "id";
    public static final String KEY_SSL_SUPPORT = "sslSupport";
    protected final AtomicServiceReference<SSLSupport> sslSupportRef = new AtomicServiceReference("sslSupport");
    OidcClientAuthenticator oidcClientAuthenticator;
    AccessTokenAuthenticator accessTokenAuthenticator;
    boolean initOidcClientAuth = false;
    private final Object initOidcClientAuthLock = new Object(){
        static final long serialVersionUID = 3683499390514337751L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.openidconnect.client.internal.OidcClientImpl$1", 1.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
        }
    };
    boolean initBeforeSso = false;
    private final BoundedHashMap authFilterWarnings = new BoundedHashMap(10);
    static final String KEY_AUTH_CACHE_SERVICE = "authCacheService";
    static final AtomicServiceReference<AuthCacheService> authCacheServiceRef = new AtomicServiceReference("authCacheService");
    static SubjectHelper subjectHelper = new SubjectHelper();
    private final AtomicServiceReference<SecurityService> securityServiceRef = new AtomicServiceReference("securityService");
    SecurityService securityService = null;
    private final ConcurrentServiceReferenceMap<String, OidcClientConfig> oidcClientConfigRef = new ConcurrentServiceReferenceMap("oidcClientConfig");
    protected final ConcurrentServiceReferenceMap<String, AuthenticationFilter> authFilterServiceRef = new ConcurrentServiceReferenceMap("authFilter");
    public static final String KEY_USER_RESOLVER = "userResolver";
    protected final ConcurrentServiceReferenceMap<String, UserCredentialResolver> userResolverRef = new ConcurrentServiceReferenceMap("userResolver");
    int iClientIsBeforeSso = 0;
    boolean needProviderHint = true;
    static final long serialVersionUID = 5453844537047217574L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setOidcClientConfig(ServiceReference<OidcClientConfig> ref) {
        Object object = this.initOidcClientAuthLock;
        synchronized (object) {
            this.oidcClientConfigRef.putReference((Object)((String)ref.getProperty(CFG_KEY_ID)), ref);
            this.initOidcClientAuth = true;
            this.initBeforeSso = true;
            this.warnIfAuthFilterUseDuplicated(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedOidcClientConfig(ServiceReference<OidcClientConfig> ref) {
        Object object = this.initOidcClientAuthLock;
        synchronized (object) {
            this.oidcClientConfigRef.putReference((Object)((String)ref.getProperty(CFG_KEY_ID)), ref);
            this.initOidcClientAuth = true;
            this.initBeforeSso = true;
            this.warnIfAuthFilterUseDuplicated(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetOidcClientConfig(ServiceReference<OidcClientConfig> ref) {
        Object object = this.initOidcClientAuthLock;
        synchronized (object) {
            this.oidcClientConfigRef.removeReference((Object)((String)ref.getProperty(CFG_KEY_ID)), ref);
            this.initOidcClientAuth = true;
            this.initBeforeSso = true;
        }
    }

    protected void setSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
        this.initOidcClientAuth = true;
    }

    protected void updatedSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.setReference(ref);
        this.initOidcClientAuth = true;
    }

    protected void unsetSslSupport(ServiceReference<SSLSupport> ref) {
        this.sslSupportRef.unsetReference(ref);
        this.initOidcClientAuth = true;
    }

    protected void setSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.setReference(reference);
        this.securityService = (SecurityService)this.securityServiceRef.getService();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("OLGH22405 - setSecurityService service.pid:" + reference.getProperty(KEY_SERVICE_PID)), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("OLGH22405 - setSecurityService securityService:" + this.securityService), (Object[])new Object[0]);
        }
        this.initOidcClientAuth = true;
    }

    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        this.securityServiceRef.unsetReference(reference);
        this.securityService = null;
        this.initOidcClientAuth = true;
    }

    protected void setOidcClientAuthenticator(OidcClientAuthenticator oidcClientAuthenticator) {
        this.oidcClientAuthenticator = oidcClientAuthenticator;
    }

    protected OidcClientAuthenticator getOidcClientAuthenticator() {
        return this.oidcClientAuthenticator;
    }

    protected void setAccessTokenAuthenticator(AccessTokenAuthenticator accessTokenAuthenticator) {
        this.accessTokenAuthenticator = accessTokenAuthenticator;
    }

    protected AccessTokenAuthenticator getAccessTokenAuthenticator() {
        return this.accessTokenAuthenticator;
    }

    protected void setAuthFilter(ServiceReference<AuthenticationFilter> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAuthenticationFilter id:" + ref.getProperty(CFG_KEY_ID)), (Object[])new Object[0]);
        }
        this.authFilterServiceRef.putReference((Object)((String)ref.getProperty(CFG_KEY_ID)), ref);
    }

    protected void updatedAuthenticationFilter(ServiceReference<AuthenticationFilter> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatedAuthenticationFilter id:" + ref.getProperty(CFG_KEY_ID)), (Object[])new Object[0]);
        }
        this.authFilterServiceRef.putReference((Object)((String)ref.getProperty(CFG_KEY_ID)), ref);
    }

    protected void unsetAuthFilter(ServiceReference<AuthenticationFilter> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetAuthenticationFilter id:" + ref.getProperty(CFG_KEY_ID)), (Object[])new Object[0]);
        }
        this.authFilterServiceRef.removeReference((Object)((String)ref.getProperty(CFG_KEY_ID)), ref);
    }

    protected void setAuthCacheService(ServiceReference<AuthCacheService> reference) {
        authCacheServiceRef.setReference(reference);
    }

    protected void unsetAuthCacheService(ServiceReference<AuthCacheService> reference) {
        authCacheServiceRef.unsetReference(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserResolver(ServiceReference<UserCredentialResolver> ref) {
        String serviceId = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, UserCredentialResolver> concurrentServiceReferenceMap = this.userResolverRef;
        synchronized (concurrentServiceReferenceMap) {
            this.userResolverRef.putReference((Object)serviceId, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" setUserResolver id:" + serviceId), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatedUserResolver(ServiceReference<UserCredentialResolver> ref) {
        String serviceId = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, UserCredentialResolver> concurrentServiceReferenceMap = this.userResolverRef;
        synchronized (concurrentServiceReferenceMap) {
            this.userResolverRef.putReference((Object)serviceId, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" updateUserResolver id:" + serviceId), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetUserResolver(ServiceReference<UserCredentialResolver> ref) {
        String serviceId = (String)ref.getProperty(KEY_SERVICE_PID);
        ConcurrentServiceReferenceMap<String, UserCredentialResolver> concurrentServiceReferenceMap = this.userResolverRef;
        synchronized (concurrentServiceReferenceMap) {
            this.userResolverRef.removeReference((Object)serviceId, ref);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" unsetUserResolverRef id:" + serviceId), (Object[])new Object[0]);
        }
    }

    protected void activate(ComponentContext cc) {
        this.sslSupportRef.activate(cc);
        this.securityServiceRef.activate(cc);
        this.authFilterServiceRef.activate(cc);
        authCacheServiceRef.activate(cc);
        this.userResolverRef.activate(cc);
        AttributeToSubjectExt.setActivatedUserResolverRef(this.userResolverRef);
        this.oidcClientConfigRef.activate(cc);
        this.initOidcClientAuth = true;
        this.initBeforeSso = true;
        OidcRedirectServlet.setActivatedOidcClientImpl(this);
    }

    protected synchronized void modify(Map<String, Object> properties) {
    }

    protected synchronized void deactivate(ComponentContext cc) {
        this.sslSupportRef.deactivate(cc);
        this.securityServiceRef.deactivate(cc);
        this.authFilterServiceRef.deactivate(cc);
        authCacheServiceRef.deactivate(cc);
        this.oidcClientConfigRef.deactivate(cc);
        this.oidcClientAuthenticator = null;
    }

    void warnIfAuthFilterUseDuplicated(Iterator<OidcClientConfig> configs) {
        if (configs == null) {
            configs = this.oidcClientConfigRef.getServices();
        }
        ArrayList<String> authFilters = new ArrayList<String>();
        while (configs.hasNext()) {
            OidcClientConfig config = (OidcClientConfig)configs.next();
            String authFilter = config.getAuthFilterId();
            if (authFilter == null) continue;
            if (authFilters.contains(authFilter)) {
                if (this.authFilterWarnings.containsKey((Object)authFilter)) continue;
                Tr.warning((TraceComponent)tc, (String)"CONFIG_AUTHFILTER_NOTUNIQUE", (Object[])new Object[]{authFilter});
                this.authFilterWarnings.put((Object)authFilter, null);
                continue;
            }
            authFilters.add(authFilter);
        }
    }

    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, String provider, ReferrerURLCookieHandler referrerURLCookieHandler, boolean beforeSso) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OIDC _SSO RP PROCESS IS STARTING.", (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("OIDC _SSO RP inbound URL " + WebUtils.getRequestStringForTrace((HttpServletRequest)req, (String)"client_secret")), (Object[])new Object[0]);
        }
        PostParameterHelper.savePostParams((IExtendedRequest)((IExtendedRequest)req));
        OidcClientConfig oidcClientConfig = (OidcClientConfig)this.oidcClientConfigRef.getService((Object)provider);
        OidcClientRequest oidcClientRequest = new OidcClientRequest(req, res, (ConvergedClientConfig)oidcClientConfig, referrerURLCookieHandler);
        req.setAttribute("com.ibm.wsspi.security.oidc.client.request", (Object)oidcClientRequest);
        ProviderAuthenticationResult result = this.authenticate(req, res, provider, referrerURLCookieHandler, beforeSso, oidcClientConfig, oidcClientRequest);
        this.handleOauthChallenge(res, result);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OIDC _SSO RP PROCESS HAS ENDED.", (Object[])new Object[0]);
        }
        return result;
    }

    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, String provider, ReferrerURLCookieHandler referrerURLCookieHandler, boolean beforeSso, OidcClientConfig oidcClientConfig, OidcClientRequest oidcClientRequest) {
        ProviderAuthenticationResult result = null;
        if (beforeSso) {
            if (oidcClientConfig.isDisableLtpaCookie()) {
                OidcClientCache oidcCache = new OidcClientCache((AuthCacheService)authCacheServiceRef.getService(), oidcClientConfig, oidcClientRequest);
                Subject readOnlySubject = oidcCache.getBackValidSubject(req, oidcClientConfig);
                if (readOnlySubject != null) {
                    String username = OidcUtil.getUserNameFromSubject((Subject)readOnlySubject);
                    Hashtable<String, Object> customProperties = new Hashtable<String, Object>();
                    String customCacheKey = oidcCache.getCustomCacheKey();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("customCacheKey is :" + customCacheKey), (Object[])new Object[0]);
                    }
                    if (oidcClientConfig.isIncludeCustomCacheKeyInSubject()) {
                        customProperties.put("com.ibm.wsspi.security.cred.cacheKey", customCacheKey);
                    }
                    customProperties.put("com.ibm.ws.authentication.internal.assertion", Boolean.TRUE);
                    result = new ProviderAuthenticationResult(AuthResult.SUCCESS, 200, username, null, customProperties, null);
                } else {
                    result = this.authenticate(req, res, provider, oidcClientRequest);
                    if (result.getStatus() == AuthResult.SUCCESS) {
                        oidcClientRequest.createOidcClientCookieIfAnyAndDisableLtpa();
                    }
                }
            } else {
                result = "required".equalsIgnoreCase(oidcClientConfig.getInboundPropagation()) ? this.authenticate(req, res, provider, oidcClientRequest) : new ProviderAuthenticationResult(AuthResult.CONTINUE, 200);
            }
        } else {
            result = !oidcClientConfig.isDisableLtpaCookie() ? this.authenticate(req, res, provider, oidcClientRequest) : new ProviderAuthenticationResult(AuthResult.CONTINUE, 200);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("result httpStatusCode:" + result.getHttpStatusCode() + " status:" + result.getStatus() + " result:" + result), (Object[])new Object[0]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, String provider, OidcClientRequest oidcClientRequest) {
        OidcClientConfig oidcClientConfig = oidcClientRequest.getOidcClientConfig();
        if (this.initOidcClientAuth) {
            Object object = this.initOidcClientAuthLock;
            synchronized (object) {
                if (this.initOidcClientAuth) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Initializing authenticator objects", (Object[])new Object[0]);
                    }
                    this.oidcClientAuthenticator = new OidcClientAuthenticator(this.sslSupportRef);
                    this.accessTokenAuthenticator = new AccessTokenAuthenticator(this.sslSupportRef);
                    this.initOidcClientAuth = false;
                }
            }
        }
        if (!oidcClientConfig.getInboundPropagation().equalsIgnoreCase("none")) {
            ProviderAuthenticationResult oidcResult;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Token propagation is supported or required. Will attempt to authenticate using a provided token", (Object[])new Object[0]);
            }
            if ((oidcResult = this.accessTokenAuthenticator.authenticate(req, res, oidcClientConfig, oidcClientRequest)).getHttpStatusCode() == 200) {
                return oidcResult;
            }
            if (oidcClientConfig.getInboundPropagation().equalsIgnoreCase("required")) {
                oidcClientRequest.setWWWAuthenticate();
                return oidcResult;
            }
            String rsFailMsg = oidcClientRequest.getRsFailMsg();
            if (rsFailMsg != null) {
                boolean suppress = rsFailMsg.equals("suppress_CWWKS1704W");
                if (!suppress) {
                    Tr.warning((TraceComponent)tc, (String)"OIDC_CLIENT_BAD_RS_TOKEN", (Object[])new Object[]{rsFailMsg, provider});
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"access token was not present, warning message was suppressed", (Object[])new Object[0]);
                }
            }
        }
        return this.oidcClientAuthenticator.authenticate(req, res, oidcClientConfig);
    }

    public void logoutIfSessionInvalidated(HttpServletRequest req) {
        String provider = this.getOidcProvider(req);
        if (provider == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not get oidc provider.", (Object[])new Object[0]);
            }
            return;
        }
        OidcClientConfig oidcClientConfig = (OidcClientConfig)this.oidcClientConfigRef.getService((Object)provider);
        OidcSessionInfo sessionInfo = OidcSessionInfo.getSessionInfo((HttpServletRequest)req, (ConvergedClientConfig)oidcClientConfig);
        if (sessionInfo == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Session info could not be retrieved from client cookies.", (Object[])new Object[0]);
            }
            return;
        }
        OidcSessionUtils.logoutIfSessionInvalidated((HttpServletRequest)req, (OidcSessionInfo)sessionInfo, (ConvergedClientConfig)oidcClientConfig);
    }

    private boolean requestHasOidcCookie(HttpServletRequest req) {
        return this.requestHasCookie(req, "WASOidcClient_");
    }

    private boolean requestHasCookie(HttpServletRequest req, String cookieNamePrefix) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie ck = cookies[i];
                if (!ck.getName().startsWith(cookieNamePrefix)) continue;
                return true;
            }
        }
        return false;
    }

    public String getOidcProvider(HttpServletRequest req) {
        Iterator oidcClientConfigs;
        String ctxPath = req.getContextPath();
        if ("/IBMJMXConnectorREST".equals(ctxPath)) {
            if (!this.requestHasOidcCookie(req)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"return null for contextPath=/IBMJMXConnectorREST", (Object[])new Object[0]);
                }
                return null;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"contextPath=/IBMJMXConnectorREST but oidc cookie found, let authentication proceed", (Object[])new Object[0]);
            }
        }
        Iterator clientConfigs = this.oidcClientConfigRef.getServices();
        while (clientConfigs.hasNext()) {
            if (!ctxPath.equals(((OidcClientConfig)clientConfigs.next()).getContextPath())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("return null for contextPath " + ctxPath + " matches a clientConfig context path"), (Object[])new Object[0]);
            }
            return null;
        }
        String oidcProvider = null;
        String reqProviderHint = null;
        if (this.needProviderHint()) {
            reqProviderHint = this.getReqProviderHint(req);
        }
        if ((oidcProvider = this.getProviderConfig(oidcClientConfigs = this.oidcClientConfigRef.getServices(), reqProviderHint, req)) != null) {
            this.warnIfAmbiguousAuthFilters(this.oidcClientConfigRef.getServices(), req, this.authFilterServiceRef);
        }
        return oidcProvider;
    }

    void warnIfAmbiguousAuthFilters(Iterator<OidcClientConfig> oidcClientConfigs, HttpServletRequest req, ConcurrentServiceReferenceMap<String, AuthenticationFilter> AFServiceRef) {
        HashMap acceptingAuthFilterIds = new HashMap();
        while (oidcClientConfigs.hasNext()) {
            String authFilterId;
            OidcClientConfig clientConfig = oidcClientConfigs.next();
            if (!clientConfig.isValidConfig() || (authFilterId = clientConfig.getAuthFilterId()) == null || authFilterId.length() <= 0) continue;
            AuthenticationFilter authFilter = (AuthenticationFilter)AFServiceRef.getService((Object)authFilterId);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authFilter id:" + authFilterId + " authFilter:" + authFilter), (Object[])new Object[0]);
            }
            if (authFilter == null || !authFilter.isAccepted(req)) continue;
            acceptingAuthFilterIds.put(authFilterId, null);
        }
        if (acceptingAuthFilterIds.size() > 1) {
            String filterIds = "";
            Iterator it = acceptingAuthFilterIds.keySet().iterator();
            while (it.hasNext()) {
                filterIds = filterIds + (String)it.next() + " ";
            }
            filterIds = filterIds.trim();
            Tr.warning((TraceComponent)tc, (String)"AUTHFILTER_MULTIPLE_MATCHED", (Object[])new Object[]{req.getRequestURL(), filterIds});
        }
    }

    String getReqProviderHint(HttpServletRequest req) {
        String providerHint = this.getHeader(req, "oidcAuthnHint");
        if (providerHint == null || providerHint.isEmpty()) {
            providerHint = this.getHeader(req, "oidc_client");
        }
        if (providerHint == null || providerHint.isEmpty()) {
            PostParameterHelper.savePostParams((IExtendedRequest)((IExtendedRequest)req));
            providerHint = req.getParameter("oidc_client");
            if (providerHint != null) {
                providerHint = providerHint.trim();
            }
        }
        return providerHint;
    }

    String getHeader(HttpServletRequest req, String headerName) {
        String providerHint = req.getHeader(headerName);
        if (providerHint != null) {
            providerHint = providerHint.trim();
        }
        return providerHint;
    }

    protected String getProviderConfig(Iterator<OidcClientConfig> oidcClientConfigs, String reqProviderHint, HttpServletRequest req) {
        return this.getProviderConfig(reqProviderHint, req);
    }

    protected String getProviderConfigCurrent(Iterator<OidcClientConfig> oidcClientConfigs, String reqProviderHint, HttpServletRequest req) {
        while (oidcClientConfigs.hasNext()) {
            OidcClientConfig oidcClientConfig = oidcClientConfigs.next();
            if (!oidcClientConfig.isValidConfig()) continue;
            String provider = oidcClientConfig.getId();
            if (reqProviderHint != null) {
                if (reqProviderHint.equalsIgnoreCase(provider) && this.authFilter(oidcClientConfig, req, provider) != null) {
                    return provider;
                }
                String issuerIdentifier = oidcClientConfig.getIssuerIdentifier();
                if (!reqProviderHint.equals(issuerIdentifier) || this.authFilter(oidcClientConfig, req, provider) == null) continue;
                return provider;
            }
            String providerCfg = this.authFilter(oidcClientConfig, req, provider);
            if (providerCfg == null) continue;
            return providerCfg;
        }
        return null;
    }

    protected String getProviderConfig(String reqProviderHint, HttpServletRequest req) {
        String provider = null;
        if (reqProviderHint != null) {
            provider = this.selectByRequestProviderHint(req, reqProviderHint);
        } else {
            provider = this.selectByAuthFilter(req);
            if (provider == null) {
                provider = this.selectByIssuer(req);
            }
            if (provider == null) {
                provider = this.selectNonFiltered(req);
            }
        }
        return provider;
    }

    private String selectByRequestProviderHint(HttpServletRequest req, String reqProviderHint) {
        Iterator oidcClientConfigs = this.oidcClientConfigRef.getServices();
        while (oidcClientConfigs.hasNext()) {
            OidcClientConfig oidcClientConfig = (OidcClientConfig)oidcClientConfigs.next();
            if (!oidcClientConfig.isValidConfig()) continue;
            String provider = oidcClientConfig.getId();
            if (reqProviderHint.equalsIgnoreCase(provider) && this.authFilter(oidcClientConfig, req, provider) != null) {
                return provider;
            }
            String issuerIdentifier = oidcClientConfig.getIssuerIdentifier();
            if (!reqProviderHint.equals(issuerIdentifier) || this.authFilter(oidcClientConfig, req, provider) == null) continue;
            return provider;
        }
        return null;
    }

    String authFilter(OidcClientConfig oidcClientConfig, HttpServletRequest req, String provider) {
        String authFilterId = oidcClientConfig.getAuthFilterId();
        if (authFilterId != null && authFilterId.length() > 0) {
            AuthenticationFilter authFilter = (AuthenticationFilter)this.authFilterServiceRef.getService((Object)authFilterId);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authFilter id:" + authFilterId + " authFilter:" + authFilter), (Object[])new Object[0]);
            }
            if (authFilter != null && !authFilter.isAccepted(req)) {
                return null;
            }
        }
        return provider;
    }

    private String selectByAuthFilter(HttpServletRequest req) {
        Iterator oidcClientConfigs = this.oidcClientConfigRef.getServices();
        while (oidcClientConfigs.hasNext()) {
            OidcClientConfig oidcClientConfig = (OidcClientConfig)oidcClientConfigs.next();
            if (!oidcClientConfig.isValidConfig()) continue;
            String provider = oidcClientConfig.getId();
            if (!this.isConfigUsableByAuthFilter(oidcClientConfig, req)) continue;
            return provider;
        }
        return null;
    }

    private String selectByIssuer(HttpServletRequest req) {
        AccessTokenAuthenticator tempAccessTokenAuthenticator;
        Iterator oidcClientConfigs = this.oidcClientConfigRef.getServices();
        AccessTokenAuthenticator accessTokenAuthenticator = tempAccessTokenAuthenticator = this.accessTokenAuthenticator != null ? this.accessTokenAuthenticator : new AccessTokenAuthenticator();
        while (oidcClientConfigs.hasNext()) {
            OidcClientConfig oidcClientConfig = (OidcClientConfig)oidcClientConfigs.next();
            if (!oidcClientConfig.isValidConfig()) continue;
            String provider = oidcClientConfig.getId();
            if (!tempAccessTokenAuthenticator.canUseIssuerAsSelectorForInboundPropagation(req, oidcClientConfig)) continue;
            return provider;
        }
        return null;
    }

    private String selectNonFiltered(HttpServletRequest req) {
        Iterator oidcClientConfigs = this.oidcClientConfigRef.getServices();
        while (oidcClientConfigs.hasNext()) {
            OidcClientConfig oidcClientConfig = (OidcClientConfig)oidcClientConfigs.next();
            if (!oidcClientConfig.isValidConfig()) continue;
            String provider = oidcClientConfig.getId();
            String authFilterId = oidcClientConfig.getAuthFilterId();
            if (authFilterId != null && authFilterId.length() > 0) {
                AuthenticationFilter authFilter = (AuthenticationFilter)this.authFilterServiceRef.getService((Object)authFilterId);
                if (authFilter != null) continue;
                return provider;
            }
            return provider;
        }
        return null;
    }

    private boolean isConfigUsableByAuthFilter(OidcClientConfig oidcClientConfig, HttpServletRequest req) {
        boolean result = false;
        String authFilterId = oidcClientConfig.getAuthFilterId();
        if (authFilterId != null && authFilterId.length() > 0) {
            AuthenticationFilter authFilter = (AuthenticationFilter)this.authFilterServiceRef.getService((Object)authFilterId);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authFilter id:" + authFilterId + " authFilter:" + authFilter), (Object[])new Object[0]);
            }
            if (authFilter != null && authFilter.isAccepted(req)) {
                result = true;
            }
        }
        return result;
    }

    public boolean isMapIdentityToRegistryUser(String provider) {
        return ((OidcClientConfig)this.oidcClientConfigRef.getService((Object)provider)).isMapIdentityToRegistryUser();
    }

    public boolean isValidRedirectUrl(HttpServletRequest req) {
        String path;
        OidcClientConfig oidcClientConfig;
        String uri = req.getRequestURI();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Validate Request URI:" + uri), (Object[])new Object[0]);
        }
        String clientId = null;
        int iPrefix = uri.lastIndexOf("/");
        if (iPrefix > -1) {
            clientId = uri.substring(iPrefix + 1);
        }
        if ((oidcClientConfig = (OidcClientConfig)this.oidcClientConfigRef.getService(clientId)) != null && uri.endsWith(path = oidcClientConfig.getContextPath() + "/redirect/" + clientId)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Configuration id:" + clientId), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean isAuthenticationRequired(HttpServletRequest request) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logout(HttpServletRequest request, HttpServletResponse response, String userName) {
        boolean bSetSubject = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("logout() userName:" + userName), (Object[])new Object[0]);
        }
        ConcurrentServiceReferenceMap<String, OidcClientConfig> concurrentServiceReferenceMap = this.oidcClientConfigRef;
        synchronized (concurrentServiceReferenceMap) {
            Iterator services = this.oidcClientConfigRef.getServices();
            while (services.hasNext()) {
                OidcClientConfig oidcClientConfig = (OidcClientConfig)services.next();
                OidcSessionUtils.removeOidcSession((HttpServletRequest)request, (HttpServletResponse)response, (ConvergedClientConfig)oidcClientConfig);
                OidcClientRequest oidcClientRequest = new OidcClientRequest(request, response, (ConvergedClientConfig)oidcClientConfig, (ReferrerURLCookieHandler)null);
                if (!this.handleOidcCookie(request, response, oidcClientRequest, userName, bSetSubject)) continue;
                bSetSubject = true;
            }
        }
        return bSetSubject;
    }

    @FFDCIgnore(value={CredentialExpiredException.class, CredentialDestroyedException.class})
    boolean handleOidcCookie(HttpServletRequest req, HttpServletResponse response, OidcClientRequest oidcClientRequest, String userName, boolean bSetSubjectAlready) {
        boolean bSetSubject = false;
        OidcClientConfig oidcClientConfig = oidcClientRequest.getOidcClientConfig();
        if (oidcClientConfig.isDisableLtpaCookie()) {
            WSCredential wsCredential;
            OidcClientCache oidcCache = new OidcClientCache((AuthCacheService)authCacheServiceRef.getService(), oidcClientConfig, oidcClientRequest);
            String preKeyValue = oidcCache.getPreKeyValue(req);
            if (preKeyValue == null || preKeyValue.isEmpty()) {
                return false;
            }
            Subject subject = oidcCache.getBackCachedSubject(req, preKeyValue);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("subject from cache is:" + subject), (Object[])new Object[0]);
            }
            if (subject == null) {
                OidcUtil.removeCookie((OidcClientRequest)oidcClientRequest);
                return false;
            }
            if (userName != null && !bSetSubjectAlready && (wsCredential = this.getWSCredential(subject)) != null) {
                try {
                    String accessId = wsCredential.getAccessId();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("wsCredential user:" + accessId), (Object[])new Object[0]);
                    }
                    if (this.sameUser(userName, accessId)) {
                        WSAuthenticationData authenticationData = new WSAuthenticationData();
                        authenticationData.set("HTTP_SERVLET_REQUEST", (Object)req);
                        authenticationData.set("HTTP_SERVLET_RESPONSE", (Object)response);
                        authenticationData.set("TOKEN64", (Object)oidcCache.getCustomCacheKey());
                        if (this.authenticateSubject(subject, req, response, (AuthenticationData)authenticationData)) {
                            bSetSubject = true;
                        }
                    }
                }
                catch (CredentialExpiredException credentialExpiredException) {
                }
                catch (CredentialDestroyedException credentialDestroyedException) {
                    // empty catch block
                }
            }
            oidcCache.removeSubject(req);
        }
        return bSetSubject;
    }

    /*
     * WARNING - void declaration
     */
    boolean authenticateSubject(Subject subject, HttpServletRequest req, HttpServletResponse resp, AuthenticationData authenticationData) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("subject from oidcCookie is:" + subject), (Object[])new Object[0]);
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("OLGH22405 - securityService:" + this.securityServiceRef.getService()), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)("OLGH22405 - authenticationService:" + ((SecurityService)this.securityServiceRef.getService()).getAuthenticationService()), (Object[])new Object[0]);
            }
            SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
            AuthenticationService authenticationService = securityService.getAuthenticationService();
            return this.authenticateWithSubject(req, resp, subject, authenticationService, authenticationData);
        }
        catch (Exception securityService) {
            FFDCFilter.processException((Throwable)securityService, (String)"com.ibm.ws.security.openidconnect.client.internal.OidcClientImpl", (String)"912", (Object)this, (Object[])new Object[]{subject, req, resp, authenticationData});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("OLGH22405 - exception authenticateWithSubject():" + e.getMessage()), (Object[])new Object[0]);
            }
            return false;
        }
    }

    @FFDCIgnore(value={AuthenticationException.class})
    boolean authenticateWithSubject(HttpServletRequest req, HttpServletResponse res, Subject subject, AuthenticationService authenticationService, AuthenticationData authenticationData) {
        try {
            Subject newSubject = authenticationService.authenticate("system.WEB_INBOUND", authenticationData, subject);
            SubjectManager subjectManager = new SubjectManager();
            subjectManager.setCallerSubject(newSubject);
        }
        catch (AuthenticationException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("authenticationException:" + (Object)((Object)e)), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    protected WSCredential getWSCredential(Subject subject) {
        if (subject == null) {
            return null;
        }
        Set<WSCredential> credentials = subject.getPublicCredentials(WSCredential.class);
        return credentials.iterator().next();
    }

    protected boolean sameUser(String userName, String accessId) {
        if (userName == null) {
            return false;
        }
        return userName.equals(accessId);
    }

    public OidcClientConfigImpl getOidcClientConfig(HttpServletRequest req, String clientId) {
        Iterator oidcClientConfigs = this.oidcClientConfigRef.getServices();
        while (oidcClientConfigs.hasNext()) {
            OidcClientConfig oidcClientConfig = (OidcClientConfig)oidcClientConfigs.next();
            if (!oidcClientConfig.isValidConfig() || !oidcClientConfig.getId().equals(clientId)) continue;
            return (OidcClientConfigImpl)oidcClientConfig;
        }
        return null;
    }

    public boolean anyClientIsBeforeSso() {
        if (this.initBeforeSso) {
            this.initOidcClientConfigs();
        }
        return this.iClientIsBeforeSso > 0;
    }

    public boolean needProviderHint() {
        if (this.initBeforeSso) {
            this.initOidcClientConfigs();
        }
        return this.needProviderHint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initOidcClientConfigs() {
        Object object = this.initOidcClientAuthLock;
        synchronized (object) {
            if (this.initBeforeSso) {
                this.iClientIsBeforeSso = 0;
                this.needProviderHint = false;
                Iterator oidcClientConfigs = this.oidcClientConfigRef.getServices();
                while (oidcClientConfigs.hasNext()) {
                    OidcClientConfig oidcClientConfig = (OidcClientConfig)oidcClientConfigs.next();
                    if (oidcClientConfig.isDisableLtpaCookie()) {
                        ++this.iClientIsBeforeSso;
                    } else if ("required".equalsIgnoreCase(oidcClientConfig.getInboundPropagation())) {
                        ++this.iClientIsBeforeSso;
                    }
                    if (!oidcClientConfig.isOidcclientRequestParameterSupported()) continue;
                    this.needProviderHint = true;
                }
                this.initBeforeSso = false;
            }
        }
    }

    void handleOauthChallenge(HttpServletResponse rsp, ProviderAuthenticationResult oidcResult) {
        if (oidcResult.getStatus() == AuthResult.CONTINUE || oidcResult.getStatus() == AuthResult.REDIRECT_TO_PROVIDER) {
            return;
        }
        String errorDescription = null;
        if (oidcResult.getStatus() == AuthResult.FAILURE) {
            if (401 == oidcResult.getHttpStatusCode()) {
                errorDescription = "OpenID Connect client failed the request...";
            }
        } else if (oidcResult.getStatus() != AuthResult.SUCCESS && 401 == oidcResult.getHttpStatusCode()) {
            errorDescription = "OpenID Connect client returned with status: " + oidcResult.getStatus();
        }
        if (errorDescription != null) {
            try {
                OAuth20ProviderUtils.handleOAuthChallenge((HttpServletResponse)rsp, (ProviderAuthenticationResult)oidcResult, (String)errorDescription);
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.openidconnect.client.internal.OidcClientImpl", (String)"1054", (Object)this, (Object[])new Object[]{rsp, oidcResult});
            }
        }
    }

    public boolean postLogout(HttpServletRequest arg0, HttpServletResponse arg1) {
        return false;
    }
}

