/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.google.gson.JsonObject;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.SecureRandom;
import java.util.HashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HashSecretUtils {
    private static final TraceComponent tc = Tr.register(HashSecretUtils.class, null, null);
    public static final String PBKDF2WithHmacSHA512 = "PBKDF2WithHmacSHA512";
    public static final String DEFAULT_HASH = "PBKDF2WithHmacSHA512";
    public static final int DEFAULT_SALTSIZE = 32;
    public static final int DEFAULT_ITERATIONS = 2048;
    public static final int DEFAULT_KEYSIZE = 32;
    private static final int generateSaltSize = 32;
    static final long serialVersionUID = 8690420941482694302L;

    @Sensitive
    public static String hashSecret(@Sensitive String clientSecret, String clientId, boolean updateXORtoHash, @Sensitive JsonObject clientMetadataAsJson) {
        return HashSecretUtils.hashSecret(clientSecret, clientId, updateXORtoHash, clientMetadataAsJson.get("salt").getAsString(), clientMetadataAsJson.get("hash_alg").getAsString(), clientMetadataAsJson.get("hash_itr").getAsInt(), clientMetadataAsJson.get("hash_len").getAsInt());
    }

    @Sensitive
    public static String hashSecret(@Sensitive String clientSecret, String clientId, boolean updateXORtoHash, @Sensitive String salt, @Sensitive String algorithm, int iteration, int length) {
        if (clientSecret != null && !clientSecret.isEmpty()) {
            if (salt == null) {
                throw new IllegalArgumentException("A null salt was provided for clientId " + clientId + ". Cannot hash secret.");
            }
            String secretToHash = clientSecret;
            String secretType = PasswordUtil.getCryptoAlgorithm((String)clientSecret);
            if (secretType != null && secretType.equals("xor")) {
                if (updateXORtoHash) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Client secret for " + clientId + " is stored as XOR, convert to hash"), (Object[])new Object[0]);
                    }
                    secretToHash = PasswordUtil.passwordDecode((String)clientSecret);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Client secret for " + clientId + " is stored as XOR, not converting to hash"), (Object[])new Object[0]);
                    }
                    return clientSecret;
                }
            }
            if (secretType == null || !secretType.equals("hash")) {
                HashMap<String, String> hashProps = new HashMap<String, String>();
                hashProps.put("hash.algorithm", algorithm == null ? "PBKDF2WithHmacSHA512" : algorithm);
                hashProps.put("hash.salt", salt);
                hashProps.put("hash.iteration", iteration == 0 ? String.valueOf(2048) : String.valueOf(iteration));
                hashProps.put("hash.length", length == 0 ? String.valueOf(32) : String.valueOf(length));
                return PasswordUtil.encode_password((String)secretToHash, (String)"hash", hashProps);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Client secret for " + clientId + " is already hashed."), (Object[])new Object[0]);
            }
        }
        return clientSecret;
    }

    public static void hashClientMetaTypeSecret(@Sensitive JsonObject clientMetadataAsJson, String clientId, boolean updateXORtoHash) {
        String clientSecret;
        if (clientMetadataAsJson != null && clientMetadataAsJson.has("client_secret") && (clientSecret = clientMetadataAsJson.get("client_secret").getAsString()) != null && !clientSecret.isEmpty()) {
            clientMetadataAsJson.addProperty("client_secret", HashSecretUtils.hashSecret(clientSecret, clientId, updateXORtoHash, clientMetadataAsJson.get("salt").getAsString(), clientMetadataAsJson.get("hash_alg").getAsString(), clientMetadataAsJson.get("hash_itr").getAsInt(), clientMetadataAsJson.get("hash_len").getAsInt()));
        }
    }

    @Sensitive
    public static String generateSalt() {
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[32];
        random.nextBytes(salt);
        return Base64Coder.base64EncodeToString((byte[])salt);
    }

    @Sensitive
    public static JsonObject processMetatypeForHashInfo(@Sensitive JsonObject clientMetadataAsJson, String clientId, String algDefault, int itrDefault, int lengthDefault) {
        if (clientMetadataAsJson.get("hash_alg") == null) {
            clientMetadataAsJson.addProperty("hash_alg", algDefault);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Added default hash algorithm for " + clientId + ": " + algDefault), (Object[])new Object[0]);
            }
        }
        if (clientMetadataAsJson.get("salt") == null) {
            clientMetadataAsJson.addProperty("salt", HashSecretUtils.generateSalt());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Salt added for " + clientId), (Object[])new Object[0]);
            }
        }
        if (clientMetadataAsJson.get("hash_itr") == null || clientMetadataAsJson.get("hash_itr").getAsInt() == 0) {
            clientMetadataAsJson.addProperty("hash_itr", (Number)itrDefault);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Added default hash iterations for " + clientId + ": " + itrDefault), (Object[])new Object[0]);
            }
        }
        if (clientMetadataAsJson.get("hash_len") == null || clientMetadataAsJson.get("hash_len").getAsInt() == 0) {
            clientMetadataAsJson.addProperty("hash_len", (Number)32);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Added default hash key size for " + clientId + ": " + itrDefault), (Object[])new Object[0]);
            }
        }
        return clientMetadataAsJson;
    }
}

