/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.error;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.error.ErrorHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SocialLoginException
extends Exception {
    private static TraceComponent tc = Tr.register(SocialLoginException.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    private static final long serialVersionUID = 64513701282549878L;
    protected String _message = null;
    protected String _msgKey = null;
    protected Object[] _objects = null;
    protected String _defaultMsg = null;
    protected boolean ffdcAlready = false;
    protected int httpErrorCode = 403;
    protected ErrorHandler errorHandler = null;

    public SocialLoginException(String msgKey, Exception cause, Object[] objects) {
        this(msgKey, cause, cause != null, objects);
    }

    public SocialLoginException(Exception cause) {
        this(cause, false);
    }

    public SocialLoginException(Exception cause, boolean ffdcAlready) {
        this.ffdcAlready = ffdcAlready;
        this.handleUnexpectException(cause);
    }

    public SocialLoginException(String msgKey, Exception cause, boolean ffdcAlready, Object[] objects) {
        super(cause);
        this.ffdcAlready = ffdcAlready;
        this.handleInternalMessage(msgKey, objects);
    }

    public void setErrorHanlder(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHanlder() {
        return this.errorHandler;
    }

    public void setHttpErrorCode(int httpErrorCode) {
        this.httpErrorCode = httpErrorCode;
    }

    public int getHttpErrorCode() {
        return this.httpErrorCode;
    }

    public boolean ffdcAlready() {
        return this.ffdcAlready;
    }

    public void setFfdcAlready(boolean ffdcAlready) {
        this.ffdcAlready = ffdcAlready;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ffdc already handled? " + ffdcAlready), (Object[])new Object[0]);
        }
    }

    @Override
    @Trivial
    public String getMessage() {
        if (this._message == null) {
            this.setExternalMsg();
        }
        return this._message;
    }

    @Trivial
    public static String formatMessage(String msgKey, String defaultMsg, Object[] objects) {
        return TraceNLS.getFormattedMessage(SocialLoginException.class, (String)"com.ibm.ws.security.social.resources.SocialMessages", (String)msgKey, (Object[])objects, (String)defaultMsg);
    }

    @Trivial
    protected void handleUnexpectException(Exception cause) {
        String exceptionName = cause.getClass().getName();
        String msg = cause.getMessage();
        StringBuffer sb = SocialLoginException.dumpStackTrace(cause, 6);
        this._msgKey = "SOCIAL_LOGIN_SERVER_INTERNAL_LOG_ERROR";
        this._objects = new Object[]{exceptionName, msg, sb.toString()};
        this._message = SocialLoginException.formatMessage(this._msgKey, null, this._objects);
    }

    @Trivial
    protected void handleInternalMessage(String msgKey, Object[] objects) {
        this._msgKey = msgKey;
        this._objects = objects;
        this._message = SocialLoginException.formatMessage(msgKey, null, objects);
    }

    @Trivial
    private void setExternalMsg() {
        this._msgKey = "SOCIAL_LOGIN_AUTHENTICATION_FAIL";
        this._objects = new Object[0];
        this._defaultMsg = "CWWKS5404E: Social Login Exception: The social login service provider failed to process the authentication request.";
        this._message = SocialLoginException.formatMessage(this._msgKey, this._defaultMsg, this._objects);
    }

    @Trivial
    public void logErrorMessage() {
        if (this._msgKey != null) {
            Tr.error((TraceComponent)tc, (String)this._msgKey, (Object[])this._objects);
        }
    }

    @Trivial
    public static StringBuffer dumpStackTrace(Throwable cause, int iLimited) {
        int iI;
        StackTraceElement[] stackTrace = cause.getStackTrace();
        if (iLimited == -1 || iLimited > stackTrace.length) {
            iLimited = stackTrace.length;
        }
        StringBuffer sb = new StringBuffer("\n  ");
        for (iI = 0; iI < iLimited; ++iI) {
            sb.append(stackTrace[iI].toString() + "\n  ");
        }
        if (iI < stackTrace.length) {
            sb.append("  ....\n");
        }
        return sb;
    }
}

