/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.rest.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class ConfigBasedRESTHandler
implements RESTHandler {
    private static final TraceComponent tc = Tr.register(ConfigBasedRESTHandler.class, (String)"rest.configbased", (String)"com.ibm.wsspi.rest.config.resources.CWWKOMessages");
    private static final ServiceCaller<ConfigurationAdmin> configurationAdminService = new ServiceCaller(ConfigBasedRESTHandler.class, ConfigurationAdmin.class);
    static final long serialVersionUID = 3051162906457371640L;

    public boolean filterBy(String name) {
        return false;
    }

    public abstract String getAPIRoot();

    private static String getDeepestNestedElementName(String configDisplayId) {
        int end;
        int start = configDisplayId.lastIndexOf("]/");
        if (start > 1 && (end = configDisplayId.indexOf(91, start += 2)) > start) {
            return configDisplayId.substring(start, end);
        }
        return null;
    }

    private Dictionary<String, Object> getProperties(String servicePid, Configuration[] configurations) {
        for (Configuration c : configurations) {
            Dictionary props = c.getProperties();
            if (!servicePid.equals(props.get("service.pid"))) continue;
            return props;
        }
        throw new IllegalArgumentException(servicePid);
    }

    @Trivial
    private static String getUID(String configDisplayId, String id) {
        return id == null || configDisplayId.matches(".*/.*\\[.*\\].*") ? configDisplayId : id;
    }

    public abstract Object handleError(RESTRequest var1, String var2, String var3);

    @Override
    @ManualTrace
    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        Configuration[] configurations;
        String elementName;
        String path = request.getPath();
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"handleRequest", (Object[])new Object[]{path});
        }
        if (this.requireAdministratorRole() && !request.isUserInRole("Administrator")) {
            response.sendError(403, "Forbidden");
            response.setRequiredRoles(new HashSet<String>(Arrays.asList("Administrator")));
            if (trace && tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"handleRequest", (Object)"403 Forbidden");
            }
            return;
        }
        String apiRoot = this.getAPIRoot();
        String uid = null;
        int endElementName = path.indexOf(47, apiRoot.length() + 1);
        if (endElementName < 0) {
            endElementName = path.length();
        } else {
            uid = URLDecoder.decode(path.substring(endElementName + 1), "UTF-8");
            if (uid.length() == 0) {
                uid = null;
            }
        }
        String string = elementName = path.length() < apiRoot.length() + 1 ? "" : URLDecoder.decode(path.substring(apiRoot.length() + 1, endElementName), "UTF-8");
        if (elementName.indexOf(91) >= 0) {
            response.sendError(404, Tr.formatMessage((TraceComponent)tc, (Locale)request.getLocale(), (String)"CWWKO1500_NOT_FOUND", (Object[])new Object[]{elementName}));
            return;
        }
        StringBuilder filter = new StringBuilder("(&");
        if (uid != null && (uid.startsWith(elementName + "[default-") || uid.matches(".*/.*\\[.*\\].*"))) {
            filter.append(FilterUtils.createPropertyFilter((String)"config.displayId", (String)uid));
        } else if (elementName.length() > 0) {
            Object e = null;
            for (int i = elementName.length() - 1; i >= 0; --i) {
                switch (elementName.charAt(i)) {
                    case '(': 
                    case ')': 
                    case '*': 
                    case '\\': {
                        if (e == null) {
                            e = new StringBuilder(elementName);
                        }
                        ((StringBuilder)e).insert(i, '\\');
                    }
                }
            }
            String en = e == null ? elementName : ((StringBuilder)e).toString();
            filter.append("(|(config.displayId=*").append(en).append("[*)(config.displayId=*").append(en).append("))");
            if (uid != null) {
                filter.append(FilterUtils.createPropertyFilter((String)"id", (String)uid));
            }
        } else {
            filter.append("(config.displayId=*)");
            if (uid != null) {
                filter.append(FilterUtils.createPropertyFilter((String)"id", (String)uid));
            }
        }
        for (Map.Entry<String, String[]> param : request.getParameterMap().entrySet()) {
            Configuration[] key = param.getKey();
            if (!this.filterBy((String)key) || "_".equals(key)) continue;
            String[] values = param.getValue();
            if (values.length > 1) {
                filter.append("(|");
            }
            for (String value : values) {
                filter.append(FilterUtils.createPropertyFilter((String)key, (String)value));
            }
            if (values.length <= 1) continue;
            filter.append(')');
        }
        filter.append(')');
        if (trace && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"filter", (Object[])new Object[]{filter});
        }
        try {
            configurations = ((ConfigurationAdmin)configurationAdminService.current().get()).listConfigurations(filter.toString());
        }
        catch (NoSuchElementException | InvalidSyntaxException param) {
            FFDCFilter.processException((Throwable)param, (String)"com.ibm.wsspi.rest.config.ConfigBasedRESTHandler", (String)"238", (Object)this, (Object[])new Object[]{request, response});
            configurations = null;
        }
        TreeMap<String, Dictionary<String, Object>> configMap = new TreeMap<String, Dictionary<String, Object>>();
        if (configurations != null) {
            for (Configuration c : configurations) {
                String subtypePid;
                Dictionary<String, Object> props = c.getProperties();
                String displayId = (String)props.get("config.displayId");
                int nestedStart = -1;
                if (!(elementName.length() == 0 || displayId.startsWith(elementName + '[') && !displayId.contains("]/") || elementName.contentEquals(displayId) || (nestedStart = displayId.lastIndexOf('/' + elementName + '[')) > 0 && displayId.indexOf("]/", nestedStart) < 0 && displayId.charAt(displayId.length() - 1) == ']') && !displayId.endsWith('/' + elementName)) continue;
                Dictionary oldProps = (Dictionary)configMap.get(displayId);
                if (oldProps == null) {
                    String subtypePid2;
                    while ((subtypePid2 = (String)props.get("ibm.extends.subtype.pid")) != null) {
                        props = this.getProperties(subtypePid2, configurations);
                    }
                    configMap.put(displayId, props);
                    continue;
                }
                String oldServicePid = (String)oldProps.get("service.pid");
                if (oldServicePid == null || oldServicePid.startsWith(elementName + '_')) {
                    configMap.put(displayId, props);
                }
                if ((subtypePid = (String)props.get("ibm.extends.subtype.pid")) == null) continue;
                while ((subtypePid = (String)(props = this.getProperties(subtypePid, configurations)).get("ibm.extends.subtype.pid")) != null) {
                }
                configMap.put(displayId, props);
            }
        }
        Object result = null;
        if (configMap.isEmpty()) {
            result = null;
        } else if (uid == null) {
            ArrayList<Object> results = new ArrayList<Object>();
            for (Map.Entry entry : configMap.entrySet()) {
                String id;
                String configDisplayId = (String)entry.getKey();
                String nestedElementName = ConfigBasedRESTHandler.getDeepestNestedElementName(configDisplayId);
                if (nestedElementName != null && !nestedElementName.equals(elementName)) continue;
                Dictionary configProps = (Dictionary)entry.getValue();
                String uniqueId = configDisplayId.endsWith("]") ? ConfigBasedRESTHandler.getUID(configDisplayId, (String)configProps.get("id")) : null;
                Object r = this.handleSingleInstance(request, uniqueId, (id = (String)configProps.get("id")) == null || ConfigBasedRESTHandler.isGenerated(id) ? null : id, configProps);
                if (r == null) continue;
                results.add(r);
            }
            if (!results.isEmpty()) {
                result = results;
            }
        } else {
            String id;
            Dictionary configProps;
            Map.Entry entry;
            String configDisplayId;
            String uniqueId;
            result = configMap.size() == 1 ? (uid.equals(uniqueId = ConfigBasedRESTHandler.getUID(configDisplayId = (String)(entry = configMap.firstEntry()).getKey(), (String)(configProps = (Dictionary)entry.getValue()).get("id"))) ? this.handleSingleInstance(request, uid, (id = (String)configProps.get("id")) == null || ConfigBasedRESTHandler.isGenerated(id) ? null : id, (Dictionary)entry.getValue()) : this.handleError(request, null, Tr.formatMessage((TraceComponent)tc, (Locale)request.getLocale(), (String)"CWWKO1501_INVALID_IDENTIFIER", (Object[])new Object[]{uid, uniqueId}))) : this.handleError(request, null, Tr.formatMessage((TraceComponent)tc, (Locale)request.getLocale(), (String)"CWWKO1502_MULTIPLE_FOUND", (Object[])new Object[]{uid}));
        }
        if (result == null) {
            if (uid != null) {
                response.sendError(404, Tr.formatMessage((TraceComponent)tc, (Locale)request.getLocale(), (String)"CWWKO1500_NOT_FOUND", (Object[])new Object[]{elementName + "(uid: " + uid + ")"}));
            } else {
                response.sendError(404, Tr.formatMessage((TraceComponent)tc, (Locale)request.getLocale(), (String)"CWWKO1500_NOT_FOUND", (Object[])new Object[]{elementName}));
            }
            return;
        }
        this.populateResponse(response, result);
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"handleRequest");
        }
    }

    public abstract Object handleSingleInstance(RESTRequest var1, String var2, String var3, Dictionary<String, Object> var4) throws IOException;

    private static boolean isGenerated(String id) {
        return id.matches(".*//.*\\[.*\\].*");
    }

    public abstract void populateResponse(RESTResponse var1, Object var2) throws IOException;

    public abstract boolean requireAdministratorRole();
}

