/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.interceptors;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.spi.ResteasyDeployment;

@Provider
@Priority(value=4000)
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class MessageSanitizerContainerResponseFilter
implements ContainerResponseFilter {
    private static final HashMap<String, String> replacementMap;
    static final long serialVersionUID = -1548804771581398702L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (400 == responseContext.getStatus()) {
            List contentTypes;
            Boolean disable;
            ResteasyDeployment deployment = ResteasyContext.getContextData(ResteasyDeployment.class);
            if (deployment != null && (disable = (Boolean)deployment.getProperty("resteasy.disable.html.sanitizer")) != null && disable.booleanValue()) {
                return;
            }
            Object entity = responseContext.getEntity();
            if (entity != null && entity instanceof String && (contentTypes = (List)responseContext.getHeaders().get((Object)"Content-Type")) != null && this.containsHtmlText(contentTypes)) {
                String escapedMsg = this.escapeXml((String)entity);
                responseContext.setEntity((Object)escapedMsg);
            }
        }
    }

    private String escapeXml(String str) {
        StringBuilder sb = new StringBuilder();
        if (!str.isEmpty()) {
            for (String key : str.split("|")) {
                String value = replacementMap.get(key);
                if (value == null) {
                    sb.append(key);
                    continue;
                }
                sb.append(value);
            }
        }
        return sb.toString();
    }

    private boolean containsHtmlText(List<Object> list) {
        for (Object o : list) {
            String mediaType;
            String[] partsType;
            if (o instanceof MediaType && MediaType.TEXT_HTML_TYPE.isCompatible((MediaType)o)) {
                return true;
            }
            if (!(o instanceof String) || (partsType = (mediaType = (String)o).split("/")).length < 2) continue;
            String[] partsSubtype = partsType[1].split(";");
            if (!partsType[0].trim().equalsIgnoreCase("text") || !partsSubtype[0].trim().toLowerCase().equals("html")) continue;
            return true;
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.interceptors.MessageSanitizerContainerResponseFilter", MessageSanitizerContainerResponseFilter.class, null, null);
        replacementMap = new HashMap();
        replacementMap.put("/", "&#x2F;");
        replacementMap.put("<", "&lt;");
        replacementMap.put(">", "&gt;");
        replacementMap.put("&", "&amp;");
        replacementMap.put("\"", "&quot;");
        replacementMap.put("'", "&#x27;");
    }
}

