/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import com.ibm.websphere.jaxrs20.multipart.IAttachment;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jboss.resteasy.plugins.providers.ProviderHelper;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.util.NoContent;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class IAttachmentImpl
implements IAttachment,
InputPart {
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private final MultivaluedMap<String, String> headers;
    private final boolean contentTypeFromMessage;
    private final String fieldName;
    private final Optional<String> fileName;
    private final InputStream inputStream;
    private final DataHandler dataHandler = new DataHandler(new DataSource(){
        static final long serialVersionUID = 5254526130563343304L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public InputStream getInputStream() throws IOException {
            return IAttachmentImpl.this.inputStream;
        }

        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        public String getContentType() {
            return IAttachmentImpl.this.getMediaType().toString();
        }

        public String getName() {
            return IAttachmentImpl.this.fileName.orElse(IAttachmentImpl.this.fieldName);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.multipart.IAttachmentImpl$1", 1.class, null, null);
        }
    });
    static final long serialVersionUID = 7801646687882823526L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public IAttachmentImpl(InputPart part) throws IOException {
        this(part.getHeaders(), IAttachmentImpl.extractFromHeader((String)part.getHeaders().getFirst((Object)CONTENT_DISPOSITION_HEADER), "name").orElseThrow(() -> new IOException("Missing required header, Content-Disposition or required attribute, name.")), IAttachmentImpl.extractFromHeader((String)part.getHeaders().getFirst((Object)CONTENT_DISPOSITION_HEADER), "filename"), part.getBody(InputStream.class, null));
    }

    public IAttachmentImpl(MultivaluedMap<String, String> headers, String fieldName, Optional<String> fileName, InputStream inputStream) {
        this.headers = headers;
        this.contentTypeFromMessage = headers.containsKey((Object)CONTENT_TYPE_HEADER);
        headers.computeIfAbsent((Object)CONTENT_TYPE_HEADER, this::constructContentTypeHeaderValue);
        this.fieldName = fieldName;
        this.fileName = fileName;
        this.inputStream = inputStream;
    }

    @Override
    public String getContentId() {
        return this.getHeader("Content-ID");
    }

    @Override
    public MediaType getContentType() {
        return this.getMediaType();
    }

    @Override
    public DataHandler getDataHandler() {
        return this.dataHandler;
    }

    @Override
    public String getHeader(String name) {
        return (String)this.headers.getFirst((Object)name);
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public <T> T getBody(GenericType<T> type) throws IOException {
        return this.getBody(type.getRawType(), type.getType());
    }

    @Override
    public <T> T getBody(Class<T> clazz, Type type) throws IOException {
        if (InputStream.class.equals(clazz)) {
            return (T)this.inputStream;
        }
        if (String.class.equals(clazz)) {
            if (NoContent.isContentLengthZero(this.headers)) {
                return (T)"";
            }
            return (T)ProviderHelper.readString(this.inputStream, this.getMediaType());
        }
        if (IAttachment.class.equals(clazz) || InputPart.class.equals(clazz)) {
            return (T)this;
        }
        return null;
    }

    @Override
    public String getBodyAsString() throws IOException {
        return this.getBody(String.class, null);
    }

    @Override
    public MediaType getMediaType() {
        return MediaType.valueOf((String)((String)this.headers.getFirst((Object)CONTENT_TYPE_HEADER)));
    }

    @Override
    public boolean isContentTypeFromMessage() {
        return this.contentTypeFromMessage;
    }

    @Override
    public void setMediaType(MediaType mt) {
        this.headers.putSingle((Object)CONTENT_TYPE_HEADER, (Object)mt.toString());
    }

    public String getFileName() {
        return this.fileName.orElse(null);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    private List<String> constructContentTypeHeaderValue(String headerName) {
        String mediaType = this.fileName == null ? "text/plain" : "application/octet-stream";
        return Collections.singletonList(mediaType);
    }

    public static String getFieldNameFromHeader(String headerValue) {
        return IAttachmentImpl.extractFromHeader(headerValue, "name").orElse(null);
    }

    private static Optional<String> extractFromHeader(String headerValue, String field) {
        if (headerValue == null) {
            return Optional.empty();
        }
        int x = headerValue.indexOf(field + "=\"");
        if (x < 0) {
            return Optional.empty();
        }
        x = x + field.length() + 2;
        int y = headerValue.indexOf("\"", x + 1);
        return Optional.of(headerValue.substring(x, y));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.providers.multipart.IAttachmentImpl", IAttachmentImpl.class, null, null);
    }
}

