/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.util.HeaderParameterParser;
import org.jboss.resteasy.util.LocaleHelper;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class WeightedLanguage
implements Comparable<WeightedLanguage> {
    private float weight = 1.0f;
    private String language;
    private Locale locale;
    private Map<String, String> params;
    static final long serialVersionUID = -549951938211036586L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public WeightedLanguage(Locale locale, float weight) {
        this.locale = locale;
        this.weight = weight;
    }

    private WeightedLanguage(String lang, Map<String, String> parameters) {
        String q;
        this.language = lang;
        this.params = parameters;
        this.locale = LocaleHelper.extractLocale(lang);
        if (this.params != null && (q = this.params.get("q")) != null) {
            this.weight = WeightedLanguage.getQWithParamInfo(this, q);
        }
    }

    public float getWeight() {
        return this.weight;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public int compareTo(WeightedLanguage o) {
        WeightedLanguage type2 = this;
        WeightedLanguage type1 = o;
        if (type1.weight < type2.weight) {
            return -1;
        }
        if (type1.weight > type2.weight) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        String rtn = this.language;
        if (this.params == null || this.params.size() == 0) {
            return rtn;
        }
        for (Map.Entry<String, String> paramEntry : this.params.entrySet()) {
            rtn = rtn + ";" + paramEntry.getKey() + "=\"" + paramEntry.getValue() + "\"";
        }
        return rtn;
    }

    public static WeightedLanguage parse(String lang) {
        String params = null;
        int idx = lang.indexOf(";");
        if (idx > -1) {
            params = lang.substring(idx + 1).trim();
            lang = lang.substring(0, idx);
        }
        HashMap<String, String> typeParams = new HashMap<String, String>();
        if (params != null && !params.equals("")) {
            int start = 0;
            while (start < params.length()) {
                start = HeaderParameterParser.setParam(typeParams, params, start);
            }
        }
        return new WeightedLanguage(lang, typeParams);
    }

    private static float getQWithParamInfo(WeightedLanguage lang, String val) {
        try {
            if (val != null) {
                float rtn = Float.valueOf(val).floatValue();
                if (rtn > 1.0f) {
                    throw new LoggableFailure(Messages.MESSAGES.qValueCannotBeGreaterThan1(lang.toString()), 400);
                }
                return rtn;
            }
        }
        catch (NumberFormatException e) {
            throw new LoggableFailure(Messages.MESSAGES.mediaTypeQWeightedLanguageMustBeFloat(lang.toString()), 400);
        }
        return 1.0f;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.util.WeightedLanguage", WeightedLanguage.class, null, null);
    }
}

