/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.webcontainer.util;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.webcontainer.osgi.WebContainer;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RequestUtils {
    private static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.util");
    private static final String CLASS_NAME = "com.ibm.wsspi.webcontainer.util.RequestUtils";
    private static final TraceNLS nls = TraceNLS.getTraceNLS(RequestUtils.class, (String)"com.ibm.ws.webcontainer.resources.Messages");
    private static final String SHORT_ENGLISH = "8859_1";
    private static final boolean ignoreInvalidQueryString = WCCustomProperties.IGNORE_INVALID_QUERY_STRING;
    private static final boolean allowQueryParamWithNoEqual = WCCustomProperties.ALLOW_QUERY_PARAM_WITH_NO_EQUAL;
    private static final String EMPTY_STRING = "";
    private static final int maxParamPerRequest = WCCustomProperties.MAX_PARAM_PER_REQUEST;
    private static final int maxDuplicateHashKeyParams = WCCustomProperties.MAX_DUPLICATE_HASHKEY_PARAMS;
    private static final boolean decodeParamViaReqEncoding = WCCustomProperties.DECODE_PARAM_VIA_REQ_ENCODING;
    private static final boolean printbyteValueandcharParamdata = WCCustomProperties.PRINT_BYTEVALUE_AND_CHARPARAMDATA;
    private static final boolean SERVLET61_OR_ABOVE = WebContainer.isServlet61orAbove();
    private static String lastShortEnglishEncoding = null;

    public static Hashtable parseQueryString(String s) {
        return RequestUtils.parseQueryString(new StringQueryString(s), SHORT_ENGLISH);
    }

    public static Hashtable parseQueryString(String s, String encoding) {
        return RequestUtils.parseQueryString(new StringQueryString(s), encoding);
    }

    private static boolean isShortEnglishEncoding(String encoding) {
        if (encoding == lastShortEnglishEncoding || encoding == SHORT_ENGLISH || encoding == "ISO-8859-1") {
            return true;
        }
        if (encoding.endsWith(SHORT_ENGLISH) || encoding.endsWith("8859-1") || encoding.indexOf("8859-1-Windows") != -1) {
            lastShortEnglishEncoding = encoding;
            return true;
        }
        return false;
    }

    private static Hashtable parseQueryString(QueryString qs, String encoding) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "parseQueryString( QueryString , encoding --> [" + encoding + "])");
        }
        int totalSize = 0;
        int dupSize = 0;
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        HashSet<Integer> key_hset = new HashSet<Integer>();
        boolean encoding_is_ShortEnglish = RequestUtils.isShortEnglishEncoding(encoding);
        while (qs.findNextPair()) {
            if (qs.hasEquals() || allowQueryParamWithNoEqual) {
                String value;
                String key;
                block22: {
                    key = null;
                    value = null;
                    try {
                        if (decodeParamViaReqEncoding && !encoding_is_ShortEnglish) {
                            key = RequestUtils.parse_decode_Parameter(qs.getKey(), encoding, "paramKey");
                            value = !qs.hasEquals() ? (key != null ? EMPTY_STRING : null) : RequestUtils.parse_decode_Parameter(qs.getValue(), encoding, "paramValue");
                            if (ignoreInvalidQueryString && (value == null || key == null)) {
                                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                                logger.logp(Level.FINE, CLASS_NAME, "parseQueryString", "null in (key,value) suggests that an invalid character in either/both: key[" + key + "] , value [" + value + "] ;pair position [" + totalSize + "]");
                                continue;
                            }
                            break block22;
                        }
                        key = qs.parseKey();
                        value = !qs.hasEquals() ? (key != null ? EMPTY_STRING : null) : qs.parseValue();
                        if (ignoreInvalidQueryString && (value == null || key == null)) {
                            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
                            logger.logp(Level.FINE, CLASS_NAME, "parseQueryString", "null in (key,value) suggests there is an invalid character in either/both: key[" + key + "] , value [" + value + "] ;pair position [" + totalSize + "]");
                            continue;
                        }
                        if (encoding_is_ShortEnglish) break block22;
                        try {
                            if (!qs.isKeySingleByteString()) {
                                key = new String(key.getBytes(SHORT_ENGLISH), encoding);
                            }
                            if (!qs.isValueSingleByteString()) {
                                value = new String(value.getBytes(SHORT_ENGLISH), encoding);
                            }
                        }
                        catch (UnsupportedEncodingException uee) {
                            logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", "unsupported exception", uee);
                            if (SERVLET61_OR_ABOVE) {
                                throw new IllegalStateException();
                            }
                            throw new IllegalArgumentException();
                        }
                    }
                    catch (IllegalStateException ise) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "parseQueryString", "null in (key,value) suggests that an invalid character in either/both: key[" + key + "] , value [" + value + "] ;pair position [" + totalSize + "]");
                        }
                        throw ise;
                    }
                }
                String[] valArray = new String[]{value};
                String[] oldVals = ht.put(key, valArray);
                if (oldVals != null) {
                    valArray = new String[oldVals.length + 1];
                    System.arraycopy(oldVals, 0, valArray, 0, oldVals.length);
                    valArray[oldVals.length] = value;
                    ht.put(key, valArray);
                } else if (!key_hset.add(key.hashCode())) {
                    ++dupSize;
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "parseQueryString", "duplicate hashCode generated by key --> " + key);
                    }
                    if (dupSize > maxDuplicateHashKeyParams) {
                        logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", MessageFormat.format(nls.getString("Exceeding.maximum.hash.collisions"), maxDuplicateHashKeyParams));
                        if (SERVLET61_OR_ABOVE) {
                            throw new IllegalStateException();
                        }
                        throw new IllegalArgumentException();
                    }
                }
            }
            if (maxParamPerRequest == -1 || ++totalSize < maxParamPerRequest) continue;
            logger.logp(Level.SEVERE, CLASS_NAME, "parseQueryString", MessageFormat.format(nls.getString("Exceeding.maximum.parameters"), maxParamPerRequest, totalSize));
            if (SERVLET61_OR_ABOVE) {
                throw new IllegalStateException();
            }
            throw new IllegalArgumentException();
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "parseQueryString(QueryString, String)");
        }
        return ht;
    }

    public static Hashtable parseQueryString(char[][] cha, String encoding) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "parseQueryString( query , encoding --> [" + encoding + "])");
        }
        if (cha == null || cha.length == 0) {
            if (SERVLET61_OR_ABOVE) {
                throw new IllegalStateException(nls.getString("query.or.post.is.null"));
            }
            throw new IllegalArgumentException(nls.getString("query.or.post.is.null"));
        }
        if (cha.length == 1) {
            Hashtable returnValue = RequestUtils.parseQueryString(new CharArrayQueryString(cha[0]), encoding);
            cha[0] = null;
            return returnValue;
        }
        return RequestUtils.parseQueryString(new CharArrayArrayQueryString(cha), encoding);
    }

    public static String getURIForCurrentDispatch(HttpServletRequest req) {
        String includeURI = (String)req.getAttribute("jakarta.servlet.include.request_uri");
        if (includeURI == null) {
            return req.getRequestURI();
        }
        return includeURI;
    }

    private static String parse_decode_Parameter(String paramData, String encoding, String val) {
        if (printbyteValueandcharParamdata && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            RequestUtils.printValues(paramData, "parsed " + val);
        }
        try {
            paramData = URLDecoder.decode(paramData, encoding);
            if (printbyteValueandcharParamdata && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                RequestUtils.printValues(paramData, "decoded " + val);
            }
        }
        catch (UnsupportedEncodingException uee) {
            logger.logp(Level.SEVERE, CLASS_NAME, "parse_decode_Parameter", "unsupported exception--> ", uee);
            if (SERVLET61_OR_ABOVE) {
                throw new IllegalStateException();
            }
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException ie) {
            if (ignoreInvalidQueryString) {
                logger.logp(Level.WARNING, CLASS_NAME, "parse_decode_Parameter", "invalid.query.string");
                return null;
            }
            throw ie;
        }
        return paramData;
    }

    private static void printValues(String value, String loc) {
        char[] buffervalue = value.toCharArray();
        byte[] bytevalue = new byte[buffervalue.length];
        for (int ivalue = 0; ivalue < bytevalue.length; ++ivalue) {
            bytevalue[ivalue] = (byte)buffervalue[ivalue];
            if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) continue;
            logger.logp(Level.FINE, CLASS_NAME, "printValues", EMPTY_STRING + loc + " byteValue-->" + bytevalue[ivalue] + " ,charValue-->" + buffervalue[ivalue]);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "printValues", EMPTY_STRING + loc + " -->[" + value + "]");
        }
    }

    private static char[] getSingleBuffer(char[][] buffers, int start_pos, int start_index, int end_pos, int end_index) throws IllegalArgumentException {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.entering(CLASS_NAME, "getSingleBuffer", "start_pos=" + start_pos + ", start_index=" + start_index + ", end_pos=" + end_pos + ", end_index=" + end_index);
        }
        long bufflen = buffers[start_index].length - start_pos;
        if (start_index != end_index) {
            for (int i = start_index + 1; i <= end_index; ++i) {
                if (i == end_index) {
                    bufflen += (long)end_pos;
                    continue;
                }
                bufflen += (long)buffers[i].length;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getSingleBuffer", "calculated required buffer length =" + bufflen);
        }
        if (bufflen >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        char[] buff = new char[(int)bufflen];
        if (start_index != end_index) {
            int bufferPos = 0;
            for (int count = start_index; count <= end_index; ++count) {
                long len;
                if (count == start_index) {
                    if (start_pos < buffers[start_index].length) {
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                            logger.logp(Level.FINE, CLASS_NAME, "getSingleBuffer", "copy " + (buffers[start_index].length - start_pos) + " bytes from buffer " + count);
                        }
                        System.arraycopy(buffers[start_index], start_pos, buff, bufferPos, buffers[start_index].length - start_pos);
                    }
                    bufferPos = buffers[start_index].length - start_pos;
                    buffers[count] = null;
                    continue;
                }
                if (count == end_index) {
                    len = bufferPos + end_pos;
                    if (len > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                        logger.logp(Level.FINE, CLASS_NAME, "getSingleBuffer", "copy " + end_pos + " bytes from buffer " + count);
                    }
                    System.arraycopy(buffers[count], 0, buff, bufferPos, end_pos);
                    continue;
                }
                len = bufferPos + buffers[count].length;
                if (len > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException();
                }
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                    logger.logp(Level.FINE, CLASS_NAME, "getSingleBuffer", "copy " + buffers[count].length + " bytes from buffer " + count);
                }
                System.arraycopy(buffers[count], 0, buff, bufferPos, buffers[count].length);
                bufferPos += buffers[count].length;
                buffers[count] = null;
            }
        } else {
            System.arraycopy(buffers[start_index], start_pos, buff, 0, buffers[start_index].length - start_pos);
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.exiting(CLASS_NAME, "getSingleBuffer");
        }
        return buff;
    }

    private static class StringQueryString
    extends QueryString {
        private final String queryString;
        private final int lgth;

        StringQueryString(String queryString) {
            this.queryString = queryString;
            this.lgth = queryString.length();
        }

        @Override
        protected boolean lessThanEqualLength() {
            return this.i <= this.lgth;
        }

        @Override
        protected boolean isEqualLength() {
            return this.i == this.lgth;
        }

        @Override
        protected char getNextChar() {
            return this.queryString.charAt(this.i);
        }

        @Override
        String getKey() {
            return this.queryString.substring(this.pair_start, this.equalSign);
        }

        @Override
        String getValue() {
            return this.queryString.substring(this.equalSign + 1, this.i);
        }

        @Override
        String parseKey() {
            return this.parseName(this.pair_start, this.equalSign, true);
        }

        @Override
        String parseValue() {
            return this.parseName(this.equalSign + 1, this.i, false);
        }

        private String parseName(int startOffset, int endOffset, boolean isKey) {
            String returnValue;
            StringBuilder sb = null;
            block4: for (int offset = startOffset; offset < endOffset; ++offset) {
                char c = this.queryString.charAt(offset);
                switch (c) {
                    case '+': {
                        if (sb == null) {
                            sb = new StringBuilder(endOffset - startOffset);
                            if (offset != startOffset) {
                                sb.append(this.queryString, startOffset, offset);
                            }
                        }
                        sb.append(' ');
                        continue block4;
                    }
                    case '%': {
                        if (offset + 2 < endOffset) {
                            if (sb == null) {
                                sb = new StringBuilder(endOffset - startOffset);
                                if (offset != startOffset) {
                                    sb.append(this.queryString, startOffset, offset);
                                }
                            }
                            int num1 = Character.digit(this.queryString.charAt(++offset), 16);
                            int num2 = Character.digit(this.queryString.charAt(++offset), 16);
                            if (num1 == -1 || num2 == -1) {
                                if (ignoreInvalidQueryString) {
                                    logger.logp(Level.WARNING, RequestUtils.CLASS_NAME, "parseName", "invalid.query.string");
                                    return null;
                                }
                                if (SERVLET61_OR_ABOVE) {
                                    throw new IllegalStateException();
                                }
                                throw new IllegalArgumentException();
                            }
                            char newChar = (char)(num1 << 4 | num2);
                            if (!decodeParamViaReqEncoding && newChar > '\u007f') {
                                if (isKey) {
                                    this.isKeySingleByteString = false;
                                } else {
                                    this.isValueSingleByteString = false;
                                }
                            }
                            sb.append(newChar);
                            continue block4;
                        }
                        if (sb != null) {
                            if (offset >= endOffset) continue block4;
                            sb.append(this.queryString, offset, endOffset);
                            continue block4;
                        }
                        offset = endOffset;
                        continue block4;
                    }
                    default: {
                        if (sb == null) continue block4;
                        sb.append(c);
                    }
                }
            }
            String string = returnValue = sb != null ? sb.toString() : this.queryString.substring(startOffset, endOffset);
            if (printbyteValueandcharParamdata && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                RequestUtils.printValues(returnValue, "parseNameOUT");
            }
            return returnValue;
        }
    }

    private static abstract class QueryString {
        protected int pair_start = 0;
        protected int equalSign = -1;
        protected int i = -1;
        protected boolean isKeySingleByteString = true;
        protected boolean isValueSingleByteString = true;
        protected boolean equalsFound = false;

        private QueryString() {
        }

        protected abstract boolean lessThanEqualLength();

        protected abstract boolean isEqualLength();

        protected abstract char getNextChar();

        protected void increment() {
            ++this.i;
        }

        protected void setEqualSign() {
            this.equalSign = this.i;
        }

        boolean findNextPair() {
            this.increment();
            this.pair_start = this.i;
            this.isKeySingleByteString = true;
            this.isValueSingleByteString = true;
            this.equalsFound = false;
            while (this.lessThanEqualLength()) {
                if (this.isEqualLength()) {
                    if (!this.equalsFound) {
                        this.setEqualSign();
                    }
                    return true;
                }
                char c = this.getNextChar();
                if (c == '&') {
                    if (!this.equalsFound) {
                        this.setEqualSign();
                    }
                    return true;
                }
                if (c == '=' && !this.equalsFound) {
                    this.setEqualSign();
                    this.equalsFound = true;
                }
                if (!decodeParamViaReqEncoding && c > '\u007f') {
                    if (this.equalsFound) {
                        this.isValueSingleByteString = false;
                    } else {
                        this.isKeySingleByteString = false;
                    }
                }
                this.increment();
            }
            return false;
        }

        final boolean isKeySingleByteString() {
            return this.isKeySingleByteString;
        }

        final boolean isValueSingleByteString() {
            return this.isValueSingleByteString;
        }

        final boolean hasEquals() {
            return this.equalsFound;
        }

        abstract String getKey();

        abstract String getValue();

        abstract String parseKey();

        abstract String parseValue();

        protected String parseName(char[] ch, int startOffset, int endOffset, boolean isKey) {
            String returnValue;
            int j = 0;
            char[] c = null;
            block4: for (int offset = startOffset; offset < endOffset; ++offset) {
                switch (ch[offset]) {
                    case '+': {
                        if (c == null) {
                            c = new char[endOffset - startOffset];
                            j = offset - startOffset;
                            if (j != 0) {
                                System.arraycopy(ch, startOffset, c, 0, j);
                            }
                        }
                        c[j++] = 32;
                        continue block4;
                    }
                    case '%': {
                        if (offset + 2 < endOffset) {
                            if (c == null) {
                                c = new char[endOffset - startOffset];
                                j = offset - startOffset;
                                if (j != 0) {
                                    System.arraycopy(ch, startOffset, c, 0, j);
                                }
                            }
                            int num1 = Character.digit(ch[++offset], 16);
                            int num2 = Character.digit(ch[++offset], 16);
                            if (num1 == -1 || num2 == -1) {
                                if (ignoreInvalidQueryString) {
                                    logger.logp(Level.WARNING, RequestUtils.CLASS_NAME, "parseName", "invalid.query.string");
                                    return null;
                                }
                                if (SERVLET61_OR_ABOVE) {
                                    throw new IllegalStateException();
                                }
                                throw new IllegalArgumentException();
                            }
                            char newChar = (char)(num1 << 4 | num2);
                            if (!decodeParamViaReqEncoding && newChar > '\u007f') {
                                if (isKey) {
                                    this.isKeySingleByteString = false;
                                } else {
                                    this.isValueSingleByteString = false;
                                }
                            }
                            c[j++] = newChar;
                            continue block4;
                        }
                        if (c != null) {
                            while (offset < endOffset) {
                                c[j++] = ch[offset];
                                ++offset;
                            }
                            continue block4;
                        }
                        offset = endOffset;
                        continue block4;
                    }
                    default: {
                        if (c == null) continue block4;
                        c[j++] = ch[offset];
                    }
                }
            }
            String string = returnValue = c != null ? new String(c, 0, j) : new String(ch, startOffset, endOffset - startOffset);
            if (printbyteValueandcharParamdata && TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                RequestUtils.printValues(returnValue, "parseNameOUT");
            }
            return returnValue;
        }
    }

    private static class CharArrayQueryString
    extends QueryString {
        private final char[] queryString;
        private final int lgth;

        CharArrayQueryString(char[] queryString) {
            this.queryString = queryString;
            this.lgth = queryString.length;
        }

        @Override
        protected boolean lessThanEqualLength() {
            return this.i <= this.lgth;
        }

        @Override
        protected boolean isEqualLength() {
            return this.i == this.lgth;
        }

        @Override
        protected char getNextChar() {
            return this.queryString[this.i];
        }

        @Override
        String getKey() {
            return new String(this.queryString, this.pair_start, this.equalSign - this.pair_start);
        }

        @Override
        String getValue() {
            return new String(this.queryString, this.equalSign + 1, this.i - this.equalSign - 1);
        }

        @Override
        String parseKey() {
            return this.parseName(this.queryString, this.pair_start, this.equalSign, true);
        }

        @Override
        String parseValue() {
            return this.parseName(this.queryString, this.equalSign + 1, this.i, false);
        }
    }

    private static class CharArrayArrayQueryString
    extends QueryString {
        private final char[][] queryString;
        private int pair_start_index = 0;
        private int k = 0;
        private int equalSign_index = 0;

        CharArrayArrayQueryString(char[][] cha) {
            this.queryString = cha;
        }

        @Override
        protected boolean lessThanEqualLength() {
            return this.k < this.queryString.length && this.i <= this.queryString[this.k].length;
        }

        @Override
        protected boolean isEqualLength() {
            return this.k == this.queryString.length - 1 && this.i == this.queryString[this.queryString.length - 1].length;
        }

        @Override
        protected char getNextChar() {
            return this.queryString[this.k][this.i];
        }

        @Override
        protected void increment() {
            ++this.i;
            while (this.k < this.queryString.length - 1 && this.i >= this.queryString[this.k].length) {
                this.i = 0;
                ++this.k;
            }
        }

        @Override
        protected void setEqualSign() {
            super.setEqualSign();
            this.equalSign_index = this.k;
        }

        @Override
        boolean findNextPair() {
            while (this.k < this.queryString.length && this.i + 1 >= this.queryString[this.k].length) {
                this.queryString[this.k] = null;
                this.i = -1;
                ++this.k;
            }
            if (this.pair_start_index < this.k && this.queryString[this.pair_start_index] != null) {
                for (int j = this.pair_start_index; j < this.k; ++j) {
                    this.queryString[j] = null;
                }
            }
            this.pair_start_index = this.k;
            return super.findNextPair();
        }

        @Override
        String getKey() {
            int nameLen;
            int nameStart;
            char[] nameChars;
            if (this.pair_start_index != this.equalSign_index) {
                nameChars = RequestUtils.getSingleBuffer(this.queryString, this.pair_start, this.pair_start_index, this.equalSign, this.equalSign_index);
                nameStart = 0;
                nameLen = nameChars.length;
            } else {
                nameChars = this.queryString[this.pair_start_index];
                nameStart = this.pair_start;
                nameLen = this.equalSign - this.pair_start;
            }
            return new String(nameChars, nameStart, nameLen);
        }

        @Override
        String getValue() {
            int valueLen;
            int valueStart;
            char[] valueChars;
            if (this.equalSign_index != this.k) {
                valueChars = RequestUtils.getSingleBuffer(this.queryString, this.equalSign + 1, this.equalSign_index, this.i, this.k);
                valueStart = 0;
                valueLen = valueChars.length;
            } else {
                valueChars = this.queryString[this.k];
                valueStart = this.equalSign + 1;
                valueLen = this.i - valueStart;
            }
            return new String(valueChars, valueStart, valueLen);
        }

        @Override
        String parseKey() {
            int nameEnd;
            int nameStart;
            char[] nameChars;
            if (this.pair_start_index != this.equalSign_index) {
                nameChars = RequestUtils.getSingleBuffer(this.queryString, this.pair_start, this.pair_start_index, this.equalSign, this.equalSign_index);
                nameStart = 0;
                nameEnd = nameChars.length;
            } else {
                nameChars = this.queryString[this.pair_start_index];
                nameStart = this.pair_start;
                nameEnd = this.equalSign;
            }
            return this.parseName(nameChars, nameStart, nameEnd, true);
        }

        @Override
        String parseValue() {
            int valueEnd;
            int valueStart;
            char[] valueChars;
            if (this.equalSign_index != this.k) {
                valueChars = RequestUtils.getSingleBuffer(this.queryString, this.equalSign + 1, this.equalSign_index, this.i, this.k);
                valueStart = 0;
                valueEnd = valueChars.length;
            } else {
                valueChars = this.queryString[this.k];
                valueStart = this.equalSign + 1;
                valueEnd = this.i;
            }
            return this.parseName(valueChars, valueStart, valueEnd, false);
        }
    }
}

