/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.internal;

import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.plugins.BaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.openidconnect.token.JWT;
import com.ibm.ws.security.openidconnect.token.JWTPayload;
import com.ibm.ws.security.openidconnect.token.JsonTokenUtil;
import com.ibm.ws.webcontainer.security.jwk.JSONWebKey;
import com.ibm.ws.webcontainer.security.openidconnect.OidcServerConfig;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import io.openliberty.security.common.jwt.jws.JwsSignatureVerifier;
import java.security.Key;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwtUtils {
    private static final TraceComponent tc = Tr.register(JwtUtils.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    static final long serialVersionUID = 8097198534165362550L;

    public static JWT createJwt(String tokenString, OAuth20Provider oauth20provider, OidcServerConfig oidcServerConfig) throws Exception {
        String aud = null;
        String issuer = null;
        JWTPayload payload = JsonTokenUtil.getPayload((String)tokenString);
        if (payload != null) {
            aud = JsonTokenUtil.getAud((JWTPayload)payload);
            issuer = JsonTokenUtil.getIss((JWTPayload)payload);
        }
        Object key = JwtUtils.getJwtVerificationKey(tokenString, oauth20provider, oidcServerConfig);
        String signatureAlgorithm = oidcServerConfig.getSignatureAlgorithm();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clientId : " + aud + " key : " + (key == null ? "null" : "<removed>") + " issuer : " + issuer + " signatureAlgorithm : " + signatureAlgorithm), (Object[])new Object[0]);
        }
        return new JWT(tokenString, key, aud, issuer, signatureAlgorithm);
    }

    @Sensitive
    static Object getJwtVerificationKey(String tokenString, OAuth20Provider oauth20provider, OidcServerConfig oidcServerConfig) throws Exception {
        Object key = null;
        JwtContext jwtContext = JwtParsingUtils.parseJwtWithoutValidation((String)tokenString);
        String signingAlgorithm = JwsSignatureVerifier.verifyJwsAlgHeaderOnly((JwtContext)jwtContext, Arrays.asList(oidcServerConfig.getIdTokenSigningAlgValuesSupported()));
        if (signingAlgorithm.equals("none")) {
            key = null;
        } else if (signingAlgorithm.startsWith("HS")) {
            key = JwtUtils.getSharedKey(jwtContext, oauth20provider);
        } else {
            JsonWebStructure jsonStruct = JwtParsingUtils.getJsonWebStructureFromJwtContext((JwtContext)jwtContext);
            key = JwtUtils.getPublicKeyFromJsonWebStructure(jsonStruct, oidcServerConfig);
        }
        return key;
    }

    @Sensitive
    static Object getSharedKey(JwtContext jwtContext, OAuth20Provider oauth20provider) throws OidcServerException, MalformedClaimException {
        JwtClaims jwtClaims = jwtContext.getJwtClaims();
        List audiences = jwtClaims.getAudience();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Audiences from JWT: " + audiences), (Object[])new Object[0]);
        }
        if (audiences == null || audiences.isEmpty() || audiences.size() > 1) {
            return null;
        }
        String clientId = (String)audiences.get(0);
        return JwtUtils.getSharedKey(oauth20provider, clientId);
    }

    @Sensitive
    static Object getSharedKey(OAuth20Provider oauth20provider, String clientId) throws OidcServerException {
        String sharedKey = null;
        OidcOAuth20ClientProvider clientProvider = oauth20provider.getClientProvider();
        OidcBaseClient oauth20Client = clientProvider.get(clientId);
        if (oauth20Client instanceof BaseClient) {
            BaseClient baseClient = (BaseClient)oauth20Client;
            sharedKey = baseClient.getClientSecret();
        }
        return sharedKey;
    }

    static Key getPublicKeyFromJsonWebStructure(JsonWebStructure jsonStruct, OidcServerConfig oidcServerConfig) {
        String alg = jsonStruct.getAlgorithmHeaderValue();
        String kid = jsonStruct.getKeyIdHeaderValue();
        String x5t = jsonStruct.getX509CertSha1ThumbprintHeaderValue();
        PublicKey publicKey = null;
        JSONWebKey jwk = oidcServerConfig.getJSONWebKey();
        if (jwk != null && alg.equals(jwk.getAlgorithm())) {
            if (kid != null && kid.equals(jwk.getKeyID())) {
                publicKey = jwk.getPublicKey();
            } else if (x5t != null && x5t.equals(jwk.getKeyX5t())) {
                publicKey = jwk.getPublicKey();
            } else if (kid == null && x5t == null) {
                publicKey = jwk.getPublicKey();
            }
        }
        return publicKey;
    }
}

