/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.plugins;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.web.WebSecurityHelper;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.http.Cookie;
import java.security.MessageDigest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OIDCBrowserStateUtil {
    private static final TraceComponent tc = Tr.register(OIDCBrowserStateUtil.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    private static final String CHAR_ENCODING = "UTF-8";
    private static final String HASH_ALGORITHM = "SHA-256";
    static final long serialVersionUID = -245320595970638195L;

    /*
     * WARNING - void declaration
     */
    public static String generateOIDCBrowserState(boolean isUnauthenticate) {
        Cookie c;
        block4: {
            c = null;
            if (!isUnauthenticate) {
                try {
                    c = WebSecurityHelper.getSSOCookieFromSSOToken();
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.server.plugins.OIDCBrowserStateUtil", (String)"48", null, (Object[])new Object[]{isUnauthenticate});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("Exception obtaining SSOCookie from SSOToken: " + e), (Object[])new Object[0]);
                }
            }
        }
        String cookieString = "UNAUTHENTICATE";
        if (c != null) {
            cookieString = c.getValue();
        }
        return OIDCBrowserStateUtil.generateOIDCBrowserState(cookieString);
    }

    protected static String generateOIDCBrowserState(String input) {
        return OIDCBrowserStateUtil.generateOIDCBrowserState(input, CHAR_ENCODING, HASH_ALGORITHM);
    }

    /*
     * WARNING - void declaration
     */
    protected static String generateOIDCBrowserState(String input, String encoding, String algorithm) {
        String output;
        block3: {
            output = null;
            try {
                if (input != null) {
                    byte[] inputBytes = input.getBytes(encoding);
                    MessageDigest md = MessageDigest.getInstance(algorithm);
                    byte[] digest = md.digest(inputBytes);
                    output = new String(Base64Coder.base64Encode((byte[])digest), encoding);
                }
            }
            catch (Exception inputBytes) {
                void e;
                FFDCFilter.processException((Throwable)inputBytes, (String)"com.ibm.ws.security.openidconnect.server.plugins.OIDCBrowserStateUtil", (String)"90", null, (Object[])new Object[]{input, encoding, algorithm});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("Exception generating hash value : " + e), (Object[])new Object[0]);
            }
        }
        return output;
    }
}

