/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.web;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.oauth20.OAuth20BadParameterFormatException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.web.BrowserState;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OidcOptionalParams {
    private static TraceComponent tc = Tr.register(OidcOptionalParams.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    private static final String SPACE = " ";
    private volatile BrowserState browserState = null;
    private static final String[] OIDC_ALL_OPTIONAL_PARAMS = new String[]{"nonce", "display", "prompt", "max_age", "ui_locales", "claims_locales", "id_token_hint", "login_hint", "acr_values", "response_mode"};
    private static final List<String> OIDC_OPTIONAL_PARAMS_TO_BE_HANDLED = Collections.unmodifiableList(Arrays.asList("nonce"));
    private static final List<String> MULTIPLE_VALUE_PARAMS = Collections.unmodifiableList(Arrays.asList("ui_locales", "claims_locales", "acr_values"));
    static final long serialVersionUID = 4529778470243347486L;

    OidcOptionalParams() {
    }

    public AttributeList getParameters(HttpServletRequest request) throws OAuth20BadParameterFormatException {
        AttributeList options = new AttributeList();
        for (String key : OIDC_ALL_OPTIONAL_PARAMS) {
            String value = request.getParameter(key);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("key:" + key + " value:" + value), (Object[])new Object[0]);
            }
            if (value == null || value.trim().length() <= 0) continue;
            String[] values = new String[1];
            if ("prompt".equals(key)) {
                if ((value = value.trim()).contains("none") && value.contains(SPACE)) {
                    throw new OAuth20BadParameterFormatException("security.oauth20.error.invalid.authorization.prompt.none.value", "prompt", value);
                }
                values = value.split(SPACE);
            } else if (MULTIPLE_VALUE_PARAMS.contains(key)) {
                values = value.trim().split(SPACE);
            } else {
                values[0] = value.trim();
            }
            options.setAttribute(key, "urn:ibm:names:oauth:request", values);
            if (!OIDC_OPTIONAL_PARAMS_TO_BE_HANDLED.contains(key)) continue;
            options.setAttribute("com.ibm.wsspi.security.oidc.external.claims:" + key, "com.ibm.wsspi.security.oidc.external.claims", values);
        }
        return options;
    }
}

