/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.genericbnf.PasswordNullifier;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.Audit;
import com.ibm.ws.security.authentication.AuthenticationService;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebProviderAuthenticatorProxy;
import com.ibm.ws.webcontainer.security.WebRequestImpl;
import com.ibm.ws.webcontainer.security.internal.BasicAuthAuthenticator;
import com.ibm.ws.webcontainer.security.internal.DenyReply;
import com.ibm.ws.webcontainer.security.metadata.FormLoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.webapp.WebAppConfigExtended;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.osgi.extension.WebExtensionProcessor;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class FormLoginExtensionProcessor
extends WebExtensionProcessor {
    private static final TraceComponent tc = Tr.register(FormLoginExtensionProcessor.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    private final SubjectManager subjectManager = new SubjectManager();
    private final AuthenticationService authenticationService;
    private final UserRegistry userRegistry;
    private final SecurityMetadata securityMetadata;
    private final WebAppSecurityConfig webAppSecConfig;
    protected SSOCookieHelper ssoCookieHelper;
    private String appName = null;
    private final WebProviderAuthenticatorProxy providerAuthenticatorProxy;
    private ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef = null;
    ReferrerURLCookieHandler referrerURLHandler = null;
    String errorPage = null;
    private WebAppConfig wac = null;
    static final long serialVersionUID = -8427100847400030663L;

    public FormLoginExtensionProcessor(WebAppSecurityConfig webAppSecConfig, AuthenticationService authenticationService, UserRegistry userRegistry, IServletContext webapp, WebProviderAuthenticatorProxy providerAuthenticatorProxy, ConcurrentServiceReferenceMap<String, WebAuthenticator> webAuthenticatorRef) {
        super(webapp);
        this.authenticationService = authenticationService;
        this.userRegistry = userRegistry;
        this.webAppSecConfig = webAppSecConfig;
        this.providerAuthenticatorProxy = providerAuthenticatorProxy;
        this.webAuthenticatorRef = webAuthenticatorRef;
        this.ssoCookieHelper = webAppSecConfig.createSSOCookieHelper();
        this.referrerURLHandler = webAppSecConfig.createReferrerURLCookieHandler();
        this.wac = webapp.getWebAppConfig();
        WebModuleMetaData wmmd = ((WebAppConfigExtended)this.wac).getMetaData();
        this.appName = this.wac.getApplicationName();
        this.securityMetadata = (SecurityMetadata)wmmd.getSecurityMetaData();
    }

    public void handleRequest(ServletRequest req, ServletResponse res) throws Exception {
        HttpServletResponse response;
        HttpServletRequest request;
        boolean handleByProvider;
        if (req instanceof HttpServletRequest && res instanceof HttpServletResponse && !(handleByProvider = this.handleProviderAuthenticate(request = (HttpServletRequest)req, response = (HttpServletResponse)res))) {
            this.formLogin(request, response, this.referrerURLHandler);
        }
    }

    private boolean handleProviderAuthenticate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthenticationResult authResult;
        HashMap<String, Object> props = null;
        if (this.isJaspiEnabled()) {
            props = new HashMap<String, Object>();
            props.put("authType", "FORM_LOGIN");
            props.put("webAppConfig", this.wac);
            props.put("securityMetadata", this.securityMetadata);
            props.put("webAppSecurityConfig", this.webAppSecConfig);
        }
        if ((authResult = this.providerAuthenticatorProxy.authenticate(request, response, props)).getStatus() == AuthResult.CONTINUE) {
            return false;
        }
        if (authResult.getStatus() == AuthResult.REDIRECT_TO_PROVIDER) {
            return true;
        }
        if (authResult.getStatus() != AuthResult.SUCCESS) {
            WebRequestImpl webRequest = new WebRequestImpl(request, response, null, this.webAppSecConfig);
            DenyReply reply = new DenyReply("AuthenticationFailed");
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHN_01, (Object[])new Object[]{webRequest, authResult, reply.getStatusCode()});
            if (!this.isJaspiEnabled() || !this.isPostLoginProcessDone(request)) {
                this.handleError(request, response);
            }
        } else {
            this.postFormLoginProcess(request, response, authResult.getSubject());
        }
        return true;
    }

    private void formLogin(HttpServletRequest req, HttpServletResponse res, ReferrerURLCookieHandler referrerURLHandler) throws ServletException, IOException {
        boolean compliance = this.webAppSecConfig.getLogoutOnHttpSessionExpire();
        if (compliance && req.getRequestedSessionId() != null && !req.isRequestedSessionIdValid()) {
            req.getSession(true);
        }
        if (!this.webAppSecConfig.isSingleSignonEnabled()) {
            Tr.error((TraceComponent)tc, (String)"SEC_FORM_LOGIN_BAD_CONFIG", (Object[])new Object[]{this.appName});
            this.handleError(req, res);
            return;
        }
        String username = req.getParameter("j_username");
        String password = req.getParameter("j_password");
        if (username == null || password == null || password.length() == 0) {
            this.handleError(req, res);
            return;
        }
        BasicAuthAuthenticator basicAuthAuthenticator = new BasicAuthAuthenticator(this.authenticationService, this.userRegistry, this.ssoCookieHelper, this.webAppSecConfig);
        AuthenticationResult authResult = basicAuthAuthenticator.basicAuthenticate(null, username, password, req, res);
        authResult.setTargetRealm(authResult.realm);
        if (authResult.getStatus() != AuthResult.SUCCESS) {
            this.handleError(req, res);
            String realm = authResult.realm;
            WebRequestImpl webRequest = new WebRequestImpl(req, res, null, this.webAppSecConfig);
            DenyReply reply = new DenyReply("AuthenticationFailed");
            authResult.setAuditCredType("FORM");
            Audit.audit((Audit.EventID)Audit.EventID.SECURITY_AUTHN_01, (Object[])new Object[]{webRequest, authResult, reply.getStatusCode()});
            return;
        }
        this.postFormLoginProcess(req, res, authResult.getSubject());
    }

    private void handleError(HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.setStatus(401);
        if (this.getErrorPage(req, res) != null) {
            res.sendRedirect(res.encodeURL(this.getErrorPage(req, res)));
        }
    }

    protected void postFormLoginProcess(HttpServletRequest req, HttpServletResponse res, Subject subject) throws IOException, RuntimeException {
        boolean isPostLoginProcessDone;
        String storedReq = null;
        this.subjectManager.setCallerSubject(subject);
        this.subjectManager.setInvocationSubject(subject);
        boolean bl = isPostLoginProcessDone = this.isJaspiEnabled() && this.isPostLoginProcessDone(req);
        if (!isPostLoginProcessDone) {
            storedReq = this.getStoredReq(req, this.referrerURLHandler);
            if (storedReq != null && storedReq.length() > 0) {
                ReferrerURLCookieHandler.isReferrerHostValid(PasswordNullifier.nullifyParams((String)req.getRequestURL().toString()), PasswordNullifier.nullifyParams((String)storedReq), this.webAppSecConfig.getWASReqURLRedirectDomainNames());
            }
            this.ssoCookieHelper.addSSOCookiesToResponse(subject, req, res, this.wac.getContextRoot());
            this.referrerURLHandler.invalidateReferrerURLCookie(req, res, "WASReqURL");
            if (!res.isCommitted()) {
                res.sendRedirect(res.encodeURL(storedReq));
            }
        }
    }

    @Sensitive
    private String getStoredReq(HttpServletRequest req, ReferrerURLCookieHandler referrerURLHandler) {
        String storedReq = referrerURLHandler.getReferrerURLFromCookies(req, "WASReqURL");
        if (storedReq != null) {
            if (storedReq.equals("/")) {
                storedReq = "";
            } else if (storedReq.startsWith("/")) {
                storedReq = storedReq.substring(1);
            }
        } else {
            storedReq = "";
        }
        return storedReq;
    }

    private String setUpAFullUrl(HttpServletRequest req, String loginErrorPage, boolean bCtx) {
        String errorPage = null;
        if (loginErrorPage != null) {
            if (loginErrorPage.startsWith("http://") || loginErrorPage.startsWith("https://")) {
                return loginErrorPage;
            }
            if (!loginErrorPage.startsWith("/")) {
                loginErrorPage = "/" + loginErrorPage;
            }
            StringBuffer URL2 = req.getRequestURL();
            String URLString = URL2.toString();
            int index = URLString.indexOf("//");
            index = URLString.indexOf("/", index + 2);
            int endindex = URLString.length();
            if (bCtx) {
                String ctx = req.getContextPath();
                if (ctx.equals("/")) {
                    ctx = "";
                }
                errorPage = ctx + loginErrorPage;
            } else {
                errorPage = loginErrorPage;
            }
            URL2.replace(index, endindex, errorPage);
            errorPage = URL2.toString();
        }
        return errorPage;
    }

    private String getErrorPage(HttpServletRequest req, HttpServletResponse res) {
        boolean bCtx = true;
        String loginErrorPage = this.getCustomErrorPage(req);
        if (loginErrorPage == null || loginErrorPage.length() == 0) {
            bCtx = false;
            loginErrorPage = this.getCustomReloginErrorPage(req);
        }
        if (loginErrorPage == null || loginErrorPage.length() == 0) {
            bCtx = true;
            loginErrorPage = this.getErrorPageFromWebXml();
        }
        if (loginErrorPage == null || loginErrorPage.length() == 0) {
            bCtx = false;
            loginErrorPage = this.webAppSecConfig.getLoginErrorURL();
        }
        if (loginErrorPage != null) {
            return this.setUpAFullUrl(req, loginErrorPage, bCtx);
        }
        return null;
    }

    private String getCustomErrorPage(HttpServletRequest req) {
        return req.getParameter("error_page");
    }

    private String getCustomReloginErrorPage(HttpServletRequest req) {
        String reLogin = CookieHelper.getCookieValue(req.getCookies(), "WASReLoginURL");
        if (reLogin != null && reLogin.length() > 0 && reLogin.indexOf("?") < 0) {
            reLogin = reLogin + "?error=error";
        }
        return reLogin;
    }

    private String getErrorPageFromWebXml() {
        String loginErrorPage = null;
        FormLoginConfiguration formLoginConfig = null;
        LoginConfiguration loginConfig = this.securityMetadata.getLoginConfiguration();
        if (loginConfig != null && (formLoginConfig = loginConfig.getFormLoginConfiguration()) != null) {
            loginErrorPage = formLoginConfig.getErrorPage();
        }
        return loginErrorPage;
    }

    private boolean isJaspiEnabled() {
        WebAuthenticator jaspiAuthenticator = this.webAuthenticatorRef != null ? (WebAuthenticator)this.webAuthenticatorRef.getService((Object)"com.ibm.ws.security.jaspi") : null;
        return jaspiAuthenticator != null;
    }

    private boolean isPostLoginProcessDone(HttpServletRequest req) {
        Boolean result = (Boolean)req.getAttribute("com.ibm.ws.security.javaeesec.donePostLoginProcess");
        return result != null && result != false;
    }
}

