/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.apache.yoko.io.ReadBuffer;
import org.apache.yoko.logging.VerboseLogging;
import org.apache.yoko.orb.CORBA.Any;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.CORBA.TypeCode;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.ValueFactoryManager;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.Exceptions;
import org.apache.yoko.util.MinorCodes;
import org.apache.yoko.util.PrivilegedActions;
import org.apache.yoko.util.cmsf.RepIds;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.DataInputStream;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.WStringValueHelper;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.SendingContext.CodeBase;
import org.omg.SendingContext.RunTime;

public final class ValueReader {
    private final ORBInstance orbInstance_;
    private final InputStream in_;
    private final ReadBuffer buf_;
    private final Map<Integer, Serializable> instanceTable_;
    private final Map<Integer, Header> headerTable_;
    private Map<Integer, Integer> positionTable_;
    private final ChunkState chunkState_ = new ChunkState();
    private Header currentHeader_;
    private ValueHandler valueHandler;
    private CodeBase remoteCodeBase;

    private void addInstance(int pos, Serializable instance) {
        if (instance != null) {
            this.instanceTable_.put(pos, instance);
        }
    }

    private void removeInstance(int pos) {
        this.instanceTable_.remove(pos);
    }

    private void readHeader(Header h) {
        int offs;
        int indTag;
        if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.MARSHAL_LOG.fine(String.format("Reading header with tag value 0x%08x at %s", h.tag, this.in_.dumpPosition()));
        }
        Assert.ensure((h.tag != 0 && h.tag != -1 ? 1 : 0) != 0);
        boolean bl = h.state.chunked = (h.tag & 8) == 8;
        if ((h.tag & 1) == 1) {
            int save = this.buf_.getPosition();
            indTag = this.in_.read_long();
            if (indTag == -1) {
                int offs2 = this.in_.read_long();
                if (offs2 >= -4) {
                    throw new MARSHAL(MinorCodes.describeMarshal((int)1095974954), 1095974954, CompletionStatus.COMPLETED_NO);
                }
                int tmp = this.buf_.getPosition();
                this.buf_.setPosition(this.buf_.getPosition() - 4 + offs2);
                if (this.buf_.getPosition() < 0) {
                    throw new MARSHAL(MinorCodes.describeMarshal((int)1095974954), 1095974954, CompletionStatus.COMPLETED_NO);
                }
                h.codebase = this.in_.read_string();
                this.buf_.setPosition(tmp);
            } else {
                this.buf_.setPosition(save);
                h.codebase = this.in_.read_string();
            }
            if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINER)) {
                VerboseLogging.MARSHAL_LOG.finer(String.format("Value header codebase value is \"%s\"", h.codebase));
            }
        }
        if ((h.tag & 6) == 0) {
            VerboseLogging.MARSHAL_LOG.finer("No type information was included");
        } else if ((h.tag & 6) == 6) {
            boolean indList;
            VerboseLogging.MARSHAL_LOG.finer("Multiple types included in header");
            int saveList = this.buf_.getPosition();
            indTag = this.in_.read_long();
            boolean bl2 = indList = indTag == -1;
            if (indList) {
                offs = this.in_.read_long();
                if (offs > -4) {
                    throw new MARSHAL(MinorCodes.describeMarshal((int)1095974954), 1095974954, CompletionStatus.COMPLETED_NO);
                }
                saveList = this.buf_.getPosition();
                this.buf_.setPosition(this.buf_.getPosition() - 4 + offs);
                if (this.buf_.getPosition() < 0) {
                    throw new MARSHAL(MinorCodes.describeMarshal((int)1095974954), 1095974954, CompletionStatus.COMPLETED_NO);
                }
            } else {
                this.buf_.setPosition(saveList);
            }
            int count = this.in_.read_long();
            h.ids = new String[count];
            for (int i = 0; i < count; ++i) {
                int saveRep = this.buf_.getPosition();
                indTag = this.in_.read_long();
                if (indTag == -1) {
                    int offs3 = this.in_.read_long();
                    if (offs3 > -4) {
                        throw new MARSHAL(MinorCodes.describeMarshal((int)1095974954), 1095974954, CompletionStatus.COMPLETED_NO);
                    }
                    saveRep = this.buf_.getPosition();
                    this.buf_.setPosition(this.buf_.getPosition() - 4 + offs3);
                    if (this.buf_.getPosition() < 0) {
                        throw new MARSHAL(MinorCodes.describeMarshal((int)1095974954), 1095974954, CompletionStatus.COMPLETED_NO);
                    }
                    h.ids[i] = this.in_.read_string();
                    this.buf_.setPosition(saveRep);
                } else {
                    this.buf_.setPosition(saveRep);
                    h.ids[i] = this.in_.read_string();
                }
                if (!VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINER)) continue;
                VerboseLogging.MARSHAL_LOG.finer(String.format("Value header respoitory id added \"%s\"", h.ids[i]));
            }
            if (indList) {
                this.buf_.setPosition(saveList);
            }
        } else if ((h.tag & 6) == 2) {
            String id;
            int save = this.buf_.getPosition();
            int indTag2 = this.in_.read_long();
            if (indTag2 == -1) {
                offs = this.in_.read_long();
                if (offs > -4) {
                    throw new MARSHAL(MinorCodes.describeMarshal((int)1095974954), 1095974954, CompletionStatus.COMPLETED_NO);
                }
                save = this.buf_.getPosition();
                this.buf_.setPosition(this.buf_.getPosition() - 4 + offs);
                if (this.buf_.getPosition() < 0) {
                    throw new MARSHAL(MinorCodes.describeMarshal((int)1095974954), 1095974954, CompletionStatus.COMPLETED_NO);
                }
                id = this.in_.read_string();
                this.buf_.setPosition(save);
            } else {
                this.buf_.setPosition(save);
                id = this.in_.read_string();
            }
            h.ids = new String[1];
            h.ids[0] = id;
            if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINER)) {
                VerboseLogging.MARSHAL_LOG.finer(String.format("Single header repository id read \"%s\"", id));
            }
        }
        h.dataPos = this.buf_.getPosition();
        this.headerTable_.put(h.headerPos, h);
    }

    private void readChunk(ChunkState state) {
        int size = this.in_._OB_readLongUnchecked();
        if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINEST)) {
            VerboseLogging.MARSHAL_LOG.finest(String.format("Reading new chunk.  Size value is 0x%x current nest is %d current position=0x%x", size, state.nestingLevel, this.buf_.getPosition()));
        }
        if (size >= 0 && size < 0x7FFFFF00) {
            state.chunkStart = this.buf_.getPosition();
            state.chunkSize = size;
        } else if (size < 0) {
            this.buf_.rewind(4);
            state.chunkStart = this.buf_.getPosition();
            state.chunkSize = 0;
        } else {
            this.buf_.rewind(4);
            state.chunkStart = 0;
            state.chunkSize = 0;
        }
        if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINEST)) {
            VerboseLogging.MARSHAL_LOG.finest(String.format("Chunk read.  start=0x%x, size=0x%x buffer position=0x%x", state.chunkStart, state.chunkSize, this.buf_.getPosition()));
        }
    }

    private void initHeader(Header h) {
        Assert.ensure((h.tag != 0 && h.tag != -1 ? 1 : 0) != 0);
        h.headerPos = this.buf_.getPosition() - 4;
        h.state.copyFrom(this.chunkState_);
        this.readHeader(h);
        this.chunkState_.copyFrom(h.state);
        if (this.chunkState_.chunked) {
            this.readChunk(this.chunkState_);
            ++this.chunkState_.nestingLevel;
        }
    }

    private void skipChunk() {
        if (this.chunkState_.chunked) {
            if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
                VerboseLogging.MARSHAL_LOG.fine(String.format("Skipping a chunked value.  nesting level=%d current position is 0x%x chunk end is 0x%x", this.chunkState_.nestingLevel, this.buf_.getPosition(), this.chunkState_.chunkStart + this.chunkState_.chunkSize));
            }
            if (this.chunkState_.chunkStart > 0) {
                this.buf_.setPosition(this.chunkState_.chunkStart);
                this.in_._OB_skip(this.chunkState_.chunkSize);
                if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINEST)) {
                    VerboseLogging.MARSHAL_LOG.finest(String.format("Skipping to end of current chunk.  New position is 0x%x", this.buf_.getPosition()));
                }
            }
            this.chunkState_.chunkStart = 0;
            this.chunkState_.chunkSize = 0;
            int level = this.chunkState_.nestingLevel;
            int tag = this.in_._OB_readLongUnchecked();
            if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINEST)) {
                VerboseLogging.MARSHAL_LOG.finest(String.format("Skipping chunk:  read tag value =0x%08x", tag));
            }
            while (tag >= 0 || tag < 0 && tag < -this.chunkState_.nestingLevel) {
                if (tag >= 0x7FFFFF00) {
                    VerboseLogging.MARSHAL_LOG.finest("Skipping chunk:  reading a nested chunk value");
                    Header nest = new Header();
                    nest.tag = tag;
                    nest.headerPos = this.buf_.getPosition() - 4;
                    nest.state.nestingLevel = ++level;
                    this.readHeader(nest);
                } else if (tag >= 0) {
                    if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINEST)) {
                        VerboseLogging.MARSHAL_LOG.finest(String.format("Skipping chunk:  skipping over a chunk for length 0x%x", tag));
                    }
                    this.in_._OB_skip(tag);
                } else {
                    if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINEST)) {
                        VerboseLogging.MARSHAL_LOG.finest(String.format("Skipping chunk:  chunk end tag=0x%08x current level=%d", tag, level));
                    }
                    level = -tag - 1;
                }
                tag = this.in_._OB_readLongUnchecked();
                if (!VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINEST)) continue;
                VerboseLogging.MARSHAL_LOG.finest(String.format("Skipping chunk:  read tag value=0x%08x", tag));
            }
            if (tag > -this.chunkState_.nestingLevel) {
                this.buf_.rewind(4);
            }
            --this.chunkState_.nestingLevel;
            if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINEST)) {
                VerboseLogging.MARSHAL_LOG.finest(String.format("New chunk nesting level is %d", this.chunkState_.nestingLevel));
            }
            if (this.chunkState_.nestingLevel == 0) {
                this.chunkState_.chunked = false;
            } else {
                VerboseLogging.MARSHAL_LOG.finest("Reading chunk for skipping to end of a chunk");
                this.readChunk(this.chunkState_);
            }
            if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINEST)) {
                VerboseLogging.MARSHAL_LOG.finest(String.format("Final chunk state is nesting level=%d current position is 0x%x chunk end is 0x%x", this.chunkState_.nestingLevel, this.buf_.getPosition(), this.chunkState_.chunkStart + this.chunkState_.chunkSize));
            }
        }
    }

    private void unmarshalValueState(Serializable v) {
        if (v instanceof StreamableValue) {
            ((StreamableValue)v)._read((org.omg.CORBA.portable.InputStream)this.in_);
        } else if (v instanceof CustomMarshal) {
            org.apache.yoko.orb.CORBA.DataInputStream dis = new org.apache.yoko.orb.CORBA.DataInputStream(this.in_);
            ((CustomMarshal)v).unmarshal((DataInputStream)dis);
        } else {
            throw new MARSHAL("Valuetype does not implement StreamableValue or CustomMarshal");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable readIndirection(CreationStrategy strategy) {
        Integer posObj;
        Serializable v;
        int offs = this.in_.read_long();
        int pos = this.buf_.getPosition() - 4 + offs;
        pos += 3;
        if ((v = this.instanceTable_.get(posObj = Integer.valueOf(pos -= pos & 3))) != null) {
            return v;
        }
        int save = this.buf_.getPosition();
        this.buf_.setPosition(pos);
        if (this.in_._OB_readLongUnchecked() == 0) {
            this.buf_.setPosition(save);
            return null;
        }
        Header nest = this.headerTable_.get(posObj);
        if (nest == null) {
            throw new MARSHAL(MinorCodes.describeMarshal((int)1330446337) + ": cannot instantiate value for indirection", 1330446337, CompletionStatus.COMPLETED_NO);
        }
        if (nest.isRMIValue()) {
            this.buf_.setPosition(save);
            throw new IndirectionException(pos);
        }
        this.buf_.setPosition(nest.dataPos);
        ChunkState saveState = new ChunkState(this.chunkState_);
        this.chunkState_.copyFrom(nest.state);
        if (this.chunkState_.chunked) {
            this.readChunk(this.chunkState_);
        }
        try {
            v = strategy.create(nest);
        }
        finally {
            this.buf_.setPosition(save);
            this.chunkState_.copyFrom(saveState);
        }
        return v;
    }

    private Serializable read(CreationStrategy strategy) {
        Header h = new Header();
        h.tag = this.in_.read_long();
        if (h.tag == 0) {
            return null;
        }
        if (h.tag == -1) {
            return this.readIndirection(strategy);
        }
        if (h.tag < 0x7FFFFF00) {
            throw new MARSHAL(String.format("Illegal valuetype tag 0x%08x", h.tag));
        }
        this.initHeader(h);
        SecondaryValuetypeMarker result = this.isSecondaryCustomValuetype(h) ? SecondaryValuetypeMarker.ATTEMPT_TO_READ_CUSTOM_DATA_AS_VALUE : strategy.create(h);
        this.skipChunk();
        return result;
    }

    private boolean isSecondaryCustomValuetype(Header h) {
        if (h.ids.length != 1) {
            return false;
        }
        String repId = h.ids[0];
        if (!repId.startsWith("RMI:org.omg.custom.") && !repId.startsWith("RMI:org.omg.customRMI.")) {
            return false;
        }
        if (h.codebase != null && VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.MARSHAL_LOG.fine(String.format("Secondary custom marshal valuetype found with non-null codebase: \"%s\", repId: \"%s\"", h.codebase, repId));
        }
        return true;
    }

    private void copyValueState(org.omg.CORBA.TypeCode tc, OutputStream out) {
        block6: {
            try {
                if (tc.kind() == TCKind.tk_value) {
                    org.omg.CORBA.TypeCode base = tc.concrete_base_type();
                    if (base != null) {
                        this.copyValueState(base, out);
                    }
                    for (int i = 0; i < tc.member_count(); ++i) {
                        out.write_InputStream((org.omg.CORBA.portable.InputStream)this.in_, tc.member_type(i));
                    }
                    break block6;
                }
                if (tc.kind() == TCKind.tk_value_box) {
                    out.write_InputStream((org.omg.CORBA.portable.InputStream)this.in_, tc.content_type());
                    break block6;
                }
                throw Assert.fail();
            }
            catch (BadKind | Bounds ex) {
                VerboseLogging.MARSHAL_LOG.log(Level.FINER, "Invalid type kind", ex);
                throw Assert.fail((Throwable)ex);
            }
        }
    }

    private void pushHeader(Header h) {
        h.next = this.currentHeader_;
        this.currentHeader_ = h;
    }

    private void popHeader() {
        Assert.ensure((this.currentHeader_ != null ? 1 : 0) != 0);
        this.currentHeader_ = this.currentHeader_.next;
    }

    private org.omg.CORBA.TypeCode findTypeCode(String id, org.omg.CORBA.TypeCode tc) {
        org.omg.CORBA.TypeCode result = null;
        org.omg.CORBA.TypeCode t = tc;
        while (result == null) {
            try {
                org.omg.CORBA.TypeCode t2 = TypeCode._OB_getOrigType(t);
                if (id.equals(t2.id())) {
                    result = t;
                    continue;
                }
                if (t2.kind() != TCKind.tk_value || t2.type_modifier() != 3) break;
                t = t2.concrete_base_type();
            }
            catch (BadKind ex) {
                throw Assert.fail((Throwable)ex);
            }
        }
        return result;
    }

    public ValueReader(InputStream in) {
        this.in_ = in;
        this.buf_ = in.getBuffer();
        this.orbInstance_ = in._OB_ORBInstance();
        this.instanceTable_ = in.getOffsetMap();
        this.headerTable_ = new Hashtable<Integer, Header>(131);
    }

    private Serializable readRMIValue(Header h, String repid) {
        return this.readRMIValue(h, repid, null);
    }

    private Serializable readRMIValue(Header h, String repid, Class<?> declaredType) {
        if (repid == null && (repid = h.ids[0]) == null) {
            throw new MARSHAL("missing repository id");
        }
        if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.MARSHAL_LOG.fine(String.format("Reading RMI value of type \"%s\"", repid));
        }
        if (this.valueHandler == null) {
            this.valueHandler = Util.createValueHandler();
        }
        String repoClassName = RepIds.query((String)repid).toClassName();
        Class repoClass = Optional.ofNullable(declaredType).filter(type -> type.getName().equals(repoClassName)).orElseGet(() -> ValueReader.resolveRepoClass(repoClassName));
        if (repoClass == null) {
            throw new MARSHAL("class " + repoClassName + " not found");
        }
        if (this.remoteCodeBase == null) {
            this.remoteCodeBase = this.in_.__getSendingContextRuntime();
        }
        try {
            return this.valueHandler.readValue((org.omg.CORBA.portable.InputStream)this.in_, h.headerPos, repoClass, repid, (RunTime)this.remoteCodeBase);
        }
        catch (RuntimeException ex) {
            if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
                VerboseLogging.MARSHAL_LOG.log(Level.FINE, "Caught exception when reading GIOP stream: \n" + this.in_.dumpAllDataWithPosition(), ex);
            }
            throw ex;
        }
    }

    private static <T> Class<T> resolveRepoClass(String name) {
        if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.MARSHAL_LOG.fine(String.format("Attempting to resolve class \"%s\"", name));
        }
        return name.startsWith("[") ? ValueReader.resolveArrayClass(name) : ValueReader.resolveClass(name);
    }

    private static <T> Class<T> resolveArrayClass(String name) {
        int levels = 1 + name.lastIndexOf(91);
        Class<Comparable<Boolean>> elementClass = null;
        switch (name.charAt(levels)) {
            case 'Z': {
                elementClass = Boolean.TYPE;
                break;
            }
            case 'B': {
                elementClass = Byte.TYPE;
                break;
            }
            case 'S': {
                elementClass = Short.TYPE;
                break;
            }
            case 'C': {
                elementClass = Character.TYPE;
                break;
            }
            case 'I': {
                elementClass = Integer.TYPE;
                break;
            }
            case 'J': {
                elementClass = Long.TYPE;
                break;
            }
            case 'F': {
                elementClass = Float.TYPE;
                break;
            }
            case 'D': {
                elementClass = Double.TYPE;
                break;
            }
            case 'L': {
                elementClass = ValueReader.resolveClass(name.substring(levels + 1, name.indexOf(59)));
                if (null != elementClass) break;
                return null;
            }
        }
        Object archetype = 1 == levels ? Array.newInstance(elementClass, 0) : Array.newInstance(elementClass, new int[levels]);
        return ValueReader.generify(archetype.getClass());
    }

    private static <T> Class<T> generify(Class<?> c) {
        return c;
    }

    private static <T> Class<T> resolveClass(String name) {
        try {
            return ValueReader.generify(Util.loadClass((String)name, null, (ClassLoader)((ClassLoader)AccessController.doPrivileged(PrivilegedActions.GET_CONTEXT_CLASS_LOADER))));
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public Serializable readValue() {
        FactoryCreationStrategy strategy = new FactoryCreationStrategy(this, this.in_, null);
        return this.read(strategy);
    }

    public Serializable readValue(String id) {
        if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.MARSHAL_LOG.fine(String.format("Reading value of type \"%s\"", id));
        }
        FactoryCreationStrategy strategy = new FactoryCreationStrategy(this, this.in_, id);
        return this.read(strategy);
    }

    public Serializable readValue(Class<? extends Serializable> clz) {
        Serializable result;
        if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.MARSHAL_LOG.fine(String.format("Reading value of type \"%s\"", null == clz ? "" : clz.getName()));
        }
        if (String.class.equals(clz)) {
            return WStringValueHelper.read((org.omg.CORBA.portable.InputStream)this.in_);
        }
        ClassCreationStrategy strategy = new ClassCreationStrategy(this, this.in_, clz);
        try {
            result = this.read(strategy);
        }
        catch (MARSHAL marshalex) {
            VerboseLogging.MARSHAL_LOG.severe(String.format("MARSHAL \"%s\", 4 bytes before ", marshalex.getMessage(), this.in_.dumpPosition()));
            if (SettingsHolder.IGNORE_INVALID_VALUE_TAG) {
                result = this.read(strategy);
            }
            throw marshalex;
        }
        return null == clz ? result : clz.cast(result);
    }

    public Serializable readValueBox(BoxedValueHelper helper) {
        BoxCreationStrategy strategy = new BoxCreationStrategy(this, this.in_, helper);
        return this.read(strategy);
    }

    public void initializeValue(Serializable value) {
        Assert.ensure((this.currentHeader_ != null ? 1 : 0) != 0);
        this.addInstance(this.currentHeader_.headerPos, value);
        try {
            this.unmarshalValueState(value);
        }
        catch (SystemException ex) {
            this.removeInstance(this.currentHeader_.headerPos);
            throw ex;
        }
    }

    public Object readAbstractInterface() {
        return this.in_.read_boolean() ? this.in_.read_Object() : this.readValue();
    }

    public Object readAbstractInterface(Class<? extends Serializable> clz) {
        return this.in_.read_boolean() ? this.in_.read_Object(clz) : this.readValue(clz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public org.omg.CORBA.TypeCode remarshalValue(org.omg.CORBA.TypeCode tc, OutputStream out) {
        org.omg.CORBA.TypeCode result;
        if (this.positionTable_ == null) {
            this.positionTable_ = new Hashtable<Integer, Integer>(131);
        }
        org.omg.CORBA.TypeCode origTC = TypeCode._OB_getOrigType(tc);
        Header h = new Header();
        h.tag = this.in_.read_long();
        if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.MARSHAL_LOG.fine(String.format("Read tag value 0x%08x", h.tag));
        }
        h.headerPos = this.buf_.getPosition() - 4;
        h.state.copyFrom(this.chunkState_);
        int pos = h.headerPos;
        if (h.tag == 0) {
            out.write_long(0);
            result = tc;
        } else if (h.tag == -1) {
            Integer newPos;
            int offs = this.in_.read_long();
            int oldPos = this.buf_.getPosition() - 4 + offs;
            oldPos += 3;
            if ((newPos = this.positionTable_.get(oldPos -= oldPos & 3)) == null) throw new MARSHAL("Cannot find value for indirection");
            out.write_long(h.tag);
            offs = newPos - out.getPosition();
            out.write_long(offs);
            result = tc;
        } else {
            Class baseType;
            int idPos;
            if (h.tag < 0x7FFFFF00) {
                throw new MARSHAL("Illegal valuetype tag 0x" + Integer.toHexString(h.tag));
            }
            if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
                VerboseLogging.MARSHAL_LOG.fine(String.format("Remarshalling header with tag value 0x%08x", h.tag));
            }
            int outPos = out.getPosition();
            outPos += 3;
            outPos -= outPos & 3;
            this.positionTable_.put(pos, outPos);
            this.readHeader(h);
            this.chunkState_.copyFrom(h.state);
            if (this.chunkState_.chunked) {
                VerboseLogging.MARSHAL_LOG.finest("Reading chunk in remarshal value()");
                this.readChunk(this.chunkState_);
                ++this.chunkState_.nestingLevel;
            }
            String tcId = null;
            short mod = 0;
            try {
                tcId = origTC.id();
                if (origTC.kind() == TCKind.tk_value) {
                    mod = origTC.type_modifier();
                }
            }
            catch (BadKind ex) {
                throw Assert.fail((Throwable)ex);
            }
            if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
                VerboseLogging.MARSHAL_LOG.fine(String.format("Attempting to resolve typeId \"%s\"", tcId));
            }
            String id = null;
            for (idPos = 0; idPos < h.ids.length; ++idPos) {
                if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINER)) {
                    VerboseLogging.MARSHAL_LOG.finer(String.format("Comparing type id \"%s\" against \"%s\"", tcId, h.ids[idPos]));
                }
                if (!tcId.equals(h.ids[idPos])) continue;
                id = h.ids[idPos];
                break;
            }
            if (id == null && (baseType = RepIds.query((String)tcId).toClass()) != null) {
                for (idPos = 0; idPos < h.ids.length; ++idPos) {
                    Class idType;
                    if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINER)) {
                        VerboseLogging.MARSHAL_LOG.finer(String.format("Considering base types of id \"%s\" against \"%s\"", tcId, h.ids[idPos]));
                    }
                    if ((idType = RepIds.query((String)h.ids[idPos]).toClass()) == null) continue;
                    if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINER)) {
                        VerboseLogging.MARSHAL_LOG.finer(String.format("Comparing type id \"%s\" against \"%s\"", baseType.getName(), idType.getName()));
                    }
                    if (!baseType.isAssignableFrom(idType)) continue;
                    id = h.ids[idPos];
                    break;
                }
            }
            String factoryId = null;
            int factoryPos = 0;
            ValueFactory factory = null;
            if (this.orbInstance_ != null) {
                ValueFactoryManager manager = this.orbInstance_.getValueFactoryManager();
                for (factoryPos = 0; factoryPos < h.ids.length; ++factoryPos) {
                    factory = manager.lookupValueFactoryWithClass(h.ids[factoryPos]);
                    if (factory == null) continue;
                    factoryId = h.ids[factoryPos];
                    break;
                }
            }
            if (h.ids.length > 0 && id == null && factoryId == null) {
                if (!VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) throw new MARSHAL(MinorCodes.describeMarshal((int)1330446337) + ": insufficient information to copy valuetype", 1330446337, CompletionStatus.COMPLETED_NO);
                VerboseLogging.MARSHAL_LOG.fine(String.format("Unable to resolve a factory for type \"%s\"", tcId));
                throw new MARSHAL(MinorCodes.describeMarshal((int)1330446337) + ": insufficient information to copy valuetype", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            if (mod == 1 && factoryId == null) {
                throw new MARSHAL(MinorCodes.describeMarshal((int)1330446337) + ": unable to copy custom valuetype", 1330446337, CompletionStatus.COMPLETED_NO);
            }
            if (idPos < factoryPos || h.ids.length == 0 || origTC.kind() == TCKind.tk_value_box) {
                int numIds = h.ids.length - idPos;
                String[] ids = new String[numIds];
                System.arraycopy(h.ids, idPos, ids, 0, h.ids.length - idPos);
                VerboseLogging.MARSHAL_LOG.fine("Copying value state of object using truncated type");
                out._OB_beginValue(h.tag, ids, h.state.chunked);
                this.copyValueState(origTC, out);
                out._OB_endValue();
                result = tc;
            } else {
                try {
                    this.pushHeader(h);
                    Serializable vb = factory.read_value((org.omg.CORBA_2_3.portable.InputStream)this.in_);
                    VerboseLogging.MARSHAL_LOG.fine("Creating a temporary copy of the object for marshalling");
                    try {
                        out.write_value(vb);
                    }
                    finally {
                        this.removeInstance(h.headerPos);
                    }
                }
                finally {
                    this.popHeader();
                }
                result = this.findTypeCode(h.ids[factoryPos], tc);
                if (result == null) {
                    result = tc;
                }
            }
            this.skipChunk();
        }
        Assert.ensure((result != null ? 1 : 0) != 0);
        return result;
    }

    public void readValueAny(org.omg.CORBA.Any any, org.omg.CORBA.TypeCode tc) {
        Any obAny = null;
        try {
            obAny = (Any)any;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        org.omg.CORBA.TypeCode origTC = TypeCode._OB_getOrigType(tc);
        if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.MARSHAL_LOG.fine(String.format("Reading an Any value of kind=%d from position 0x%x", origTC.kind().value(), this.buf_.getPosition()));
        }
        if (origTC.kind() == TCKind.tk_abstract_interface) {
            boolean b = this.in_.read_boolean();
            if (b) {
                VerboseLogging.MARSHAL_LOG.fine("Reading an object reference for an abstract interface");
                any.insert_Object(this.in_.read_Object(), tc);
                return;
            }
            VerboseLogging.MARSHAL_LOG.fine("Reading an object value for an abstract interface");
            any.insert_Value(this.readValue(), tc);
            return;
        }
        try {
            String id = origTC.id();
            if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
                VerboseLogging.MARSHAL_LOG.fine(String.format("Reading an Any value of id=\"%s\"", id));
            }
            if ("IDL:omg.org/CORBA/ValueBase:1.0".equals(id)) {
                any.insert_Value(this.readValue(), tc);
                return;
            }
        }
        catch (BadKind ex) {
            throw Assert.fail((Throwable)ex);
        }
        int startPos = this.buf_.getPosition();
        ChunkState startState = new ChunkState(this.chunkState_);
        if (origTC.kind() == TCKind.tk_value_box) {
            try {
                any.insert_Value(this.readValue(tc.id()), tc);
                return;
            }
            catch (MARSHAL ex) {
                this.buf_.setPosition(startPos);
                this.chunkState_.copyFrom(startState);
                try (OutputStream out = new OutputStream();){
                    out._OB_ORBInstance(this.orbInstance_);
                    this.remarshalValue(origTC, out);
                    InputStream in = out.create_input_stream();
                    Assert.ensure((obAny != null ? 1 : 0) != 0);
                    obAny.replace(tc, (Object)in);
                    return;
                }
            }
            catch (BadKind ex) {
                throw Assert.fail((Throwable)ex);
            }
        }
        Header h = new Header();
        h.tag = this.in_.read_long();
        if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.MARSHAL_LOG.fine(String.format("Read tag value 0x%08x", h.tag));
        }
        if (h.tag == 0) {
            any.insert_Value(null, tc);
            return;
        }
        if (h.tag != -1 && h.tag < 0x7FFFFF00) {
            throw new MARSHAL("Illegal valuetype tag 0x" + Integer.toHexString(h.tag));
        }
        FactoryCreationStrategy strategy = new FactoryCreationStrategy(this, this.in_, null);
        try {
            if (h.tag == -1) {
                VerboseLogging.MARSHAL_LOG.fine("Handling a value type indirection value");
                any.insert_Value(this.readIndirection(strategy), tc);
                return;
            }
            this.initHeader(h);
            StringHolder idH = new StringHolder();
            Serializable vb = strategy.create(h, idH);
            if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
                VerboseLogging.MARSHAL_LOG.fine(String.format("Obtained a value of type \"%s\"", vb.getClass().getName()));
            }
            this.skipChunk();
            org.omg.CORBA.TypeCode t = null;
            if (idH.value != null) {
                t = this.findTypeCode(idH.value, tc);
            }
            if (t != null) {
                any.insert_Value(vb, t);
            } else {
                any.insert_Value(vb, tc);
            }
            return;
        }
        catch (MARSHAL ex) {
            VerboseLogging.MARSHAL_LOG.log(Level.FINE, "Marshaling exception occurred, attempting to remarshal", ex);
            this.buf_.setPosition(startPos);
            this.chunkState_.copyFrom(startState);
            try (OutputStream out = new OutputStream();){
                out._OB_ORBInstance(this.orbInstance_);
                org.omg.CORBA.TypeCode t = this.remarshalValue(origTC, out);
                InputStream in = out.create_input_stream();
                Assert.ensure((obAny != null ? 1 : 0) != 0);
                obAny.replace(t, (Object)in);
                return;
            }
        }
    }

    public void beginValue() {
        Header h = new Header();
        h.tag = this.in_.read_long();
        if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
            VerboseLogging.MARSHAL_LOG.fine(String.format("Read tag value 0x%08x", h.tag));
        }
        Assert.ensure((h.tag != 0 && h.tag != -1 ? 1 : 0) != 0);
        this.initHeader(h);
    }

    public void endValue() {
        this.skipChunk();
    }

    public void checkChunk() {
        if (!this.chunkState_.chunked) {
            return;
        }
        if (this.chunkState_.chunkStart > 0 && this.chunkState_.chunkStart + this.chunkState_.chunkSize == this.buf_.getPosition()) {
            this.readChunk(this.chunkState_);
        }
    }

    private static enum SecondaryValuetypeMarker {
        ATTEMPT_TO_READ_CUSTOM_DATA_AS_VALUE;

    }

    private class FactoryCreationStrategy
    extends CreationStrategy {
        private final String id_;
        private final ORBInstance orbInstance_;

        FactoryCreationStrategy(ValueReader reader, InputStream is, String id) {
            super(reader, is);
            this.id_ = id;
            this.orbInstance_ = is._OB_ORBInstance();
        }

        private ValueFactory findFactory(Header h, StringHolder id) {
            ValueFactory f = null;
            if (this.orbInstance_ != null) {
                ValueFactoryManager manager = this.orbInstance_.getValueFactoryManager();
                if (h.ids.length > 0) {
                    for (int i = 0; i < h.ids.length; ++i) {
                        f = manager.lookupValueFactoryWithClass(h.ids[i]);
                        if (f != null) {
                            id.value = h.ids[i];
                        } else if (this.id_ == null || !h.ids[i].equals(this.id_)) {
                            continue;
                        }
                        break;
                    }
                } else if (this.id_ != null) {
                    f = manager.lookupValueFactoryWithClass(this.id_);
                    id.value = this.id_;
                }
            }
            return f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Serializable createWithFactory(Header h, ValueFactory factory) {
            try {
                this.reader_.pushHeader(h);
                Serializable serializable = factory.read_value((org.omg.CORBA_2_3.portable.InputStream)this.is_);
                return serializable;
            }
            finally {
                this.reader_.popHeader();
            }
        }

        private BoxedValueHelper getBoxedHelper(String id) {
            if (WStringValueHelper.id().equals(id)) {
                return new WStringValueHelper();
            }
            Class helperClass = RepIds.query((String)id).suffix("Helper").toClass();
            try {
                if (helperClass != null) {
                    return (BoxedValueHelper)((Constructor)AccessController.doPrivileged(PrivilegedActions.getNoArgConstructor((Class)helperClass))).newInstance(new Object[0]);
                }
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException | PrivilegedActionException ex) {
                String msg = MinorCodes.describeMarshal((int)1330446337) + ": invalid BoxedValueHelper for " + id;
                throw (MARSHAL)Exceptions.as(MARSHAL::new, (Throwable)ex, (Object)msg, (Object)1330446337, (Object)CompletionStatus.COMPLETED_NO);
            }
            return null;
        }

        @Override
        Serializable create(Header h) {
            StringHolder idH = new StringHolder();
            return this.create(h, idH);
        }

        Serializable create(Header h, StringHolder id) {
            Assert.ensure((h.tag >= 0x7FFFFF00 && h.tag != -1 ? 1 : 0) != 0);
            if (h.isRMIValue()) {
                Serializable result = ValueReader.this.readRMIValue(h, h.ids[0]);
                ValueReader.this.addInstance(h.headerPos, result);
                return result;
            }
            ValueFactory factory = this.findFactory(h, id);
            if (factory != null) {
                Serializable result = this.createWithFactory(h, factory);
                this.reader_.addInstance(h.headerPos, result);
                return result;
            }
            BoxedValueHelper helper = null;
            if (h.ids.length > 0 && (helper = this.getBoxedHelper(h.ids[0])) != null) {
                id.value = h.ids[0];
            }
            if (helper == null && this.id_ != null && (helper = this.getBoxedHelper(this.id_)) != null) {
                id.value = this.id_;
            }
            if (helper != null) {
                Serializable result = helper.read_value((org.omg.CORBA.portable.InputStream)this.is_);
                this.reader_.addInstance(h.headerPos, result);
                return result;
            }
            String type = "<unknown>";
            if (h.ids.length > 0) {
                type = h.ids[0];
            } else if (this.id_ != null) {
                type = this.id_;
            }
            throw new MARSHAL(MinorCodes.describeMarshal((int)1330446337) + ": " + type, 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    private static class ClassCreationStrategy
    extends CreationStrategy {
        private final Class<? extends Serializable> clz_;

        ClassCreationStrategy(ValueReader reader, InputStream is, Class<? extends Serializable> clz) {
            super(reader, is);
            this.clz_ = clz;
        }

        @Override
        Serializable create(Header h) {
            if (VerboseLogging.MARSHAL_LOG.isLoggable(Level.FINE)) {
                VerboseLogging.MARSHAL_LOG.fine(String.format("Creating a value object with tag value 0x%08x", h.tag));
            }
            Assert.ensure((h.tag >= 0x7FFFFF00 && h.tag != -1 ? 1 : 0) != 0);
            if (h.isRMIValue()) {
                return this.reader_.readRMIValue(h, h.ids[0], this.clz_);
            }
            try {
                Serializable result = (Serializable)((Constructor)AccessController.doPrivileged(PrivilegedActions.getNoArgConstructor(this.clz_))).newInstance(new Object[0]);
                this.reader_.addInstance(h.headerPos, result);
                try {
                    this.reader_.unmarshalValueState(result);
                }
                catch (SystemException ex) {
                    this.reader_.removeInstance(h.headerPos);
                    throw ex;
                }
                return result;
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | InvocationTargetException | PrivilegedActionException e) {
                throw (MARSHAL)Exceptions.as(MARSHAL::new, (Throwable)e, (Object)(MinorCodes.describeMarshal((int)1330446337) + ": " + this.clz_.getName()), (Object)1330446337, (Object)CompletionStatus.COMPLETED_NO);
            }
        }
    }

    private static class BoxCreationStrategy
    extends CreationStrategy {
        private final BoxedValueHelper helper_;

        BoxCreationStrategy(ValueReader reader, InputStream is, BoxedValueHelper helper) {
            super(reader, is);
            this.helper_ = helper;
        }

        @Override
        Serializable create(Header h) {
            Assert.ensure((h.tag >= 0x7FFFFF00 && h.tag != -1 ? 1 : 0) != 0);
            Serializable result = this.helper_.read_value((org.omg.CORBA.portable.InputStream)this.is_);
            if (result != null) {
                this.reader_.addInstance(h.headerPos, result);
                return result;
            }
            throw new MARSHAL(MinorCodes.describeMarshal((int)1330446337) + ": " + this.helper_.get_id(), 1330446337, CompletionStatus.COMPLETED_NO);
        }
    }

    private static abstract class CreationStrategy {
        final ValueReader reader_;
        final InputStream is_;

        CreationStrategy(ValueReader reader, InputStream is) {
            this.reader_ = reader;
            this.is_ = is;
        }

        abstract Serializable create(Header var1);
    }

    private static class Header {
        int tag;
        int headerPos;
        int dataPos;
        String[] ids = new String[0];
        final ChunkState state = new ChunkState();
        Header next;
        String codebase;

        Header() {
        }

        boolean isRMIValue() {
            return this.ids != null && this.ids.length > 0 && this.ids[0].startsWith("RMI:");
        }
    }

    private static class ChunkState {
        boolean chunked;
        int nestingLevel;
        int chunkStart;
        int chunkSize;

        ChunkState() {
        }

        ChunkState(ChunkState s) {
            this.copyFrom(s);
        }

        void copyFrom(ChunkState s) {
            this.chunked = s.chunked;
            this.nestingLevel = s.nestingLevel;
            this.chunkStart = s.chunkStart;
            this.chunkSize = s.chunkSize;
        }
    }

    static enum SettingsHolder {

        static final boolean IGNORE_INVALID_VALUE_TAG = (Boolean)AccessController.doPrivileged(PrivilegedActions.action(() -> Boolean.getBoolean("org.apache.yoko.ignoreInvalidValueTag")));
    }
}

