/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resources;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;

public class FileLogger {
    public static final String CLASS_NAME = FileLogger.class.getSimpleName();
    private static final Date current = new Date(FileLogger.getTime());
    private static final SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy HH:mm:ss:SSS z");
    private static String currentFormatted = formatter.format(current);
    public static final String ENABLED_PROPERTY_NAME = "JBOSS_HOTSPOT_TRACE_ENABLED";
    public static final boolean enabled;
    public static final FileLoggerProperties loggerProperties;
    public static final FileLogger fileLogger;
    public static final boolean AUTOFLUSH = true;
    public static final boolean DO_APPEND = true;
    public final boolean autoflush;
    public final File outputFile;
    public final String outputPath;
    public final OutputStream outputStream;
    public final PrintStream outputPrinter;
    public final String textPrefix;
    private final Map<Thread, String> shortIds = new WeakHashMap<Thread, String>();
    private int lastId = 0;
    private static final String ZERO_FILL = "000000";
    private static final int ZERO_FILL_LENGTH = 6;
    private static final String SPACES = "                                        ";
    private static final int NUM_SPACES = 40;
    public static final int BYTES_PER_ROW = 16;
    public static final int BYTE_INDENT = 4;
    public static final String INDENT = "    ";

    public static long getTime() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFormattedTime() {
        Date date = current;
        synchronized (date) {
            long currentMs = FileLogger.getTime();
            if (currentMs - current.getTime() > 10L) {
                current.setTime(currentMs);
                currentFormatted = formatter.format(current);
            }
            return currentFormatted;
        }
    }

    public static String getClassResourceName(Class<?> targetClass) {
        return "/" + targetClass.getName().replace('.', '/') + ".class";
    }

    public static byte[] read(ClassLoader classLoader, String resourceName) throws IOException {
        URL resourceURL = classLoader.getResource(resourceName);
        try (InputStream resourceStream = resourceURL.openStream();){
            byte[] byArray = FileLogger.read(resourceStream);
            return byArray;
        }
    }

    public static byte[] read(InputStream inputStream) throws IOException {
        int read;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[32768];
        while ((read = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
        }
        return outputStream.toByteArray();
    }

    protected static String getSystemProperty(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
    }

    public static boolean isLoggablePath(String path) {
        return loggerProperties != null && loggerProperties.isLoggablePath(path);
    }

    public static boolean isLoggableClassName(String className) {
        return loggerProperties != null && loggerProperties.isLoggableClassName(className);
    }

    public static PrintWriter fileWriter() {
        return fileLogger == null ? null : new PrintWriter(FileLogger.fileLogger.outputPrinter);
    }

    public static void fileLog(String className, String methodName, String text) {
        if (fileLogger != null) {
            fileLogger.log(className, methodName, text);
        }
    }

    public static void fileLog(String className, String methodName, String text, Object value) {
        if (fileLogger != null) {
            fileLogger.log(className, methodName, text, value);
        }
    }

    public static void fileDump(String className, String methodName, String text, byte[] bytes) {
        if (fileLogger != null) {
            fileLogger.dump(className, methodName, text, bytes);
        }
    }

    public static void fileStack(String className, String methodName, String text, Throwable th) {
        if (fileLogger != null) {
            fileLogger.logStack(className, methodName, text, th);
        }
    }

    public FileLogger(String outputDirPath, String outputPrefix, String outputSuffix, String debugPrefix, boolean autoflush) {
        PrintStream useOutputPrinter;
        FileOutputStream useOutputStream;
        String useOutputPath;
        String methodName = "init";
        this.textPrefix = debugPrefix;
        this.autoflush = autoflush;
        File useOutputFile = null;
        if (outputDirPath != null || outputPrefix != null) {
            File outputDir;
            if (outputPrefix == null) {
                outputPrefix = "JBH: ";
            }
            if (outputSuffix == null) {
                outputSuffix = ".log";
            }
            String actualOutputDirPath = null;
            if (outputDirPath == null) {
                outputDir = new File(".");
                actualOutputDirPath = outputDir.getAbsolutePath();
                System.out.println("JBH: Logging [ " + outputPrefix + " ] [ " + outputSuffix + " ] to current directory [ " + actualOutputDirPath + " ]");
            } else {
                outputDir = new File(outputDirPath);
                actualOutputDirPath = outputDir.getAbsolutePath();
                if (!outputDir.exists()) {
                    outputDir.mkdirs();
                    if (!outputDir.exists()) {
                        System.out.println("JBH: ERROR: Logging [ " + outputPrefix + " ] [ " + outputSuffix + " ] failed to create directory [ " + actualOutputDirPath + " ]");
                        outputDir = null;
                    } else {
                        System.out.println("JBH: Logging [ " + outputPrefix + " ] [ " + outputSuffix + " ] to new directory [ " + actualOutputDirPath + " ]");
                    }
                } else {
                    System.out.println("JBH: Logging [ " + outputPrefix + " ] [ " + outputSuffix + " ] to existing directory [ " + actualOutputDirPath + " ]");
                }
            }
            if (outputDir != null) {
                try {
                    useOutputFile = File.createTempFile(outputPrefix, outputSuffix, outputDir);
                }
                catch (IOException e) {
                    System.out.println("JBH: ERROR: Failed to create [ " + outputPrefix + " ] [ " + outputSuffix + " ] [ " + actualOutputDirPath + " ]");
                    e.printStackTrace(System.out);
                }
            }
        }
        this.outputFile = useOutputFile;
        if (this.outputFile == null) {
            useOutputPath = null;
            useOutputStream = null;
            useOutputPrinter = System.out;
            System.out.println("JBH: Logging to Standard Output");
        } else {
            useOutputPath = this.outputFile.getAbsolutePath();
            try {
                useOutputStream = new FileOutputStream(this.outputFile, true);
                useOutputPrinter = new PrintStream(useOutputStream, this.autoflush);
                System.out.println("JBH: Logging to [ " + useOutputPath + " ]");
            }
            catch (IOException e) {
                System.out.println("JBH: ERROR: Unable to write to output file [ " + useOutputPath + " ]");
                e.printStackTrace(System.out);
                useOutputPath = null;
                useOutputStream = null;
                useOutputPrinter = System.out;
                System.out.println("JBH: Logging to Standard Output");
            }
        }
        this.outputPath = useOutputPath;
        this.outputStream = useOutputStream;
        this.outputPrinter = useOutputPrinter;
        String output = this.outputFile != null ? this.outputFile.getAbsolutePath() : "[ System.out ]";
        this.log(CLASS_NAME, methodName, "Output to", output);
    }

    protected void rawLog(String text) {
        this.outputPrinter.println(text);
    }

    public synchronized void log(String text) {
        this.rawLog(this.head() + text);
    }

    public synchronized void log(String className, String text) {
        this.rawLog(this.head() + className + ": " + text);
    }

    public synchronized void log(String className, String methodName, String text) {
        this.rawLog(this.head() + className + ": " + methodName + ": " + text);
    }

    public synchronized void log(String className, String methodName, String text, Object value) {
        this.rawLog(this.head() + className + ": " + methodName + ": " + text + " [ " + value + " ]");
    }

    public synchronized void logStack(String text) {
        new Throwable(this.head() + text).printStackTrace(this.outputPrinter);
    }

    public synchronized void logStack(String className, String text) {
        new Throwable(this.head() + className + ": " + text).printStackTrace(this.outputPrinter);
    }

    public synchronized void logStack(String className, String methodName, String text) {
        new Throwable(this.head() + className + ": " + methodName + ": " + text).printStackTrace(this.outputPrinter);
    }

    public synchronized void logStack(String text, Throwable th) {
        this.log(text);
        th.printStackTrace(this.outputPrinter);
    }

    public synchronized void logStack(String className, String text, Throwable th) {
        this.log(className, text);
        th.printStackTrace(this.outputPrinter);
    }

    public synchronized void logStack(String className, String methodName, String text, Throwable th) {
        this.log(className, methodName, text);
        th.printStackTrace(this.outputPrinter);
    }

    public synchronized void dump(String text, byte[] bytes) {
        String header = this.head() + text;
        this.rawDump(header, bytes);
    }

    public synchronized void dump(String className, String text, byte[] bytes) {
        String header = this.head() + className + ": " + text;
        this.rawDump(header, bytes);
    }

    public synchronized void dump(String className, String methodName, String text, byte[] bytes) {
        String header = this.head() + className + ": " + methodName + ": " + text;
        this.rawDump(header, bytes);
    }

    public Thread getCurrentThread() {
        return Thread.currentThread();
    }

    public static String getLongId(Thread thread) {
        return thread.toString();
    }

    private String computeShortId(Thread thread) {
        String longId = FileLogger.getLongId(thread);
        String rawId = Integer.toHexString(++this.lastId);
        int rawIdLen = rawId.length();
        String shortId = "Thread-";
        if (rawIdLen < 6) {
            shortId = shortId + ZERO_FILL.substring(rawIdLen);
        }
        shortId = shortId + rawId;
        String head = this.head(shortId);
        this.rawLog(head + "Assigned thread ID [ " + longId + " ] [ " + shortId + " ]");
        if (this.lastId % 20 == 0) {
            this.displayThreadIds(head);
        }
        return shortId;
    }

    private void displayThreadIds(String head) {
        this.rawLog(head + "Thread assignments:");
        boolean LONG_ID = false;
        boolean SHORT_ID = true;
        ArrayList<String[]> assignments = new ArrayList<String[]>(this.shortIds.size());
        int maxLong = 0;
        for (Map.Entry<Thread, String> idEntry : this.shortIds.entrySet()) {
            Thread t = idEntry.getKey();
            String shortId = idEntry.getValue();
            String longId = FileLogger.getLongId(t);
            int longLen = longId.length();
            if (longLen > maxLong) {
                maxLong = longLen;
            }
            assignments.add(new String[]{longId, shortId});
        }
        if (maxLong > 40) {
            maxLong = 40;
        }
        assignments.sort((a1, a2) -> a1[1].compareTo(a2[1]));
        int useMaxLong = maxLong;
        assignments.forEach(assignment -> {
            String longId = assignment[0];
            int longIdLen = longId.length();
            if (longIdLen > useMaxLong) {
                longIdLen = useMaxLong;
            }
            String spaces = SPACES.substring(longIdLen, useMaxLong);
            String shortId = assignment[1];
            this.rawLog(head + ":  [ " + longId + spaces + " ] [ " + shortId + " ]");
        });
    }

    private String getShortId(Thread thread) {
        return this.shortIds.computeIfAbsent(thread, this::computeShortId);
    }

    private String head() {
        return this.head(this.getShortId(this.getCurrentThread()));
    }

    private String head(String threadId) {
        return "[ " + FileLogger.getFormattedTime() + " ] [ " + threadId + " ] " + this.textPrefix;
    }

    private void rawDump(String header, byte[] bytes) {
        String tail = " [ " + bytes.length + " ]";
        this.rawLog(header + tail + ": BEGIN");
        this.dump(bytes);
        this.rawLog(header + tail + ": END");
    }

    private void dump(byte[] bytes) {
        int len = bytes.length;
        if (len == 0) {
            return;
        }
        int rows = len / 16;
        int rem = len % 16;
        int partialRow = rem == 0 ? 0 : 1;
        StringBuilder builder = new StringBuilder(51);
        for (int rowNo = 0; rowNo < rows + partialRow; ++rowNo) {
            int start = rowNo * 16;
            int end = start + (rowNo == rows ? rem : 16);
            builder.append(INDENT);
            for (int byteNo = start; byteNo < end; ++byteNo) {
                String nextHex;
                if (byteNo > start) {
                    builder.append(' ');
                }
                if ((nextHex = Integer.toHexString(bytes[byteNo] & 0xFF)).length() < 2) {
                    builder.append('0');
                }
                builder.append(nextHex);
            }
            String output = builder.toString();
            builder.setLength(0);
            this.rawLog(output);
        }
    }

    static {
        String enabledValue = FileLogger.getSystemProperty(ENABLED_PROPERTY_NAME);
        boolean bl = enabled = enabledValue != null && enabledValue.equalsIgnoreCase("true");
        if (enabled) {
            System.out.println("JBH: Enabled [ JBOSS_HOTSPOT_TRACE_ENABLED ] [ " + enabledValue + " ]");
        }
        if (enabled) {
            loggerProperties = new FileLoggerProperties();
            fileLogger = loggerProperties.create();
        } else {
            loggerProperties = null;
            fileLogger = null;
        }
    }

    public static class FileLoggerProperties {
        public static final String WLP_INSTALL_PROPERTY_NAME = "wlp.install.dir";
        public static final String WLP_SERVER_PROPERTY_NAME = "wlp.server.name";
        public static final String WLP_LOG1_PROPERTY_NAME = "com.ibm.ws.logging.log.directory";
        public static final String WLP_LOG2_PROPERTY_NAME = "LOG_DIR";
        public static final String DIR_PROPERTY_NAME = "JBOSS_HOTSPOT_TRACE_DIR";
        public static final String FILE_PROPERTY_NAME = "JBOSS_HOTSPOT_TRACE_FILE";
        public static final String FILE_EXT_PROPERTY_NAME = "JBOSS_HOTSPOT_TRACE_EXT";
        public static final String PREFIX_PROPERTY_NAME = "JBOSS_HOTSPOT_TRACE_PREFIX";
        public static final String AUTOFLUSH_PROPERTY_NAME = "JBOSS_HOTSPOT_TRACE_AUTOFLUSH";
        public static final String PATTERN_PROPERTY_NAME = "JBOSS_HOTSPOT_TRACE_PATTERN";
        public static final String[] PROPERTY_NAMES = new String[]{"JBOSS_HOTSPOT_TRACE_DIR", "JBOSS_HOTSPOT_TRACE_FILE", "JBOSS_HOTSPOT_TRACE_EXT", "JBOSS_HOTSPOT_TRACE_PREFIX", "JBOSS_HOTSPOT_TRACE_AUTOFLUSH", "JBOSS_HOTSPOT_TRACE_PATTERN"};
        private final String wlpHome;
        private final String wlpName;
        private final String log1Home;
        private final String log2Home;
        private final String logHome;
        private final Properties systemProperties;
        private final String systemPattern;
        private final Properties overrideProperties;
        private final String overridePattern;

        public static FileLogger create(File logFile, String prefix, boolean autoflush) {
            String logExt;
            String baseLogName;
            Properties properties = new Properties();
            File parent = logFile.getParentFile();
            String parentPath = parent == null ? "." : parent.getPath();
            String logName = logFile.getName();
            int extOffset = logName.lastIndexOf(46);
            if (extOffset == -1) {
                baseLogName = logName;
                logExt = null;
            } else {
                baseLogName = logName.substring(0, extOffset);
                logExt = logName.substring(extOffset);
            }
            properties.setProperty(DIR_PROPERTY_NAME, parentPath);
            properties.setProperty(FILE_PROPERTY_NAME, baseLogName);
            if (logExt != null) {
                properties.setProperty(FILE_EXT_PROPERTY_NAME, logExt);
            }
            properties.setProperty(PREFIX_PROPERTY_NAME, prefix);
            properties.setProperty(AUTOFLUSH_PROPERTY_NAME, Boolean.valueOf(autoflush).toString());
            return new FileLoggerProperties(properties).create();
        }

        public String getProperty(String propertyName, String defaultValue) {
            String propertyValue = this.getProperty(propertyName);
            return propertyValue == null ? defaultValue : propertyValue;
        }

        public boolean getProperty(String propertyName, boolean defaultValue) {
            String propertyValue = this.getProperty(propertyName);
            return propertyValue == null ? defaultValue : Boolean.valueOf(propertyValue);
        }

        public FileLogger create() {
            String dirName = this.getProperty(DIR_PROPERTY_NAME, this.logHome);
            String fileName = this.getProperty(FILE_PROPERTY_NAME, "JHotspot");
            String fileExt = this.getProperty(FILE_EXT_PROPERTY_NAME, ".log");
            String prefix = this.getProperty(PREFIX_PROPERTY_NAME, "JBH: ");
            boolean autoflush = this.getProperty(AUTOFLUSH_PROPERTY_NAME, false);
            return new FileLogger(dirName, fileName, fileExt, prefix, autoflush);
        }

        public FileLoggerProperties() {
            this(null);
        }

        public FileLoggerProperties(Properties properties) {
            this.overrideProperties = properties;
            this.overridePattern = properties == null ? null : properties.getProperty(PATTERN_PROPERTY_NAME);
            this.wlpHome = FileLogger.getSystemProperty(WLP_INSTALL_PROPERTY_NAME);
            this.wlpName = FileLogger.getSystemProperty(WLP_SERVER_PROPERTY_NAME);
            this.log1Home = FileLogger.getSystemProperty(WLP_LOG1_PROPERTY_NAME);
            this.log2Home = FileLogger.getSystemProperty(WLP_LOG2_PROPERTY_NAME);
            this.logHome = this.selectLogHome();
            System.out.println("JBH: Install Home [ wlp.install.dir ] [ " + this.wlpHome + " ]");
            System.out.println("JBH: Server Name [ wlp.server.name ] [ " + this.wlpName + " ]");
            System.out.println("JBH: Log1 Home [ com.ibm.ws.logging.log.directory ] [ " + this.log1Home + " ]");
            System.out.println("JBH: Log2 Home [ LOG_DIR ] [ " + this.log2Home + " ]");
            System.out.println("JBH: Log Home [ " + this.logHome + " ]");
            Properties useProperties = new Properties();
            for (String propertyName : PROPERTY_NAMES) {
                String propertyValue = FileLogger.getSystemProperty(propertyName);
                if (propertyValue == null) continue;
                useProperties.setProperty(propertyName, propertyValue);
                System.out.println("JBH: [ " + propertyName + " ] [ " + propertyValue + " ]");
            }
            this.systemProperties = useProperties;
            this.systemPattern = this.systemProperties.getProperty(PATTERN_PROPERTY_NAME);
        }

        public static String pathAppend(String p1, String p2) {
            boolean s2;
            if (p1 == null || p1.isEmpty()) {
                return p2;
            }
            if (p2 == null || p2.isEmpty()) {
                return p1;
            }
            char c1 = p1.charAt(p1.length() - 1);
            boolean s1 = c1 == '/';
            char c2 = p2.charAt(0);
            boolean bl = s2 = c2 == '/';
            if (s1) {
                if (s2) {
                    return p1 + p2.substring(1);
                }
                return p1 + p2;
            }
            if (s2) {
                return p1 + p2;
            }
            return p1 + "/" + p2;
        }

        public String selectLogHome() {
            if (this.log2Home != null) {
                return this.log2Home;
            }
            if (this.log1Home != null) {
                return this.log1Home;
            }
            if (this.wlpHome == null) {
                return "./logs";
            }
            if (this.wlpName == null) {
                return FileLoggerProperties.pathAppend(this.wlpHome, "/logs");
            }
            return FileLoggerProperties.pathAppend(FileLoggerProperties.pathAppend(FileLoggerProperties.pathAppend(this.wlpHome, "/usr/servers/"), this.wlpName), "/logs");
        }

        public String getProperty(String propertyName) {
            String overrideProperty;
            String string = overrideProperty = this.overrideProperties == null ? null : this.overrideProperties.getProperty(propertyName);
            if (overrideProperty != null) {
                return overrideProperty;
            }
            return this.systemProperties.getProperty(propertyName);
        }

        public String getPattern() {
            if (this.overridePattern != null) {
                return this.overridePattern;
            }
            return this.systemPattern;
        }

        public boolean isLoggablePath(String path) {
            String usePattern = this.getPattern();
            if (usePattern == null || usePattern.isEmpty()) {
                return true;
            }
            String className = path.replace(File.separatorChar, '.');
            if (File.separatorChar == '\\') {
                className = className.replace('/', '.');
            }
            return className.contains(usePattern);
        }

        public boolean isLoggableClassName(String className) {
            String usePattern = this.getPattern();
            if (usePattern == null || usePattern.isEmpty()) {
                return true;
            }
            return className.contains(usePattern);
        }
    }
}

