/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.pkce;

import com.ibm.oauth.core.api.error.oauth20.InvalidGrantException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.pkce.PkceMethodS256;
import com.ibm.ws.security.oauth20.pkce.ProofKeyForCodeExchangeMethod;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PkceMethodPlain
extends ProofKeyForCodeExchangeMethod {
    private static final TraceComponent tc = Tr.register(PkceMethodS256.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static String CHALLENGE_METHOD = "plain";
    static final long serialVersionUID = 6945364687492703314L;

    @Override
    public String getCodeChallengeMethod() {
        return CHALLENGE_METHOD;
    }

    @Override
    public String generateCodeChallenge(String codeVerifier) {
        return codeVerifier;
    }

    @Override
    public void validate(String codeVerifier, String codeChallenge) throws InvalidGrantException {
        if (codeVerifier == null && codeChallenge == null) {
            return;
        }
        if (codeChallenge == null && codeVerifier != null || !codeChallenge.equals(codeVerifier)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"security.oauth20.pkce.error.mismatch.codeverifier", (Object[])new Object[]{codeChallenge, codeVerifier});
            throw new InvalidGrantException(message, null);
        }
    }
}

