/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.telemetry.internal.interfaces;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.telemetry.internal.common.info.ErrorOpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.common.info.OpenTelemetryInfo;
import io.openliberty.microprofile.telemetry.internal.interfaces.OpenTelemetryInfoFactory;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenTelemetryAccessor {
    private static final TraceComponent tc = Tr.register(OpenTelemetryAccessor.class, (String)"TELEMETRY", (String)"io.openliberty.microprofile.telemetry.internal.common.resources.MPTelemetry");
    private static final ServiceCaller<OpenTelemetryInfoFactory> openTelemetryInfoFactoryService = new ServiceCaller(OpenTelemetryAccessor.class, OpenTelemetryInfoFactory.class);
    private static final ServiceCaller<CDIService> cdiService = new ServiceCaller(OpenTelemetryAccessor.class, CDIService.class);
    static final long serialVersionUID = -8403991091001708632L;

    public static OpenTelemetryInfo getOpenTelemetryInfo() {
        Optional openTelemetryInfo = openTelemetryInfoFactoryService.call(factory -> factory.getOpenTelemetryInfo());
        return openTelemetryInfo.orElseGet(ErrorOpenTelemetryInfo::new);
    }

    public static Tracer getTracer() {
        return OpenTelemetryAccessor.getOpenTelemetryInfo().getTracer();
    }

    public static Span getSpan() {
        return Span.current();
    }

    public static Baggage getBaggage() {
        return Baggage.current();
    }

    public static Set<Annotation> getInterceptorBindingsFromInvocationContext(InvocationContext context) {
        Optional bindings = cdiService.call(service -> service.getInterceptorBindingsFromInvocationContext(context));
        return (Set)bindings.orElseThrow(() -> new IllegalStateException("Unable to get CDIService"));
    }
}

