/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.json;

import io.smallrye.graphql.client.typesafe.api.GraphQlClientException;
import io.smallrye.graphql.client.typesafe.impl.json.GraphQlClientValueException;
import io.smallrye.graphql.client.typesafe.impl.json.Location;
import io.smallrye.graphql.client.typesafe.impl.json.Reader;
import io.smallrye.graphql.client.typesafe.impl.reflection.ConstructionInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import jakarta.json.JsonString;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;

class JsonStringReader
extends Reader<JsonString> {
    JsonStringReader(TypeInfo type, Location location, JsonString value) {
        super(type, location, value);
    }

    @Override
    Object read() {
        if (Character.TYPE.equals(this.type.getRawType()) || Character.class.equals(this.type.getRawType())) {
            if (((JsonString)this.value).getChars().length() != 1) {
                throw new GraphQlClientValueException(this.location, this.value);
            }
            return Character.valueOf(((JsonString)this.value).getChars().charAt(0));
        }
        if (String.class.equals(this.type.getRawType()) || Object.class.equals(this.type.getRawType())) {
            return ((JsonString)this.value).getString();
        }
        if (this.type.isEnum()) {
            return this.enumValue();
        }
        if (Date.class.equals(this.type.getRawType())) {
            return Date.from(Instant.parse(((JsonString)this.value).getString()));
        }
        if (UUID.class.equals(this.type.getRawType())) {
            return UUID.fromString(((JsonString)this.value).getString());
        }
        ConstructionInfo constructor = this.type.scalarConstructor().orElseThrow(() -> new GraphQlClientValueException(this.location, this.value));
        try {
            return constructor.execute(((JsonString)this.value).getString());
        }
        catch (Exception e) {
            throw new GraphQlClientException("can't create scalar " + this.location, e);
        }
    }

    private Enum<?> enumValue() {
        return Enum.valueOf(this.type.getRawType(), ((JsonString)this.value).getString());
    }
}

