/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.jakartasec.el;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.javaeesec.identitystore.ELHelper;
import jakarta.el.ELProcessor;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ELUtils {
    private static final TraceComponent tc = Tr.register(ELUtils.class, null, null);
    public static final String EVAL_EXPRESSION_PATTERN_GROUP_NAME = "expr";
    public static final Pattern EVAL_EXPRESSION_PATTERN = Pattern.compile("(\\$|#)\\{(?<expr>[^}]*)\\}");
    private static final ELHelper elHelper = new ELHelper();
    private static final ELProcessor elProcessor = new ELProcessor();
    static final long serialVersionUID = -5073441328652605454L;

    @FFDCIgnore(value={IllegalArgumentException.class})
    public static String evaluateStringAttribute(String attributeName, String attribute, String attributeDefault, boolean immediateOnly) {
        try {
            return elHelper.processString(attributeName, attribute, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression((String)attribute)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)attributeName, (Object[])new Object[]{"Returning null since " + attributeName + " is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            ELUtils.issueWarningMessage(attributeName, attribute, attributeDefault);
            return attributeDefault;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    public static Boolean evaluateBooleanAttribute(String attributeName, boolean attribute, boolean attributeDefault, String attributeExpression, boolean immediateOnly) {
        try {
            return elHelper.processBoolean(attributeName, attributeExpression, attribute, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression((String)attributeExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)attributeName, (Object[])new Object[]{"Returning null since " + attributeName + " is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            ELUtils.issueWarningMessage(attributeName, attributeExpression == null ? Boolean.valueOf(attribute) : attributeExpression, attributeDefault);
            return attributeDefault;
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    public static Integer evaluateIntegerAttribute(String attributeName, int attribute, int attributeDefault, String attributeExpression, boolean immediateOnly) {
        try {
            return elHelper.processInt(attributeName, attributeExpression, attribute, immediateOnly);
        }
        catch (IllegalArgumentException e) {
            if (immediateOnly) {
                if (ELHelper.isDeferredExpression((String)attributeExpression)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)attributeName, (Object[])new Object[]{"Returning null since " + attributeName + " is a deferred expression and this is called on initialization."});
                    }
                    return null;
                }
            }
            ELUtils.issueWarningMessage(attributeName, attributeExpression == null ? Integer.valueOf(attribute) : attributeExpression, attributeDefault);
            return attributeDefault;
        }
    }

    public static String[] evaluateStringArrayAttribute(String attributeName, String attribute, String[] attributeDefault, boolean immediateOnly) {
        String preEvaluatedValue = ELUtils.evaluateStringAttribute(attributeName, attribute, null, immediateOnly);
        if (preEvaluatedValue != null) {
            attribute = preEvaluatedValue;
        }
        StringBuffer sb = new StringBuffer();
        Matcher matcher = EVAL_EXPRESSION_PATTERN.matcher(attribute);
        while (matcher.find()) {
            String exprGroup = matcher.group(EVAL_EXPRESSION_PATTERN_GROUP_NAME);
            String processedExp = (String)elProcessor.eval(exprGroup);
            matcher.appendReplacement(sb, processedExp);
        }
        matcher.appendTail(sb);
        return ELUtils.createStringArrayFromDelimitedString(sb, ",");
    }

    private static String[] createStringArrayFromDelimitedString(StringBuffer sb, String delimiter) {
        String[] processedString = sb.toString().split(delimiter);
        ArrayList<String> entries = new ArrayList<String>();
        for (String segment : processedString) {
            String trimmed = segment.trim();
            if (trimmed.isEmpty()) continue;
            entries.add(trimmed);
        }
        return entries.toArray(new String[entries.size()]);
    }

    private static void issueWarningMessage(String attributeName, Object valueProvided, Object attributeDefault) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"JAKARTASEC_WARNING_CLAIM_DEF_CONFIG", (Object[])new Object[]{attributeName, valueProvided, attributeDefault});
        }
    }
}

