/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejb.portable;

import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ejb.portable.HandleHelper;
import com.ibm.ws.ejb.portable.KeyHelper;
import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBObject;
import jakarta.ejb.Handle;
import jakarta.ejb.HomeHandle;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;

public class HandleImpl
implements Handle,
Serializable {
    private static final long serialVersionUID = -4496370801878254926L;
    static final int EYECATCHER_LENGTH = 4;
    static final byte[] EYECATCHER = Constants.HANDLE_EYE_CATCHER;
    static final short PLATFORM = 1;
    static final boolean DEBUG_ON = false;
    private transient EJBObject ivEjbObject;
    private transient short ivActualVersion;
    private transient Serializable ivKey = null;
    private transient HomeHandle ivHomeHandle = null;

    public HandleImpl(EJBObject object) {
        this.ivEjbObject = object;
        this.ivActualVersion = (short)2;
    }

    private Method findFindByPrimaryKey(Class c) {
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("findByPrimaryKey")) continue;
            return methods[i];
        }
        return null;
    }

    private EJBObject getReference() throws RemoteException {
        EJBObject object = null;
        EJBHome home = this.ivHomeHandle.getEJBHome();
        Class<?> homeClass = home.getClass();
        try {
            Method fbpk = this.findFindByPrimaryKey(homeClass);
            object = (EJBObject)fbpk.invoke((Object)home, this.ivKey);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RemoteException) {
                throw (RemoteException)t;
            }
            throw new RemoteException("Could not find bean", t);
        }
        catch (IllegalAccessException e) {
            throw new RemoteException("Bad home interface definition", e);
        }
        return object;
    }

    public EJBObject getEJBObject() throws RemoteException {
        if (this.ivEjbObject == null) {
            this.ivEjbObject = this.getReference();
        }
        return this.ivEjbObject;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.write(EYECATCHER);
        out.writeShort(1);
        out.writeShort(this.ivActualVersion);
        HandleHelper.lookupHandleDelegate().writeEJBObject(this.ivEjbObject, out);
        if (this.ivActualVersion == 1) {
            out.writeObject(this.ivHomeHandle);
            Boolean orb = HandleHelper.isORBOutputStream(out);
            if (orb != null && orb.booleanValue()) {
                out.writeObject(this.ivKey);
            } else {
                out.writeObject(KeyHelper.serialize(this.ivKey));
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block6: {
            in.defaultReadObject();
            byte[] tempEyeCatcher = new byte[4];
            int bytesRead = 0;
            for (int offset = 0; offset < 4; offset += bytesRead) {
                bytesRead = in.read(tempEyeCatcher, offset, 4 - offset);
                if (bytesRead != -1) continue;
                throw new IOException("end of input stream while reading eye catcher");
            }
            for (int i = 0; i < EYECATCHER.length; ++i) {
                if (tempEyeCatcher[i] == EYECATCHER[i]) continue;
                String eyeCatcherString = new String(tempEyeCatcher);
                throw new IOException("Invalid eye catcher '" + eyeCatcherString + "' in handle input stream");
            }
            in.readShort();
            this.ivActualVersion = in.readShort();
            if (this.ivActualVersion != 1 && this.ivActualVersion != 2) {
                throw new InvalidObjectException("Handle data stream is not of the correct version, this client should be updated.");
            }
            try {
                this.ivEjbObject = HandleHelper.lookupHandleDelegate().readEJBObject(in);
            }
            catch (IOException ioe) {
                if (this.ivActualVersion == 1) break block6;
                throw ioe;
            }
        }
        if (this.ivActualVersion == 1) {
            this.ivEjbObject = null;
            this.ivHomeHandle = (HomeHandle)in.readObject();
            this.ivKey = (Serializable)in.readObject();
        }
    }
}

