/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.msgstore.cache.links;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemReference;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.ReferenceMembership;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.msgstore.SevereMessageStoreException;
import com.ibm.ws.sib.msgstore.cache.links.AbstractItemLink;
import com.ibm.ws.sib.msgstore.cache.links.ItemLink;
import com.ibm.ws.sib.msgstore.cache.links.ReferenceStreamLink;
import com.ibm.ws.sib.msgstore.impl.MessageStoreImpl;
import com.ibm.ws.sib.msgstore.persistence.Persistable;
import com.ibm.ws.sib.msgstore.transactions.impl.PersistentTransaction;
import com.ibm.ws.sib.utils.ras.SibTr;

final class ItemReferenceLink
extends AbstractItemLink
implements ReferenceMembership {
    private static TraceComponent tc = SibTr.register(ItemReferenceLink.class, (String)"SIBMessageStore", (String)"com.ibm.ws.sib.msgstore.CWSISMessages");

    ItemReferenceLink(ItemReference itemReference, ReferenceStreamLink owningStreamLink, Persistable persistable) throws OutOfCacheSpace, SevereMessageStoreException {
        super((AbstractItem)itemReference, owningStreamLink, persistable);
        Item referredItem = itemReference.getReferredItem();
        if (referredItem.isItemStream()) {
            throw new SevereMessageStoreException("cannot have reference to itemStream");
        }
        if (referredItem.isReferenceStream()) {
            throw new SevereMessageStoreException("cannot have reference to referenceStream");
        }
        if (referredItem.isItemReference()) {
            throw new SevereMessageStoreException("cannot have reference to reference");
        }
        long _referredID = referredItem.getID();
        this.getTuple().setReferredID(_referredID);
        if (-1L == _referredID) {
            throw new SevereMessageStoreException("Restored reference with invalid ID");
        }
        MessageStoreImpl msi = (MessageStoreImpl)this.getMessageStore();
        ItemLink itemLink = (ItemLink)msi.getMembership(_referredID);
        if (null != itemLink) {
            itemLink.incrementReferenceCount();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("reference to non-existent item: " + _referredID));
        }
    }

    ItemReferenceLink(ReferenceStreamLink owningStreamLink, Persistable persistable) throws SevereMessageStoreException {
        super(owningStreamLink, persistable);
        long _referredID = persistable.getReferredID();
        this.getTuple().setReferredID(_referredID);
        if (-1L == _referredID) {
            throw new SevereMessageStoreException("Restored reference with invalid ID");
        }
        MessageStoreImpl msi = (MessageStoreImpl)this.getMessageStore();
        ItemLink itemLink = (ItemLink)msi.getMembership(_referredID);
        if (null != itemLink) {
            itemLink.incrementReferenceCount();
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("reference to non-existent item: " + _referredID));
        }
    }

    @Override
    public final void abortAdd(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"abortAdd", (Object)transaction);
        }
        long _referredID = this.getTuple().getReferredID();
        super.abortAdd(transaction);
        if (-1L != _referredID) {
            MessageStoreImpl msi = this.getMessageStoreImpl();
            ItemLink itemLink = (ItemLink)msi.getMembership(_referredID);
            if (null != itemLink) {
                itemLink.rollbackIncrementReferenceCount(transaction);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("reference to non-existent item: " + _referredID));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"abortAdd");
        }
    }

    public final ReferenceStream getOwningReferenceStream() throws SevereMessageStoreException {
        return ((ReferenceStreamLink)this.getOwningStreamLink()).getReferenceStream();
    }

    public final long getReferencedID() {
        return this.getTuple().getReferredID();
    }

    public final long getReferredID() {
        return this.getTuple().getReferredID();
    }

    @Override
    public final void internalCommitRemove(PersistentTransaction transaction) throws SevereMessageStoreException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"internalCommitRemove");
        }
        long _referredID = this.getTuple().getReferredID();
        super.internalCommitRemove(transaction);
        if (-1L != _referredID) {
            MessageStoreImpl msi = this.getMessageStoreImpl();
            ItemLink itemLink = (ItemLink)msi.getMembership(_referredID);
            if (null != itemLink) {
                itemLink.commitDecrementReferenceCount(transaction);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("reference to non-existent item: " + _referredID));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"internalCommitRemove");
        }
    }

    @Override
    public String toString() {
        return "ItemReferenceLink(" + this.getID() + " --> " + this.getReferencedID() + ")" + super.toString() + " state=" + this.getState();
    }

    @Override
    protected final String xmlTagName() {
        return "reference";
    }
}

