/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulWS.client.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import io.openliberty.restfulWS.client.security.OAuthPropagationHelper;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.ClientRequestContext;
import java.util.Arrays;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class OAuthHandler {
    private static final TraceComponent tc = Tr.register(OAuthHandler.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
    private static final String AUTHN_TOKEN = "authnToken";
    private static final String WEB_TARGET = "webTarget";
    static final long serialVersionUID = -4185383823553957161L;

    public static void handleMpJwtToken(ClientRequestContext crc) {
        String mpJwt = OAuthPropagationHelper.getMpJsonWebToken();
        if (mpJwt != null && !mpJwt.isEmpty()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got MpJwt token from the subject. Set it on the request" + mpJwt), (Object[])new Object[0]);
            }
            OAuthHandler.addAuthnHeader(mpJwt, crc);
        } else {
            Tr.warning((TraceComponent)tc, (String)"warn_missing_mpjwt_token", (Object[])new Object[]{AUTHN_TOKEN, WEB_TARGET, "mpjwt"});
        }
    }

    public static void handleJwtToken(ClientRequestContext crc) {
        try {
            String token = OAuthPropagationHelper.getJwtToken();
            if (token != null && !token.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Retrieved a JWT token. About to set a request cookie: " + token), (Object[])new Object[0]);
                }
                OAuthHandler.addAuthnHeader(token, crc);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot find a JWT token out of the WSSubject", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    public static void handleOAuthToken(ClientRequestContext crc) {
        try {
            String token = OAuthPropagationHelper.getAccessToken();
            if (token != null && !token.isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Retrieved an OAuth access token. About to set a request cookie: " + token), (Object[])new Object[0]);
                }
                OAuthHandler.addAuthnHeader(token, crc);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cannot find an OAuth access token out of the WSSubject", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private static void addAuthnHeader(String token, ClientRequestContext crc) {
        crc.getHeaders().put((Object)"Authorization", Arrays.asList("Bearer " + token));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Authorization header with Bearer token is added successfully!!!", (Object[])new Object[0]);
        }
    }
}

