/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.util.RoleMethodAuthUtil;
import com.ibm.ws.security.authorization.util.UnauthenticatedException;
import io.grpc.Metadata;
import io.openliberty.grpc.internal.security.UnauthorizedException;
import io.openliberty.grpc.internal.servlet.GrpcServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class GrpcServerSecurity {
    private static final TraceComponent tc = Tr.register(GrpcServerSecurity.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.resources.grpcmessages");
    public static final String LIBERTY_AUTH_KEY_STRING = "libertyAuthCheck";
    private static final Map<String, Boolean> authMap = new ConcurrentHashMap<String, Boolean>();
    public static final Metadata.Key<String> LIBERTY_AUTH_KEY = Metadata.Key.of((String)"libertyAuthCheck", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    static final long serialVersionUID = -5437531490470206046L;

    public static void addLibertyAuthHeader(List<byte[]> byteArrays, HttpServletRequest req, boolean authorized) {
        byteArrays.add(LIBERTY_AUTH_KEY.name().getBytes(StandardCharsets.US_ASCII));
        byteArrays.add(String.valueOf(req.hashCode()).getBytes(StandardCharsets.US_ASCII));
        authMap.put(String.valueOf(req.hashCode()), authorized);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"adding {0} to authMap with value {1}", (Object[])new Object[]{req.hashCode(), authorized});
        }
    }

    @FFDCIgnore(value={UnauthenticatedException.class, UnauthenticatedException.class, UnauthorizedException.class})
    public static boolean doServletAuth(HttpServletRequest req, HttpServletResponse res, String requestPath) {
        try {
            GrpcServerSecurity.handleSecurity(req, requestPath);
            return true;
        }
        catch (UnauthenticatedException ex) {
            Tr.error((TraceComponent)tc, (String)"authentication.error", (Object[])new Object[]{requestPath, ex.getMessage()});
        }
        catch (UnauthorizedException e) {
            Tr.error((TraceComponent)tc, (String)"authorization.error", (Object[])new Object[]{requestPath, e.getMessage()});
        }
        return false;
    }

    private static void handleSecurity(final HttpServletRequest req, String path) throws UnauthenticatedException, UnauthorizedException {
        Method method = GrpcServletUtils.getTargetMethod(path);
        if (method == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"gRPC target service for this path {0} does not exist", (Object[])new Object[]{path});
            }
            return;
        }
        if (RoleMethodAuthUtil.parseMethodSecurity((Method)method, (Supplier)new Supplier<Principal>(){
            static final long serialVersionUID = -2074093545759569959L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Principal get() {
                return req.getUserPrincipal();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.grpc.internal.security.GrpcServerSecurity$1", 1.class, null, null);
            }
        }, s -> req.isUserInRole(s))) {
            return;
        }
        throw new UnauthorizedException("Unauthorized");
    }

    public static boolean isAuthorized(String key) {
        if (key == null) {
            return false;
        }
        return Boolean.TRUE.equals(authMap.remove(key));
    }
}

