/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.helpers;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.Subscriptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;

public class SenderProcessor
implements Flow.Processor<Message<?>, Message<?>>,
Flow.Subscription {
    private final long inflights;
    private final boolean waitForCompletion;
    private final Function<Message<?>, Uni<Void>> send;
    private final AtomicReference<Flow.Subscription> subscription = new AtomicReference();
    private final AtomicReference<Flow.Subscriber<? super Message<?>>> downstream = new AtomicReference();

    public SenderProcessor(long inflights, boolean waitForCompletion, Function<Message<?>, Uni<Void>> send) {
        this.inflights = inflights;
        this.waitForCompletion = waitForCompletion;
        this.send = send;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Message<?>> subscriber) {
        if (!this.downstream.compareAndSet(null, subscriber)) {
            Subscriptions.fail(subscriber, (Throwable)ProviderExceptions.ex.illegalStateOnlyOneSubscriber());
        } else if (this.subscription.get() != null) {
            subscriber.onSubscribe(this);
        }
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        if (this.subscription.compareAndSet(null, subscription)) {
            Flow.Subscriber<Message<?>> subscriber = this.downstream.get();
            if (subscriber != null) {
                subscriber.onSubscribe(this);
            }
        } else {
            Flow.Subscriber<Message<?>> subscriber = this.downstream.get();
            if (subscriber != null) {
                subscriber.onSubscribe((Flow.Subscription)Subscriptions.CANCELLED);
            }
        }
    }

    @Override
    public void onNext(Message<?> message) {
        if (this.waitForCompletion) {
            this.send.apply(message).subscribe().with(x -> this.requestNext(message), this::onError);
        } else {
            this.send.apply(message).subscribe().with(x -> {}, this::onError);
            this.requestNext(message);
        }
    }

    @Override
    public void request(long l) {
        if (l != Long.MAX_VALUE) {
            throw ProviderExceptions.ex.illegalStateConsumeWithoutBackPressure();
        }
        this.subscription.get().request(this.inflights);
    }

    @Override
    public void cancel() {
        Flow.Subscription s = this.subscription.getAndSet((Flow.Subscription)Subscriptions.CANCELLED);
        if (s != null) {
            s.cancel();
        }
    }

    private void requestNext(Message<?> message) {
        Flow.Subscription up;
        Flow.Subscriber<Message<?>> down = this.downstream.get();
        if (down != null) {
            down.onNext(message);
        }
        if ((up = this.subscription.get()) != null && this.inflights != Long.MAX_VALUE) {
            up.request(1L);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        Flow.Subscriber subscriber = this.downstream.getAndSet(null);
        if (subscriber != null) {
            subscriber.onError(throwable);
        }
    }

    @Override
    public void onComplete() {
        Flow.Subscriber subscriber = this.downstream.getAndSet(null);
        if (subscriber != null) {
            subscriber.onComplete();
        }
    }
}

