/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.impl;

import com.ibm.websphere.channelfw.EndPointMgr;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.channelfw.internal.chains.EndPointMgrImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.ServerQuiesceListener;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.openliberty.netty.internal.BootstrapExtended;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.ServerBootstrapExtended;
import io.openliberty.netty.internal.exception.NettyException;
import io.openliberty.netty.internal.impl.NettyQuiesceListener;
import io.openliberty.netty.internal.impl.QuiesceHandler;
import io.openliberty.netty.internal.tcp.TCPConfigurationImpl;
import io.openliberty.netty.internal.tcp.TCPUtils;
import io.openliberty.netty.internal.udp.UDPUtils;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"io.openliberty.netty.internal"}, immediate=true, service={NettyFramework.class, ServerQuiesceListener.class}, property={"service.vendor=IBM"})
public class NettyFrameworkImpl
implements ServerQuiesceListener,
NettyFramework {
    private static final TraceComponent tc = Tr.register(NettyFrameworkImpl.class, (String)"Netty", (String)"io.openliberty.netty.internal.impl.resources.NettyFrameworkMessages");
    private ExecutorService executorService = null;
    private static AtomicBoolean serverCompletelyStarted = new AtomicBoolean(false);
    private static Queue<FutureTask<?>> serverStartedTasks = new LinkedBlockingQueue();
    private static Object syncStarted = new Object(){
        static final long serialVersionUID = -8867004694885759496L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.netty.internal.impl.NettyFrameworkImpl$1", 1.class, null, null);
        }
    };
    private Map<Channel, ChannelGroup> activeChannelMap = new ConcurrentHashMap<Channel, ChannelGroup>();
    private ChannelGroup outboundConnections = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private EventLoopGroup parentGroup;
    private EventLoopGroup childGroup;
    private CHFWBundle chfw;
    private volatile boolean isActive = false;
    private ScheduledExecutorService scheduledExecutorService = null;
    static final long serialVersionUID = 7602976227640533620L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) {
        this.parentGroup = new NioEventLoopGroup(1);
        this.childGroup = new NioEventLoopGroup(0);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Deactivate called", (Object[])new Object[]{context, properties});
        }
        EndPointMgrImpl.destroyEndpoints();
        this.stopEventLoops();
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> config) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)"Processing config", (Object[])new Object[]{config});
        }
    }

    @Reference(name="chfwBundle")
    protected void setChfwBundle(CHFWBundle bundle) {
        this.chfw = bundle;
    }

    protected void unsetChfwBundle(CHFWBundle bundle) {
    }

    @Reference(service=ExecutorService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    protected void unsetExecutorService(ExecutorService executorService) {
        this.executorService = null;
    }

    @Reference(service=ScheduledExecutorService.class, cardinality=ReferenceCardinality.MANDATORY)
    protected void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    protected void unsetScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = null;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isStopping() {
        return NettyFrameworkImpl.isServerCompletelyStarted() && !this.isActive();
    }

    /*
     * WARNING - void declaration
     */
    public void serverStopping() {
        block8: {
            if (this.isActive) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)("Destroying all endpoints (closing all channels): " + this.activeChannelMap.keySet()), (Object[])new Object[0]);
                }
                this.isActive = false;
                long timeout = this.getDefaultChainQuiesceTimeout();
                if (timeout > 0L) {
                    if (this.activeChannelMap.isEmpty() && this.outboundConnections.isEmpty()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No connections to clean up, skipping quiesce creation.", (Object[])new Object[0]);
                        }
                        return;
                    }
                    NettyQuiesceListener quiesce = new NettyQuiesceListener(this, this.scheduledExecutorService, timeout);
                    try {
                        for (Channel channel : this.activeChannelMap.keySet()) {
                            channel.pipeline().fireUserEventTriggered((Object)QuiesceHandler.QUIESCE_EVENT);
                        }
                        quiesce.startTasks();
                    }
                    catch (Exception exception) {
                        void e;
                        FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.netty.internal.impl.NettyFrameworkImpl", (String)"237", (Object)this, (Object[])new Object[0]);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block8;
                        Tr.event((Object)this, (TraceComponent)tc, (String)"Exception occurred on quiesce", (Object[])new Object[]{e});
                    }
                }
            }
        }
    }

    private void stopEventLoops() {
        Future parent = null;
        Future child = null;
        Future global = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Gracefully shutting down parentGroup Event Loop " + this.parentGroup), (Object[])new Object[0]);
        }
        if (this.parentGroup != null) {
            parent = this.parentGroup.shutdownGracefully();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Gracefully shutting down childGroup Event Loop " + this.childGroup), (Object[])new Object[0]);
        }
        if (this.childGroup != null) {
            child = this.childGroup.shutdownGracefully();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Gracefully shutting down GlobalEventExecutor " + GlobalEventExecutor.INSTANCE), (Object[])new Object[0]);
        }
        global = GlobalEventExecutor.INSTANCE.shutdownGracefully();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Waiting for parentGroup Event Loop shutdown...", (Object[])new Object[0]);
        }
        if (parent != null) {
            parent.awaitUninterruptibly();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Waiting for childGroup Event Loop shutdown...", (Object[])new Object[0]);
        }
        if (child != null) {
            child.awaitUninterruptibly();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Waiting for GlobalEventExecutor shutdown...", (Object[])new Object[0]);
        }
        if (global != null) {
            global.awaitUninterruptibly();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Event loops finished clean up!", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Reference(service=ServerStarted.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected void setServerStarted(ServiceReference<ServerStarted> ref) {
        FutureTask<?> task;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Netty Framework signaled- Server Completely Started signal received", (Object[])new Object[0]);
        }
        while ((task = serverStartedTasks.poll()) != null) {
            try {
                if (task.isCancelled()) continue;
                this.executorService.submit(task);
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.netty.internal.impl.NettyFrameworkImpl", (String)"321", (Object)this, (Object[])new Object[]{ref});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("caught exception performing late cycle server startup task: " + e), (Object[])new Object[0]);
            }
        }
        Object object = syncStarted;
        synchronized (object) {
            serverCompletelyStarted.set(true);
            this.isActive = true;
            syncStarted.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> FutureTask<T> runWhenServerStarted(Callable<T> callable) throws Exception {
        Object object = syncStarted;
        synchronized (object) {
            FutureTask<T> future = new FutureTask<T>(callable);
            if (!serverCompletelyStarted.get()) {
                serverStartedTasks.add(future);
            } else {
                this.executorService.submit(future);
            }
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={InterruptedException.class})
    public static void waitServerCompletelyStarted() {
        Object object = syncStarted;
        synchronized (object) {
            if (!serverCompletelyStarted.get()) {
                try {
                    syncStarted.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static boolean isServerCompletelyStarted() {
        return serverCompletelyStarted.get();
    }

    public void registerEndpointQuiesce(Channel chan, Callable quiesce) {
        if (chan != null && this.getActiveChannelsMap().containsKey(chan)) {
            QuiesceHandler quiesceHandler = new QuiesceHandler(quiesce);
            chan.pipeline().addLast(new ChannelHandler[]{quiesceHandler});
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"Attempted to add a Quiesce Task to a channel which is not an endpoint. Quiesce will not be added and will be ignored.", (Object[])new Object[0]);
        }
    }

    protected synchronized void unsetServerStarted(ServiceReference<ServerStarted> ref) {
        serverCompletelyStarted.set(false);
    }

    public ServerBootstrapExtended createTCPBootstrap(Map<String, Object> tcpOptions) throws NettyException {
        return TCPUtils.createTCPBootstrap(this, tcpOptions);
    }

    public BootstrapExtended createTCPBootstrapOutbound(Map<String, Object> tcpOptions) throws NettyException {
        return TCPUtils.createTCPBootstrapOutbound(this, tcpOptions);
    }

    public BootstrapExtended createUDPBootstrap(Map<String, Object> options) throws NettyException {
        return UDPUtils.createUDPBootstrap(this, options);
    }

    public BootstrapExtended createUDPBootstrapOutbound(Map<String, Object> options) throws NettyException {
        return UDPUtils.createUDPBootstrapOutbound(this, options);
    }

    public FutureTask<ChannelFuture> start(ServerBootstrapExtended bootstrap, String inetHost, int inetPort, ChannelFutureListener bindListener) throws NettyException {
        return TCPUtils.start(this, bootstrap, inetHost, inetPort, bindListener);
    }

    public FutureTask<ChannelFuture> start(BootstrapExtended bootstrap, String inetHost, int inetPort, ChannelFutureListener bindListener) throws NettyException {
        return UDPUtils.start(this, bootstrap, inetHost, inetPort, bindListener);
    }

    public FutureTask<ChannelFuture> startOutbound(BootstrapExtended bootstrap, String inetHost, int inetPort, ChannelFutureListener bindListener) throws NettyException {
        if (bootstrap.getConfiguration() instanceof TCPConfigurationImpl) {
            return TCPUtils.startOutbound(this, bootstrap, inetHost, inetPort, bindListener);
        }
        return UDPUtils.startOutbound(this, bootstrap, inetHost, inetPort, bindListener);
    }

    public ChannelFuture stop(Channel channel) {
        ChannelGroup group = this.activeChannelMap.get(channel);
        if (group != null) {
            group.close().addListener(innerFuture -> {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("channel group" + group + " has closed..."), (Object[])new Object[0]);
                }
            });
            this.activeChannelMap.remove(channel);
        }
        return channel.close();
    }

    public void stop(Channel channel, long timeout) {
        ChannelFuture future;
        if (timeout == -1L) {
            timeout = this.getDefaultChainQuiesceTimeout();
        }
        if ((future = this.stop(channel)) != null) {
            future.awaitUninterruptibly(timeout, TimeUnit.MILLISECONDS);
        }
    }

    public Set<Channel> getActiveChannels() {
        return this.activeChannelMap.keySet();
    }

    public Map<Channel, ChannelGroup> getActiveChannelsMap() {
        return this.activeChannelMap;
    }

    public ChannelGroup getOutboundConnections() {
        return this.outboundConnections;
    }

    public long getDefaultChainQuiesceTimeout() {
        if (this.chfw != null) {
            return this.chfw.getFramework().getDefaultChainQuiesceTimeout();
        }
        return 0L;
    }

    public void destroy() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("NettyFrameworkImpl@").append(Integer.toHexString(System.identityHashCode(this)));
        buf.append(": {");
        buf.append("Parent Group: ");
        buf.append(this.getParentGroup());
        if (this.getParentGroup() != null) {
            buf.append(" isShuttingDown? ");
            buf.append(this.getParentGroup().isShuttingDown());
            buf.append(" isShutDown? ");
            buf.append(this.getParentGroup().isShutdown());
            buf.append(" isTerminated? ");
            buf.append(this.getParentGroup().isTerminated());
        }
        buf.append(", Child Group: ");
        buf.append(this.getChildGroup());
        if (this.getChildGroup() != null) {
            buf.append(" isShuttingDown? ");
            buf.append(this.getChildGroup().isShuttingDown());
            buf.append(" isShutDown? ");
            buf.append(this.getChildGroup().isShutdown());
            buf.append(" isTerminated? ");
            buf.append(this.getChildGroup().isTerminated());
        }
        buf.append(", EndpointManager: ");
        buf.append(this.getEndpointManager());
        buf.append(", Default Chain Quiesce Timeout: ");
        buf.append(this.getDefaultChainQuiesceTimeout());
        buf.append(", Outbound Connections: ");
        buf.append(this.getOutboundConnections());
        buf.append(", Active Endpoints: ");
        buf.append(this.getActiveChannels());
        buf.append(", Active endpoint maps: ");
        buf.append(this.getActiveChannelsMap());
        buf.append(", Is Active: ");
        buf.append(this.isActive());
        buf.append(", Is Stopping: ");
        buf.append(this.isStopping());
        buf.append("}");
        return buf.toString();
    }

    public EventLoopGroup getParentGroup() {
        return this.parentGroup;
    }

    public EventLoopGroup getChildGroup() {
        return this.childGroup;
    }

    private void logChannelStopped(Channel channel) {
        if (channel instanceof NioServerSocketChannel || channel instanceof NioSocketChannel) {
            TCPUtils.logChannelStopped(channel);
        } else if (channel instanceof NioDatagramChannel) {
            UDPUtils.logChannelStopped(channel);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unexpected channel type: " + channel), (Object[])new Object[0]);
        }
    }

    public EndPointMgr getEndpointManager() {
        return EndPointMgrImpl.getRef();
    }
}

