/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.mongo.internal;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.mongo.MongoChangeListener;
import com.ibm.ws.mongo.MongoSslHelper;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.OnErrorUtil;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.library.LibraryChangeListener;
import java.beans.IntrospectionException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MongoService
implements LibraryChangeListener,
MongoChangeListener {
    private static final TraceComponent tc = Tr.register(MongoService.class, (String)"mongo", (String)"com.ibm.ws.mongo.resources.CWKKDMessages");
    private static final String com_mongodb_MongoClient = "com.mongodb.MongoClient";
    private final AtomicServiceReference<Library> libraryRef = new AtomicServiceReference("library");
    private final AtomicServiceReference<Object> sslConfigurationRef = new AtomicServiceReference("ssl");
    private final AtomicServiceReference<Object> keyStoreServiceRef = new AtomicServiceReference("keyStoreService");
    static final String CONFIG_DISPLAY_ID = "config.displayId";
    private static final String HOST_NAMES = "hostNames";
    static final String MONGO = "mongo";
    private static final String PASSWORD = "password";
    private static final String PORTS = "ports";
    private static final String READ_PREFERENCE = "readPreference";
    private static final String WRITE_CONCERN = "writeConcern";
    private static final String USER = "user";
    private static final String SSL_ENABLED = "sslEnabled";
    private static final String SSL_REF = "sslRef";
    private static final String USE_CERTIFICATE_AUTHENTICATION = "useCertificateAuthentication";
    private static final Set<String> NOT_MONGO_CLIENT_OPTIONS = new HashSet<String>(Arrays.asList("hostNames", "id", "libraryRef", "objectClass", "onError", "password", "ports", "readPreference", "writeConcern", "user", "sslEnabled", "sslRef", "useCertificateAuthentication"));
    private static final Map<String, Class<?>> MONGO_CLIENT_OPTIONS_TYPES = new HashMap();
    private Method DB_authenticate;
    private Method DB_isAuthenticated;
    private String id;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Object mongoClient;
    private Method MongoClient_getDB;
    private Map<String, Object> props;
    private boolean useCertAuth = false;
    private MongoSslHelper sslHelper;
    private final Set<MongoChangeListener> changeListeners = Collections.synchronizedSet(new HashSet());
    static final long serialVersionUID = 3030188542791939904L;

    protected void activate(ComponentContext context, Map<String, Object> props) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"MongoService activate", (Object[])new Object[0]);
        }
        this.libraryRef.activate(context);
        this.sslConfigurationRef.activate(context);
        this.props = props;
        this.keyStoreServiceRef.activate(context);
        this.id = (String)props.get(CONFIG_DISPLAY_ID);
    }

    protected void deactivate(ComponentContext context) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"MongoService deactivate", (Object[])new Object[0]);
        }
        try {
            this.closeMongoClient();
            if (this.sslHelper != null) {
                this.sslHelper.removeChangeListener(this);
            }
        }
        finally {
            this.libraryRef.deactivate(context);
            this.sslConfigurationRef.deactivate(context);
            this.keyStoreServiceRef.deactivate(context);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={InvocationTargetException.class})
    Object getDB(String databaseName) throws Exception {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.lock.readLock().lock();
        try {
            Object db;
            block23: {
                block24: {
                    if (this.mongoClient == null) {
                        this.lock.readLock().unlock();
                        this.lock.writeLock().lock();
                        try {
                            if (this.mongoClient == null) {
                                this.init();
                            }
                        }
                        finally {
                            this.lock.readLock().lock();
                            this.lock.writeLock().unlock();
                        }
                    }
                    db = this.MongoClient_getDB.invoke(this.mongoClient, databaseName);
                    String user = (String)this.props.get(USER);
                    if (user == null) break block24;
                    if (((Boolean)this.DB_isAuthenticated.invoke(db, new Object[0])).booleanValue()) {
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"already authenticated", (Object[])new Object[0]);
                        }
                        break block23;
                    } else {
                        SerializableProtectedString password;
                        if (trace && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)("authenticate as: " + user), (Object[])new Object[0]);
                        }
                        String pwdStr = (password = (SerializableProtectedString)this.props.get(PASSWORD)) == null ? null : String.valueOf(password.getChars());
                        pwdStr = PasswordUtil.getCryptoAlgorithm((String)pwdStr) == null ? pwdStr : PasswordUtil.decode((String)pwdStr);
                        char[] pwdChars = pwdStr == null ? null : pwdStr.toCharArray();
                        try {
                            if (!((Boolean)this.DB_authenticate.invoke(db, user, pwdChars)).booleanValue()) {
                                if (!((Boolean)this.DB_isAuthenticated.invoke(db, new Object[0])).booleanValue()) {
                                    throw new IllegalArgumentException(Tr.formatMessage((TraceComponent)tc, (String)"CWKKD0012.authentication.error", (Object[])new Object[]{MONGO, this.id, databaseName}));
                                }
                                if (trace && tc.isDebugEnabled()) {
                                    Tr.debug((Object)this, (TraceComponent)tc, (String)"another thread must have authenticated first", (Object[])new Object[0]);
                                }
                            }
                            break block23;
                        }
                        catch (InvocationTargetException x) {
                            Throwable cause = x.getCause();
                            if (!(cause instanceof IllegalStateException)) throw cause;
                            if ((Boolean)this.DB_isAuthenticated.invoke(db, new Object[0]) == false) throw cause;
                            if (trace && tc.isDebugEnabled()) {
                                Tr.debug((Object)this, (TraceComponent)tc, (String)"another thread must have authenticated first", (Object[])new Object[]{cause});
                            }
                            break block23;
                        }
                    }
                }
                if (this.useCertAuth) {
                    // empty if block
                }
            }
            Object object = db;
            return object;
        }
        catch (Throwable db) {
            Throwable x;
            FFDCFilter.processException((Throwable)db, (String)"com.ibm.ws.mongo.internal.MongoService", (String)"330", (Object)this, (Object[])new Object[]{databaseName});
            Object object = x = x instanceof InvocationTargetException ? x.getCause() : x;
            if (x instanceof Exception) {
                throw (Exception)x;
            }
            if (!(x instanceof Error)) throw new RuntimeException(x);
            throw (Error)x;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private <T extends Throwable> T ignoreWarnOrFail(Throwable throwable, Class<T> exceptionClassToRaise, String msgKey, Object ... objs) {
        switch ((OnErrorUtil.OnError)this.props.get("onError")) {
            case IGNORE: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("ignoring error: " + msgKey), (Object[])objs);
                }
                return null;
            }
            case WARN: {
                Tr.warning((TraceComponent)tc, (String)msgKey, (Object[])objs);
                return null;
            }
            case FAIL: {
                try {
                    if (throwable != null && exceptionClassToRaise.isInstance(throwable)) {
                        return (T)((Throwable)exceptionClassToRaise.cast(throwable));
                    }
                    Constructor<T> con = exceptionClassToRaise.getConstructor(String.class);
                    String message = msgKey == null ? throwable.getMessage() : Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])objs);
                    Throwable failure = (Throwable)con.newInstance(message);
                    failure.initCause(throwable);
                    return (T)failure;
                }
                catch (RuntimeException con) {
                    void e;
                    FFDCFilter.processException((Throwable)con, (String)"com.ibm.ws.mongo.internal.MongoService", (String)"377", (Object)this, (Object[])new Object[]{throwable, exceptionClassToRaise, msgKey, objs});
                    throw e;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.mongo.internal.MongoService", (String)"379", (Object)this, (Object[])new Object[]{throwable, exceptionClassToRaise, msgKey, objs});
                    throw new RuntimeException(e);
                }
            }
        }
        return null;
    }

    private void init() throws Exception {
        this.useCertAuth = (Boolean)this.props.get(USE_CERTIFICATE_AUTHENTICATION) == null ? false : (Boolean)this.props.get(USE_CERTIFICATE_AUTHENTICATION);
        ClassLoader loader = ((Library)this.libraryRef.getServiceWithException()).getClassLoader();
        boolean sslEnabled = (Boolean)this.props.get(SSL_ENABLED) == null ? false : (Boolean)this.props.get(SSL_ENABLED);
        this.assertLibrary(loader, sslEnabled);
        this.assertValidSSLConfig();
        LinkedList serverAddresses = new LinkedList();
        Constructor<?> ServerAddress_constructor = loader.loadClass("com.mongodb.ServerAddress").getConstructor(String.class, Integer.TYPE);
        String[] hosts = (String[])this.props.get(HOST_NAMES);
        int[] ports = (int[])this.props.get(PORTS);
        int numServerAddresses = hosts.length;
        if (hosts.length != ports.length) {
            IllegalArgumentException failure = this.ignoreWarnOrFail(null, IllegalArgumentException.class, "CWKKD0011.hosts.ports.mismatch", MONGO, this.id, hosts.length, ports.length);
            if (failure == null) {
                numServerAddresses = hosts.length < ports.length ? hosts.length : ports.length;
            } else {
                throw failure;
            }
        }
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append("mongodb://");
        for (int i = 0; i < numServerAddresses; ++i) {
            serverAddresses.add(ServerAddress_constructor.newInstance(hosts[i], ports[i]));
            uriBuilder.append(hosts[i] + ":" + ports[i]);
            if (i == numServerAddresses - 1) continue;
            uriBuilder.append(",");
        }
        Class<?> MongoClientOptions = loader.loadClass("com.mongodb.MongoClientOptions");
        Class<?> MongoClientOptions_Builder = loader.loadClass("com.mongodb.MongoClientOptions$Builder");
        Object optionsBuilder = MongoClientOptions_Builder.newInstance();
        for (Map.Entry<String, Object> prop : this.props.entrySet()) {
            String name = prop.getKey();
            Object value = prop.getValue();
            if (value == null || name.indexOf(46) >= 0 || NOT_MONGO_CLIENT_OPTIONS.contains(name)) continue;
            this.set(MongoClientOptions_Builder, optionsBuilder, name, value);
        }
        String value = (String)this.props.get(READ_PREFERENCE);
        if (value != null) {
            this.setReadPreference(MongoClientOptions_Builder, optionsBuilder, value);
        }
        if ((value = (String)this.props.get(WRITE_CONCERN)) != null) {
            this.setWriteConcern(MongoClientOptions_Builder, optionsBuilder, value);
        }
        boolean sslRefExists = this.props.containsKey(SSL_REF);
        Properties sslProperties = null;
        if (sslEnabled) {
            Map<String, Object> connectionInfo = this.getConnectionInfo();
            this.setSocketFactory(MongoClientOptions_Builder, optionsBuilder, connectionInfo);
            sslProperties = this.sslHelper.getSSLProperties(this.sslConfigurationRef.getService(), connectionInfo, this);
        }
        Class<?> MongoClient = loader.loadClass(com_mongodb_MongoClient);
        Class<?> MongoClientURI = loader.loadClass("com.mongodb.MongoClientURI");
        if (sslEnabled && !sslRefExists && !this.useCertAuth) {
            uriBuilder.append("/?ssl=true");
            String uri = uriBuilder.toString();
            Constructor<?> MongoClientURI_constructor = MongoClientURI.getConstructor(String.class, MongoClientOptions_Builder);
            Object uriObject = MongoClientURI_constructor.newInstance(uri, optionsBuilder);
            Constructor<?> MongoClient_constructor = MongoClient.getConstructor(MongoClientURI);
            this.mongoClient = MongoClient_constructor.newInstance(uriObject);
        } else if (sslEnabled && this.useCertAuth) {
            String certificateDN = this.getCerticateSubject(this.keyStoreServiceRef, sslProperties);
            Class<?> MongoCredential = loader.loadClass("com.mongodb.MongoCredential");
            Method MongoCredential_createCertificate = MongoCredential.getMethod("createMongoX509Credential", String.class);
            Object credential = MongoCredential_createCertificate.invoke(null, certificateDN);
            Constructor<?> MongoClient_constructor = MongoClient.getConstructor(List.class, List.class, MongoClientOptions);
            Object mongoClientOptions = MongoClientOptions_Builder.getMethod("build", new Class[0]).invoke(optionsBuilder, new Object[0]);
            this.mongoClient = MongoClient_constructor.newInstance(serverAddresses, Arrays.asList(credential), mongoClientOptions);
        } else {
            Constructor<?> MongoClient_constructor = MongoClient.getConstructor(List.class, MongoClientOptions);
            Object mongoClientOptions = MongoClientOptions_Builder.getMethod("build", new Class[0]).invoke(optionsBuilder, new Object[0]);
            this.mongoClient = MongoClient_constructor.newInstance(serverAddresses, mongoClientOptions);
        }
        this.MongoClient_getDB = MongoClient.getMethod("getDB", String.class);
        Class<?> DB = loader.loadClass("com.mongodb.DB");
        this.DB_authenticate = DB.getMethod("authenticate", String.class, char[].class);
        this.DB_isAuthenticated = DB.getMethod("isAuthenticated", new Class[0]);
    }

    /*
     * WARNING - void declaration
     */
    private String getCerticateSubject(AtomicServiceReference<Object> serviceRef, Properties sslProperties) {
        String certificateDN = null;
        try {
            certificateDN = this.sslHelper.getClientKeyCertSubject(serviceRef, sslProperties);
        }
        catch (KeyStoreException keyStoreException) {
            void ke;
            FFDCFilter.processException((Throwable)keyStoreException, (String)"com.ibm.ws.mongo.internal.MongoService", (String)"510", (Object)this, (Object[])new Object[]{serviceRef, sslProperties});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.error((TraceComponent)tc, (String)"CWKKD0020.ssl.get.certificate.user", (Object[])new Object[]{MONGO, this.id, ke});
            }
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWKKD0020.ssl.get.certificate.user", (Object[])new Object[]{MONGO, this.id, ke}));
        }
        catch (CertificateException ke) {
            void ce;
            FFDCFilter.processException((Throwable)ke, (String)"com.ibm.ws.mongo.internal.MongoService", (String)"515", (Object)this, (Object[])new Object[]{serviceRef, sslProperties});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.error((TraceComponent)tc, (String)"CWKKD0020.ssl.get.certificate.user", (Object[])new Object[]{MONGO, this.id, ce});
            }
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWKKD0020.ssl.get.certificate.user", (Object[])new Object[]{MONGO, this.id, ce}));
        }
        if (certificateDN == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.error((TraceComponent)tc, (String)"CWKKD0026.ssl.certificate.exception", (Object[])new Object[]{MONGO, this.id});
            }
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWKKD0026.ssl.certificate.exception", (Object[])new Object[]{MONGO, this.id}));
        }
        return certificateDN;
    }

    private Map<String, Object> getConnectionInfo() {
        String[] hostnames = (String[])this.props.get(HOST_NAMES);
        int[] ports = (int[])this.props.get(PORTS);
        String hostname = hostnames == null || hostnames.length < 1 ? null : hostnames[0];
        String port = ports == null || ports.length < 1 ? null : String.valueOf(ports[0]);
        return this.sslHelper.getConnectionInfo(hostname, port);
    }

    public void libraryNotification() {
        this.closeMongoClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeOccurred() {
        this.closeMongoClient();
        if (this.sslHelper != null) {
            this.sslHelper.removeChangeListener(this);
        }
        Set<MongoChangeListener> set = this.changeListeners;
        synchronized (set) {
            for (MongoChangeListener listener : this.changeListeners) {
                listener.changeOccurred();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void closeMongoClient() {
        block9: {
            this.lock.writeLock().lock();
            try {
                if (this.mongoClient == null) break block9;
                try {
                    this.mongoClient.getClass().getMethod("close", new Class[0]).invoke(this.mongoClient, new Object[0]);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.mongo.internal.MongoService", (String)"581", (Object)this, (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void x;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"unable to close mongo", (Object[])new Object[]{x});
                    }
                }
                finally {
                    this.mongoClient = null;
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Trivial
    @FFDCIgnore(value={Throwable.class})
    private void set(Class<?> MongoClientOptions_Builder, Object optionsBuilder, String propName, Object value) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)(propName + '=' + value), (Object[])new Object[0]);
            }
            Class<?> type = MONGO_CLIENT_OPTIONS_TYPES.get(propName);
            Method method = MongoClientOptions_Builder.getMethod(propName, type);
            if (type.equals(Integer.TYPE) && value instanceof Long) {
                value = ((Long)value).intValue();
            }
            method.invoke(optionsBuilder, value);
            return;
        }
        catch (Throwable x) {
            IllegalArgumentException failure;
            if (x instanceof InvocationTargetException) {
                x = x.getCause();
            }
            if ((failure = this.ignoreWarnOrFail(x, IllegalArgumentException.class, "CWKKD0010.prop.error", propName, MONGO, this.id, x)) != null) {
                FFDCFilter.processException((Throwable)failure, (String)this.getClass().getName(), (String)"394", (Object)this, (Object[])new Object[]{value == null ? null : value.getClass(), value});
                throw failure;
            }
            return;
        }
    }

    @Trivial
    @FFDCIgnore(value={Throwable.class})
    private void setReadPreference(Class<?> MongoClientOptions_Builder, Object optionsBuilder, String creatorMethod) throws ClassNotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        block4: {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("readPreference=" + creatorMethod), (Object[])new Object[0]);
                }
                Class<?> ReadPreference = MongoClientOptions_Builder.getClassLoader().loadClass("com.mongodb.ReadPreference");
                Object readPreference = ReadPreference.getMethod(creatorMethod, new Class[0]).invoke(ReadPreference, new Object[0]);
                MongoClientOptions_Builder.getMethod(READ_PREFERENCE, ReadPreference).invoke(optionsBuilder, readPreference);
            }
            catch (Throwable x) {
                IllegalArgumentException failure;
                if (x instanceof InvocationTargetException) {
                    x = x.getCause();
                }
                if ((failure = this.ignoreWarnOrFail(x, IllegalArgumentException.class, "CWKKD0010.prop.error", READ_PREFERENCE, MONGO, this.id, x)) == null) break block4;
                FFDCFilter.processException((Throwable)failure, (String)this.getClass().getName(), (String)"422", (Object)this);
                throw failure;
            }
        }
    }

    @Trivial
    @FFDCIgnore(value={Throwable.class})
    private void setWriteConcern(Class<?> MongoClientOptions_Builder, Object optionsBuilder, String fieldName) throws ClassNotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        block4: {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("writeConcern=" + fieldName), (Object[])new Object[0]);
                }
                Class<?> WriteConcern = MongoClientOptions_Builder.getClassLoader().loadClass("com.mongodb.WriteConcern");
                Object writeConcern = WriteConcern.getField(fieldName).get(null);
                MongoClientOptions_Builder.getMethod(WRITE_CONCERN, WriteConcern).invoke(optionsBuilder, writeConcern);
            }
            catch (Throwable x) {
                IllegalArgumentException failure;
                if (x instanceof InvocationTargetException) {
                    x = x.getCause();
                }
                if ((failure = this.ignoreWarnOrFail(x, IllegalArgumentException.class, "CWKKD0010.prop.error", WRITE_CONCERN, MONGO, this.id, x)) == null) break block4;
                FFDCFilter.processException((Throwable)failure, (String)this.getClass().getName(), (String)"422", (Object)this);
                throw failure;
            }
        }
    }

    private void setSocketFactory(Class<?> MongoClientOptions_Builder, Object optionsBuilder, Map<String, Object> connectionInfo) throws Exception {
        SSLSocketFactory sslSocketFactory = null;
        Object sslService = this.sslConfigurationRef.getService();
        sslSocketFactory = this.sslHelper.getSSLSocketFactory(sslService, connectionInfo);
        Method socketFactoryMethod = MongoClientOptions_Builder.getMethod("socketFactory", SocketFactory.class);
        socketFactoryMethod.invoke(optionsBuilder, sslSocketFactory);
    }

    protected void setLibrary(ServiceReference<Library> ref) {
        this.libraryRef.setReference(ref);
    }

    protected void unsetLibrary(ServiceReference<Library> ref) {
        this.libraryRef.unsetReference(ref);
    }

    protected void setSsl(ServiceReference<Object> reference) {
        this.sslConfigurationRef.setReference(reference);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("sslRef set to " + reference.getProperty(CONFIG_DISPLAY_ID)), (Object[])new Object[0]);
        }
    }

    protected void unsetSsl(ServiceReference<Object> reference) {
        this.sslConfigurationRef.unsetReference(reference);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"sslRef unset", (Object[])new Object[0]);
        }
    }

    protected void setKeyStoreService(ServiceReference<Object> ref) {
        this.keyStoreServiceRef.setReference(ref);
    }

    protected void unsetKeyStoreService(ServiceReference<Object> ref) {
        this.keyStoreServiceRef.unsetReference(ref);
    }

    protected void setMongoSslHelper(MongoSslHelper sslHelper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Mongo helper set", (Object[])new Object[0]);
        }
        this.sslHelper = sslHelper;
    }

    protected void unsetMongoSslHelper(MongoSslHelper sslHelper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"Mongo helper unset", (Object[])new Object[0]);
        }
        this.sslHelper = null;
    }

    private void assertValidSSLConfig() {
        boolean sslRefExists;
        boolean trace = TraceComponent.isAnyTracingEnabled();
        boolean sslEnabled = (Boolean)this.props.get(SSL_ENABLED) == null ? false : (Boolean)this.props.get(SSL_ENABLED);
        boolean bl = sslRefExists = this.props.get(SSL_REF) != null;
        if (sslRefExists && !sslEnabled) {
            if (trace && tc.isDebugEnabled()) {
                Tr.error((TraceComponent)tc, (String)"CWKKD0024.ssl.sslref.no.ssl", (Object[])new Object[]{MONGO, this.id});
            }
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWKKD0024.ssl.sslref.no.ssl", (Object[])new Object[]{MONGO, this.id}));
        }
        if (sslEnabled) {
            if (this.sslHelper == null) {
                throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWKKD0015.ssl.feature.missing", (Object[])new Object[]{MONGO, this.id}));
            }
            if (this.useCertAuth) {
                if (!sslEnabled) {
                    throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWKKD0019.ssl.certificate.no.ssl", (Object[])new Object[]{MONGO, this.id}));
                }
                if (this.props.get(USER) != null || this.props.get(PASSWORD) != null) {
                    throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWKKD0018.ssl.user.pswd.certificate", (Object[])new Object[]{MONGO, this.id}));
                }
            }
        }
    }

    private void assertLibrary(ClassLoader loader, boolean sslEnabled) {
        Class<?> MongoClient = this.loadClass(loader, com_mongodb_MongoClient);
        int minor = -1;
        int major = -1;
        if (MongoClient == null) {
            Class<?> Mongo = this.loadClass(loader, "com.mongodb.Mongo");
            if (Mongo == null) {
                throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWKKD0014.missing.driver", (Object[])new Object[]{MONGO, ((Library)this.libraryRef.getService()).id()}));
            }
            major = this.getVersionFromMongo(Mongo, "MAJOR_VERSION");
            minor = this.getVersionFromMongo(Mongo, "MINOR_VERSION");
        } else {
            major = this.getVersionFromMongoClient(MongoClient, "getMajorVersion");
            minor = this.getVersionFromMongoClient(MongoClient, "getMinorVersion");
        }
        int MIN_MAJOR = 2;
        int MIN_MINOR = 10;
        int SSL_MIN_MINOR = 11;
        int CERT_AUTH_MIN_MINOR = 12;
        if (this.useCertAuth && (major < 2 || major == 2 && minor < 12)) {
            Tr.error((TraceComponent)tc, (String)"CWKKD0023.ssl.certauth.incompatible.driver", (Object[])new Object[]{MONGO, this.id, ((Library)this.libraryRef.getService()).id(), "2.12", major + "." + minor});
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWKKD0023.ssl.certauth.incompatible.driver", (Object[])new Object[]{MONGO, this.id, ((Library)this.libraryRef.getService()).id(), "2.12", major + "." + minor}));
        }
        if (sslEnabled && (major < 2 || major == 2 && minor < 11)) {
            Tr.error((TraceComponent)tc, (String)"CWKKD0017.ssl.incompatible.driver", (Object[])new Object[]{MONGO, this.id, ((Library)this.libraryRef.getService()).id(), "2.11", major + "." + minor});
            throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWKKD0017.ssl.incompatible.driver", (Object[])new Object[]{MONGO, this.id, ((Library)this.libraryRef.getService()).id(), "2.11", major + "." + minor}));
        }
        if (major > 2 || major == 2 && minor >= 10) {
            return;
        }
        Tr.error((TraceComponent)tc, (String)"CWKKD0013.unsupported.driver", (Object[])new Object[]{MONGO, ((Library)this.libraryRef.getService()).id(), "2.10", major + "." + minor});
        throw new RuntimeException(Tr.formatMessage((TraceComponent)tc, (String)"CWKKD0013.unsupported.driver", (Object[])new Object[]{MONGO, ((Library)this.libraryRef.getService()).id(), "2.10", major + "." + minor}));
    }

    public void registerChangeListener(MongoChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void unregisterChangeListener(MongoChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    @FFDCIgnore(value={Exception.class})
    private int getVersionFromMongo(Class<?> mongo, String fieldName) {
        try {
            return mongo.getField(fieldName).getInt(null);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("unable to getVersionFromMongo " + mongo + "." + fieldName + " " + e.getMessage()), (Object[])new Object[0]);
            }
            return -1;
        }
    }

    @FFDCIgnore(value={Exception.class})
    private int getVersionFromMongoClient(Class<?> mongoClient, String methodName) {
        try {
            return (Integer)mongoClient.getMethod(methodName, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("unable to getVersionFromMongoClient " + mongoClient + "." + methodName + "() " + e.getMessage()), (Object[])new Object[0]);
            }
            return -1;
        }
    }

    @FFDCIgnore(value={Exception.class})
    private Class<?> loadClass(ClassLoader loader, String clsStr) {
        try {
            return loader.loadClass(clsStr);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("unable to load " + clsStr + " from " + loader + " " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        MONGO_CLIENT_OPTIONS_TYPES.put("autoConnectRetry", Boolean.TYPE);
        MONGO_CLIENT_OPTIONS_TYPES.put("connectionsPerHost", Integer.TYPE);
        MONGO_CLIENT_OPTIONS_TYPES.put("connectTimeout", Integer.TYPE);
        MONGO_CLIENT_OPTIONS_TYPES.put("cursorFinalizerEnabled", Boolean.TYPE);
        MONGO_CLIENT_OPTIONS_TYPES.put("description", String.class);
        MONGO_CLIENT_OPTIONS_TYPES.put("maxAutoConnectRetryTime", Long.TYPE);
        MONGO_CLIENT_OPTIONS_TYPES.put("maxWaitTime", Integer.TYPE);
        MONGO_CLIENT_OPTIONS_TYPES.put("socketKeepAlive", Boolean.TYPE);
        MONGO_CLIENT_OPTIONS_TYPES.put("socketTimeout", Integer.TYPE);
        MONGO_CLIENT_OPTIONS_TYPES.put("threadsAllowedToBlockForConnectionMultiplier", Integer.TYPE);
    }
}

