/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.appqueue;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.appqueue.AppQueueHandler;
import com.ibm.ws.sip.container.appqueue.DispatcherWorkingThread;
import com.ibm.ws.sip.container.appqueue.MessageDispatchingHandler;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.properties.PropertiesStore;
import com.ibm.ws.sip.container.util.Queueable;
import com.ibm.ws.sip.properties.SipPropertiesMap;

public class NativeMessageDispatchingHandler
implements MessageDispatchingHandler {
    private static final LogMgr c_logger = Log.get(NativeMessageDispatchingHandler.class);
    protected PerformanceMgr m_perfMgr;
    static int s_maxDispatchMessages = 1000;
    static int s_queueSizeInDispatcher = 100;
    protected AppQueueHandler[] _dispatchersArray = null;
    public static int s_dispatchers = 15;
    static int s_maxMsgPerThread;
    static int s_onlyCriricalMessagesGetsIn;
    static int s_rejectLowPriorityMsgs;

    public NativeMessageDispatchingHandler() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "pool handler created: " + this);
        }
    }

    @Override
    public void start() {
        this.initThreadsArray();
    }

    protected void initThreadsArray() {
        SipPropertiesMap props = PropertiesStore.getInstance().getProperties();
        try {
            s_maxDispatchMessages = props.getInt("dispatcherMessageQueueSize");
            s_queueSizeInDispatcher = props.getInt("threadMessageQueueSize");
            s_dispatchers = props.getInt("concurrentContainerTasks");
        }
        catch (NumberFormatException e2) {
            c_logger.traceDebug("WASXMessageDispatcher.getThreadPool(): custom property  must be numeric!");
        }
        this.changeDispatcherCount(s_dispatchers);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "initThreadsArray", "initializing SIP Container Application queues number:" + s_dispatchers + " each queue size:" + s_queueSizeInDispatcher);
        }
        this.fillArray(s_queueSizeInDispatcher);
    }

    protected void changeDispatcherCount(int dispatchers) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "changeDispatcherCount", (Object)dispatchers);
        }
        s_maxMsgPerThread = s_maxDispatchMessages / s_dispatchers;
        s_onlyCriricalMessagesGetsIn = s_maxDispatchMessages;
        s_rejectLowPriorityMsgs = s_maxMsgPerThread >> 1;
        this._dispatchersArray = new AppQueueHandler[s_dispatchers];
    }

    protected void fillArray(int maxQsize) {
        for (int i = 0; i < this._dispatchersArray.length; ++i) {
            this._dispatchersArray[i] = new DispatcherWorkingThread(maxQsize, i, this);
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean dispatch(Queueable msg) {
        return this.dispatch(msg, -1L);
    }

    @Override
    public boolean dispatch(Queueable msg, long blockTimeout) {
        long index;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "dispatch message = " + msg + " blockTime=" + blockTimeout);
        }
        if ((index = msg.getQueueIndex()) < 0L) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "dispatch", "got negative queue index. check flow. message omitted:" + msg);
            }
            return false;
        }
        boolean result = this.getQueueToProcess(index, msg).dispatchMessage(msg, blockTimeout);
        if (result) {
            PerformanceMgr.getInstance().incrementInvokeCounter();
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(this, "dispatch result=" + result + " for=" + msg);
        }
        return result;
    }

    protected AppQueueHandler getQueueToProcess(long index, Queueable msg) {
        int daIndex = (int)index % s_dispatchers;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getQueueToProcess", "sending msg to queue no:" + daIndex + " msg=" + msg + " handler Q:" + this._dispatchersArray[daIndex].getClass().getName());
        }
        return this._dispatchersArray[daIndex];
    }

    @Override
    public void queueChanged() {
        long allQueuesSize = 0L;
        for (int i = 0; i < this._dispatchersArray.length; ++i) {
            AppQueueHandler dispatcher = this._dispatchersArray[i];
            allQueuesSize += (long)dispatcher.getQueueLoad();
        }
        PerformanceMgr.getInstance().setQueueSize(allQueuesSize);
    }

    @Override
    public void printState() {
        StringBuffer buff = new StringBuffer("Statistic:");
        for (int i = 0; i < this._dispatchersArray.length; ++i) {
            AppQueueHandler thread = this._dispatchersArray[i];
            buff.append(thread.getInfo());
            buff.append('|');
        }
        c_logger.info(buff.toString(), "Report.STATUS");
    }
}

