/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.events;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.SipApplicationSessionStateListener;
import com.ibm.websphere.sip.SipSessionStateListener;
import com.ibm.websphere.sip.resolver.DomainResolverListener;
import com.ibm.websphere.sip.resolver.events.SipURILookupErrorEvent;
import com.ibm.websphere.sip.resolver.events.SipURILookupEvent;
import com.ibm.websphere.sip.resolver.exception.SipURIResolveException;
import com.ibm.websphere.sip.unmatchedMessages.UnmatchedMessageListener;
import com.ibm.websphere.sip.unmatchedMessages.events.UnmatchedRequestEvent;
import com.ibm.websphere.sip.unmatchedMessages.events.UnmatchedResponseEvent;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.events.ContextEstablisher;
import com.ibm.ws.sip.container.events.ListenerTask;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.router.SipRouter;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.was.HttpDestroyedEvent;
import com.ibm.ws.sip.container.was.WASHttpSessionListener;
import com.ibm.wsspi.sip.channel.resolver.SipURILookupException;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionActivationListener;
import javax.servlet.sip.SipApplicationSessionBindingEvent;
import javax.servlet.sip.SipApplicationSessionBindingListener;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionActivationListener;
import javax.servlet.sip.SipSessionBindingEvent;
import javax.servlet.sip.SipSessionBindingListener;
import javax.servlet.sip.SipSessionEvent;
import javax.servlet.sip.SipURI;

public class EventsDispatcher {
    private static final transient LogMgr c_logger = Log.get(EventsDispatcher.class);
    private static long ERR_PRINTOUT_INTERVAL = 1000L;
    private static long _lastErrorPrintoutTime = 0L;
    private static Object PRINT_SYNC = new Object();

    public static void noAckReceived(SipServletResponseImpl response, SipAppDesc appDescriptor) {
        EventsDispatcher.dispatchErrorListenerTasks(response, appDescriptor, 7);
    }

    public static void unmatchedRequestReceived(SipServletRequestImpl response) {
        SipRouter router = SipContainer.getInstance().getRouter();
        for (SipAppDesc desc : router.getAllApps()) {
            EventsDispatcher.dispatchUnmatchedRequestListenerTasks(response, desc, 17);
        }
    }

    public static void unmatchedResponseReceived(SipServletResponseImpl response) {
        SipRouter router = SipContainer.getInstance().getRouter();
        for (SipAppDesc desc : router.getAllApps()) {
            EventsDispatcher.dispatchUnmatchedResponseListenerTasks(response, desc, 18);
        }
    }

    public static void noPrackReceived(SipServletResponseImpl response, SipAppDesc appDescriptor) {
        EventsDispatcher.dispatchErrorListenerTasks(response, appDescriptor, 8);
    }

    public static void AppSessionActivated(SipApplicationSessionImpl appSession) {
        EventsDispatcher.dispatchAppSessionStateListenerTasks(appSession, 1);
    }

    public static void AppSessionWillPassivate(SipApplicationSessionImpl appSession) {
        EventsDispatcher.dispatchAppSessionStateListenerTasks(appSession, 2);
    }

    public static void SipSessionActivated(SipSessionImplementation session, SipAppDesc appDescriptor) {
        EventsDispatcher.dispatchSipSessionStateListenerTasks(session, appDescriptor, 3);
    }

    public static void SipSessionAllAttributeUnbounding(SipSession session, SipAppDesc appDescriptor) {
        Map attrMap = SessionRepository.getInstance().getAttributes(session.getId());
        for (String attrib : attrMap.keySet()) {
            SipSessionBindingEvent evt = new SipSessionBindingEvent(session, attrib);
            EventsDispatcher.dispatchAttributeListener(attrMap, attrib, appDescriptor, evt, true, 11);
        }
    }

    public static void SipSessionAttributeBounding(SipSession session, String attribute, SipAppDesc appDescriptor, boolean isBound) {
        Map attrMap = SessionRepository.getInstance().getAttributes(session.getId());
        SipSessionBindingEvent evt = new SipSessionBindingEvent(session, attribute);
        int taskNum = isBound ? 10 : 11;
        EventsDispatcher.dispatchAttributeListener(attrMap, attribute, appDescriptor, evt, true, taskNum);
    }

    public static void AppSessionAttributeBounding(SipApplicationSession appSession, String attribute, SipAppDesc appDescriptor, boolean isBound) {
        Map attrMap = SessionRepository.getInstance().getAttributes(appSession);
        SipApplicationSessionBindingEvent evt = new SipApplicationSessionBindingEvent(appSession, attribute);
        int taskNum = isBound ? 12 : 13;
        EventsDispatcher.dispatchAttributeListener(attrMap, attribute, appDescriptor, evt, true, taskNum);
    }

    public static void SipSessionWillPassivate(SipSessionImplementation session, SipAppDesc appDescriptor) {
        EventsDispatcher.dispatchSipSessionStateListenerTasks(session, appDescriptor, 4);
    }

    public static void sipServletInitiated(SipAppDesc appDescriptor, SipServlet sipServlet, ServletContext context, long appQueueIndex) {
        if (appDescriptor.getSipServletListeners().isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceExit(null, "dispatchSipServletListeners, no listeners to call");
            }
            return;
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(null, "dispatchSipServletListeners calling listeners");
        }
        SipServletContextEvent evt = new SipServletContextEvent(context, sipServlet);
        Iterator<SipServletListener> iter = appDescriptor.getSipServletListeners().iterator();
        EventsDispatcher.dispatchTasksOnCurrentThread(iter, (EventObject)((Object)evt), appDescriptor, 9, appQueueIndex);
    }

    public static void uriLookupComplete(DomainResolverListener listener, SipSession session, SipURI sipUri, List<SipURI> results, boolean isOnCurrentThread) {
        SipURILookupEvent evt = new SipURILookupEvent(session, sipUri, results);
        EventsDispatcher.dispatchTask(listener, evt, isOnCurrentThread, 14);
    }

    public static void uriLookupError(DomainResolverListener listener, SipSession session, SipURI sipUri, SipURILookupException exception, boolean isOnCurrentThread) {
        SipURILookupErrorEvent evt = new SipURILookupErrorEvent(session, sipUri, new SipURIResolveException(exception));
        EventsDispatcher.dispatchTask(listener, evt, isOnCurrentThread, 15);
    }

    public static void httpSessionDestroyed(WASHttpSessionListener listener, HttpSession session) {
        HttpDestroyedEvent evt = new HttpDestroyedEvent(session);
        EventsDispatcher.dispatchTask(listener, evt, false, 16);
    }

    private static void dispatchUnmatchedRequestListenerTasks(SipServletRequestImpl request, SipAppDesc appDescriptor, int taskNum) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry((Object)null, "dispatchUnmatchedRequestListenerTasks", request, appDescriptor, new Integer(taskNum));
        }
        if (appDescriptor.getUnmatchedMessagesListeners().isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceExit(null, "dispatchErrorListenerTasks, no listeners to call");
            }
            return;
        }
        UnmatchedRequestEvent evt = new UnmatchedRequestEvent(request, appDescriptor.getServletContext());
        Iterator<UnmatchedMessageListener> iter = appDescriptor.getUnmatchedMessagesListeners().iterator();
        EventsDispatcher.dispatchTasks(iter, evt, taskNum, appDescriptor);
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("dispatchUnmatchedRequestListenerTasks sent: ");
            buff.append(ListenerTask.getTaskName(taskNum));
            buff.append("request = ");
            buff.append(request.getMethod());
            buff.append("id = ");
            buff.append(request.getCallId());
            c_logger.traceDebug((Object)null, "EventsDispatcher.dispatchUnmatchedRequestListenerTasks", buff.toString());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(null, "dispatchUnmatchedRequestListenerTasks");
        }
    }

    private static void dispatchUnmatchedResponseListenerTasks(SipServletResponseImpl response, SipAppDesc appDescriptor, int taskNum) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry((Object)null, "dispatchUnmatchedRequestListenerTasks", response, appDescriptor, new Integer(taskNum));
        }
        if (appDescriptor.getUnmatchedMessagesListeners().isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceExit(null, "dispatchUnmatchedResponseListenerTasks, no listeners to call");
            }
            return;
        }
        UnmatchedResponseEvent evt = new UnmatchedResponseEvent(response, appDescriptor.getServletContext());
        Iterator<UnmatchedMessageListener> iter = appDescriptor.getUnmatchedMessagesListeners().iterator();
        EventsDispatcher.dispatchTasks(iter, evt, taskNum, appDescriptor);
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("dispatchUnmatchedResponseListenerTasks sent: ");
            buff.append(ListenerTask.getTaskName(taskNum));
            buff.append("response = ");
            buff.append(response.getMethod());
            buff.append("id = ");
            buff.append(response.getCallId());
            c_logger.traceDebug((Object)null, "dispatchUnmatchedResponseListenerTasks", buff.toString());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(null, "dispatchUnmatchedResponseListenerTasks");
        }
    }

    private static void dispatchErrorListenerTasks(SipServletResponseImpl response, SipAppDesc appDescriptor, int taskNum) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry((Object)null, "dispatchErrorListenerTasks", response, appDescriptor, new Integer(taskNum));
        }
        if (appDescriptor.getErrorListeners().isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceExit(null, "dispatchErrorListenerTasks, no listeners to call");
            }
            return;
        }
        SipErrorEvent evt = new SipErrorEvent(response.getRequest(), response);
        Iterator<SipErrorListener> iter = appDescriptor.getErrorListeners().iterator();
        EventsDispatcher.dispatchTasks(iter, evt, taskNum);
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("Error notifications sent: ");
            buff.append(ListenerTask.getTaskName(taskNum));
            buff.append("response = ");
            buff.append(response.getMethod());
            buff.append("id = ");
            buff.append(response.getCallId());
            c_logger.traceDebug((Object)null, "EventsDispatcher.dispatchErrorListenerTasks", buff.toString());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(null, "dispatchErrorListenerTasks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispatchAppSessionStateListenerTasks(SipApplicationSessionImpl appSession, int taskNum) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry((Object)null, "dispatchAppSessionStateListenerTasks", appSession, new Integer(taskNum));
        }
        SipApplicationSessionEvent evt = new SipApplicationSessionEvent(appSession);
        SipAppDesc appDescriptor = appSession.getAppDescriptor();
        Iterator<SipApplicationSessionStateListener> iter = appDescriptor.getAppSessionStateListeners().iterator();
        EventsDispatcher.dispatchTasks(iter, evt, taskNum);
        Iterator<SipApplicationSessionActivationListener> iter2 = appDescriptor.getAppSessionActivationListeners().iterator();
        EventsDispatcher.dispatchTasks(iter2, evt, taskNum);
        Map attributes = SessionRepository.getInstance().getAttributes(appSession);
        if (attributes == null || attributes.isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("dispatchAppSessionStateListenerTasks, no attribute listeners to call");
            }
        } else {
            Map map = attributes;
            synchronized (map) {
                EventsDispatcher.dispatchAttributesListeners(attributes, appDescriptor, evt, taskNum);
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            StringBuffer buff = new StringBuffer(100);
            buff.append("App Session notifications Sent: ");
            buff.append(ListenerTask.getTaskName(taskNum));
            buff.append("Id = ");
            buff.append(appSession.getId());
            c_logger.traceDebug((Object)null, "EventsDispatcher.dispatchAppSessionStateListenerTasks", buff.toString());
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(null, "dispatchAppSessionStateListenerTasks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispatchSipSessionStateListenerTasks(SipSessionImplementation session, SipAppDesc appDescriptor, int taskNum) {
        Map attributes;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry((Object)null, "dispatchSipSessionStateListenerTasks", appDescriptor, new Integer(taskNum));
        }
        SipSessionEvent evt = null;
        if (appDescriptor.getSessionStateListeners().isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("dispatchSipSessionStateListenerTasks, no listeners to call");
            }
        } else {
            evt = new SipSessionEvent(session);
            Iterator<SipSessionStateListener> iter = appDescriptor.getSessionStateListeners().iterator();
            EventsDispatcher.dispatchTasks(iter, evt, taskNum);
            if (c_logger.isTraceDebugEnabled()) {
                StringBuffer buff = new StringBuffer(100);
                buff.append("SIP Session notifications Sent: ");
                buff.append(ListenerTask.getTaskName(taskNum));
                buff.append("Id = ");
                buff.append(session.getId());
                c_logger.traceDebug((Object)null, "EventsDispatcher.dispatchTasks", buff.toString());
            }
        }
        if ((attributes = SessionRepository.getInstance().getAttributes(session.getId())) == null || attributes.isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("dispatchSipSessionStateListenerTasks, no attribute listeners to call");
            }
        } else {
            if (evt == null) {
                evt = new SipSessionEvent(session);
            }
            Map map = attributes;
            synchronized (map) {
                EventsDispatcher.dispatchAttributesListeners(attributes, appDescriptor, evt, taskNum);
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(null, "dispatchSipSessionStateListenerTasks");
        }
    }

    private static void dispatchAttributesListeners(Map attributes, SipAppDesc appDescriptor, EventObject evt, int taskNum) {
        Iterator itr = attributes.keySet().iterator();
        while (itr.hasNext()) {
            EventsDispatcher.dispatchAttributeListener(attributes, (String)itr.next(), appDescriptor, evt, false, taskNum);
        }
    }

    private static EventListener getAttributeListener(Map attributes, String name) {
        Object value = attributes.get(name);
        if (value == null || !(value instanceof EventListener)) {
            return null;
        }
        return (EventListener)value;
    }

    private static void dispatchAttributeListener(Map attributes, String attribute, SipAppDesc appDescriptor, EventObject evt, boolean isOnCurrentThread, int taskNum) {
        ContextEstablisher contextEstablisher = appDescriptor.getContextEstablisher();
        if (contextEstablisher == null) {
            return;
        }
        EventListener listener = EventsDispatcher.getAttributeListener(attributes, attribute);
        if (listener == null) {
            return;
        }
        switch (taskNum) {
            case 3: {
                if (!(listener instanceof SipSessionActivationListener)) break;
                EventsDispatcher.dispatchTask(listener, evt, isOnCurrentThread, 5);
                break;
            }
            case 4: {
                if (!(listener instanceof SipSessionActivationListener)) break;
                EventsDispatcher.dispatchTask(listener, evt, isOnCurrentThread, 6);
                break;
            }
            case 10: {
                if (!(listener instanceof SipSessionBindingListener)) break;
                EventsDispatcher.dispatchTask(listener, evt, isOnCurrentThread, 10);
                break;
            }
            case 11: {
                if (!(listener instanceof SipSessionBindingListener)) break;
                EventsDispatcher.dispatchTask(listener, evt, isOnCurrentThread, 11);
                break;
            }
            case 1: {
                if (!(listener instanceof SipApplicationSessionActivationListener)) break;
                EventsDispatcher.dispatchTask(listener, evt, isOnCurrentThread, 1);
                break;
            }
            case 2: {
                if (!(listener instanceof SipApplicationSessionActivationListener)) break;
                EventsDispatcher.dispatchTask(listener, evt, isOnCurrentThread, 2);
                break;
            }
            case 12: {
                if (!(listener instanceof SipApplicationSessionBindingListener)) break;
                EventsDispatcher.dispatchTask(listener, evt, isOnCurrentThread, 12);
                break;
            }
            case 13: {
                if (!(listener instanceof SipApplicationSessionBindingListener)) break;
                EventsDispatcher.dispatchTask(listener, evt, isOnCurrentThread, 13);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static void dispatchTask(EventListener listener, EventObject evt, boolean isOnCurrentThread, int taskNum) {
        ListenerTask task = ListenerTask.getAvailableInstance();
        task.init(listener, evt, taskNum);
        if (!isOnCurrentThread) {
            EventsDispatcher.dispatch(task);
        } else {
            task.run();
        }
    }

    private static void dispatchTasksOnCurrentThread(Iterator<? extends EventListener> listenerIter, EventObject evt, SipAppDesc appDesc, int taskNum, long appQueueIndex) {
        while (listenerIter.hasNext()) {
            EventListener listener = listenerIter.next();
            ListenerTask task = ListenerTask.getAvailableInstance();
            task.init(listener, evt, taskNum, appDesc, appQueueIndex);
            task.run();
        }
    }

    private static void dispatchTasks(Iterator<? extends EventListener> listenerIter, EventObject evt, int taskNum) {
        while (listenerIter.hasNext()) {
            EventListener listener = listenerIter.next();
            ListenerTask task = ListenerTask.getAvailableInstance();
            task.init(listener, evt, taskNum);
            EventsDispatcher.dispatch(task);
        }
    }

    private static void dispatchTasks(Iterator<? extends EventListener> listenerIter, EventObject evt, int taskNum, SipAppDesc appDesc) {
        while (listenerIter.hasNext()) {
            EventListener listener = listenerIter.next();
            ListenerTask task = ListenerTask.getAvailableInstance();
            task.init(listener, evt, taskNum, appDesc, -1L);
            EventsDispatcher.dispatch(task);
        }
    }

    private static void dispatch(ListenerTask event) {
        if (!SipContainer.getTasksInvoker().invokeTask(event)) {
            EventsDispatcher.printDispatchError(event);
            event.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printDispatchError(ListenerTask event) {
        if (_lastErrorPrintoutTime < System.currentTimeMillis() - ERR_PRINTOUT_INTERVAL) {
            Object object = PRINT_SYNC;
            synchronized (object) {
                if (_lastErrorPrintoutTime < System.currentTimeMillis() - ERR_PRINTOUT_INTERVAL) {
                    c_logger.error("Dispatch queue overloaded listener task " + event.getThisTaskname() + " rejected!");
                    _lastErrorPrintoutTime = System.currentTimeMillis();
                }
            }
        }
    }
}

