/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.events;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.SipApplicationSessionStateListener;
import com.ibm.websphere.sip.SipSessionStateListener;
import com.ibm.websphere.sip.resolver.DomainResolverListener;
import com.ibm.websphere.sip.resolver.events.SipURILookupErrorEvent;
import com.ibm.websphere.sip.resolver.events.SipURILookupEvent;
import com.ibm.websphere.sip.unmatchedMessages.UnmatchedMessageListener;
import com.ibm.websphere.sip.unmatchedMessages.events.UnmatchedRequestEvent;
import com.ibm.websphere.sip.unmatchedMessages.events.UnmatchedResponseEvent;
import com.ibm.ws.sip.container.events.ContextEstablisher;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.pmi.TaskDurationMeasurer;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.util.Queueable;
import com.ibm.ws.sip.container.was.HttpDestroyedEvent;
import com.ibm.ws.sip.container.was.WASHttpSessionListener;
import com.ibm.ws.sip.parser.util.ObjectPool;
import java.util.EventListener;
import java.util.EventObject;
import javax.servlet.ServletContext;
import javax.servlet.sip.ConvergedHttpSession;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionActivationListener;
import javax.servlet.sip.SipApplicationSessionBindingEvent;
import javax.servlet.sip.SipApplicationSessionBindingListener;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipSessionActivationListener;
import javax.servlet.sip.SipSessionBindingEvent;
import javax.servlet.sip.SipSessionBindingListener;
import javax.servlet.sip.SipSessionEvent;

public class ListenerTask
implements Queueable {
    private static final transient LogMgr c_logger = Log.get(ListenerTask.class);
    private static ObjectPool pool = new ObjectPool(ListenerTask.class);
    public static final int APP_SESSION_ACTIVATED_TASK = 1;
    public static final int APP_SESSION_PASSIVATE_TASK = 2;
    public static final int SESSION_ACTIVATED_TASK = 3;
    public static final int SESSION_PASSIVATE_TASK = 4;
    public static final int SESSION_ATTR_ACTIVATED_TASK = 5;
    public static final int SESSION_ATTR_PASSIVATE_TASK = 6;
    public static final int ERROR_NO_ACK_RECEIVED = 7;
    public static final int ERROR_NO_PRACK_RECEIVED = 8;
    public static final int SIP_SERVLET_INITIATED = 9;
    public static final int SESSION_ATTRIBUTE_BOUND = 10;
    public static final int SESSION_ATTRIBUTE_UNBOUND = 11;
    public static final int APP_SESSION_ATTRIBUTE_BOUND = 12;
    public static final int APP_SESSION_ATTRIBUTE_UNBOUND = 13;
    public static final int URI_LOOKUP_COMPLETED = 14;
    public static final int URI_LOOKUP_ERROR = 15;
    public static final int HTTP_SESSION_DESTROYED = 16;
    public static final int UNMATCHED_REQUEST_RECEIVED = 17;
    public static final int UNMATCHED_RESPONSE_RECEIVED = 18;
    private EventListener _listener;
    private EventObject _event;
    private int _taskNum;
    private SipAppDesc _appDesc;
    private long _appQueueIndex = -1L;
    private static int _listenerQueue = 0;
    private TaskDurationMeasurer _sipContainerQueueDuration = null;
    private TaskDurationMeasurer _sipContainerApplicationCodeDuration = null;

    public void init(EventListener listener, EventObject event, int taskNum) {
        this._listener = listener;
        this._event = event;
        this._taskNum = taskNum;
    }

    public void init(EventListener listener, EventObject event, int taskNum, SipAppDesc appDesc, long appQueueIndex) {
        this.init(listener, event, taskNum);
        this._appDesc = appDesc;
        this._appQueueIndex = appQueueIndex;
    }

    public static ListenerTask getAvailableInstance() {
        return (ListenerTask)pool.get();
    }

    @Override
    public void run() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry((Object)this, "run", this._listener, this._event, new Integer(this._taskNum));
        }
        EventListener listener = this._listener;
        EventObject event = this._event;
        int task = this._taskNum;
        SipAppDesc appDesc = this._appDesc;
        this.recycle();
        ListenerTask.runTask(listener, event, task, appDesc);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceExit(this, "run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void runTask(EventListener listener, EventObject event, int task, SipAppDesc appDesc) {
        SipApplicationSessionImpl as;
        ContextEstablisher contextEstablisher = null;
        if (event.getSource() instanceof SipApplicationSession) {
            contextEstablisher = ((SipApplicationSessionImpl)event.getSource()).getAppDescriptor().getContextEstablisher();
        } else if (event.getSource() instanceof SipSessionImplementation) {
            as = (SipApplicationSessionImpl)((SipSessionImplementation)event.getSource()).getApplicationSession();
            contextEstablisher = as.getAppDescriptor().getContextEstablisher();
        } else if (event.getSource() instanceof ServletContext || event instanceof UnmatchedRequestEvent || event instanceof UnmatchedResponseEvent) {
            contextEstablisher = appDesc.getContextEstablisher();
        } else if (event.getSource() instanceof ConvergedHttpSession) {
            ConvergedHttpSession session = (ConvergedHttpSession)event.getSource();
            SipApplicationSessionImpl as2 = (SipApplicationSessionImpl)session.getApplicationSession();
            contextEstablisher = as2.getAppDescriptor().getContextEstablisher();
        } else {
            as = (SipApplicationSessionImpl)((SipServletRequestImpl)event.getSource()).getApplicationSession();
            contextEstablisher = as.getAppDescriptor().getContextEstablisher();
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (contextEstablisher != null) {
                contextEstablisher.establishContext(listener.getClass().getClassLoader());
            }
            switch (task) {
                case 1: {
                    if (listener instanceof SipApplicationSessionStateListener) {
                        ((SipApplicationSessionStateListener)listener).sessionDidActivate((SipApplicationSessionEvent)event);
                        return;
                    } else {
                        ((SipApplicationSessionActivationListener)listener).sessionDidActivate((SipApplicationSessionEvent)event);
                        return;
                    }
                }
                case 2: {
                    if (listener instanceof SipApplicationSessionStateListener) {
                        ((SipApplicationSessionStateListener)listener).sessionWillPassivate((SipApplicationSessionEvent)event);
                        return;
                    } else {
                        ((SipApplicationSessionActivationListener)listener).sessionWillPassivate((SipApplicationSessionEvent)event);
                        return;
                    }
                }
                case 3: {
                    ((SipSessionStateListener)listener).sessionDidActivate((SipSessionEvent)event);
                    return;
                }
                case 4: {
                    ((SipSessionStateListener)listener).sessionWillPassivate((SipSessionEvent)event);
                    return;
                }
                case 5: {
                    ((SipSessionActivationListener)listener).sessionDidActivate((SipSessionEvent)event);
                    return;
                }
                case 6: {
                    ((SipSessionActivationListener)listener).sessionWillPassivate((SipSessionEvent)event);
                    return;
                }
                case 7: {
                    ((SipErrorListener)listener).noAckReceived((SipErrorEvent)event);
                    return;
                }
                case 8: {
                    ((SipErrorListener)listener).noPrackReceived((SipErrorEvent)event);
                    return;
                }
                case 9: {
                    ((SipServletListener)listener).servletInitialized((SipServletContextEvent)((Object)event));
                    return;
                }
                case 10: {
                    ((SipSessionBindingListener)listener).valueBound((SipSessionBindingEvent)event);
                    return;
                }
                case 11: {
                    ((SipSessionBindingListener)listener).valueUnbound((SipSessionBindingEvent)event);
                    return;
                }
                case 12: {
                    ((SipApplicationSessionBindingListener)listener).valueBound((SipApplicationSessionBindingEvent)event);
                    return;
                }
                case 13: {
                    ((SipApplicationSessionBindingListener)listener).valueUnbound((SipApplicationSessionBindingEvent)event);
                    return;
                }
                case 14: {
                    ((DomainResolverListener)listener).handleResults((SipURILookupEvent)event);
                    return;
                }
                case 15: {
                    ((DomainResolverListener)listener).error((SipURILookupErrorEvent)event);
                    return;
                }
                case 16: {
                    ((WASHttpSessionListener)listener).handleHttpSessionDestoyEvent(((HttpDestroyedEvent)event).getHTTPSession());
                    return;
                }
                case 17: {
                    ((UnmatchedMessageListener)listener).unmatchedRequestReceived((UnmatchedRequestEvent)event);
                    return;
                }
                case 18: {
                    ((UnmatchedMessageListener)listener).unmatchedResponseReceived((UnmatchedResponseEvent)event);
                    return;
                }
                default: {
                    if (!c_logger.isTraceDebugEnabled()) return;
                    c_logger.error("ListenerTask.dispatch: Task number does not exists!: " + task);
                    return;
                }
            }
        }
        finally {
            if (contextEstablisher != null) {
                contextEstablisher.removeContext(currentThreadClassLoader);
            }
        }
    }

    public static String getTaskName(int taskNum) {
        switch (taskNum) {
            case 1: {
                return "Application Session activation";
            }
            case 2: {
                return "Application Session passivation";
            }
            case 3: {
                return "SIP Session activation";
            }
            case 4: {
                return "SIP Session passivation";
            }
            case 5: {
                return "SIP Session activation";
            }
            case 6: {
                return "SIP Session passivation";
            }
            case 7: {
                return "No ACK received";
            }
            case 8: {
                return "No PRACK received";
            }
            case 9: {
                return "Sip servlet initiated";
            }
            case 10: {
                return "SIP session atribute bounded";
            }
            case 11: {
                return "SIP session atribute unbounded";
            }
            case 12: {
                return "Application Session atribute bounded";
            }
            case 13: {
                return "Application Session atribute unbounded";
            }
            case 14: {
                return "URI Lookup complete";
            }
            case 15: {
                return "URI Lookup failed";
            }
            case 16: {
                return "HTTP session destroyed";
            }
            case 17: {
                return "Unmatched Request received";
            }
            case 18: {
                return "Unmatched Response received";
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.error("SipApplicationSessionListenerTask.getTaskName: Task number does not exists!");
        }
        return null;
    }

    @Override
    public long getQueueIndex() {
        long index = -1L;
        if (this._event instanceof SipApplicationSessionBindingEvent) {
            SipApplicationSessionBindingEvent event = (SipApplicationSessionBindingEvent)this._event;
            SipApplicationSessionImpl app = (SipApplicationSessionImpl)event.getApplicationSession();
            index = app.extractAppSessionCounter();
        } else if (this._event instanceof SipSessionBindingEvent) {
            SipSessionBindingEvent event = (SipSessionBindingEvent)this._event;
            SipSessionImplementation session = (SipSessionImplementation)event.getSession();
            index = SipApplicationSessionImpl.extractAppSessionCounter(session.getApplicationSessionId());
        } else if (this._event instanceof SipApplicationSessionEvent) {
            SipApplicationSessionEvent event = (SipApplicationSessionEvent)this._event;
            SipApplicationSessionImpl app = (SipApplicationSessionImpl)event.getApplicationSession();
            index = app.extractAppSessionCounter();
        } else if (this._event instanceof SipErrorEvent) {
            SipErrorEvent event = (SipErrorEvent)this._event;
            SipServletMessageImpl request = (SipServletMessageImpl)((Object)event.getRequest());
            TransactionUserWrapper tu = request.getTransactionUser();
            SipApplicationSessionImpl appSess = tu.getAppSessionForInternalUse();
            index = appSess != null ? appSess.extractAppSessionCounter() : SipApplicationSessionImpl.extractAppSessionCounter(tu.getApplicationId());
        } else if (this._event instanceof SipSessionEvent) {
            SipSessionEvent event = (SipSessionEvent)this._event;
            SipSessionImplementation session = (SipSessionImplementation)event.getSession();
            index = SipApplicationSessionImpl.extractAppSessionCounter(session.getApplicationSessionId());
        } else if (this._event instanceof SipServletContextEvent || this._event instanceof UnmatchedRequestEvent || this._event instanceof UnmatchedResponseEvent) {
            index = this._appQueueIndex > 0L ? this._appQueueIndex : (long)(++_listenerQueue);
        } else if (this._event instanceof SipURILookupEvent || this._event instanceof SipURILookupErrorEvent) {
            SipSessionImplementation session = (SipSessionImplementation)this._event.getSource();
            index = SipApplicationSessionImpl.extractAppSessionCounter(session.getApplicationSessionId());
        } else if (this._event instanceof HttpDestroyedEvent) {
            ConvergedHttpSession session = (ConvergedHttpSession)this._event.getSource();
            SipApplicationSessionImpl appSession = (SipApplicationSessionImpl)session.getApplicationSession();
            index = appSession.extractAppSessionCounter();
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.error("getQueueIndex is returning a queue index of -1, unknown event was sent.");
        }
        return index;
    }

    public String getThisTaskname() {
        return ListenerTask.getTaskName(this._taskNum);
    }

    public void recycle() {
        this._appDesc = null;
        this._appQueueIndex = -1L;
        this._event = null;
        this._listener = null;
        this._sipContainerApplicationCodeDuration = null;
        this._sipContainerQueueDuration = null;
        pool.putBack(this);
    }

    @Override
    public int priority() {
        return 50;
    }

    @Override
    public TaskDurationMeasurer getSipContainerQueueDuration() {
        return this._sipContainerQueueDuration;
    }

    @Override
    public TaskDurationMeasurer getApplicationCodeDuration() {
        return this._sipContainerApplicationCodeDuration;
    }

    @Override
    public String getAppName() {
        if (this._appDesc != null) {
            return this._appDesc.getApplicationName();
        }
        return null;
    }

    @Override
    public Integer getAppIndexForPMI() {
        if (this._appDesc != null) {
            return this._appDesc.getAppIndexForPmi();
        }
        return null;
    }

    @Override
    public void setSipContainerQueueDuration(TaskDurationMeasurer tm) {
        this._sipContainerQueueDuration = tm;
    }

    @Override
    public void setApplicationCodeDuration(TaskDurationMeasurer tm) {
        this._sipContainerApplicationCodeDuration = tm;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        if (this._event == null) {
            return null;
        }
        Object source = this._event.getSource();
        if (source instanceof SipApplicationSession) {
            return (SipApplicationSession)source;
        }
        if (source instanceof SipSessionImplementation) {
            return ((SipSessionImplementation)source).getApplicationSession(false);
        }
        if (source instanceof SipServletRequestImpl) {
            return ((SipServletRequestImpl)source).getApplicationSession(false);
        }
        return null;
    }

    @Override
    public TransactionUserWrapper getTuWrapper() {
        SipSession session;
        Object source = this._event.getSource();
        if (this._event instanceof UnmatchedResponseEvent || this._event instanceof UnmatchedRequestEvent) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("getTuWrapper is always null for unmatched messages");
            }
            return null;
        }
        if (source instanceof SipSession) {
            return ((SipSessionImplementation)source).getInternalTuWrapper();
        }
        if (source instanceof SipServletMessageImpl && (session = ((SipServletMessageImpl)source).getSession()) != null) {
            return ((SipSessionImplementation)session).getInternalTuWrapper();
        }
        if (this._event instanceof SipErrorEvent) {
            SipErrorEvent event = (SipErrorEvent)this._event;
            SipServletMessageImpl request = (SipServletMessageImpl)((Object)event.getRequest());
            return request.getTransactionUser();
        }
        return null;
    }

    @Override
    public Object getServiceSynchronizer() {
        return null;
    }
}

