/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.parser;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.sip.SipApplicationSessionStateListener;
import com.ibm.websphere.sip.SipSessionStateListener;
import com.ibm.ws.sip.container.SipContainer;
import com.ibm.ws.sip.container.events.EventsDispatcher;
import com.ibm.ws.sip.container.osgi.ServletInstanceHolderInterface;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.parser.SipServletDesc;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.sip.SipApplicationSessionActivationListener;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.TimerListener;

public class ServletsInstanceHolder
implements ServletInstanceHolderInterface {
    private static final LogMgr c_logger = Log.get(ServletsInstanceHolder.class);
    private static final ServletsInstanceHolder s_instance = new ServletsInstanceHolder();
    private SipContainer m_sipcontainer = SipContainer.getInstance();
    private ThreadLocal<InitMembers> sipServletThreadLocal = new ThreadLocal();
    private Map<String, Map<String, Object>> m_sipAppsServlets = new HashMap<String, Map<String, Object>>(1);

    private ServletsInstanceHolder() {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "ServletsInstanceHolder", "ServletsInstanceHolder constructor");
        }
    }

    public static ServletsInstanceHolder getInstance() {
        return s_instance;
    }

    @Override
    public void addSipletInstance(String appName, String className, Object servletInstance) {
        Map<String, Object> app;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addSipletInstance", "appName[" + appName + "] class[" + className + "] instance[" + servletInstance + "]");
        }
        SipAppDesc sipApp = this.m_sipcontainer.getSipApp(appName);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "addSipletInstance", "found sipAppDesc [" + sipApp + "]");
        }
        if ((app = this.m_sipAppsServlets.get(appName)) == null) {
            app = new HashMap<String, Object>(1);
            this.m_sipAppsServlets.put(appName, app);
            sipApp.setupSipListeners();
        }
        app.put(className, servletInstance);
        if (sipApp != null) {
            if (servletInstance instanceof TimerListener) {
                sipApp.replaceTimerListener((TimerListener)servletInstance);
            }
            if (servletInstance instanceof SipApplicationSessionListener) {
                sipApp.replaceAppSessionListener((SipApplicationSessionListener)servletInstance);
            }
            if (servletInstance instanceof SipSessionListener) {
                sipApp.replaceSessionListener((SipSessionListener)servletInstance);
            }
            if (servletInstance instanceof SipSessionStateListener) {
                sipApp.replaceSipSessionStateListener((SipSessionStateListener)servletInstance);
            }
            if (servletInstance instanceof SipApplicationSessionStateListener) {
                sipApp.replaceApplicationSessionStateListener((SipApplicationSessionStateListener)servletInstance);
            }
            if (servletInstance instanceof SipApplicationSessionActivationListener) {
                sipApp.replaceApplicationSessionActivationListener((SipApplicationSessionActivationListener)servletInstance);
            }
            if (servletInstance instanceof SipErrorListener) {
                sipApp.replaceErrorListener((SipErrorListener)servletInstance);
            }
            if (servletInstance instanceof SipSessionAttributeListener) {
                sipApp.replaceSessionAttributeListener((SipSessionAttributeListener)servletInstance);
            }
            if (servletInstance instanceof SipServletListener) {
                sipApp.replaceSipServletListener((SipServletListener)servletInstance);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.error("addSipletInstance: can not add listeners");
        }
    }

    public void removeSipletInstance(String appName, String className) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeSipletInstance", "appName[" + appName + "] class[" + className + "] ");
        }
        SipAppDesc sipApp = this.m_sipcontainer.getSipApp(appName);
        Map<String, Object> app = this.m_sipAppsServlets.get(sipApp.getApplicationName());
        Object servletInstance = null;
        if (app != null) {
            servletInstance = app.remove(className);
            if (app.isEmpty()) {
                this.m_sipAppsServlets.remove(appName);
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeSipletInstance", "found sipAppDesc [" + sipApp + "]");
        }
        if (servletInstance != null && sipApp != null) {
            if (servletInstance instanceof TimerListener) {
                sipApp.removeTimerListener();
            }
            if (servletInstance instanceof SipApplicationSessionListener) {
                sipApp.removeAppSessionListener(className);
            }
            if (servletInstance instanceof SipSessionListener) {
                sipApp.removeSessionListener(className);
            }
            if (servletInstance instanceof SipSessionStateListener) {
                sipApp.removeSipSessionStateListener(className);
            }
            if (servletInstance instanceof SipApplicationSessionStateListener) {
                sipApp.removeApplicationSessionStateListener(className);
            }
            if (servletInstance instanceof SipApplicationSessionActivationListener) {
                sipApp.removeApplicationSessionActivationListener(className);
            }
            if (servletInstance instanceof SipErrorListener) {
                sipApp.removeErrorListener(className);
            }
            if (servletInstance instanceof SipSessionAttributeListener) {
                sipApp.removeSessionAttributeListener(className);
            }
            if (servletInstance instanceof SipServletListener) {
                sipApp.removeSipServletListener(className);
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "removeSipletInstance", "can not remove listeners for appName[" + appName + "] class[" + className + "] ");
        }
    }

    public Object getSipletinstance(String appName, String className) {
        Object instance = null;
        Map<String, Object> app = this.m_sipAppsServlets.get(appName);
        if (app != null) {
            instance = app.get(className);
        }
        return instance;
    }

    @Override
    public void saveSipletReference(String appName, SipServlet sipServlet, ServletContext sipletContext) {
        SipAppDesc sipApp = this.m_sipcontainer.getSipApp(appName);
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "triggerSipletInitServlet", "found sipAppDesc [" + sipApp + "]");
        }
        if (sipApp == null) {
            return;
        }
        SipServletDesc sipDesc = sipApp.getSipServlet(sipServlet.getServletName());
        if (!sipDesc.isServletLoadOnStartup() && sipApp.getSipServletListeners().isEmpty()) {
            return;
        }
        InitMembers members = new InitMembers(sipApp, sipServlet, sipletContext);
        this.sipServletThreadLocal.set(members);
    }

    @Override
    public void triggerSipletInitServlet(long appQueueIndex) {
        InitMembers members = this.sipServletThreadLocal.get();
        this.sipServletThreadLocal.set(null);
        if (members == null) {
            return;
        }
        EventsDispatcher.sipServletInitiated(members.appDesc, members.sipServlet, members.sipletContext, appQueueIndex);
    }

    @Override
    public void saveOnStartupServlet() {
        InitMembers members = this.sipServletThreadLocal.get();
        if (members != null) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "saveOnStartupServlet", "members are not null, adding: " + members.sipServlet.getServletName() + " to " + members.appDesc.getApplicationName());
            }
            members.appDesc.saveLoadOnStartupServlet(members.sipServlet);
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "saveOnStartupServlet", "members is null");
        }
    }

    private static class InitMembers {
        public SipServlet sipServlet;
        public ServletContext sipletContext;
        public SipAppDesc appDesc;

        public InitMembers(SipAppDesc appDesc, SipServlet sipServlet, ServletContext sipletContext) {
            this.appDesc = appDesc;
            this.sipServlet = sipServlet;
            this.sipletContext = sipletContext;
        }
    }
}

