/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.proxy;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.container.proxy.StatefullProxy;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.timer.BaseTimer;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import javax.servlet.sip.SipApplicationSession;

public class ProxyTimer
extends BaseTimer {
    private static final LogMgr c_logger = Log.get(ProxyTimer.class);
    private StatefullProxy _proxy;
    SipServletRequestImpl _origReqImp;

    public ProxyTimer(StatefullProxy proxy) {
        this._proxy = proxy;
        if (this._proxy != null) {
            this._origReqImp = (SipServletRequestImpl)this._proxy.getOriginalRequest();
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted proxy is null...");
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "ProxyTimer", "Created For Branch: " + proxy);
        }
        this.setQueueIndex(this.extractQueueIndex());
    }

    @Override
    public void run() {
        PerformanceMgr perfMgr;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry(this, "invoke");
        }
        if ((perfMgr = PerformanceMgr.getInstance()) != null) {
            perfMgr.updateSipTimersInvocationsCounter();
        }
        this._proxy.proxyTimeout();
    }

    public int getTimeRemaining() {
        long scheduled = this.m_nextExecution;
        long now = System.currentTimeMillis();
        int remaining = (int)(scheduled - now) / 1000;
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getTimeRemaining", "scheduled [" + scheduled + "] now [" + now + "] remaining [" + remaining + ']');
        }
        return remaining;
    }

    @Override
    protected long extractQueueIndex() {
        long result = -1L;
        if (this._origReqImp != null) {
            TransactionUserWrapper tuImpl = this._origReqImp.getTransactionUser();
            if (tuImpl != null) {
                String sessId = tuImpl.getApplicationId();
                result = SipApplicationSessionImpl.extractAppSessionCounter(sessId);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceEntry(this, "getQueueIndex - sessId = " + sessId + " QueueIndex result = " + result);
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "getQueueIndex - can't find the appropriate TU for incoming request ...");
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "getQueueIndex - can't find incoming request ...");
        }
        return result;
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public String getAppName() {
        SipApplicationSessionImpl sApp;
        if (this._origReqImp != null && (sApp = (SipApplicationSessionImpl)this._origReqImp.getApplicationSession()) != null && sApp.getAppDescriptor() != null) {
            return sApp.getAppDescriptor().getAppName();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted origReqImp is null...");
        }
        return null;
    }

    @Override
    public Integer getAppIndexForPMI() {
        SipApplicationSessionImpl sApp;
        if (this._origReqImp != null && (sApp = (SipApplicationSessionImpl)this._origReqImp.getApplicationSession()) != null && sApp.getAppDescriptor() != null) {
            return sApp.getAppDescriptor().getAppIndexForPmi();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted origReqImp is null...");
        }
        return null;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        if (this._origReqImp != null) {
            return this._origReqImp.getApplicationSession();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted origReqImp is null...");
        }
        return null;
    }

    @Override
    public TransactionUserWrapper getTuWrapper() {
        if (this._origReqImp != null) {
            SipSessionImplementation sSession = (SipSessionImplementation)this._origReqImp.getSession();
            if (sSession != null) {
                return sSession.getInternalTuWrapper();
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted origReqImp is null...");
        }
        return null;
    }
}

