/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.timer;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.container.servlets.ReliableResponse;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.servlets.SipSessionImplementation;
import com.ibm.ws.sip.container.timer.BaseTimer;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.stack.transaction.SIPTransactionConstants;
import javax.servlet.sip.SipApplicationSession;

public class ReliabeResponseRetransmitTimer
extends BaseTimer {
    private static final LogMgr c_logger = Log.get(ReliabeResponseRetransmitTimer.class);
    private int _count = 1;
    private long _startTime = System.currentTimeMillis();
    private ReliableResponse _responseObj = null;

    public ReliabeResponseRetransmitTimer(ReliableResponse responseObj) {
        this._responseObj = responseObj;
        this.setQueueIndex(this.extractQueueIndex());
    }

    @Override
    protected long extractQueueIndex() {
        long result = -1L;
        if (this._responseObj != null) {
            TransactionUserWrapper tuImpl = this._responseObj.getServletResponse().getTransactionUser();
            if (tuImpl != null) {
                String sessId = tuImpl.getApplicationId();
                result = SipApplicationSessionImpl.extractAppSessionCounter(sessId);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceEntry(this, "getQueueIndex - sessId = " + sessId + " QueueIndex result = " + result);
                }
            } else if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "getQueueIndex - can't find the appropriate TU for incoming request ...");
            }
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "getQueueIndex - can't find incoming request ...");
        }
        return result;
    }

    @Override
    public void run() {
        long cTime = System.currentTimeMillis();
        if (cTime - this._startTime < SIPTransactionConstants._64T1) {
            this._responseObj.retransmitResponse();
            long nextRetransmit = (long)((double)SIPTransactionConstants.T1 * Math.pow(2.0, this._count));
            long delay = Math.min(this._startTime + SIPTransactionConstants._64T1 - cTime, nextRetransmit);
            SipContainerComponent.getTimerService().schedule(this, false, delay);
            ++this._count;
        } else {
            this._responseObj.retransmissionTimedOut();
        }
    }

    @Override
    public String getAppName() {
        SipApplicationSessionImpl sApp;
        SipServletResponseImpl resp = this._responseObj.getServletResponse();
        if (resp != null && (sApp = (SipApplicationSessionImpl)resp.getApplicationSession()) != null && sApp.getAppDescriptor() != null) {
            return sApp.getAppDescriptor().getAppName();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted response is null...");
        }
        return null;
    }

    @Override
    public Integer getAppIndexForPMI() {
        SipApplicationSessionImpl sApp;
        SipServletResponseImpl resp = this._responseObj.getServletResponse();
        if (resp != null && (sApp = (SipApplicationSessionImpl)resp.getApplicationSession()) != null && sApp.getAppDescriptor() != null) {
            return sApp.getAppDescriptor().getAppIndexForPmi();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted response is null...");
        }
        return null;
    }

    @Override
    public SipApplicationSession getApplicationSession() {
        SipServletResponseImpl resp = this._responseObj.getServletResponse();
        if (resp != null) {
            return resp.getApplicationSession();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted response is null...");
        }
        return null;
    }

    @Override
    public TransactionUserWrapper getTuWrapper() {
        if (this._responseObj != null) {
            SipServletResponseImpl resp = this._responseObj.getServletResponse();
            SipSessionImplementation sSession = (SipSessionImplementation)resp.getSession();
            if (sSession != null) {
                return sSession.getInternalTuWrapper();
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceEntry(this, "sipSession is null...");
            }
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceEntry(this, "realted response is null...");
        }
        return null;
    }
}

