/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.container.appqueue.NativeMessageDispatchingHandler;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.proxy.ProxyBranchImpl;
import com.ibm.ws.sip.container.resolver.SipURILookupCallbackImpl;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.tu.TUKey;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.was.message.SipMessage;
import java.util.Vector;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;

public class ThreadLocalStorage {
    private static final LogMgr c_logger = Log.get(ThreadLocalStorage.class);
    private static ThreadLocal<SipMessage> _sipMessage = new ThreadLocal();
    private static ThreadLocal<String> _sipResponseToHeader = new ThreadLocal();
    private static ThreadLocal<Integer> _queueId = new ThreadLocal();
    private static ThreadLocal<SipURILookupCallbackImpl> _uriLookupCallBack = new ThreadLocal();
    private static ThreadLocal<TUKey> _tuKey = new ThreadLocal();
    private static ThreadLocal<Vector<TransactionUserWrapper>> _tuToinvalidate = new ThreadLocal();
    private static ThreadLocal<SipApplicationSession> _appSession = new ThreadLocal();
    private static ThreadLocal<TransactionUserWrapper> _tuWrapper = new ThreadLocal();
    private static ThreadLocal<ProxyBranchImpl> _curBranch = new ThreadLocal();

    public static void setTuForInvalidate(TransactionUserWrapper tu) {
        ThreadLocalStorage.traceThreadModelValidity(tu);
        Vector<TransactionUserWrapper> tuList = _tuToinvalidate.get();
        if (tuList == null) {
            tuList = new Vector();
            _tuToinvalidate.set(tuList);
        }
        tuList.add(tu);
    }

    private static void traceThreadModelValidity(TransactionUserWrapper tu) {
        block6: {
            if (c_logger.isTraceFailureEnabled()) {
                try {
                    long tuQueueIndex = SipApplicationSessionImpl.extractAppSessionCounter(tu.getApplicationId()) % (long)NativeMessageDispatchingHandler.s_dispatchers;
                    if (ThreadLocalStorage.getQueueId() == null || !ThreadLocalStorage.getQueueId().equals(tuQueueIndex)) {
                        c_logger.traceFailure(tu, "traceThreadModelValidity", "Threading model violation! current thread queue_id = " + ThreadLocalStorage.getQueueId() + " violation on access to SAS_id = " + tu.getApplicationId() + " violated SAS_id queue index = " + tuQueueIndex + "The TU is " + tu.getId(), new Throwable());
                        if (tu.getTuImpl() != null) {
                            c_logger.traceFailure(tu, "traceThreadModelValidity", "Violated SAS's message = " + tu.getTuImpl().getSipMessage());
                        } else {
                            c_logger.traceFailure(tu, "traceThreadModelValidity", "TUImpl is null");
                        }
                    }
                }
                catch (Exception e2) {
                    if (!c_logger.isTraceFailureEnabled()) break block6;
                    c_logger.traceFailure(tu, "traceThreadModelValidity", "unexpected exception", e2);
                }
            }
        }
    }

    public static void cleanTuForInvalidate() {
        Vector<TransactionUserWrapper> tuList = _tuToinvalidate.get();
        if (tuList != null) {
            tuList.clear();
        }
        ThreadLocalStorage.setSipMessage(null);
        ThreadLocalStorage.setSipResponseToHeader(null);
    }

    public static Vector<TransactionUserWrapper> getTuForInvalidate() {
        return _tuToinvalidate.get();
    }

    public static void setSipMessage(SipMessage msg) {
        _sipMessage.set(msg);
    }

    public static SipMessage getSipMessage() {
        return _sipMessage.get();
    }

    public static void setQueueId(Integer queueId) {
        _queueId.set(queueId);
    }

    public static Integer getQueueId() {
        return _queueId.get();
    }

    public static void setTUKey(TUKey key) {
        _tuKey.set(key);
    }

    public static TUKey getTUKey() {
        TUKey key = _tuKey.get();
        if (key == null) {
            ThreadLocalStorage.setTUKey(new TUKey());
        }
        return _tuKey.get();
    }

    public static SipServletRequest getSipServletRequest() {
        SipMessage message = _sipMessage.get();
        if (message == null) {
            return null;
        }
        return message.getRequest();
    }

    public static SipServletResponse getSipServletResponse() {
        SipMessage message = _sipMessage.get();
        if (message == null) {
            return null;
        }
        return message.getResponse();
    }

    public static SipAppDesc getSipAppDesc() {
        SipMessage message = _sipMessage.get();
        if (message == null) {
            return null;
        }
        return message.getSipAppDesc();
    }

    public static String getSipServletName() {
        SipMessage message = _sipMessage.get();
        if (message == null) {
            return null;
        }
        return message.getServletName();
    }

    public static void setSipResponseToHeader(String responseToHeader) {
        _sipResponseToHeader.set(responseToHeader);
    }

    public static String getSipResponseToHeader() {
        return _sipResponseToHeader.get();
    }

    public static SipURILookupCallbackImpl getURILookupCallback() {
        SipURILookupCallbackImpl callback = _uriLookupCallBack.get();
        if (callback == null) {
            callback = new SipURILookupCallbackImpl();
            _uriLookupCallBack.set(callback);
        }
        return callback;
    }

    public static SipApplicationSession getApplicationSession() {
        return _appSession.get();
    }

    public static void setApplicationSession(SipApplicationSession sas) {
        _appSession.set(sas);
    }

    public static TransactionUserWrapper getTuWrapper() {
        return _tuWrapper.get();
    }

    public static void setTuWrapper(TransactionUserWrapper tuWrapper) {
        _tuWrapper.set(tuWrapper);
    }

    public static ProxyBranchImpl getCurrentBranch() {
        return _curBranch.get();
    }

    public static void setCurrentBranch(ProxyBranchImpl curBranch) {
        _curBranch.set(curBranch);
    }
}

