/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.sip.stack.transport.GenericChainBase;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import java.util.Map;

public class ActiveConfiguration {
    public boolean isTls = false;
    public final int configPort;
    public final String configHost;
    public Map<String, Object> tcpOptions = null;
    public Map<String, Object> sslOptions = null;
    public Map<String, Object> udpOptions = null;
    public final Map<String, Object> endpointOptions;
    private GenericChainBase _chain = null;
    public volatile int activePort = -1;
    public String activeHost = null;
    public boolean validConfiguration = false;

    public ActiveConfiguration(boolean isTls, Map<String, Object> tcp, Map<String, Object> ssl, Map<String, Object> endpoint, GenericChainBase chain) {
        this.isTls = isTls;
        this.tcpOptions = tcp;
        this.sslOptions = ssl;
        this.endpointOptions = endpoint;
        this._chain = chain;
        String attribute = isTls ? "sipTLSPort" : "sipTCPPort";
        this.configPort = MetatypeUtils.parseInteger((Object)"sipEndpoint", (String)attribute, (Object)this.getEndpointOptions().get(attribute), (int)-1);
        this.configHost = (String)this.getEndpointOptions().get("host");
    }

    public ActiveConfiguration(Map<String, Object> udp, Map<String, Object> endpoint, GenericChainBase chain) {
        this.udpOptions = udp;
        this.endpointOptions = endpoint;
        this._chain = chain;
        String attribute = "sipUDPPort";
        this.configPort = MetatypeUtils.parseInteger((Object)"sipEndpoint", (String)attribute, (Object)this.getEndpointOptions().get(attribute), (int)-1);
        this.configHost = (String)this.getEndpointOptions().get("host");
    }

    public int getActivePort() {
        if (this.configPort < 0) {
            return -1;
        }
        return this.configPort;
    }

    @Trivial
    public boolean isReady() {
        if (this.tcpOptions == null && this.udpOptions == null) {
            return false;
        }
        return !this.isTls || this.sslOptions != null;
    }

    public boolean unchanged(ActiveConfiguration other) {
        if (other == null) {
            return false;
        }
        if (this.isTls) {
            return this.getConfigHost().equals(other.getConfigHost()) && this.getConfigPort() == other.getConfigPort() && this.tcpOptions == other.tcpOptions && this.sslOptions == other.sslOptions && this.udpOptions == other.udpOptions && !this.endpointChanged(other);
        }
        return this.getConfigHost().equals(other.getConfigHost()) && this.getConfigPort() == other.getConfigPort() && this.tcpOptions == other.tcpOptions && this.udpOptions == other.udpOptions && !this.endpointChanged(other);
    }

    public boolean tcpChanged(ActiveConfiguration other) {
        if (other == null) {
            return false;
        }
        return !this.getConfigHost().equals(other.getConfigHost()) || this.getConfigPort() != other.getConfigPort() || this.tcpOptions != other.tcpOptions;
    }

    public boolean sslChanged(ActiveConfiguration other) {
        if (other == null) {
            return false;
        }
        return this.sslOptions != other.sslOptions;
    }

    public boolean udpChanged(ActiveConfiguration other) {
        if (other == null) {
            return false;
        }
        return !this.getConfigHost().equals(other.getConfigHost()) || this.getConfigPort() != other.getConfigPort() || this.udpOptions != other.udpOptions;
    }

    public boolean endpointChanged(ActiveConfiguration other) {
        if (other == null) {
            return false;
        }
        return !this.getEndpointOptions().get("service.pid").equals(other.getEndpointOptions().get("service.pid"));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[host=" + this.getConfigHost() + ",port=" + this.getConfigPort() + ",complete=" + this.isReady() + ",tcpOptions=" + System.identityHashCode(this.tcpOptions) + ",udpOptions=" + System.identityHashCode(this.udpOptions) + ",sslOptions=" + (this.isTls ? Integer.valueOf(System.identityHashCode(this.sslOptions)) : "0") + "]";
    }

    public String getActiveHost() {
        return this.activeHost;
    }

    public void setActiveHost(String activeHost) {
        this.activeHost = activeHost;
    }

    public boolean isValidConfiguration() {
        return this.validConfiguration;
    }

    public void setValidConfiguration(boolean validConfiguration) {
        this.validConfiguration = validConfiguration;
    }

    public int getConfigPort() {
        return this.configPort;
    }

    public String getConfigHost() {
        return this.configHost;
    }

    public Map<String, Object> getEndpointOptions() {
        return this.endpointOptions;
    }
}

