/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.channelfw.osgi.ChannelFactoryProvider;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.sip.container.internal.SipContainerComponent;
import com.ibm.ws.sip.stack.transport.GenericChainBase;
import com.ibm.ws.sip.stack.transport.chfw.GenericChannelProvider;
import com.ibm.ws.sip.stack.transport.chfw.GenericTCPChain;
import com.ibm.ws.sip.stack.transport.netty.GenericChain;
import com.ibm.ws.sip.stack.transport.netty.GenericUDPChain;
import com.ibm.ws.sip.stack.transport.virtualhost.SipVirtualHostAdapter;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ChannelConfiguration;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.kernel.service.utils.FilterUtils;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.tls.NettyTlsProvider;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.event.EventAdmin;

@Component(configurationPid={"com.ibm.ws.sip.endpoint"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, service={GenericEndpointImpl.class}, immediate=false, property={"service.vendor=IBM"})
public class GenericEndpointImpl {
    public static final String s_UDP_PORT = "sipUDPPort";
    public static final String s_TCP_PORT = "sipTCPPort";
    public static final String s_TLS_PORT = "sipTLSPort";
    private ConfigurationAdmin configAdminRef;
    public static final String s_defaultSipEndpointid = "defaultSipEndpoint";
    public static final String s_sipEndpointFactoryId = "com.ibm.ws.sip.endpoint";
    private boolean isForcedDefaultEndpointIdDeactivate = false;
    private static GenericChannelProvider channelProvider = null;
    private static final String RETRIES = "bindRetries";
    private static final String RETRY_DELAY = "bindRetryDelay";
    private static ChannelConfiguration tcpOptions = null;
    private static ChannelConfiguration udpOptions = null;
    private ExecutorService executorService = null;
    private ChannelFactoryProvider sslSupport = null;
    private static NettyTlsProvider tlsProviderService = null;
    private static ChannelConfiguration sslOptions = null;
    private static EventAdmin eventService = null;
    private static final LogMgr c_logger = Log.get(GenericEndpointImpl.class);
    private static final int DEACTIVATED = 1;
    private static final int ENABLED = 2;
    private static final int DISABLED = 4;
    private final AtomicInteger endpointState = new AtomicInteger(4);
    private static NettyFramework m_nettyBundle = null;
    private static CHFWBundle m_chfw = null;
    private volatile Map<String, Object> endpointConfig = null;
    private volatile boolean endpointStarted = false;
    private volatile String host = "localhost";
    private volatile int tcpPort = -1;
    private volatile int udpPort = -1;
    private volatile int tlsPort = -1;
    public volatile int retries = 60;
    public volatile int retry_delay = 5000;
    private volatile String topicString = null;
    private volatile String name = null;
    private GenericChainBase _genericTCPChain;
    private GenericChainBase _genericUDPChain;
    private GenericChainBase _genericTLSChain;
    private final Object actionLock = new Object(){};
    private final LinkedList<Runnable> actionQueue = new LinkedList();
    private Future<?> actionFuture = null;
    private final Runnable actionsRunner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Runnable r = null;
            while (true) {
                LinkedList linkedList = GenericEndpointImpl.this.actionQueue;
                synchronized (linkedList) {
                    r = (Runnable)GenericEndpointImpl.this.actionQueue.poll();
                    if (r == null) {
                        GenericEndpointImpl.this.actionFuture = null;
                        return;
                    }
                }
                r.run();
            }
        }
    };
    private final Runnable stopAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = GenericEndpointImpl.this.actionLock;
            synchronized (object) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("EndpointAction: stopping chains");
                }
            }
        }

        public String toString() {
            return "Stop";
        }
    };
    private final Runnable stopSipsOnlyAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = GenericEndpointImpl.this.actionLock;
            synchronized (object) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug("EndpointAction: stopping sips chain");
                }
            }
        }

        public String toString() {
            return "Stop sips";
        }
    };
    private final Runnable updateAction = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            Object object = GenericEndpointImpl.this.actionLock;
            synchronized (object) {
                if (GenericEndpointImpl.this.endpointStarted && GenericEndpointImpl.this.endpointState.get() == 2 && FrameworkState.isValid()) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("EndpointAction: updating chains " + GenericEndpointImpl.this, GenericEndpointImpl.this._genericUDPChain, GenericEndpointImpl.this._genericTCPChain, GenericEndpointImpl.this._genericTLSChain);
                    }
                    GenericEndpointImpl.this._genericUDPChain.update();
                    GenericEndpointImpl.this._genericTCPChain.update();
                    GenericEndpointImpl.this._genericTLSChain.update();
                }
            }
        }

        public String toString() {
            return "update";
        }
    };

    public static ChannelFramework getChannelFramework() {
        return m_chfw.getFramework();
    }

    public static WsByteBufferPoolManager getBufferManager() {
        return m_chfw.getBufferManager();
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        Object cid = properties.get("component.id");
        this.name = (String)properties.get("id");
        if (this.name == null) {
            this.name = "sipEndpoint-" + cid;
        }
        if (GenericEndpointImpl.useNetty()) {
            this._genericTCPChain = new com.ibm.ws.sip.stack.transport.netty.GenericTCPChain(this, false);
            this._genericUDPChain = new GenericUDPChain(this);
            this._genericTLSChain = new com.ibm.ws.sip.stack.transport.netty.GenericTCPChain(this, true);
        } else {
            this._genericTCPChain = new GenericTCPChain(this, false);
            this._genericUDPChain = new com.ibm.ws.sip.stack.transport.chfw.GenericUDPChain(this);
            this._genericTLSChain = new GenericTCPChain(this, true);
        }
        if (this.isNeedToActivateSipEndpoint(this.name)) {
            if (c_logger.isEventEnabled()) {
                c_logger.event("GEP activate: " + this + " properties=" + properties, new Object[0]);
            }
            if (!GenericEndpointImpl.useNetty() && channelProvider == null) {
                try {
                    channelProvider = new GenericChannelProvider(SipContainerComponent.getContext().getBundleContext());
                }
                catch (Exception e2) {
                    if (c_logger.isEventEnabled()) {
                        c_logger.event("Failed to create ChannelProvider: " + this, new Object[0]);
                    }
                    e2.printStackTrace();
                    return;
                }
            }
            if (c_logger.isEventEnabled()) {
                c_logger.event("activate sipEndpoint " + this, new Object[0]);
            }
            if (GenericEndpointImpl.useNetty()) {
                if (udpOptions != null) {
                    ((GenericChain)this._genericUDPChain).init(this.name, cid, m_nettyBundle, "InboundUDPChain");
                }
                if (tcpOptions != null) {
                    ((GenericChain)this._genericTCPChain).init(this.name, cid, m_nettyBundle, "InboundTCPChain");
                }
                if (sslOptions != null) {
                    ((GenericChain)this._genericTLSChain).init(this.name, cid, m_nettyBundle, "InboundTLSChain");
                }
            } else {
                if (udpOptions != null) {
                    ((com.ibm.ws.sip.stack.transport.chfw.GenericChain)this._genericUDPChain).init(this.name, cid, m_chfw, "InboundUDPChain");
                }
                if (tcpOptions != null) {
                    ((com.ibm.ws.sip.stack.transport.chfw.GenericChain)this._genericTCPChain).init(this.name, cid, m_chfw, "InboundTCPChain");
                }
                if (sslOptions != null) {
                    ((com.ibm.ws.sip.stack.transport.chfw.GenericChain)this._genericTLSChain).init(this.name, cid, m_chfw, "InboundTLSChain");
                }
            }
            this.startChains(properties);
            try {
                SipVirtualHostAdapter.addSipEndpointHostAliasesToVH(properties, this.isSslEnabled(), this.configAdminRef);
            }
            catch (Exception e3) {
                this.handleSipVirtualHostException("Adding SIP endpoint to virtual host failed.", "Create", e3);
            }
        } else {
            this.isForcedDefaultEndpointIdDeactivate = true;
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("defaultSipEndpoint endpoint wasn't activated since was configured other sipendpoint");
            }
            this.removeDefaultSipEndpointIdFromConfiguration();
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx, int reason) {
        if (!this.isForcedDefaultEndpointIdDeactivate) {
            if (c_logger.isEventEnabled()) {
                c_logger.event("deactivate SIP Endpoint " + this + ", reason=" + reason, new Object[0]);
            }
            this.endpointState.set(1);
            this.performAction(this.stopAction);
            this.stopChains();
            try {
                SipVirtualHostAdapter.removeSipEndpointHostAliasesFromVH(this.getEndpointOptions(), this.isSslEnabled(), this.configAdminRef);
            }
            catch (Exception e2) {
                this.handleSipVirtualHostException("Removing SIP endpoint from virtual host failed.", "Destroy", e2);
            }
        }
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("GEP modified: " + this + " properties=" + config, new Object[0]);
        }
        if (c_logger.isWarnEnabled()) {
            c_logger.warn("warn.change.in.endpoints", null);
        }
        Map<String, Object> previousConfig = this.getEndpointOptions();
        this.applyNewConfiguration(config);
        try {
            SipVirtualHostAdapter.updateSipEndpointHostAliasesToVH(previousConfig, config, this.isSslEnabled(), this.configAdminRef);
        }
        catch (Exception e2) {
            this.handleSipVirtualHostException("Modifying SIP endpoint virtual host failed.", null, e2);
        }
    }

    protected void applyNewConfiguration(Map<String, Object> config) {
        String topicHost;
        Object cid;
        String id;
        boolean endpointEnabled;
        block14: {
            endpointEnabled = MetatypeUtils.parseBoolean((Object)"sipEndpoint", (String)"enabled", (Object)config.get("enabled"), (boolean)true);
            this.host = (String)config.get("host");
            this.host = this.host == null ? "localhost" : this.host.toLowerCase();
            this.tcpPort = MetatypeUtils.parseInteger((Object)"sipEndpoint", (String)s_TCP_PORT, (Object)config.get(s_TCP_PORT), (int)-1);
            this.udpPort = MetatypeUtils.parseInteger((Object)"sipEndpoint", (String)s_UDP_PORT, (Object)config.get(s_UDP_PORT), (int)-1);
            this.tlsPort = MetatypeUtils.parseInteger((Object)"sipEndpoint", (String)s_TLS_PORT, (Object)config.get(s_TLS_PORT), (int)-1);
            this.retries = MetatypeUtils.parseInteger((Object)"sipEndpoint", (String)RETRIES, (Object)config.get(RETRIES), (int)-1);
            this.retry_delay = MetatypeUtils.parseInteger((Object)"sipEndpoint", (String)RETRY_DELAY, (Object)config.get(RETRY_DELAY), (int)-1);
            id = (String)config.get("id");
            cid = config.get("component.id");
            id = id == null ? "cid_" + cid : id;
            topicHost = this.host;
            if (topicHost.contains("*")) {
                topicHost = "ALL";
            } else {
                try {
                    InetAddress ipAddress = InetAddress.getByName(topicHost);
                    if (ipAddress instanceof Inet6Address) {
                        topicHost = topicHost.replace(":", "_");
                    } else if (ipAddress instanceof Inet4Address) {
                        topicHost = topicHost.replace(".", "_");
                    }
                }
                catch (UnknownHostException e2) {
                    if (!c_logger.isTraceDebugEnabled()) break block14;
                    c_logger.traceDebug("Error: GenericEndpointImpl applyNewConfiguration: " + e2);
                }
            }
        }
        this.topicString = "com/ibm/ws/transport/sip/endpoint/" + topicHost + "/" + id + "/" + cid;
        if (this.tcpPort < 0 && this.tlsPort < 0 && this.udpPort < 0) {
            endpointEnabled = false;
            c_logger.warn("missingPorts.endpointDisabled", id);
        }
        if (tcpOptions != null && this.tcpPort >= 0) {
            this._genericTCPChain.enable();
        }
        if (udpOptions != null && this.udpPort >= 0) {
            this._genericUDPChain.enable();
        }
        if (this.tlsPort >= 0 && (this.sslSupport != null || tlsProviderService != null)) {
            this._genericTLSChain.enable();
        }
        this.endpointConfig = config;
        if (endpointEnabled) {
            this.endpointState.compareAndSet(4, 2);
            this.performAction(this.updateAction);
        } else {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("endpoint disabled: " + id);
            }
            this.endpointState.set(4);
            this.performAction(this.stopAction);
        }
    }

    public String getEventTopic() {
        return this.topicString;
    }

    public Map<String, Object> getEndpointOptions() {
        return this.endpointConfig;
    }

    public String getHostName() {
        String activeHost = this._genericTCPChain.getActiveHost();
        if (activeHost == null) {
            activeHost = this._genericTLSChain.getActiveHost();
        }
        if (activeHost == null) {
            activeHost = this._genericUDPChain.getActiveHost();
        }
        return activeHost == null ? this.host : activeHost;
    }

    @Reference
    protected void setConfigurationAdmin(ConfigurationAdmin ca) {
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("ConfigurationAdmin ", ca);
        }
        this.configAdminRef = ca;
    }

    protected void unsetConfigurationAdmin(ConfigurationAdmin ca) {
        this.configAdminRef = null;
    }

    @Reference(name="sslSupport", service=ChannelFactoryProvider.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL, target="(type=SSLChannel)")
    protected void setSslSupport(ChannelFactoryProvider config) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("enable ssl support ", this);
        }
        this.sslSupport = config;
    }

    protected void unsetSslSupport(ServiceReference<ChannelFactoryProvider> ref) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("disable ssl support " + ref.getProperty("type"), this);
        }
        if (this.sslSupport != null) {
            this.sslSupport = null;
        }
    }

    @Trivial
    @Reference(name="sslOptions", service=ChannelConfiguration.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setSslOptions(ChannelConfiguration config) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("set ssl options " + config.getProperty("id"), this);
        }
        sslOptions = config;
    }

    @Trivial
    protected void updatedSslOptions(ServiceReference<ChannelConfiguration> service) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("update ssl options, not supported yet " + service.getProperty("id"), this);
        }
    }

    @Trivial
    protected void unsetSslOptions(ChannelConfiguration config) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("unset ssl options = " + config, this);
        }
        if (sslOptions != null) {
            this.performAction(this.stopSipsOnlyAction);
            sslOptions = null;
        }
    }

    public static Map<String, Object> getSslOptions() {
        return sslOptions == null ? null : sslOptions.getConfiguration();
    }

    @Trivial
    @Reference(name="tcpOptions", service=ChannelConfiguration.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MANDATORY)
    protected void setTcpOptions(ChannelConfiguration config, Map prop) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("setTcpOptions " + config.getProperty("id"), this);
        }
        tcpOptions = config;
    }

    @Trivial
    protected void updatedTcpOptions(ChannelConfiguration config) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("update tcp options  - not supported yet" + config.getProperty("id"), this);
        }
    }

    protected void unsetTcpOptions(ChannelConfiguration config) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("unsetTcpOptions, stoppint TCP and TLS chains " + config.getProperty("id") + this, new Object[0]);
        }
        if (!this.isForcedDefaultEndpointIdDeactivate) {
            tcpOptions = null;
        }
    }

    public static Map<String, Object> getTcpOptions() {
        return tcpOptions == null ? null : tcpOptions.getConfiguration();
    }

    @Trivial
    @Reference(name="udpOptions", service=ChannelConfiguration.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.MANDATORY)
    protected void setUdpOptions(ChannelConfiguration config, Map prop) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("setUdpOptions " + config.getProperty("id"), this);
        }
        udpOptions = config;
    }

    protected void unsetUdpOptions(ChannelConfiguration config) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("unsetUdpOptions and stop UDP related chain " + config.getProperty("id"), this);
        }
        if (!this.isForcedDefaultEndpointIdDeactivate) {
            udpOptions = null;
        }
    }

    @Trivial
    protected void updatedUdpOptions(ChannelConfiguration config) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("update udp options  - not supported yet" + config.getProperty("id"), this);
        }
    }

    public static Map<String, Object> getUdpOptions() {
        return udpOptions == null ? null : udpOptions.getConfiguration();
    }

    @Reference(name="NettyTlsProvider", service=NettyTlsProvider.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setNettyTlsProvider(NettyTlsProvider tls) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("setNettyTlsProvider " + tls, new Object[0]);
        }
        tlsProviderService = tls;
    }

    protected void unsetNettyTlsProvider(NettyTlsProvider tls) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("unsetSipTlsProvider" + tls, new Object[0]);
        }
        tlsProviderService = null;
    }

    @Reference(name="nettyBundle", service=NettyFramework.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setNettyBundle(NettyFramework bundle) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("setNettyBundle " + bundle, new Object[0]);
        }
        m_nettyBundle = bundle;
    }

    public static NettyFramework getNettyBundle() {
        return m_nettyBundle;
    }

    protected void unsetNettyBundle(NettyFramework bundle) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("unsetNettyBundle and stop all open chains" + bundle, new Object[0]);
        }
        if (!this.isForcedDefaultEndpointIdDeactivate) {
            m_nettyBundle = null;
        }
        this.performAction(this.stopAction);
    }

    @Reference(name="chfwBundle", service=CHFWBundle.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setChfwBundle(CHFWBundle bundle) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("setChfwBundle " + bundle, new Object[0]);
        }
        m_chfw = bundle;
    }

    protected void unsetChfwBundle(CHFWBundle bundle) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("unsetChfwBundle and stop all open chains" + bundle, new Object[0]);
        }
        if (!this.isForcedDefaultEndpointIdDeactivate) {
            m_chfw = null;
        }
        this.performAction(this.stopAction);
    }

    protected CHFWBundle getChfwBundle() {
        if (c_logger.isEventEnabled()) {
            c_logger.event("chfwBundle = " + m_chfw, new Object[0]);
        }
        return m_chfw;
    }

    @Reference(name="executorService", service=ExecutorService.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY)
    protected void setExecutorService(ExecutorService service) {
        this.executorService = service;
    }

    protected void unsetExecutorService(ServiceReference<ExecutorService> executorService) {
        this.executorService = null;
    }

    @Reference(name="eventService", service=EventAdmin.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setEventAdmin(EventAdmin service) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("setEventAdmin " + this, new Object[0]);
        }
        eventService = service;
    }

    protected void unsetEventAdmin(EventAdmin service) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("unsetEventAdmin " + service, new Object[0]);
        }
        if (!this.isForcedDefaultEndpointIdDeactivate) {
            eventService = null;
        }
    }

    public static EventAdmin getEventAdmin() {
        return eventService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private void performAction(Runnable action) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("action = " + action, new Object[0]);
        }
        if (this.executorService == null) {
            action.run();
        } else {
            LinkedList<Runnable> linkedList = this.actionQueue;
            synchronized (linkedList) {
                this.actionQueue.add(action);
                if (this.actionFuture == null) {
                    this.actionFuture = this.executorService.submit(this.actionsRunner);
                }
            }
        }
    }

    private void startChains(Map<String, Object> properties) {
        if (c_logger.isEventEnabled()) {
            c_logger.event("startChains", new Object[0]);
        }
        this.endpointStarted = true;
        this.applyNewConfiguration(properties);
    }

    public void stopChains() {
        this.endpointStarted = false;
        this.performAction(this.stopAction);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[@" + System.identityHashCode(this) + ",name=" + this.name + ",host=" + this.host + ",tcp=" + this.tcpPort + ",tls=" + this.tlsPort + ",udp=" + this.udpPort + ",retries=" + this.retries + ",retry_delay=" + this.retry_delay + ",state=" + this.endpointState.get() + "]";
    }

    public String getName() {
        return this.name;
    }

    private boolean isSslEnabled() {
        return sslOptions != null;
    }

    private void handleSipVirtualHostException(String message, String situation, Exception e2) {
        if (c_logger.isErrorEnabled()) {
            Object[] params = new Object[]{this};
            c_logger.error("error.exception", situation, params, (Throwable)e2);
        }
        throw new ComponentException(message);
    }

    private boolean isNeedToActivateSipEndpoint(String sipEndpointId) {
        boolean isNeedToActivate = !this.name.equals(s_defaultSipEndpointid) ? true : !this.isExistNonDefaultSipEndpointId();
        return isNeedToActivate;
    }

    private boolean isExistNonDefaultSipEndpointId() {
        try {
            String filter = "(&" + FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)s_sipEndpointFactoryId) + "(!" + FilterUtils.createPropertyFilter((String)"id", (String)s_defaultSipEndpointid) + "))";
            Configuration[] sipEndpointConf = this.configAdminRef.listConfigurations(filter);
            return sipEndpointConf != null && sipEndpointConf.length > 0;
        }
        catch (Exception e2) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug("isExistNonDefaultSipEndpointId failed", e2);
            }
            return false;
        }
    }

    private void removeDefaultSipEndpointIdFromConfiguration() {
        block4: {
            try {
                String filter = "(&" + FilterUtils.createPropertyFilter((String)"service.factoryPid", (String)s_sipEndpointFactoryId) + FilterUtils.createPropertyFilter((String)"id", (String)s_defaultSipEndpointid) + ")";
                Configuration[] sipEndpointConf = this.configAdminRef.listConfigurations(filter);
                if (sipEndpointConf != null && sipEndpointConf.length == 1) {
                    Configuration defaultIdSipEndpoint = sipEndpointConf[0];
                    defaultIdSipEndpoint.delete();
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug("defaultSipEndpoint endpoint was removed from ConfigurationAdmin");
                    }
                }
            }
            catch (Exception e2) {
                if (!c_logger.isTraceDebugEnabled()) break block4;
                c_logger.traceDebug("Error occured while defaultSipEndpoint endpoint was removed from ConfigurationAdmin", e2);
            }
        }
    }

    public static boolean useNetty() {
        return SipContainerComponent.useNetty();
    }

    public static NettyTlsProvider getTlsProvider() {
        return tlsProviderService;
    }
}

