/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.messaging.service;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.messaging.lifecycle.Singleton;
import com.ibm.ws.sib.admin.JsAdminService;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.JsProcessComponent;
import com.ibm.ws.sib.admin.SIBExceptionBusNotFound;
import com.ibm.ws.sib.admin.internal.JsMainImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"type=com.ibm.ws.sib.admin.JsAdminService", "service.vendor=IBM"})
public class JsAdminServiceImpl
implements JsAdminService,
Singleton {
    private static TraceComponent tc = SibTr.register(JsAdminServiceImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.internal.CWSIDMessages");
    private final JsMainImpl jsMain;

    @Activate
    public JsAdminServiceImpl(@Reference JsMainImpl jsMainImpl) {
        String methodName = "<init>";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)methodName, (Object)new Object[]{this, jsMainImpl});
        }
        this.jsMain = jsMainImpl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    public String quoteJmxPropertyValue(String s) {
        if (JsAdminService.isValidJmxPropertyValue((String)s)) {
            return s;
        }
        return ObjectName.quote(s);
    }

    public String unquoteJmxPropertyValue(String s) {
        return ObjectName.unquote(s);
    }

    public boolean isInitialized() {
        return this.jsMain != null;
    }

    public JsBus getBus(String name) throws SIBExceptionBusNotFound {
        if (!this.isInitialized()) {
            return null;
        }
        return this.jsMain.getBus(name);
    }

    public JsBus getDefinedBus(String name) throws SIBExceptionBusNotFound {
        if (!this.isInitialized()) {
            return null;
        }
        return this.jsMain.getDefinedBus(name);
    }

    public List<String> listDefinedBuses() {
        if (!this.isInitialized()) {
            return new ArrayList<String>();
        }
        return this.jsMain.listDefinedBuses();
    }

    public JsProcessComponent getProcessComponent(String className) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.jsMain.getProcessComponent(className);
    }

    public Enumeration listMessagingEngines() {
        if (!this.isInitialized()) {
            Vector v = new Vector();
            return v.elements();
        }
        return this.jsMain.listMessagingEngines();
    }

    public Enumeration listMessagingEngines(String busName) {
        if (!this.isInitialized()) {
            Vector v = new Vector();
            return v.elements();
        }
        return this.jsMain.listMessagingEngines(busName);
    }

    public Set getMessagingEngineSet(String busName) {
        if (!this.isInitialized()) {
            return new HashSet();
        }
        return this.jsMain.getMessagingEngineSet(busName);
    }

    public JsMessagingEngine getMessagingEngine(String busName, String engine) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.jsMain.getMessagingEngine(busName, engine);
    }

    public void activateJMSResource() {
    }

    public void deactivateJMSResource() {
    }

    public Object getService(Class<?> c) {
        if (!this.isInitialized()) {
            return null;
        }
        return this.jsMain.getService(c);
    }

    public boolean isStandaloneServer() {
        return true;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: com/ibm/ws/messaging/service/JsAdminServiceImpl.java");
        }
    }
}

