/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.cache.AuthCacheService;
import com.ibm.ws.security.common.structures.Cache;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.internal.Authenticator;
import com.ibm.ws.security.saml.sso20.internal.SAMLRequestTAI;
import com.ibm.ws.security.saml.sso20.internal.SpCookieRetriver;
import com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.UserData;
import com.ibm.ws.security.saml.sso20.rs.SamlInboundService;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import com.ibm.wsspi.security.tai.TAIResult;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import javax.security.auth.Subject;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SAMLResponseTAI
extends SAMLRequestTAI {
    public static final TraceComponent tc = Tr.register(SAMLResponseTAI.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static ConcurrentServiceReferenceMap<String, SsoSamlService> respSsoSamlServiceRef = new ConcurrentServiceReferenceMap("ssoSamlService");
    static SAMLRequestTAI activatedRequestTAI = null;
    static SamlInboundService activatedSamlInboundService = null;
    static final long serialVersionUID = -6288792184034090297L;

    static void setActivatedRequestTai(SAMLRequestTAI activatedRequestTai) {
        activatedRequestTAI = activatedRequestTai;
    }

    public static void setActivatedInboundService(SamlInboundService inboundService) {
        activatedSamlInboundService = inboundService;
        SAMLRequestTAI.setActivatedInboundService(inboundService);
    }

    static void setTheActivatedSsoSamlServiceRef(ConcurrentServiceReferenceMap<String, SsoSamlService> activatedSsoSamlServiceRef) {
        respSsoSamlServiceRef = activatedSsoSamlServiceRef;
    }

    @Override
    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
    }

    @Override
    @Modified
    protected void modified(ComponentContext cc, Map<String, Object> props) {
    }

    @Override
    @Deactivate
    protected void deactivate(ComponentContext cc) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TAIResult negotiateValidateandEstablishTrust(HttpServletRequest req, HttpServletResponse resp) throws WebTrustAssociationFailedException {
        TAIResult taiResult = this.handleErrorIfAnyAlready(req, resp);
        if (taiResult != null) {
            return taiResult;
        }
        String providerId = null;
        SsoRequest samlRequest = (SsoRequest)req.getAttribute("Saml20Request");
        SsoSamlService service = samlRequest.getSsoSamlService();
        if (service.isInboundPropagation()) {
            return activatedSamlInboundService.negotiateValidateandEstablishTrust(req, resp, service);
        }
        try {
            HttpRequestInfo.restoreSavedParametersIfAny(req, resp, samlRequest);
        }
        catch (SamlException samlException) {
            void e;
            FFDCFilter.processException((Throwable)samlException, (String)"com.ibm.ws.security.saml.sso20.internal.SAMLResponseTAI", (String)"102", (Object)this, (Object[])new Object[]{req, resp});
            throw new WebTrustAssociationFailedException(e.getMessage());
        }
        UserData userData = samlRequest.getUserData();
        providerId = samlRequest.getProviderName();
        if (userData != null) {
            Authenticator samlAuthenticator = new Authenticator(service, userData);
            return samlAuthenticator.authenticate(req, resp);
        }
        if (samlRequest.isDisableLtpaCookie()) {
            SpCookieRetriver spCookieRetriver = new SpCookieRetriver((AuthCacheService)authCacheServiceRef.getService(), req, samlRequest);
            Subject subject = spCookieRetriver.getSubjectFromSpCookie();
            boolean bSubjectValid = this.validateSubject(subject, req, resp, samlRequest);
            if (!bSubjectValid) {
                spCookieRetriver.removeSubject();
                samlRequest.setType(Constants.EndpointType.REQUEST);
                if (activatedRequestTAI != null) {
                    return activatedRequestTAI.negotiateValidateandEstablishTrust(req, resp);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("There is no activatedRequestTAI available!! (" + providerId + ")"), (Object[])new Object[0]);
                }
            } else {
                return TAIResult.create((int)200, (String)RequestUtil.getUserName(subject), (Subject)subject);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("The SP service is not available or can not handle the request!!" + providerId), (Object[])new Object[0]);
        }
        String errMsg = SamlException.formatMessage("SAML20_AUTHENTICATION_FAIL", "CWWKS5063E: SAML Exception: The SAML service provider (SP) failed to process the authentication request.", new Object[]{providerId});
        throw new WebTrustAssociationFailedException(errMsg);
    }

    @Override
    public boolean isTargetInterceptor(HttpServletRequest request) throws WebTrustAssociationException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isTargetInterceptor()", (Object[])new Object[0]);
        }
        if (RequestUtil.isUnprotectedUrlForSaml(request)) {
            return false;
        }
        if (this.findSpSpecificFirst(request, respSsoSamlServiceRef, Constants.EndpointType.RESPONSE)) {
            IExtendedRequest req = (IExtendedRequest)request;
            SsoRequest samlRequest = (SsoRequest)req.getAttribute("Saml20Request");
            if (samlRequest != null) {
                if (samlRequest.isInboundPropagation()) {
                    return true;
                }
                samlRequest.setLocationAdminRef((AtomicServiceReference<WsLocationAdmin>)locationAdminRef);
                if (this.handledWithCookie(req, samlRequest)) {
                    return true;
                }
                if (samlRequest.isDisableLtpaCookie()) {
                    return true;
                }
            }
        } else {
            Object exception = request.getAttribute("com.ibm.ws.saml.samlexception.found");
            if (exception != null) {
                return true;
            }
        }
        return false;
    }

    boolean handledWithCookie(IExtendedRequest req, SsoRequest samlRequest) {
        if (RequestUtil.isUnprocessedAcsCookiePresent(respSsoSamlServiceRef, req, samlRequest)) {
            String acsCookieValue;
            String spProviderId = samlRequest.getProviderName();
            Cache cache = RequestUtil.getAcsCookieCacheForProvider(respSsoSamlServiceRef, spProviderId);
            UserData userData = (UserData)cache.get(acsCookieValue = RequestUtil.getAcsCookieValueFromRequest(req, spProviderId));
            if (userData != null) {
                samlRequest.setUserData(userData);
                cache.remove((Object)acsCookieValue);
                return true;
            }
            return false;
        }
        return false;
    }
}

