/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client.proxyqueue.queue;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.asynch.AsynchConsumerThreadPool;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.ConversationHelper;
import com.ibm.ws.sib.comms.client.proxyqueue.impl.LockedMessageEnumerationImpl;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.Queue;
import com.ibm.ws.sib.comms.client.proxyqueue.queue.QueueData;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsUtils;
import com.ibm.ws.sib.jfapchannel.approxtime.QuickApproxTime;
import com.ibm.ws.sib.jfapchannel.framework.Framework;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIMessageHandle;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.util.Date;
import java.util.LinkedList;

public class ReadAheadQueue
implements Queue {
    private static String CLASS_NAME = ReadAheadQueue.class.getName();
    private static final TraceComponent tc = SibTr.register(ReadAheadQueue.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private final LinkedList<QueueData> queue = new LinkedList();
    private short currentBatchNumber = 0;
    private ConversationHelper convHelper;
    private boolean serviced = false;
    private QuickApproxTime approxTimeThread = null;
    private Reliability unrecoverableReliability = Reliability.NONE;
    private Object concAccessMonitor = new Object();
    private int HIGH_QUEUE_BYTES = CommsUtils.getRuntimeIntProperty("sib.comms.RAHighQueueBytes", "102400");
    private static final double LOW_QUEUE_FACTOR;
    private static final double HIGH_QUEUE_BYTES_THRESHOLD_FACTOR;
    private static final int HIGH_QUEUE_BYTES_MAX;
    private static final int HIGH_QUEUE_BYTES_ALTERATION_TIMEOUT;
    private int LOW_QUEUE_BYTES = (int)((double)this.HIGH_QUEUE_BYTES * LOW_QUEUE_FACTOR);
    private boolean trackBytes;
    private int bytesReceivedSinceLastRequestForMsgs = 0;
    private int bytesGivenToUserSinceLastRequestForMsgs = 0;
    private int totalRequests = 0;
    private long totalBytesGiven = 0L;
    private long messagesReceived = 0L;
    private long goneEmptyCount = 0L;
    private long currentBytesOnQueue = 0L;
    private long lastRequestForMessagesTime = 0L;
    private int NEW_HIGH_QUEUE_BYTES = 0;
    private int NEW_LOW_QUEUE_BYTES = 0;

    public ReadAheadQueue(short id, ConversationHelper convHelper) {
        this(id, convHelper, true, null);
    }

    public ReadAheadQueue(short id, ConversationHelper convHelper, Reliability unrecoverableReliability) {
        this(id, convHelper, true, unrecoverableReliability);
    }

    public ReadAheadQueue(short id, ConversationHelper convHelper, boolean track, Reliability unrecoverableReliability) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{"" + id, convHelper, "" + track, unrecoverableReliability});
        }
        this.convHelper = convHelper;
        this.trackBytes = track;
        if (unrecoverableReliability != null) {
            this.unrecoverableReliability = unrecoverableReliability;
        }
        if (this.approxTimeThread == null) {
            this.approxTimeThread = Framework.getInstance().getApproximateTimeKeeper();
            this.approxTimeThread.setInterval(50L);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"ReadAhead Queue Startup paramters:", (Object)new Object[]{"HIGH_QUEUE_BYTES=" + this.HIGH_QUEUE_BYTES, "LOW_QUEUE_BYTES=" + this.LOW_QUEUE_BYTES, "HIGH_QUEUE_BYTES_THRESHOLD_FACTOR=" + HIGH_QUEUE_BYTES_THRESHOLD_FACTOR, "HIGH_QUEUE_BYTES_ALTERATION_TIMEOUT=" + HIGH_QUEUE_BYTES_ALTERATION_TIMEOUT, "HIGH_QUEUE_BYTES_MAX=" + HIGH_QUEUE_BYTES_MAX});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public void putToFront(QueueData queueData, short msgBatch) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"putToFront", (Object)new Object[]{queueData, msgBatch});
        }
        this._put(queueData, msgBatch, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"putToFront");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _put(QueueData queueData, short msgBatch, boolean putOnEnd) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"_put", (Object)new Object[]{queueData, "" + msgBatch, "" + putOnEnd});
        }
        ReadAheadQueue readAheadQueue = this;
        synchronized (readAheadQueue) {
            if (msgBatch == this.currentBatchNumber) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Message is for correct batch");
                }
                if (HIGH_QUEUE_BYTES_THRESHOLD_FACTOR != 0.0 && this.HIGH_QUEUE_BYTES != HIGH_QUEUE_BYTES_MAX && this.bytesReceivedSinceLastRequestForMsgs == 0) {
                    float queueDepthPercent = (float)this.currentBytesOnQueue / (float)this.HIGH_QUEUE_BYTES;
                    int readableQueueDepthPercent = (int)queueDepthPercent * 100;
                    if ((double)queueDepthPercent < HIGH_QUEUE_BYTES_THRESHOLD_FACTOR) {
                        long currentTime = System.currentTimeMillis();
                        if (currentTime < this.lastRequestForMessagesTime + (long)HIGH_QUEUE_BYTES_ALTERATION_TIMEOUT) {
                            if (this.NEW_HIGH_QUEUE_BYTES == 0) {
                                this.NEW_HIGH_QUEUE_BYTES = this.HIGH_QUEUE_BYTES;
                                this.NEW_LOW_QUEUE_BYTES = this.LOW_QUEUE_BYTES;
                            }
                            int old_HIGH_QUEUE_BYTES = this.NEW_HIGH_QUEUE_BYTES;
                            int bytesPercent = (int)(HIGH_QUEUE_BYTES_THRESHOLD_FACTOR * (double)this.NEW_HIGH_QUEUE_BYTES);
                            this.NEW_HIGH_QUEUE_BYTES += bytesPercent - (int)this.currentBytesOnQueue;
                            if (this.NEW_HIGH_QUEUE_BYTES > HIGH_QUEUE_BYTES_MAX) {
                                this.NEW_HIGH_QUEUE_BYTES = HIGH_QUEUE_BYTES_MAX;
                            }
                            this.NEW_LOW_QUEUE_BYTES = (int)((double)this.NEW_HIGH_QUEUE_BYTES * LOW_QUEUE_FACTOR);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)("HIGH_QUEUE_BYTES altered as Queue is " + readableQueueDepthPercent + "% full (" + this.currentBytesOnQueue + "/" + old_HIGH_QUEUE_BYTES + ")"));
                            }
                        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Messages arrived outside the alteration timeout - no alteration made (Request made at: " + this.lastRequestForMessagesTime + ", now: " + currentTime));
                        }
                    } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Queue depth is fine - no need to alter (" + readableQueueDepthPercent + "% full)"));
                    }
                }
                LinkedList<QueueData> linkedList = this.queue;
                synchronized (linkedList) {
                    if (putOnEnd) {
                        this.queue.addFirst(queueData);
                    } else {
                        this.queue.addLast(queueData);
                    }
                }
                if (!queueData.isChunkedMessage()) {
                    this.notifyMessageReceived(queueData);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message is not being put as the batch number (" + msgBatch + ") != current batch number (" + this.currentBatchNumber + ")"));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Put complete. Queue is now: " + this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"_put");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendToLastMessage(CommsByteBuffer msgBuffer, boolean lastChunk) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"appendToLastMessage", (Object)new Object[]{msgBuffer, lastChunk});
        }
        ReadAheadQueue readAheadQueue = this;
        synchronized (readAheadQueue) {
            QueueData queueData;
            LinkedList<QueueData> linkedList = this.queue;
            synchronized (linkedList) {
                queueData = this.queue.getFirst();
            }
            queueData.addSlice(msgBuffer, lastChunk);
            if (lastChunk) {
                this.notifyMessageReceived(queueData);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Append has completed: " + this));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"appendToLastMessage");
        }
    }

    private void notifyMessageReceived(QueueData queueData) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"notifyMessageReceived", (Object)queueData);
        }
        long messageLength = queueData.getMessageLength();
        if (this.trackBytes) {
            this.bytesReceivedSinceLastRequestForMsgs = (int)((long)this.bytesReceivedSinceLastRequestForMsgs + messageLength);
        }
        queueData.updateArrivalTime(this.approxTimeThread.getApproxTime());
        ++this.messagesReceived;
        this.currentBytesOnQueue += messageLength;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"notifyMessageReceived");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized JsMessage get(short sessionId) throws SIResourceException, SIConnectionDroppedException, SIConnectionLostException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"get", (Object)sessionId);
        }
        JsMessage retValue = null;
        QueueData rhData = this.removeLastIfAvailable(sessionId);
        while (rhData != null) {
            block20: {
                retValue = (JsMessage)rhData.getMessage();
                boolean messageHasExpired = false;
                long msgTTL = retValue.getRemainingTimeToLive();
                if (msgTTL != -1L) {
                    long currentTime = this.approxTimeThread.getApproxTime();
                    long msgArrivalTime = rhData.getArrivalTime();
                    msgTTL += 500L;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Arrived: " + new Date(msgArrivalTime) + ", Now: " + new Date(currentTime) + ", Expires: " + new Date(msgArrivalTime + msgTTL)));
                    }
                    if (currentTime > msgArrivalTime + msgTTL) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Message has expired: " + retValue.getMessageHandle()));
                        }
                        messageHasExpired = true;
                    }
                }
                if (this.trackBytes) {
                    this.bytesGivenToUserSinceLastRequestForMsgs = (int)((long)this.bytesGivenToUserSinceLastRequestForMsgs + rhData.getMessageLength());
                }
                this.totalBytesGiven += (long)this.bytesGivenToUserSinceLastRequestForMsgs;
                this.currentBytesOnQueue -= rhData.getMessageLength();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Current bytes on the queue", (Object)("" + this.currentBytesOnQueue));
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Bytes given since last request", (Object)("" + this.bytesGivenToUserSinceLastRequestForMsgs));
                }
                if (this.trackBytes && this.bytesGivenToUserSinceLastRequestForMsgs >= this.HIGH_QUEUE_BYTES - this.LOW_QUEUE_BYTES) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Need more messages: " + this.bytesGivenToUserSinceLastRequestForMsgs + " >= " + (this.HIGH_QUEUE_BYTES - this.LOW_QUEUE_BYTES)));
                    }
                    if (this.NEW_HIGH_QUEUE_BYTES != 0) {
                        this.HIGH_QUEUE_BYTES = this.NEW_HIGH_QUEUE_BYTES;
                        this.LOW_QUEUE_BYTES = this.NEW_LOW_QUEUE_BYTES;
                    }
                    this.convHelper.requestMoreMessages(this.bytesReceivedSinceLastRequestForMsgs, this.HIGH_QUEUE_BYTES);
                    this.bytesGivenToUserSinceLastRequestForMsgs = 0;
                    this.bytesReceivedSinceLastRequestForMsgs = 0;
                    ++this.totalRequests;
                    this.lastRequestForMessagesTime = System.currentTimeMillis();
                    LinkedList<QueueData> currentTime = this.queue;
                    synchronized (currentTime) {
                        if (this.queue.isEmpty()) {
                            ++this.goneEmptyCount;
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Queue is now: ", (Object)this);
                    }
                }
                if (!messageHasExpired) break;
                if (CommsUtils.isRecoverable((SIBusMessage)retValue, this.unrecoverableReliability)) {
                    try {
                        this.convHelper.unlockSet(new SIMessageHandle[]{retValue.getMessageHandle()});
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".get"), (String)"2-012-0002", (Object)this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block20;
                        SibTr.debug((TraceComponent)tc, (String)"Unable to unlock expired message", (Object)((Object)e));
                    }
                }
            }
            retValue = null;
            rhData = this.removeLastIfAvailable(sessionId);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get", (Object)retValue);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JsMessage[] getBatch(int batchSize, short id) throws SIResourceException, SIConnectionDroppedException, SIConnectionLostException {
        int size;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getBatch", (Object)("" + batchSize));
        }
        LinkedList<QueueData> linkedList = this.queue;
        synchronized (linkedList) {
            size = this.queue.size();
        }
        if (size > batchSize) {
            size = batchSize;
        }
        JsMessage[] retArray = new JsMessage[size];
        for (int i = 0; i < retArray.length; ++i) {
            retArray[i] = this.get(id);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getBatch", (Object)retArray);
        }
        return retArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isQueueEmpty() {
        boolean isEmpty;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isQueueEmpty");
        }
        LinkedList<QueueData> linkedList = this.queue;
        synchronized (linkedList) {
            isEmpty = this.queue.isEmpty();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isQueueEmpty", (Object)isEmpty);
        }
        return isEmpty;
    }

    @Override
    public synchronized void unlockAll() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
        if (this.trackBytes) {
            this.currentBatchNumber = (short)(this.currentBatchNumber + 1);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Current batch number is: " + this.currentBatchNumber));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"unlockAll");
        }
    }

    public String toString() {
        return "ReadAheadQueue@" + Integer.toHexString(this.hashCode()) + ":- CurDepth: " + this.queue.size() + ", serviced: " + this.serviced + ", messagesReceived: " + this.messagesReceived + ", totalRequests: " + this.totalRequests + ", goneEmptyCount: " + this.goneEmptyCount + ", bytesGivenToUserSinceLastRequest: " + this.bytesGivenToUserSinceLastRequestForMsgs + ", bytesReceivedSinceLastRequest: " + this.bytesReceivedSinceLastRequestForMsgs + ", totalBytesGiven: " + this.totalBytesGiven + ", totalBytesOnQueue: " + this.currentBytesOnQueue;
    }

    @Override
    public void put(QueueData queueData, short msgBatch) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"put", (Object)new Object[]{queueData, msgBatch});
        }
        this._put(queueData, msgBatch, true);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"put");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deliverBatch(int batchSize, short sessionId, ConversationHelper currentConvHelper) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"deliverBatch", (Object)new Object[]{"" + batchSize, "" + sessionId, currentConvHelper});
        }
        Throwable result = null;
        QueueData queueData = null;
        LinkedList<QueueData> linkedList = this.queue;
        synchronized (linkedList) {
            if (!this.queue.isEmpty()) {
                queueData = this.queue.get(0);
            } else {
                SIErrorException exception = new SIErrorException("Queue is empty");
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-012-0009", (Object)this);
            }
        }
        if (queueData != null) {
            ConsumerSessionProxy cs;
            AsynchConsumerProxyQueue proxyQueue;
            block24: {
                proxyQueue = (AsynchConsumerProxyQueue)queueData.getProxyQueue();
                proxyQueue.setAsynchConsumerThread(Thread.currentThread());
                cs = (ConsumerSessionProxy)proxyQueue.getDestinationSessionProxy();
                cs.resetCallbackThreadState();
                try {
                    int remainingLockedMessages;
                    JsMessage[] msgs = this.getBatch(batchSize, sessionId);
                    LockedMessageEnumerationImpl lockedMsgEnum = new LockedMessageEnumerationImpl(proxyQueue, this, msgs, Thread.currentThread(), proxyQueue.getLMEOperationMonitor());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)" ** About to call user callback **");
                    }
                    proxyQueue.getAsynchConsumerCallback().consumeMessages((LockedMessageEnumeration)lockedMsgEnum);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)" ** User callback has returned  **");
                    }
                    if ((remainingLockedMessages = lockedMsgEnum.getRemainingMessageCount()) != 0) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("There are still " + remainingLockedMessages + " locked messages! - Unlocking them"));
                        }
                        lockedMsgEnum.unlockUnseen();
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-012-0004", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception thrown");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        SibTr.event((TraceComponent)tc, (String)"exception", (Object)t);
                    }
                    proxyQueue.setAsynchConsumerThread(null);
                    cs.deliverAsyncException(result);
                    try {
                        cs.unlockAll();
                    }
                    catch (SIException e) {
                        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-012-0006", (Object)this);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception thrown");
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block24;
                        SibTr.event((TraceComponent)tc, (String)"exception", (Object)((Object)e));
                    }
                }
            }
            proxyQueue.setAsynchConsumerThread(null);
            try {
                if (cs.performInCallbackActions()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Starting delivery again");
                    }
                    AsynchConsumerThreadPool.getInstance().dispatch(proxyQueue);
                }
            }
            catch (SIException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-012-0007", (Object)this);
                cs.deliverAsyncException(e);
            }
        } else {
            SIErrorException exception = new SIErrorException("queueData is null");
            FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".deliverBatch"), (String)"2-012-0010", (Object)this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"deliverBatch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(short sessionId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isEmpty", (Object)("" + sessionId));
        }
        boolean queueEmpty = false;
        ReadAheadQueue readAheadQueue = this;
        synchronized (readAheadQueue) {
            LinkedList<QueueData> linkedList = this.queue;
            synchronized (linkedList) {
                queueEmpty = this.queue.isEmpty();
                if (!queueEmpty) {
                    QueueData data = this.queue.getLast();
                    queueEmpty = !data.isComplete();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isEmpty", (Object)("" + queueEmpty));
        }
        return queueEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void purge(short sessionId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"purge", (Object)("" + sessionId));
        }
        LinkedList<QueueData> linkedList = this.queue;
        synchronized (linkedList) {
            this.queue.clear();
        }
        this.bytesGivenToUserSinceLastRequestForMsgs = 0;
        this.bytesReceivedSinceLastRequestForMsgs = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"purge");
        }
    }

    @Override
    public Object getConcurrentAccessLock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConcurrentAccessLock");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConcurrentAccessLock", (Object)this.concAccessMonitor);
        }
        return this.concAccessMonitor;
    }

    public synchronized void setTrackBytes(boolean trackBytes) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setTrackBytes", (Object)trackBytes);
        }
        this.trackBytes = trackBytes;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setTrackBytes");
        }
    }

    @Override
    public void waitUntilEmpty(short sessionId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"waitUntilEmpty");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"waitUntilEmpty");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueueData removeLastIfAvailable(short sessionId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeLastIfAvailable");
        }
        QueueData qData = null;
        ReadAheadQueue readAheadQueue = this;
        synchronized (readAheadQueue) {
            LinkedList<QueueData> linkedList = this.queue;
            synchronized (linkedList) {
                if (!this.isEmpty(sessionId)) {
                    qData = this.queue.removeLast();
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeLastIfAvailable");
        }
        return qData;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/proxyqueue/queue/ReadAheadQueue.java, SIB.comms, WASX.SIB, uu1215.01 1.63");
        }
        LOW_QUEUE_FACTOR = CommsUtils.getRuntimeDoubleProperty("sib.comms.RALowQueueBytesFactor", "0.5");
        HIGH_QUEUE_BYTES_THRESHOLD_FACTOR = CommsUtils.getRuntimeDoubleProperty("sib.comms.RAHighQueueBytesThreshold", "0");
        HIGH_QUEUE_BYTES_MAX = CommsUtils.getRuntimeIntProperty("sib.comms.RAHighQueueBytesMax", "10240000");
        HIGH_QUEUE_BYTES_ALTERATION_TIMEOUT = CommsUtils.getRuntimeIntProperty("sib.comms.RAHighQueueBytesTimeOut", "2000");
    }
}

