/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component.behavior;

import jakarta.faces.component.PartialStateHolder;
import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.behavior._AttachedDeltaWrapper;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

class _DeltaList<T>
extends ArrayList<T>
implements List<T>,
PartialStateHolder,
RandomAccess {
    private static Object[] emptyObjectArray = new Object[0];
    private boolean _initialStateMarked;

    public _DeltaList() {
    }

    public _DeltaList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public void add(int index, T element) {
        this.clearInitialState();
        super.add(index, element);
    }

    @Override
    public boolean add(T e) {
        this.clearInitialState();
        return super.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.clearInitialState();
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.clearInitialState();
        return super.addAll(index, c);
    }

    @Override
    public void clear() {
        this.clearInitialState();
        super.clear();
    }

    @Override
    public T remove(int index) {
        this.clearInitialState();
        return (T)super.remove(index);
    }

    @Override
    public boolean remove(Object o) {
        this.clearInitialState();
        return super.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.clearInitialState();
        return super.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.clearInitialState();
        return super.retainAll(c);
    }

    @Override
    public T set(int index, T element) {
        this.clearInitialState();
        return super.set(index, element);
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void setTransient(boolean newTransientValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        if (this.initialStateMarked()) {
            int i;
            Object[] lst = (Object[])state;
            int j = 0;
            for (i = 0; i < lst.length; ++i) {
                if (lst[i] instanceof _AttachedDeltaWrapper) {
                    ((StateHolder)super.get(j)).restoreState(context, ((_AttachedDeltaWrapper)lst[i]).getWrappedStateObject());
                    ++j;
                    continue;
                }
                if (lst[i] != null) {
                    super.set(j, UIComponentBase.restoreAttachedState(context, lst[i]));
                    ++j;
                    continue;
                }
                super.remove(j);
            }
            if (i != j) {
                this.clearInitialState();
            }
        } else {
            Object[] lst = (Object[])state;
            super.clear();
            super.ensureCapacity(lst.length);
            for (int i = 0; i < lst.length; ++i) {
                Object value = UIComponentBase.restoreAttachedState(context, lst[i]);
                if (value == null) continue;
                super.add(value);
            }
        }
    }

    @Override
    public Object saveState(FacesContext context) {
        int size = super.size();
        if (this.initialStateMarked()) {
            Object[] lst = null;
            boolean nullDelta = true;
            if (size > 0) {
                lst = new Object[size];
                for (int i = 0; i < size; ++i) {
                    Object value = super.get(i);
                    if (value instanceof PartialStateHolder) {
                        PartialStateHolder holder = (PartialStateHolder)value;
                        if (holder.isTransient()) continue;
                        Object attachedState = holder.saveState(context);
                        if (attachedState != null) {
                            nullDelta = false;
                        }
                        lst[i] = new _AttachedDeltaWrapper(value.getClass(), attachedState);
                        continue;
                    }
                    lst[i] = UIComponentBase.saveAttachedState(context, value);
                    if (!(value instanceof StateHolder) && !(value instanceof List)) continue;
                    nullDelta = false;
                }
            } else {
                lst = emptyObjectArray;
            }
            if (nullDelta) {
                return null;
            }
            return lst;
        }
        if (size > 0) {
            Object[] lst = new Object[size];
            for (int i = 0; i < size; ++i) {
                lst[i] = UIComponentBase.saveAttachedState(context, super.get(i));
            }
            return lst;
        }
        return emptyObjectArray;
    }

    @Override
    public void clearInitialState() {
        if (this._initialStateMarked) {
            this._initialStateMarked = false;
            for (int i = 0; i < super.size(); ++i) {
                Object value = super.get(i);
                if (!(value instanceof PartialStateHolder)) continue;
                ((PartialStateHolder)value).clearInitialState();
            }
        }
    }

    @Override
    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    @Override
    public void markInitialState() {
        this._initialStateMarked = true;
        int size = super.size();
        for (int i = 0; i < size; ++i) {
            Object value = super.get(i);
            if (!(value instanceof PartialStateHolder)) continue;
            ((PartialStateHolder)value).markInitialState();
        }
    }
}

