/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.cache.exception.DynamicCacheServiceNotStarted;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.CacheConfig;
import com.ibm.ws.cache.CacheEntry;
import com.ibm.ws.cache.CacheUnit;
import com.ibm.ws.cache.InvalidationAuditDaemon;
import com.ibm.ws.cache.NullRemoteServices;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.TimeLimitDaemon;
import com.ibm.ws.cache.intf.CommandCache;
import com.ibm.ws.cache.intf.DCache;
import com.ibm.ws.cache.intf.ExternalInvalidation;
import com.ibm.ws.cache.intf.JSPCache;
import com.ibm.ws.cache.intf.ObjectCacheUnit;
import com.ibm.ws.cache.intf.ServletCacheUnit;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.cache.EventSource;
import java.util.ArrayList;
import java.util.HashMap;

public class CacheUnitImpl
implements CacheUnit {
    private static TraceComponent tc = Tr.register(CacheUnitImpl.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    protected String uniqueServerNameFQ = null;
    protected CacheConfig cacheConfig = null;
    protected BatchUpdateDaemon batchUpdateDaemon = null;
    protected InvalidationAuditDaemon invalidationAuditDaemon = null;
    protected RemoteServices nullRemoteServices = new NullRemoteServices();
    protected TimeLimitDaemon timeLimitDaemon = null;
    protected boolean servicesStarted = false;
    protected ServletCacheUnit servletCacheUnit = null;
    protected ObjectCacheUnit objectCacheUnit = null;
    private Object serviceMonitor = new Object();

    public CacheUnitImpl(CacheConfig cc) {
        this.initialize(cc);
    }

    @Override
    public void initialize(CacheConfig cc) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object[])new Object[0]);
        }
        this.cacheConfig = cc;
        if (null != cc) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Initializing CacheUnit " + this.uniqueServerNameFQ), (Object[])new Object[0]);
                }
                this.nullRemoteServices.setCacheUnit(this.uniqueServerNameFQ, this);
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ws.cache.CacheUnitImpl.initialize", (String)"120", (Object)this);
                Tr.error((TraceComponent)tc, (String)"dynacache.configerror", (Object[])new Object[]{ex.getMessage()});
                throw new IllegalStateException("Unexpected exception: " + ex.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    @Override
    public RemoteServices getRemoteService() {
        return this.nullRemoteServices;
    }

    @Override
    public String getUniqueServerNameFQ() {
        return this.uniqueServerNameFQ;
    }

    @Override
    public void batchUpdate(String cacheName, HashMap invalidateIdEvents, HashMap invalidateTemplateEvents, ArrayList pushEntryEvents) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("batchUpdate():" + cacheName), (Object[])new Object[0]);
        }
        this.invalidationAuditDaemon.registerInvalidations(cacheName, invalidateIdEvents.values().iterator());
        this.invalidationAuditDaemon.registerInvalidations(cacheName, invalidateTemplateEvents.values().iterator());
        pushEntryEvents = this.invalidationAuditDaemon.filterEntryList(cacheName, pushEntryEvents);
        DCache cache = ServerCache.getCache(cacheName);
        if (cache != null) {
            cache.batchUpdate(invalidateIdEvents, invalidateTemplateEvents, pushEntryEvents);
            if (cache.getCacheConfig().isEnableServletSupport()) {
                if (this.servletCacheUnit != null) {
                    this.servletCacheUnit.invalidateExternalCaches(invalidateIdEvents, invalidateTemplateEvents);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"batchUpdate() cannot do invalidateExternalCaches because servletCacheUnit=NULL.", (Object[])new Object[0]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"batchUpdate()");
        }
    }

    @Override
    public CacheEntry getEntry(String cacheName, Object id, boolean ignoreCounting) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEntry: {0}", (Object[])new Object[]{id});
        }
        DCache cache = ServerCache.getCache(cacheName);
        CacheEntry cacheEntry = null;
        if (cache != null) {
            cacheEntry = (CacheEntry)cache.getEntry(id, 2, ignoreCounting, true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEntry: {0}", (Object)id);
        }
        return cacheEntry;
    }

    @Override
    public void setEntry(String cacheName, CacheEntry cacheEntry) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setEntry: {0}", (Object[])new Object[]{cacheEntry.id});
        }
        if ((cacheEntry = this.invalidationAuditDaemon.filterEntry(cacheName, cacheEntry)) != null) {
            DCache cache = ServerCache.getCache(cacheName);
            cache.setEntry(cacheEntry, 2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setEntry: {0}", (Object)(cacheEntry == null ? "null" : cacheEntry.id));
        }
    }

    @Override
    public void setExternalCacheFragment(ExternalInvalidation externalCacheFragment) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setExternalCacheFragment: {0}", (Object[])new Object[]{externalCacheFragment.getUri()});
        }
        if ((externalCacheFragment = this.invalidationAuditDaemon.filterExternalCacheFragment(ServerCache.cache.getCacheName(), externalCacheFragment)) != null) {
            this.batchUpdateDaemon.pushExternalCacheFragment(externalCacheFragment, ServerCache.cache);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setExternalCacheFragment: {0}", (Object)externalCacheFragment.getUri());
        }
    }

    @Override
    public void addExternalCacheAdapter(String groupId, String address, String beanName) throws DynamicCacheServiceNotStarted {
        if (this.servletCacheUnit == null) {
            throw new DynamicCacheServiceNotStarted("Servlet cache service has not been started.");
        }
        this.servletCacheUnit.addExternalCacheAdapter(groupId, address, beanName);
    }

    @Override
    public void removeExternalCacheAdapter(String groupId, String address) throws DynamicCacheServiceNotStarted {
        if (this.servletCacheUnit == null) {
            throw new DynamicCacheServiceNotStarted("Servlet cache service has not been started.");
        }
        this.servletCacheUnit.removeExternalCacheAdapter(groupId, address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startServices(boolean startTLD) {
        Object object = this.serviceMonitor;
        synchronized (object) {
            if (this.batchUpdateDaemon == null) {
                this.batchUpdateDaemon = new BatchUpdateDaemon(this.cacheConfig.batchUpdateInterval);
                this.invalidationAuditDaemon = new InvalidationAuditDaemon(this.cacheConfig.timeHoldingInvalidations);
                this.batchUpdateDaemon.setInvalidationAuditDaemon(this.invalidationAuditDaemon);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("startServices() - starting BatchUpdateDaemon/invalidationAuditDaemon services. These services should only start once for all cache instances. Settings are:  batchUpdateInterval=" + this.cacheConfig.batchUpdateInterval + " timeHoldingInvalidations=" + this.cacheConfig.timeHoldingInvalidations), (Object[])new Object[0]);
                }
                this.batchUpdateDaemon.start();
                this.invalidationAuditDaemon.start();
            }
            if (startTLD && this.timeLimitDaemon == null) {
                int lruToDiskTriggerTime = 5000;
                if (this.cacheConfig.lruToDiskTriggerTime > this.cacheConfig.timeGranularityInSeconds * 1000 || this.cacheConfig.lruToDiskTriggerTime < 1) {
                    Tr.warning((TraceComponent)tc, (String)"DYNA0069W", (Object[])new Object[]{new Integer(this.cacheConfig.lruToDiskTriggerTime), "lruToDiskTriggerTime", this.cacheConfig.cacheName, new Integer(1), new Integer(this.cacheConfig.timeGranularityInSeconds * 1000), new Integer(5000)});
                    this.cacheConfig.lruToDiskTriggerTime = lruToDiskTriggerTime;
                } else {
                    lruToDiskTriggerTime = this.cacheConfig.lruToDiskTriggerTime;
                }
                if (lruToDiskTriggerTime == 5000 && (this.cacheConfig.lruToDiskTriggerPercent > 0 || this.cacheConfig.memoryCacheSizeInMB != -1)) {
                    this.cacheConfig.lruToDiskTriggerTime = lruToDiskTriggerTime = 1000;
                    Tr.audit((TraceComponent)tc, (String)"DYNA1069I", (Object[])new Object[]{new Integer(this.cacheConfig.lruToDiskTriggerTime)});
                }
                this.timeLimitDaemon = new TimeLimitDaemon(this.cacheConfig.timeGranularityInSeconds, lruToDiskTriggerTime);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("startServices() - starting TimeLimitDaemon service. This service should only start once for all cache instances. Settings are:  timeGranularityInSeconds=" + this.cacheConfig.timeGranularityInSeconds + " lruToDiskTriggerTime=" + this.cacheConfig.lruToDiskTriggerTime), (Object[])new Object[0]);
                }
                this.timeLimitDaemon.start();
            }
        }
    }

    @Override
    public void addAlias(String cacheName, Object id, Object[] aliasArray) {
        block3: {
            DCache cache;
            if (id != null && aliasArray != null && (cache = ServerCache.getCache(cacheName)) != null) {
                try {
                    cache.addAlias(id, aliasArray, false, false);
                }
                catch (IllegalArgumentException e) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Adding alias for cache id " + id + " failure: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
    }

    @Override
    public void removeAlias(String cacheName, Object alias) {
        block3: {
            DCache cache;
            if (alias != null && (cache = ServerCache.getCache(cacheName)) != null) {
                try {
                    cache.removeAlias(alias, false, false);
                }
                catch (IllegalArgumentException e) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("Removing alias " + alias + " failure: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
    }

    @Override
    public BatchUpdateDaemon getBatchUpdateDaemon() {
        return this.batchUpdateDaemon;
    }

    @Override
    public CommandCache getCommandCache(String cacheName) throws DynamicCacheServiceNotStarted, IllegalStateException {
        if (this.servletCacheUnit == null) {
            throw new DynamicCacheServiceNotStarted("Servlet cache service has not been started.");
        }
        return this.servletCacheUnit.getCommandCache(cacheName);
    }

    @Override
    public JSPCache getJSPCache(String cacheName) throws DynamicCacheServiceNotStarted, IllegalStateException {
        if (this.servletCacheUnit == null) {
            throw new DynamicCacheServiceNotStarted("Servlet cache service has not been started.");
        }
        return this.servletCacheUnit.getJSPCache(cacheName);
    }

    @Override
    public void setServletCacheUnit(ServletCacheUnit servletCacheUnit) {
        this.servletCacheUnit = servletCacheUnit;
    }

    @Override
    public ServletCacheUnit getServletCacheUnit() {
        return this.servletCacheUnit;
    }

    @Override
    public void setObjectCacheUnit(ObjectCacheUnit objectCacheUnit) {
        this.objectCacheUnit = objectCacheUnit;
    }

    @Override
    public Object createObjectCache(String cacheName) throws DynamicCacheServiceNotStarted, IllegalStateException {
        if (this.objectCacheUnit == null) {
            throw new DynamicCacheServiceNotStarted("Object cache service has not been started.");
        }
        return this.objectCacheUnit.createObjectCache(cacheName);
    }

    @Override
    public EventSource createEventSource(boolean createAsyncEventSource, String cacheName) throws DynamicCacheServiceNotStarted {
        if (this.objectCacheUnit == null) {
            throw new DynamicCacheServiceNotStarted("Object cache service has not been started.");
        }
        return this.objectCacheUnit.createEventSource(createAsyncEventSource, cacheName);
    }

    @Override
    public TimeLimitDaemon getTimeLimitDaemon() {
        return this.timeLimitDaemon;
    }

    @Override
    public InvalidationAuditDaemon getInvalidationAuditDaemon() {
        return this.invalidationAuditDaemon;
    }
}

