/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.audit.event;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.audit.AuditEvent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.audit.source.utils.AuditUtils;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RESTAuthorizationEvent
extends AuditEvent {
    private static final TraceComponent tc = Tr.register(RESTAuthorizationEvent.class, (String)"WebAppSecurity", (String)"com.ibm.ws.webcontainer.security.resources.WebAppSecurityMessages");
    static final long serialVersionUID = -8043858861732632923L;

    public RESTAuthorizationEvent() {
        this.set("eventName", "SECURITY_REST_HANDLER_AUTHZ");
        this.setInitiator((Map)AuditEvent.STD_INITIATOR.clone());
        this.setObserver((Map)AuditEvent.STD_OBSERVER.clone());
        this.setTarget((Map)AuditEvent.STD_TARGET.clone());
    }

    /*
     * WARNING - void declaration
     */
    public RESTAuthorizationEvent(Object request, Object resp) {
        block12: {
            this();
            try {
                int statusCode;
                URL url;
                String agent;
                RESTRequest req = (RESTRequest)request;
                RESTResponse response = (RESTResponse)resp;
                if (req != null && req.getRemoteAddr() != null) {
                    this.set("initiator.host.address", req.getRemoteAddr());
                }
                if ((agent = req.getHeader("User-Agent")) != null) {
                    this.set("initiator.host.agent", agent);
                }
                this.set("target.name", URLDecoder.decode(req.getContextPath() + req.getPath(), "UTF-8"));
                this.set("target.appname", AuditUtils.getJ2EEComponentName());
                if (req.getQueryString() != null) {
                    String str = URLDecoder.decode(req.getQueryString(), "UTF-8");
                    str = AuditUtils.hidePassword(str);
                    this.set("target.params", str);
                }
                int port = (url = new URL(req.getURL())).getPort() == -1 ? 443 : url.getPort();
                this.set("target.host.address", url.getHost() + ":" + port);
                this.set("target.credential.type", "BASIC");
                if (req.getUserPrincipal() != null && req.getUserPrincipal().getName() != null) {
                    this.set("target.credential.token", req.getUserPrincipal().getName());
                }
                this.set("target.method", req.getMethod());
                String sessionID = req.getSessionId();
                if (sessionID != null) {
                    this.set("target.session", sessionID);
                }
                this.set("target.realm", AuditUtils.getRealmName());
                if (response.getRequiredRoles() != null) {
                    ArrayList<String> rolesList = new ArrayList<String>();
                    for (String role : response.getRequiredRoles()) {
                        rolesList.add(role);
                    }
                    if (!rolesList.isEmpty()) {
                        this.set("target.role.names", rolesList.toString());
                    }
                }
                if ((statusCode = response.getStatus()) == 200) {
                    this.setOutcome("success");
                    this.set("reason.reasonCode", statusCode);
                } else {
                    this.setOutcome("failure");
                    this.set("reason.reasonCode", statusCode);
                }
                this.set("reason.reasonType", "HTTPS");
            }
            catch (Exception req) {
                void e;
                FFDCFilter.processException((Throwable)req, (String)"com.ibm.ws.security.audit.event.RESTAuthorizationEvent", (String)"98", (Object)((Object)this), (Object[])new Object[]{request, resp});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                Tr.debug((TraceComponent)tc, (String)"Internal error creating RESTAuthorizationEvent", (Object[])new Object[]{e});
            }
        }
    }
}

