/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.beanvalidation.v11.config.internal;

import com.fasterxml.classmate.Filter;
import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.RawMethod;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.dopriv.SetContextClassLoaderPrivileged;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.beanvalidation.AbstractBeanValidation;
import com.ibm.ws.beanvalidation.service.BeanValidationExtensionHelper;
import com.ibm.ws.beanvalidation.service.ConstrainedHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.classloading.ClassLoadingService;
import java.lang.annotation.ElementType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.validation.BootstrapConfiguration;
import javax.validation.Configuration;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.executable.ExecutableType;
import javax.validation.executable.ValidateOnExecution;
import javax.validation.metadata.BeanDescriptor;
import javax.validation.metadata.PropertyDescriptor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class ConstrainedHelperImpl
implements ConstrainedHelper {
    private static final TraceNLS nls = TraceNLS.getTraceNLS(ConstrainedHelperImpl.class, (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
    private static final TraceComponent tc = Tr.register(ConstrainedHelperImpl.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
    private static final EnumSet<ExecutableType> ALL_EXECUTABLE_TYPES = EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS, ExecutableType.GETTER_METHODS);
    private static final EnumSet<ExecutableType> DEFAULT_EXECUTABLE_TYPES = EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS);
    private static final String GETTER_PREFIX_GET = "get";
    private static final String GETTER_PREFIX_IS = "is";
    private static final String GETTER_PREFIX_HAS = "has";
    private static final String WELD_PROXY_INTERFACE_NAME = "org.jboss.weld.bean.proxy.ProxyObject";
    private final TypeResolver typeResolver = new TypeResolver();
    private Configuration<?> config = null;
    private Set<ExecutableType> globalExecutableTypes;
    private boolean isExecutableValidationEnabled;
    @Reference
    private ClassLoadingService classLoadingService;
    static final long serialVersionUID = -8765427414071320935L;

    private static Set<ExecutableType> convertToRuntimeTypes(Set<ExecutableType> defaultValidatedExecutableTypes) {
        EnumSet<ExecutableType> types = EnumSet.noneOf(ExecutableType.class);
        for (ExecutableType type : defaultValidatedExecutableTypes) {
            if (ExecutableType.NONE == type) continue;
            if (ExecutableType.ALL == type) {
                types.add(ExecutableType.CONSTRUCTORS);
                types.add(ExecutableType.NON_GETTER_METHODS);
                types.add(ExecutableType.GETTER_METHODS);
                break;
            }
            if (ExecutableType.IMPLICIT == type) {
                types.add(ExecutableType.CONSTRUCTORS);
                types.add(ExecutableType.NON_GETTER_METHODS);
                continue;
            }
            types.add(type);
        }
        return types;
    }

    private static String decapitalize(String string) {
        if (string == null || string.isEmpty() || ConstrainedHelperImpl.startsWithSeveralUpperCaseLetters(string)) {
            return string;
        }
        return string.substring(0, 1).toLowerCase(Locale.ROOT) + string.substring(1);
    }

    private static <T> void getHierarchy(Class<? super T> clazz, List<Class<? super T>> classes) {
        for (Class<T> current = clazz; current != null; current = current.getSuperclass()) {
            if (classes.contains(current)) {
                return;
            }
            if (!ConstrainedHelperImpl.isWeldProxy(current)) {
                classes.add(current);
            }
            Class<?>[] classArray = current.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?> currentInterface;
                Class<?> currentInterfaceCasted = currentInterface = classArray[i];
                ConstrainedHelperImpl.getHierarchy(currentInterfaceCasted, classes);
            }
        }
    }

    private static <T> List<Class<? super T>> getHierarchy(Class<T> clazz) {
        ArrayList<Class<? super T>> classes = new ArrayList<Class<? super T>>();
        ConstrainedHelperImpl.getHierarchy(clazz, classes);
        return classes;
    }

    private static boolean isMethodVisibleTo(Method visibleMethod, Method otherMethod) {
        return Modifier.isPublic(visibleMethod.getModifiers()) || Modifier.isProtected(visibleMethod.getModifiers()) || visibleMethod.getDeclaringClass().getPackage().equals(otherMethod.getDeclaringClass().getPackage());
    }

    private static boolean isWeldProxy(Class<?> clazz) {
        for (Class<?> implementedInterface : clazz.getInterfaces()) {
            if (!implementedInterface.getName().equals(WELD_PROXY_INTERFACE_NAME)) continue;
            return true;
        }
        return false;
    }

    private static boolean startsWithSeveralUpperCaseLetters(String string) {
        return string.length() > 1 && Character.isUpperCase(string.charAt(0)) && Character.isUpperCase(string.charAt(1));
    }

    private EnumSet<ExecutableType> commonExecutableTypeChecks(ValidateOnExecution validateOnExecutionAnnotation) {
        if (validateOnExecutionAnnotation == null) {
            return EnumSet.noneOf(ExecutableType.class);
        }
        EnumSet<ExecutableType> executableTypes = EnumSet.noneOf(ExecutableType.class);
        if (validateOnExecutionAnnotation.type().length == 0) {
            executableTypes.add(ExecutableType.NONE);
        } else {
            Collections.addAll(executableTypes, validateOnExecutionAnnotation.type());
        }
        if (executableTypes.contains(ExecutableType.NONE) && executableTypes.size() > 1) {
            executableTypes.remove(ExecutableType.NONE);
        }
        if (executableTypes.contains(ExecutableType.ALL)) {
            executableTypes = ALL_EXECUTABLE_TYPES;
        }
        return executableTypes;
    }

    private AbstractBeanValidation.ClassLoaderTuple configureBvalClassloader(ClassLoader cl) {
        if (cl == null) {
            cl = AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
        }
        if (cl != null) {
            if (this.classLoadingService.isThreadContextClassLoader(cl)) {
                return AbstractBeanValidation.ClassLoaderTuple.of((ClassLoader)cl, (boolean)false);
            }
            if (this.classLoadingService.isAppClassLoader(cl)) {
                return AbstractBeanValidation.ClassLoaderTuple.of((ClassLoader)this.createTCCL(cl), (boolean)true);
            }
        }
        return AbstractBeanValidation.ClassLoaderTuple.of((ClassLoader)this.createTCCL(ConstrainedHelper.class.getClassLoader()), (boolean)true);
    }

    private ClassLoader createTCCL(ClassLoader parentCL) {
        return AccessController.doPrivileged(() -> this.classLoadingService.createThreadContextClassLoader(parentCL));
    }

    private EnumSet<ExecutableType> executableTypesDefinedOnConstructor(Constructor<?> constructor) {
        ValidateOnExecution validateOnExecutionAnnotation = constructor.getAnnotation(ValidateOnExecution.class);
        EnumSet<ExecutableType> executableTypes = this.commonExecutableTypeChecks(validateOnExecutionAnnotation);
        if (executableTypes.contains(ExecutableType.IMPLICIT) && executableTypes.size() > 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Mixing IMPLICIT and other executable types is not allowed.", (Object[])new Object[0]);
            }
            throw new IllegalArgumentException(nls.getString("BVKEY_MIXING_IMPLICIT_TYPE_NOT_ALLOWED_CWNBV0008E", "CWNBV0008E: Mixing IMPLICIT and other executable types is not allowed. Check the executable types set for: \n" + constructor.toString()));
        }
        if (executableTypes.contains(ExecutableType.IMPLICIT)) {
            executableTypes.add(ExecutableType.CONSTRUCTORS);
        }
        return executableTypes;
    }

    private EnumSet<ExecutableType> executableTypesDefinedOnMethod(Method method, boolean isGetter) {
        ValidateOnExecution validateOnExecutionAnnotation = method.getAnnotation(ValidateOnExecution.class);
        EnumSet<ExecutableType> executableTypes = this.commonExecutableTypeChecks(validateOnExecutionAnnotation);
        if (executableTypes.contains(ExecutableType.IMPLICIT) && executableTypes.size() > 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Mixing IMPLICIT and other executable types is not allowed.", (Object[])new Object[0]);
            }
            throw new IllegalArgumentException(nls.getString("BVKEY_MIXING_IMPLICIT_TYPE_NOT_ALLOWED_CWNBV0008E", "CWNBV0008E: Mixing IMPLICIT and other executable types is not allowed. Check the executable types set for: \n" + method.toString()));
        }
        if (executableTypes.contains(ExecutableType.IMPLICIT)) {
            if (isGetter) {
                executableTypes.add(ExecutableType.GETTER_METHODS);
            } else {
                executableTypes.add(ExecutableType.NON_GETTER_METHODS);
            }
        }
        return executableTypes;
    }

    private EnumSet<ExecutableType> executableTypesDefinedOnType(Class<?> clazz) {
        ValidateOnExecution validateOnExecutionAnnotation = clazz.getAnnotation(ValidateOnExecution.class);
        EnumSet<ExecutableType> executableTypes = this.commonExecutableTypeChecks(validateOnExecutionAnnotation);
        if (executableTypes.contains(ExecutableType.IMPLICIT) && executableTypes.size() > 1) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Mixing IMPLICIT and other executable types is not allowed.", (Object[])new Object[0]);
            }
            throw new IllegalArgumentException(nls.getString("BVKEY_MIXING_IMPLICIT_TYPE_NOT_ALLOWED_CWNBV0008E", "CWNBV0008E: Mixing IMPLICIT and other executable types is not allowed. Check the executable types set for: \n" + clazz.getName()));
        }
        if (executableTypes.contains(ExecutableType.IMPLICIT)) {
            return DEFAULT_EXECUTABLE_TYPES;
        }
        return executableTypes;
    }

    private Optional<String> getProperty(ConstrainableMethod executable) {
        if (executable.getParameterTypes().length != 0) {
            return Optional.empty();
        }
        String methodName = executable.getName();
        if (methodName.startsWith(GETTER_PREFIX_GET) && executable.getReturnType() != Void.TYPE) {
            return Optional.of(ConstrainedHelperImpl.decapitalize(methodName.substring(GETTER_PREFIX_IS.length())));
        }
        if (methodName.startsWith(GETTER_PREFIX_IS) && executable.getReturnType() == Boolean.TYPE) {
            return Optional.of(ConstrainedHelperImpl.decapitalize(methodName.substring(GETTER_PREFIX_IS.length())));
        }
        if (methodName.startsWith(GETTER_PREFIX_HAS) && executable.getReturnType() == Boolean.TYPE) {
            return Optional.of(ConstrainedHelperImpl.decapitalize(methodName.substring(GETTER_PREFIX_HAS.length())));
        }
        return Optional.empty();
    }

    private boolean instanceMethodParametersResolveToSameTypes(Class<?> mainSubType, Method left, Method right) {
        if (left.getParameterTypes().length == 0) {
            return true;
        }
        ResolvedType resolvedSubType = this.typeResolver.resolve(mainSubType, new Type[0]);
        MemberResolver memberResolver = new MemberResolver(this.typeResolver);
        memberResolver.setMethodFilter((Filter)new SimpleMethodFilter(left, right));
        ResolvedTypeWithMembers typeWithMembers = memberResolver.resolve(resolvedSubType, null, null);
        ResolvedMethod[] resolvedMethods = AccessController.doPrivileged(() -> typeWithMembers.getMemberMethods());
        if (resolvedMethods.length == 1) {
            return true;
        }
        for (int i = 0; i < resolvedMethods[0].getArgumentCount(); ++i) {
            if (resolvedMethods[0].getArgumentType(i).equals((Object)resolvedMethods[1].getArgumentType(i))) continue;
            return false;
        }
        return true;
    }

    private boolean instanceMethodParametersResolveToSameTypes(Method subTypeMethod, Method superTypeMethod) {
        return this.instanceMethodParametersResolveToSameTypes(subTypeMethod.getDeclaringClass(), subTypeMethod, superTypeMethod);
    }

    public boolean isConstructorConstrained(Constructor<?> constructor, BeanDescriptor beanDescriptor, ClassLoader moduleClassLoader, String moduleUri) {
        EnumSet<ExecutableType> memberLevelExecutableType;
        this.setupGlobalValidationSettings(moduleClassLoader);
        if (!this.isExecutableValidationEnabled) {
            return false;
        }
        EnumSet<ExecutableType> classLevelExecutableTypes = this.executableTypesDefinedOnType(constructor.getDeclaringClass());
        if (this.veto(classLevelExecutableTypes, memberLevelExecutableType = this.executableTypesDefinedOnConstructor(constructor), ExecutableType.CONSTRUCTORS)) {
            return false;
        }
        return beanDescriptor.getConstraintsForConstructor((Class[])constructor.getParameterTypes()) != null;
    }

    private boolean isGetterConstrained(BeanDescriptor beanDescriptor, Method method, String property) {
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty(property);
        return propertyDescriptor != null && propertyDescriptor.findConstraints().declaredOn(new ElementType[]{ElementType.METHOD}).hasConstraints();
    }

    public boolean isMethodConstrained(Method method, BeanDescriptor beanDescriptor, ClassLoader moduleClassLoader, String moduleUri) {
        ExecutableType currentExecutableType;
        this.setupGlobalValidationSettings(moduleClassLoader);
        if (!this.isExecutableValidationEnabled) {
            return false;
        }
        List<Method> overriddenAndImplementedMethods = InheritedMethodsHelper.getAllMethods(method.getDeclaringClass());
        Optional<String> correspondingProperty = this.getProperty(new ConstrainableMethod(method));
        Method methodForExecutableTypeRetrieval = this.replaceWithOverriddenOrInterfaceMethod(method, overriddenAndImplementedMethods);
        EnumSet<ExecutableType> classLevelExecutableTypes = this.executableTypesDefinedOnType(methodForExecutableTypeRetrieval.getDeclaringClass());
        EnumSet<ExecutableType> memberLevelExecutableType = this.executableTypesDefinedOnMethod(methodForExecutableTypeRetrieval, correspondingProperty.isPresent());
        ExecutableType executableType = currentExecutableType = correspondingProperty.isPresent() ? ExecutableType.GETTER_METHODS : ExecutableType.NON_GETTER_METHODS;
        if (this.veto(classLevelExecutableTypes, memberLevelExecutableType, currentExecutableType)) {
            return false;
        }
        boolean needsValidation = correspondingProperty.isPresent() ? this.isGetterConstrained(beanDescriptor, method, correspondingProperty.get()) : this.isNonGetterConstrained(beanDescriptor, method);
        return needsValidation;
    }

    private boolean isNonGetterConstrained(BeanDescriptor beanDescriptor, Method method) {
        return beanDescriptor.getConstraintsForMethod(method.getName(), (Class[])method.getParameterTypes()) != null;
    }

    private boolean overrides(Method subTypeMethod, Method superTypeMethod) {
        if (subTypeMethod.equals(superTypeMethod)) {
            return false;
        }
        if (!subTypeMethod.getName().equals(superTypeMethod.getName())) {
            return false;
        }
        if (subTypeMethod.getParameterTypes().length != superTypeMethod.getParameterTypes().length) {
            return false;
        }
        if (!superTypeMethod.getDeclaringClass().isAssignableFrom(subTypeMethod.getDeclaringClass())) {
            return false;
        }
        if (Modifier.isStatic(superTypeMethod.getModifiers()) || Modifier.isStatic(subTypeMethod.getModifiers())) {
            return false;
        }
        if (subTypeMethod.isBridge()) {
            return false;
        }
        if (Modifier.isPrivate(superTypeMethod.getModifiers())) {
            return false;
        }
        if (!ConstrainedHelperImpl.isMethodVisibleTo(superTypeMethod, subTypeMethod)) {
            return false;
        }
        return this.instanceMethodParametersResolveToSameTypes(subTypeMethod, superTypeMethod);
    }

    private void releaseLoader(ClassLoader tccl) {
        AccessController.doPrivileged(() -> {
            this.classLoadingService.destroyThreadContextClassLoader(tccl);
            return null;
        });
    }

    private Method replaceWithOverriddenOrInterfaceMethod(Method method, List<Method> allMethodsOfType) {
        LinkedList<Method> list = new LinkedList<Method>(allMethodsOfType);
        Iterator<Method> iterator = list.descendingIterator();
        while (iterator.hasNext()) {
            Method overriddenOrInterfaceMethod = iterator.next();
            if (!this.overrides(method, overriddenOrInterfaceMethod)) continue;
            if (method.getAnnotation(ValidateOnExecution.class) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("@ValidateOnExecution is not allowed on methods overriding a superclass method or implementing an interface. Check configuration for " + method), (Object[])new Object[0]);
                }
                throw new ValidationException(nls.getFormattedMessage("BVKEY_VALIDATE_ON_EXECUTION_NOT_ALLOWED_CWNBV0007E", new Object[]{method}, "CWNBV0007E: @ValidateOnExecution is not allowed on methods overriding a superclass method or implementing an interface. Check configuration for " + method));
            }
            return overriddenOrInterfaceMethod;
        }
        return method;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void setupGlobalValidationSettings(ClassLoader appCl) {
        AbstractBeanValidation.ClassLoaderTuple tuple;
        block16: {
            SetContextClassLoaderPrivileged setClassLoader = null;
            ClassLoader oldClassLoader = null;
            ClassLoader classLoader = null;
            tuple = null;
            try {
                ThreadContextAccessor tca = AccessController.doPrivileged(() -> ThreadContextAccessor.getThreadContextAccessor());
                tuple = this.configureBvalClassloader(appCl);
                classLoader = tuple.classLoader;
                classLoader = BeanValidationExtensionHelper.newValidationClassLoader((ClassLoader)classLoader);
                setClassLoader = new SetContextClassLoaderPrivileged(tca);
                oldClassLoader = setClassLoader.execute(classLoader);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Called setClassLoader with oldClassLoader of " + oldClassLoader + " and newClassLoader of " + classLoader), (Object[])new Object[0]);
                }
                this.config = Validation.byDefaultProvider().configure();
                try {
                    BootstrapConfiguration bootstrap = this.config.getBootstrapConfiguration();
                    this.globalExecutableTypes = Collections.unmodifiableSet(ConstrainedHelperImpl.convertToRuntimeTypes(bootstrap.getDefaultValidatedExecutableTypes()));
                    this.isExecutableValidationEnabled = bootstrap.isExecutableValidationEnabled();
                }
                catch (Exception bootstrap) {
                    FFDCFilter.processException((Throwable)bootstrap, (String)"com.ibm.ws.beanvalidation.v11.config.internal.ConstrainedHelperImpl", (String)"546", (Object)this, (Object[])new Object[]{appCl});
                    if (tc.isDebugEnabled()) {
                        void e;
                        Tr.debug((TraceComponent)tc, (String)e.getMessage(), (Object[])new Object[]{e});
                    }
                    this.globalExecutableTypes = Collections.emptySet();
                    this.isExecutableValidationEnabled = false;
                }
                if (setClassLoader == null) break block16;
            }
            catch (ValidationException tca) {
                block17: {
                    try {
                        FFDCFilter.processException((Throwable)tca, (String)"com.ibm.ws.beanvalidation.v11.config.internal.ConstrainedHelperImpl", (String)"555", (Object)this, (Object[])new Object[]{appCl});
                        if (tc.isDebugEnabled()) {
                            void e;
                            Tr.debug((TraceComponent)tc, (String)("Returning a null Configuration: " + e.getMessage()), (Object[])new Object[0]);
                        }
                        if (setClassLoader == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (setClassLoader != null) {
                            setClassLoader.execute(oldClassLoader);
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                            }
                        }
                        if (tuple != null && tuple.wasCreatedViaClassLoadingService) {
                            this.releaseLoader(tuple.classLoader);
                        }
                        throw throwable;
                    }
                    setClassLoader.execute(oldClassLoader);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
                    }
                }
                if (tuple != null && tuple.wasCreatedViaClassLoadingService) {
                    this.releaseLoader(tuple.classLoader);
                }
            }
            setClassLoader.execute(oldClassLoader);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set Class loader back to " + oldClassLoader), (Object[])new Object[0]);
            }
        }
        if (tuple != null && tuple.wasCreatedViaClassLoadingService) {
            this.releaseLoader(tuple.classLoader);
        }
    }

    private boolean veto(EnumSet<ExecutableType> classLevelExecutableTypes, EnumSet<ExecutableType> memberLevelExecutableType, ExecutableType currentExecutableType) {
        if (!memberLevelExecutableType.isEmpty()) {
            return !memberLevelExecutableType.contains(currentExecutableType) && !memberLevelExecutableType.contains(ExecutableType.IMPLICIT);
        }
        if (!classLevelExecutableTypes.isEmpty()) {
            return !classLevelExecutableTypes.contains(currentExecutableType) && !classLevelExecutableTypes.contains(ExecutableType.IMPLICIT);
        }
        return !this.globalExecutableTypes.contains(currentExecutableType);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ConstrainableMethod {
        private final Method method;
        static final long serialVersionUID = -903365337755986263L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ConstrainableMethod(Method method) {
            this.method = method;
        }

        public String getName() {
            return this.method.getName();
        }

        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.beanvalidation.v11.config.internal.ConstrainedHelperImpl$ConstrainableMethod", ConstrainableMethod.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class SimpleMethodFilter
    implements Filter<RawMethod> {
        private final Method method1;
        private final Method method2;
        static final long serialVersionUID = 5845519375136520232L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SimpleMethodFilter(Method method1, Method method2) {
            this.method1 = method1;
            this.method2 = method2;
        }

        public boolean include(RawMethod element) {
            return element.getRawMember().equals(this.method1) || element.getRawMember().equals(this.method2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.beanvalidation.v11.config.internal.ConstrainedHelperImpl$SimpleMethodFilter", SimpleMethodFilter.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class InheritedMethodsHelper {
        static final long serialVersionUID = 5092142568293638692L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private InheritedMethodsHelper() {
        }

        public static List<Method> getAllMethods(Class<?> clazz) {
            ArrayList<Method> methods = new ArrayList<Method>();
            for (Class hierarchyClass : ConstrainedHelperImpl.getHierarchy(clazz)) {
                Method[] hierarchyClassMethods = AccessController.doPrivileged(() -> hierarchyClass.getMethods());
                Collections.addAll(methods, hierarchyClassMethods);
            }
            return methods;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.beanvalidation.v11.config.internal.ConstrainedHelperImpl$InheritedMethodsHelper", InheritedMethodsHelper.class, (String)"BeanValidation", (String)"com.ibm.ws.beanvalidation.resources.nls.BVNLSMessages");
        }
    }
}

